/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.installer;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataInstallationException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.transform.ArtifactTransformationManager;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;

public class DefaultArtifactInstaller
extends AbstractLogEnabled
implements ArtifactInstaller {
    private ArtifactTransformationManager transformationManager;
    private RepositoryMetadataManager repositoryMetadataManager;

    public void install(String basedir, String finalName, Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        String extension = artifact.getArtifactHandler().getExtension();
        File source2 = new File(basedir, finalName + "." + extension);
        this.install(source2, artifact, localRepository);
    }

    public void install(File source2, Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        try {
            this.transformationManager.transformForInstall(artifact, localRepository);
            String localPath = localRepository.pathOf(artifact);
            File destination = new File(localRepository.getBasedir(), localPath);
            if (!destination.getParentFile().exists()) {
                destination.getParentFile().mkdirs();
            }
            this.getLogger().info("Installing " + source2.getPath() + " to " + destination);
            FileUtils.copyFile(source2, destination);
            Iterator i2 = artifact.getMetadataList().iterator();
            while (i2.hasNext()) {
                ArtifactMetadata metadata = (ArtifactMetadata)i2.next();
                this.repositoryMetadataManager.install(metadata, localRepository);
            }
        }
        catch (IOException e) {
            throw new ArtifactInstallationException("Error installing artifact: " + e.getMessage(), e);
        }
        catch (RepositoryMetadataInstallationException e) {
            throw new ArtifactInstallationException("Error installing artifact's metadata: " + e.getMessage(), e);
        }
    }
}

