/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.factory;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=ArtifactFactory.class)
public class DefaultArtifactFactory
implements ArtifactFactory {
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    @Override
    public Artifact createArtifact(String groupId, String artifactId, String version2, String scope, String type) {
        return this.createArtifact(groupId, artifactId, version2, scope, type, null, null);
    }

    @Override
    public Artifact createArtifactWithClassifier(String groupId, String artifactId, String version2, String type, String classifier) {
        return this.createArtifact(groupId, artifactId, version2, null, type, classifier, null);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope) {
        return this.createArtifact(groupId, artifactId, versionRange, type, classifier, scope, null);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, boolean optional) {
        return this.createArtifact(groupId, artifactId, versionRange, type, classifier, scope, null, optional);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope) {
        return this.createArtifact(groupId, artifactId, versionRange, type, classifier, scope, inheritedScope);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope, boolean optional) {
        return this.createArtifact(groupId, artifactId, versionRange, type, classifier, scope, inheritedScope, optional);
    }

    @Override
    public Artifact createBuildArtifact(String groupId, String artifactId, String version2, String packaging) {
        return this.createArtifact(groupId, artifactId, version2, null, packaging, null, null);
    }

    @Override
    public Artifact createProjectArtifact(String groupId, String artifactId, String version2) {
        return this.createProjectArtifact(groupId, artifactId, version2, null);
    }

    @Override
    public Artifact createParentArtifact(String groupId, String artifactId, String version2) {
        return this.createProjectArtifact(groupId, artifactId, version2);
    }

    @Override
    public Artifact createPluginArtifact(String groupId, String artifactId, VersionRange versionRange) {
        return this.createArtifact(groupId, artifactId, versionRange, "maven-plugin", null, "runtime", null);
    }

    @Override
    public Artifact createProjectArtifact(String groupId, String artifactId, String version2, String scope) {
        return this.createArtifact(groupId, artifactId, version2, scope, "pom");
    }

    @Override
    public Artifact createExtensionArtifact(String groupId, String artifactId, VersionRange versionRange) {
        return this.createArtifact(groupId, artifactId, versionRange, "jar", null, "runtime", null);
    }

    private Artifact createArtifact(String groupId, String artifactId, String version2, String scope, String type, String classifier, String inheritedScope) {
        VersionRange versionRange = null;
        if (version2 != null) {
            versionRange = VersionRange.createFromVersion(version2);
        }
        return this.createArtifact(groupId, artifactId, versionRange, type, classifier, scope, inheritedScope);
    }

    private Artifact createArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope) {
        return this.createArtifact(groupId, artifactId, versionRange, type, classifier, scope, inheritedScope, false);
    }

    private Artifact createArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope, boolean optional) {
        String desiredScope = "runtime";
        if (inheritedScope == null) {
            desiredScope = scope;
        } else {
            if ("test".equals(scope) || "provided".equals(scope)) {
                return null;
            }
            if ("compile".equals(scope) && "compile".equals(inheritedScope)) {
                desiredScope = "compile";
            }
        }
        if ("test".equals(inheritedScope)) {
            desiredScope = "test";
        }
        if ("provided".equals(inheritedScope)) {
            desiredScope = "provided";
        }
        if ("system".equals(scope)) {
            desiredScope = "system";
        }
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(type);
        return new DefaultArtifact(groupId, artifactId, versionRange, desiredScope, type, classifier, handler, optional);
    }
}

