/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.Context;
import javax.sql.DataSource;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.users.GenericGroup;
import org.apache.catalina.users.GenericRole;
import org.apache.catalina.users.GenericUser;
import org.apache.catalina.users.SparseUserDatabase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class DataSourceUserDatabase
extends SparseUserDatabase {
    private static final Log log = LogFactory.getLog(DataSourceUserDatabase.class);
    private static final StringManager sm = StringManager.getManager(DataSourceUserDatabase.class);
    protected final Context namingContext;
    protected final String id;
    protected final ConcurrentHashMap<String, User> createdUsers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, User> modifiedUsers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, User> removedUsers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Group> createdGroups = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Group> modifiedGroups = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Group> removedGroups = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Role> createdRoles = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Role> modifiedRoles = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Role> removedRoles = new ConcurrentHashMap();
    private String preparedAllUsers = null;
    private String preparedAllGroups = null;
    private String preparedAllRoles = null;
    private String preparedGroup = null;
    private String preparedRole = null;
    private String preparedUserRoles = null;
    private String preparedUser = null;
    private String preparedUserGroups = null;
    private String preparedGroupRoles = null;
    protected String dataSourceName = null;
    protected String roleNameCol = null;
    protected String roleAndGroupDescriptionCol = null;
    protected String groupNameCol = null;
    protected String userCredCol = null;
    protected String userFullNameCol = null;
    protected String userNameCol = null;
    protected String userRoleTable = null;
    protected String userGroupTable = null;
    protected String groupRoleTable = null;
    protected String userTable = null;
    protected String groupTable = null;
    protected String roleTable = null;
    private volatile boolean connectionSuccess = true;
    protected boolean readonly = true;
    private final ReentrantReadWriteLock dbLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.dbLock.readLock();
    private final Lock writeLock = this.dbLock.writeLock();

    public DataSourceUserDatabase(Context namingContext, String id) {
        this.namingContext = namingContext;
        this.id = id;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getRoleNameCol() {
        return this.roleNameCol;
    }

    public void setRoleNameCol(String roleNameCol) {
        this.roleNameCol = roleNameCol;
    }

    public String getUserCredCol() {
        return this.userCredCol;
    }

    public void setUserCredCol(String userCredCol) {
        this.userCredCol = userCredCol;
    }

    public String getUserNameCol() {
        return this.userNameCol;
    }

    public void setUserNameCol(String userNameCol) {
        this.userNameCol = userNameCol;
    }

    public String getUserRoleTable() {
        return this.userRoleTable;
    }

    public void setUserRoleTable(String userRoleTable) {
        this.userRoleTable = userRoleTable;
    }

    public String getUserTable() {
        return this.userTable;
    }

    public void setUserTable(String userTable) {
        this.userTable = userTable;
    }

    public String getRoleAndGroupDescriptionCol() {
        return this.roleAndGroupDescriptionCol;
    }

    public void setRoleAndGroupDescriptionCol(String roleAndGroupDescriptionCol) {
        this.roleAndGroupDescriptionCol = roleAndGroupDescriptionCol;
    }

    public String getGroupNameCol() {
        return this.groupNameCol;
    }

    public void setGroupNameCol(String groupNameCol) {
        this.groupNameCol = groupNameCol;
    }

    public String getUserFullNameCol() {
        return this.userFullNameCol;
    }

    public void setUserFullNameCol(String userFullNameCol) {
        this.userFullNameCol = userFullNameCol;
    }

    public String getUserGroupTable() {
        return this.userGroupTable;
    }

    public void setUserGroupTable(String userGroupTable) {
        this.userGroupTable = userGroupTable;
    }

    public String getGroupRoleTable() {
        return this.groupRoleTable;
    }

    public void setGroupRoleTable(String groupRoleTable) {
        this.groupRoleTable = groupRoleTable;
    }

    public String getGroupTable() {
        return this.groupTable;
    }

    public void setGroupTable(String groupTable) {
        this.groupTable = groupTable;
    }

    public String getRoleTable() {
        return this.roleTable;
    }

    public void setRoleTable(String roleTable) {
        this.roleTable = roleTable;
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Group> getGroups() {
        this.readLock.lock();
        try {
            HashMap<String, Group> groups2 = new HashMap<String, Group>();
            groups2.putAll(this.createdGroups);
            groups2.putAll(this.modifiedGroups);
            Connection dbConnection = this.openConnection();
            if (dbConnection != null && this.preparedAllGroups != null) {
                try (PreparedStatement stmt = dbConnection.prepareStatement(this.preparedAllGroups);
                     ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        Group group;
                        String groupName = rs.getString(1);
                        if (groupName == null || groups2.containsKey(groupName) || this.removedGroups.containsKey(groupName) || (group = this.findGroupInternal(dbConnection, groupName)) == null) continue;
                        groups2.put(groupName, group);
                    }
                }
                catch (SQLException e) {
                    log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                }
                finally {
                    this.closeConnection(dbConnection);
                }
            }
            Iterator<Group> iterator2 = groups2.values().iterator();
            return iterator2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Role> getRoles() {
        this.readLock.lock();
        try {
            HashMap<String, Role> roles = new HashMap<String, Role>();
            roles.putAll(this.createdRoles);
            roles.putAll(this.modifiedRoles);
            Connection dbConnection = this.openConnection();
            if (dbConnection != null && this.preparedAllRoles != null) {
                try (PreparedStatement stmt = dbConnection.prepareStatement(this.preparedAllRoles);
                     ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        Role role;
                        String roleName = rs.getString(1);
                        if (roleName == null || roles.containsKey(roleName) || this.removedRoles.containsKey(roleName) || (role = this.findRoleInternal(dbConnection, roleName)) == null) continue;
                        roles.put(roleName, role);
                    }
                }
                catch (SQLException e) {
                    log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                }
                finally {
                    this.closeConnection(dbConnection);
                }
            }
            Iterator<Role> iterator2 = roles.values().iterator();
            return iterator2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<User> getUsers() {
        this.readLock.lock();
        try {
            HashMap<String, User> users = new HashMap<String, User>();
            users.putAll(this.createdUsers);
            users.putAll(this.modifiedUsers);
            Connection dbConnection = this.openConnection();
            if (dbConnection != null) {
                try (PreparedStatement stmt = dbConnection.prepareStatement(this.preparedAllUsers);
                     ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        User user;
                        String userName = rs.getString(1);
                        if (userName == null || users.containsKey(userName) || this.removedUsers.containsKey(userName) || (user = this.findUserInternal(dbConnection, userName)) == null) continue;
                        users.put(userName, user);
                    }
                }
                catch (SQLException e) {
                    log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                }
                finally {
                    this.closeConnection(dbConnection);
                }
            }
            Iterator<User> iterator2 = users.values().iterator();
            return iterator2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void close() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group createGroup(String groupname, String description) {
        this.readLock.lock();
        try {
            GenericGroup<DataSourceUserDatabase> group = new GenericGroup<DataSourceUserDatabase>(this, groupname, description, null);
            this.createdGroups.put(groupname, group);
            this.modifiedGroups.remove(groupname);
            this.removedGroups.remove(groupname);
            GenericGroup<DataSourceUserDatabase> genericGroup = group;
            return genericGroup;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role createRole(String rolename, String description) {
        this.readLock.lock();
        try {
            GenericRole<DataSourceUserDatabase> role = new GenericRole<DataSourceUserDatabase>(this, rolename, description);
            this.createdRoles.put(rolename, role);
            this.modifiedRoles.remove(rolename);
            this.removedRoles.remove(rolename);
            GenericRole<DataSourceUserDatabase> genericRole = role;
            return genericRole;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User createUser(String username, String password, String fullName) {
        this.readLock.lock();
        try {
            GenericUser<DataSourceUserDatabase> user = new GenericUser<DataSourceUserDatabase>(this, username, password, fullName, null, null);
            this.createdUsers.put(username, user);
            this.modifiedUsers.remove(username);
            this.removedUsers.remove(username);
            GenericUser<DataSourceUserDatabase> genericUser = user;
            return genericUser;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group findGroup(String groupname) {
        this.readLock.lock();
        try {
            Group group = this.createdGroups.get(groupname);
            if (group != null) {
                Group group2 = group;
                return group2;
            }
            group = this.modifiedGroups.get(groupname);
            if (group != null) {
                Group group3 = group;
                return group3;
            }
            group = this.removedGroups.get(groupname);
            if (group != null) {
                Group group4 = null;
                return group4;
            }
            if (this.isGroupStoreDefined()) {
                Connection dbConnection = this.openConnection();
                if (dbConnection == null) {
                    Group group5 = null;
                    return group5;
                }
                try {
                    Group group6 = this.findGroupInternal(dbConnection, groupname);
                    return group6;
                }
                finally {
                    this.closeConnection(dbConnection);
                }
            }
            Group group7 = null;
            return group7;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Group findGroupInternal(Connection dbConnection, String groupName) {
        GenericGroup<DataSourceUserDatabase> group;
        block54: {
            group = null;
            try (PreparedStatement stmt = dbConnection.prepareStatement(this.preparedGroup);){
                stmt.setString(1, groupName);
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next() || rs.getString(1) == null) break block54;
                    String description = this.roleAndGroupDescriptionCol != null ? rs.getString(2) : null;
                    ArrayList<Role> groupRoles = new ArrayList<Role>();
                    if (groupName != null) {
                        groupName = groupName.trim();
                        try (PreparedStatement stmt2 = dbConnection.prepareStatement(this.preparedGroupRoles);){
                            stmt2.setString(1, groupName);
                            try (ResultSet rs2 = stmt2.executeQuery();){
                                while (rs2.next()) {
                                    Role groupRole;
                                    String roleName = rs2.getString(1);
                                    if (roleName == null || (groupRole = this.findRoleInternal(dbConnection, roleName)) == null) continue;
                                    groupRoles.add(groupRole);
                                }
                            }
                        }
                        catch (SQLException e) {
                            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                        }
                    }
                    group = new GenericGroup<DataSourceUserDatabase>(this, groupName, description, groupRoles);
                }
            }
            catch (SQLException e) {
                log.error(sm.getString("dataSourceUserDatabase.exception"), e);
            }
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role findRole(String rolename) {
        this.readLock.lock();
        try {
            Role role = this.createdRoles.get(rolename);
            if (role != null) {
                Role role2 = role;
                return role2;
            }
            role = this.modifiedRoles.get(rolename);
            if (role != null) {
                Role role3 = role;
                return role3;
            }
            role = this.removedRoles.get(rolename);
            if (role != null) {
                Role role4 = null;
                return role4;
            }
            if (this.userRoleTable != null && this.roleNameCol != null) {
                Connection dbConnection = this.openConnection();
                if (dbConnection == null) {
                    Role role5 = null;
                    return role5;
                }
                try {
                    Role role6 = this.findRoleInternal(dbConnection, rolename);
                    return role6;
                }
                finally {
                    this.closeConnection(dbConnection);
                }
            }
            Role role7 = null;
            return role7;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Role findRoleInternal(Connection dbConnection, String roleName) {
        GenericRole<DataSourceUserDatabase> role = null;
        try (PreparedStatement stmt = dbConnection.prepareStatement(this.preparedRole);){
            stmt.setString(1, roleName);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next() && rs.getString(1) != null) {
                    String description = this.roleAndGroupDescriptionCol != null ? rs.getString(2) : null;
                    role = new GenericRole<DataSourceUserDatabase>(this, roleName, description);
                }
            }
        }
        catch (SQLException e) {
            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
        }
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User findUser(String username) {
        this.readLock.lock();
        try {
            User user = this.createdUsers.get(username);
            if (user != null) {
                User user2 = user;
                return user2;
            }
            user = this.modifiedUsers.get(username);
            if (user != null) {
                User user3 = user;
                return user3;
            }
            user = this.removedUsers.get(username);
            if (user != null) {
                User user4 = null;
                return user4;
            }
            Connection dbConnection = this.openConnection();
            if (dbConnection == null) {
                User user5 = null;
                return user5;
            }
            try {
                User user6 = this.findUserInternal(dbConnection, username);
                this.closeConnection(dbConnection);
                return user6;
            }
            catch (Throwable throwable) {
                this.closeConnection(dbConnection);
                throw throwable;
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public User findUserInternal(Connection dbConnection, String userName) {
        Throwable throwable;
        Object rs;
        String dbCredentials = null;
        String fullName = null;
        try (PreparedStatement stmt = dbConnection.prepareStatement(this.preparedUser);){
            stmt.setString(1, userName);
            rs = stmt.executeQuery();
            throwable = null;
            try {
                if (rs.next()) {
                    dbCredentials = rs.getString(1);
                    if (this.userFullNameCol != null) {
                        fullName = rs.getString(2);
                    }
                }
                dbCredentials = dbCredentials != null ? dbCredentials.trim() : null;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
        }
        ArrayList<Group> groups2 = new ArrayList<Group>();
        if (this.isGroupStoreDefined()) {
            try {
                PreparedStatement stmt = dbConnection.prepareStatement(this.preparedUserGroups);
                rs = null;
                try {
                    stmt.setString(1, userName);
                    try (ResultSet rs2 = stmt.executeQuery();){
                        while (rs2.next()) {
                            Group group;
                            String groupName = rs2.getString(1);
                            if (groupName == null || (group = this.findGroupInternal(dbConnection, groupName)) == null) continue;
                            groups2.add(group);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    rs = throwable4;
                    throw throwable4;
                }
                finally {
                    if (stmt != null) {
                        if (rs != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable5) {
                                ((Throwable)rs).addSuppressed(throwable5);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                log.error(sm.getString("dataSourceUserDatabase.exception"), e);
            }
        }
        ArrayList<Role> roles = new ArrayList<Role>();
        if (this.userRoleTable != null && this.roleNameCol != null) {
            try {
                throwable = null;
                try (PreparedStatement stmt = dbConnection.prepareStatement(this.preparedUserRoles);){
                    stmt.setString(1, userName);
                    try (ResultSet rs3 = stmt.executeQuery();){
                        while (rs3.next()) {
                            Role role;
                            String roleName = rs3.getString(1);
                            if (roleName == null || (role = this.findRoleInternal(dbConnection, roleName)) == null) continue;
                            roles.add(role);
                        }
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
            }
            catch (SQLException e) {
                log.error(sm.getString("dataSourceUserDatabase.exception"), e);
            }
        }
        GenericUser<DataSourceUserDatabase> user = new GenericUser<DataSourceUserDatabase>(this, userName, dbCredentials, fullName, groups2, roles);
        return user;
    }

    @Override
    public void modifiedGroup(Group group) {
        this.readLock.lock();
        try {
            String name = group.getName();
            if (!this.createdGroups.containsKey(name) && !this.removedGroups.containsKey(name)) {
                this.modifiedGroups.put(name, group);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void modifiedRole(Role role) {
        this.readLock.lock();
        try {
            String name = role.getName();
            if (!this.createdRoles.containsKey(name) && !this.removedRoles.containsKey(name)) {
                this.modifiedRoles.put(name, role);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void modifiedUser(User user) {
        this.readLock.lock();
        try {
            String name = user.getName();
            if (!this.createdUsers.containsKey(name) && !this.removedUsers.containsKey(name)) {
                this.modifiedUsers.put(name, user);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void open() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("DataSource UserDatabase features: User<->Role [" + Boolean.toString(this.userRoleTable != null && this.roleNameCol != null) + "], Roles [" + Boolean.toString(this.isRoleStoreDefined()) + "], Groups [" + Boolean.toString(this.isRoleStoreDefined()) + "]");
        }
        this.writeLock.lock();
        try {
            StringBuilder temp = new StringBuilder("SELECT ");
            temp.append(this.userCredCol);
            if (this.userFullNameCol != null) {
                temp.append(",").append(this.userFullNameCol);
            }
            temp.append(" FROM ");
            temp.append(this.userTable);
            temp.append(" WHERE ");
            temp.append(this.userNameCol);
            temp.append(" = ?");
            this.preparedUser = temp.toString();
            temp = new StringBuilder("SELECT ");
            temp.append(this.userNameCol);
            temp.append(" FROM ");
            temp.append(this.userTable);
            this.preparedAllUsers = temp.toString();
            temp = new StringBuilder("SELECT ");
            temp.append(this.roleNameCol);
            temp.append(" FROM ");
            temp.append(this.userRoleTable);
            temp.append(" WHERE ");
            temp.append(this.userNameCol);
            temp.append(" = ?");
            this.preparedUserRoles = temp.toString();
            if (this.isGroupStoreDefined()) {
                temp = new StringBuilder("SELECT ");
                temp.append(this.groupNameCol);
                temp.append(" FROM ");
                temp.append(this.userGroupTable);
                temp.append(" WHERE ");
                temp.append(this.userNameCol);
                temp.append(" = ?");
                this.preparedUserGroups = temp.toString();
                temp = new StringBuilder("SELECT ");
                temp.append(this.roleNameCol);
                temp.append(" FROM ");
                temp.append(this.groupRoleTable);
                temp.append(" WHERE ");
                temp.append(this.groupNameCol);
                temp.append(" = ?");
                this.preparedGroupRoles = temp.toString();
                temp = new StringBuilder("SELECT ");
                temp.append(this.groupNameCol);
                if (this.roleAndGroupDescriptionCol != null) {
                    temp.append(",").append(this.roleAndGroupDescriptionCol);
                }
                temp.append(" FROM ");
                temp.append(this.groupTable);
                temp.append(" WHERE ");
                temp.append(this.groupNameCol);
                temp.append(" = ?");
                this.preparedGroup = temp.toString();
                temp = new StringBuilder("SELECT ");
                temp.append(this.groupNameCol);
                temp.append(" FROM ");
                temp.append(this.groupTable);
                this.preparedAllGroups = temp.toString();
            }
            if (this.isRoleStoreDefined()) {
                temp = new StringBuilder("SELECT ");
                temp.append(this.roleNameCol);
                if (this.roleAndGroupDescriptionCol != null) {
                    temp.append(",").append(this.roleAndGroupDescriptionCol);
                }
                temp.append(" FROM ");
                temp.append(this.roleTable);
                temp.append(" WHERE ");
                temp.append(this.roleNameCol);
                temp.append(" = ?");
                this.preparedRole = temp.toString();
                temp = new StringBuilder("SELECT ");
                temp.append(this.roleNameCol);
                temp.append(" FROM ");
                temp.append(this.roleTable);
                this.preparedAllRoles = temp.toString();
            } else if (this.userRoleTable != null && this.roleNameCol != null) {
                temp = new StringBuilder("SELECT ");
                temp.append(this.roleNameCol);
                temp.append(" FROM ");
                temp.append(this.userRoleTable);
                temp.append(" WHERE ");
                temp.append(this.roleNameCol);
                temp.append(" = ?");
                this.preparedRole = temp.toString();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void removeGroup(Group group) {
        this.readLock.lock();
        try {
            String name = group.getName();
            this.createdGroups.remove(name);
            this.modifiedGroups.remove(name);
            this.removedGroups.put(name, group);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void removeRole(Role role) {
        this.readLock.lock();
        try {
            String name = role.getName();
            this.createdRoles.remove(name);
            this.modifiedRoles.remove(name);
            this.removedRoles.put(name, role);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void removeUser(User user) {
        this.readLock.lock();
        try {
            String name = user.getName();
            this.createdUsers.remove(name);
            this.modifiedUsers.remove(name);
            this.removedUsers.put(name, user);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void save() throws Exception {
        if (this.readonly) {
            return;
        }
        Connection dbConnection = this.openConnection();
        if (dbConnection == null) {
            return;
        }
        this.writeLock.lock();
        try {
            try {
                this.saveInternal(dbConnection);
            }
            finally {
                this.closeConnection(dbConnection);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void saveInternal(Connection dbConnection) {
        void var8_47;
        void var6_16;
        Object group;
        Throwable throwable;
        PreparedStatement stmt;
        Role role;
        Iterator<Role> roles;
        Throwable throwable2;
        PreparedStatement stmt2;
        StringBuilder temp = null;
        StringBuilder tempRelation = null;
        StringBuilder tempRelationDelete = null;
        if (this.isRoleStoreDefined()) {
            PreparedStatement stmt3;
            if (!this.createdRoles.isEmpty()) {
                temp = new StringBuilder("INSERT INTO ");
                temp.append(this.roleTable);
                temp.append('(').append(this.roleNameCol);
                if (this.roleAndGroupDescriptionCol != null) {
                    temp.append(',').append(this.roleAndGroupDescriptionCol);
                }
                temp.append(") VALUES (?");
                if (this.roleAndGroupDescriptionCol != null) {
                    temp.append(", ?");
                }
                temp.append(')');
                for (Role role2 : this.createdRoles.values()) {
                    try {
                        stmt3 = dbConnection.prepareStatement(temp.toString());
                        Throwable throwable3 = null;
                        try {
                            stmt3.setString(1, role2.getRolename());
                            if (this.roleAndGroupDescriptionCol != null) {
                                stmt3.setString(2, role2.getDescription());
                            }
                            stmt3.executeUpdate();
                        }
                        catch (Throwable throwable4) {
                            Throwable throwable5 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (stmt3 == null) continue;
                            if (throwable3 != null) {
                                try {
                                    stmt3.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable3.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            stmt3.close();
                        }
                    }
                    catch (SQLException e) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                    }
                }
                this.createdRoles.clear();
            }
            if (!this.modifiedRoles.isEmpty() && this.roleAndGroupDescriptionCol != null) {
                temp = new StringBuilder("UPDATE ");
                temp.append(this.roleTable);
                temp.append(" SET ").append(this.roleAndGroupDescriptionCol);
                temp.append(" = ? WHERE ").append(this.roleNameCol);
                temp.append(" = ?");
                for (Role role3 : this.modifiedRoles.values()) {
                    try {
                        stmt3 = dbConnection.prepareStatement(temp.toString());
                        Throwable throwable7 = null;
                        try {
                            stmt3.setString(1, role3.getDescription());
                            stmt3.setString(2, role3.getRolename());
                            stmt3.executeUpdate();
                        }
                        catch (Throwable throwable8) {
                            Throwable throwable9 = throwable8;
                            throw throwable8;
                        }
                        finally {
                            if (stmt3 == null) continue;
                            if (throwable7 != null) {
                                try {
                                    stmt3.close();
                                }
                                catch (Throwable throwable10) {
                                    throwable7.addSuppressed(throwable10);
                                }
                                continue;
                            }
                            stmt3.close();
                        }
                    }
                    catch (SQLException e) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                    }
                }
                this.modifiedRoles.clear();
            }
            if (!this.removedRoles.isEmpty()) {
                temp = new StringBuilder("DELETE FROM ");
                temp.append(this.roleTable);
                temp.append(" WHERE ").append(this.roleNameCol);
                temp.append(" = ?");
                if (this.groupRoleTable != null) {
                    tempRelationDelete = new StringBuilder("DELETE FROM ");
                    tempRelationDelete.append(this.groupRoleTable);
                    tempRelationDelete.append(" WHERE ");
                    tempRelationDelete.append(this.roleNameCol);
                    tempRelationDelete.append(" = ?");
                }
                StringBuilder tempRelationDelete2 = new StringBuilder("DELETE FROM ");
                tempRelationDelete2.append(this.userRoleTable);
                tempRelationDelete2.append(" WHERE ");
                tempRelationDelete2.append(this.roleNameCol);
                tempRelationDelete2.append(" = ?");
                for (Role role3 : this.removedRoles.values()) {
                    Object object;
                    if (tempRelationDelete != null) {
                        try {
                            PreparedStatement preparedStatement = dbConnection.prepareStatement(tempRelationDelete.toString());
                            object = null;
                            try {
                                preparedStatement.setString(1, role3.getRolename());
                                preparedStatement.executeUpdate();
                            }
                            catch (Throwable throwable11) {
                                object = throwable11;
                                throw throwable11;
                            }
                            finally {
                                if (preparedStatement != null) {
                                    if (object != null) {
                                        try {
                                            preparedStatement.close();
                                        }
                                        catch (Throwable throwable12) {
                                            ((Throwable)object).addSuppressed(throwable12);
                                        }
                                    } else {
                                        preparedStatement.close();
                                    }
                                }
                            }
                        }
                        catch (SQLException sQLException) {
                            log.error(sm.getString("dataSourceUserDatabase.exception"), sQLException);
                        }
                    }
                    try {
                        PreparedStatement preparedStatement = dbConnection.prepareStatement(tempRelationDelete2.toString());
                        object = null;
                        try {
                            preparedStatement.setString(1, role3.getRolename());
                            preparedStatement.executeUpdate();
                        }
                        catch (Throwable throwable13) {
                            object = throwable13;
                            throw throwable13;
                        }
                        finally {
                            if (preparedStatement != null) {
                                if (object != null) {
                                    try {
                                        preparedStatement.close();
                                    }
                                    catch (Throwable throwable14) {
                                        ((Throwable)object).addSuppressed(throwable14);
                                    }
                                } else {
                                    preparedStatement.close();
                                }
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), sQLException);
                    }
                    try {
                        PreparedStatement preparedStatement = dbConnection.prepareStatement(temp.toString());
                        object = null;
                        try {
                            preparedStatement.setString(1, role3.getRolename());
                            preparedStatement.executeUpdate();
                        }
                        catch (Throwable throwable15) {
                            object = throwable15;
                            throw throwable15;
                        }
                        finally {
                            if (preparedStatement == null) continue;
                            if (object != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable16) {
                                    ((Throwable)object).addSuppressed(throwable16);
                                }
                                continue;
                            }
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), sQLException);
                    }
                }
                this.removedRoles.clear();
            }
        } else if (this.userRoleTable != null && this.roleNameCol != null) {
            tempRelationDelete = new StringBuilder("DELETE FROM ");
            tempRelationDelete.append(this.userRoleTable);
            tempRelationDelete.append(" WHERE ");
            tempRelationDelete.append(this.roleNameCol);
            tempRelationDelete.append(" = ?");
            for (Role role4 : this.removedRoles.values()) {
                try {
                    PreparedStatement stmt3 = dbConnection.prepareStatement(tempRelationDelete.toString());
                    Throwable throwable17 = null;
                    try {
                        stmt3.setString(1, role4.getRolename());
                        stmt3.executeUpdate();
                    }
                    catch (Throwable throwable18) {
                        Throwable throwable19 = throwable18;
                        throw throwable18;
                    }
                    finally {
                        if (stmt3 == null) continue;
                        if (throwable17 != null) {
                            try {
                                stmt3.close();
                            }
                            catch (Throwable throwable20) {
                                throwable17.addSuppressed(throwable20);
                            }
                            continue;
                        }
                        stmt3.close();
                    }
                }
                catch (SQLException e) {
                    log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                }
            }
            this.removedRoles.clear();
        }
        if (this.isGroupStoreDefined()) {
            Object role4;
            PreparedStatement stmt4;
            tempRelation = new StringBuilder("INSERT INTO ");
            tempRelation.append(this.groupRoleTable);
            tempRelation.append('(').append(this.groupNameCol).append(", ");
            tempRelation.append(this.roleNameCol);
            tempRelation.append(") VALUES (?, ?)");
            String groupRoleRelation = tempRelation.toString();
            tempRelationDelete = new StringBuilder("DELETE FROM ");
            tempRelationDelete.append(this.groupRoleTable);
            tempRelationDelete.append(" WHERE ");
            tempRelationDelete.append(this.groupNameCol);
            tempRelationDelete.append(" = ?");
            String string = tempRelationDelete.toString();
            if (!this.createdGroups.isEmpty()) {
                temp = new StringBuilder("INSERT INTO ");
                temp.append(this.groupTable);
                temp.append('(').append(this.groupNameCol);
                if (this.roleAndGroupDescriptionCol != null) {
                    temp.append(',').append(this.roleAndGroupDescriptionCol);
                }
                temp.append(") VALUES (?");
                if (this.roleAndGroupDescriptionCol != null) {
                    temp.append(", ?");
                }
                temp.append(')');
                for (Group group2 : this.createdGroups.values()) {
                    try {
                        stmt4 = dbConnection.prepareStatement(temp.toString());
                        Throwable throwable21 = null;
                        try {
                            stmt4.setString(1, group2.getGroupname());
                            if (this.roleAndGroupDescriptionCol != null) {
                                stmt4.setString(2, group2.getDescription());
                            }
                            stmt4.executeUpdate();
                        }
                        catch (Throwable throwable22) {
                            throwable21 = throwable22;
                            throw throwable22;
                        }
                        finally {
                            if (stmt4 != null) {
                                if (throwable21 != null) {
                                    try {
                                        stmt4.close();
                                    }
                                    catch (Throwable throwable23) {
                                        throwable21.addSuppressed(throwable23);
                                    }
                                } else {
                                    stmt4.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                    }
                    Iterator<Role> roles2 = group2.getRoles();
                    while (roles2.hasNext()) {
                        role4 = roles2.next();
                        try {
                            stmt2 = dbConnection.prepareStatement(groupRoleRelation);
                            throwable2 = null;
                            try {
                                stmt2.setString(1, group2.getGroupname());
                                stmt2.setString(2, role4.getRolename());
                                stmt2.executeUpdate();
                            }
                            catch (Throwable throwable24) {
                                throwable2 = throwable24;
                                throw throwable24;
                            }
                            finally {
                                if (stmt2 == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        stmt2.close();
                                    }
                                    catch (Throwable throwable25) {
                                        throwable2.addSuppressed(throwable25);
                                    }
                                    continue;
                                }
                                stmt2.close();
                            }
                        }
                        catch (SQLException e) {
                            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                        }
                    }
                }
                this.createdGroups.clear();
            }
            if (!this.modifiedGroups.isEmpty()) {
                if (this.roleAndGroupDescriptionCol != null) {
                    temp = new StringBuilder("UPDATE ");
                    temp.append(this.groupTable);
                    temp.append(" SET ").append(this.roleAndGroupDescriptionCol);
                    temp.append(" = ? WHERE ").append(this.groupNameCol);
                    temp.append(" = ?");
                }
                for (Group group3 : this.modifiedGroups.values()) {
                    if (temp != null) {
                        try {
                            stmt4 = dbConnection.prepareStatement(temp.toString());
                            role4 = null;
                            try {
                                stmt4.setString(1, group3.getDescription());
                                stmt4.setString(2, group3.getGroupname());
                                stmt4.executeUpdate();
                            }
                            catch (Throwable e) {
                                role4 = e;
                                throw e;
                            }
                            finally {
                                if (stmt4 != null) {
                                    if (role4 != null) {
                                        try {
                                            stmt4.close();
                                        }
                                        catch (Throwable e) {
                                            ((Throwable)role4).addSuppressed(e);
                                        }
                                    } else {
                                        stmt4.close();
                                    }
                                }
                            }
                        }
                        catch (SQLException e) {
                            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                        }
                    }
                    try {
                        PreparedStatement stmt5 = dbConnection.prepareStatement(string);
                        role4 = null;
                        try {
                            stmt5.setString(1, group3.getGroupname());
                            stmt5.executeUpdate();
                        }
                        catch (Throwable e) {
                            role4 = e;
                            throw e;
                        }
                        finally {
                            if (stmt5 != null) {
                                if (role4 != null) {
                                    try {
                                        stmt5.close();
                                    }
                                    catch (Throwable e) {
                                        ((Throwable)role4).addSuppressed(e);
                                    }
                                } else {
                                    stmt5.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                    }
                    Iterator<Role> roles2 = group3.getRoles();
                    while (roles2.hasNext()) {
                        Role role5 = roles2.next();
                        try {
                            stmt2 = dbConnection.prepareStatement(groupRoleRelation);
                            throwable2 = null;
                            try {
                                stmt2.setString(1, group3.getGroupname());
                                stmt2.setString(2, role5.getRolename());
                                stmt2.executeUpdate();
                            }
                            catch (Throwable throwable26) {
                                throwable2 = throwable26;
                                throw throwable26;
                            }
                            finally {
                                if (stmt2 == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        stmt2.close();
                                    }
                                    catch (Throwable throwable27) {
                                        throwable2.addSuppressed(throwable27);
                                    }
                                    continue;
                                }
                                stmt2.close();
                            }
                        }
                        catch (SQLException e) {
                            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                        }
                    }
                }
                this.modifiedGroups.clear();
            }
            if (!this.removedGroups.isEmpty()) {
                temp = new StringBuilder("DELETE FROM ");
                temp.append(this.groupTable);
                temp.append(" WHERE ").append(this.groupNameCol);
                temp.append(" = ?");
                StringBuilder tempRelationDelete2 = new StringBuilder("DELETE FROM ");
                tempRelationDelete2.append(this.userGroupTable);
                tempRelationDelete2.append(" WHERE ");
                tempRelationDelete2.append(this.groupNameCol);
                tempRelationDelete2.append(" = ?");
                for (Group group3 : this.removedGroups.values()) {
                    PreparedStatement stmt5;
                    Throwable e;
                    try {
                        e = null;
                        try (PreparedStatement stmt6 = dbConnection.prepareStatement(string);){
                            stmt6.setString(1, group3.getGroupname());
                            stmt6.executeUpdate();
                        }
                        catch (Throwable throwable28) {
                            e = throwable28;
                            throw throwable28;
                        }
                    }
                    catch (SQLException e2) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e2);
                    }
                    try {
                        stmt5 = dbConnection.prepareStatement(tempRelationDelete2.toString());
                        e = null;
                        try {
                            stmt5.setString(1, group3.getGroupname());
                            stmt5.executeUpdate();
                        }
                        catch (Throwable throwable29) {
                            e = throwable29;
                            throw throwable29;
                        }
                        finally {
                            if (stmt5 != null) {
                                if (e != null) {
                                    try {
                                        stmt5.close();
                                    }
                                    catch (Throwable throwable30) {
                                        e.addSuppressed(throwable30);
                                    }
                                } else {
                                    stmt5.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e3) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e3);
                    }
                    try {
                        stmt5 = dbConnection.prepareStatement(temp.toString());
                        e = null;
                        try {
                            stmt5.setString(1, group3.getGroupname());
                            stmt5.executeUpdate();
                        }
                        catch (Throwable throwable31) {
                            e = throwable31;
                            throw throwable31;
                        }
                        finally {
                            if (stmt5 == null) continue;
                            if (e != null) {
                                try {
                                    stmt5.close();
                                }
                                catch (Throwable throwable32) {
                                    e.addSuppressed(throwable32);
                                }
                                continue;
                            }
                            stmt5.close();
                        }
                    }
                    catch (SQLException e4) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e4);
                    }
                }
                this.removedGroups.clear();
            }
        }
        String userRoleRelation = null;
        Object var6_14 = null;
        if (this.userRoleTable != null && this.roleNameCol != null) {
            tempRelation = new StringBuilder("INSERT INTO ");
            tempRelation.append(this.userRoleTable);
            tempRelation.append('(').append(this.userNameCol).append(", ");
            tempRelation.append(this.roleNameCol);
            tempRelation.append(") VALUES (?, ?)");
            userRoleRelation = tempRelation.toString();
            tempRelationDelete = new StringBuilder("DELETE FROM ");
            tempRelationDelete.append(this.userRoleTable);
            tempRelationDelete.append(" WHERE ");
            tempRelationDelete.append(this.userNameCol);
            tempRelationDelete.append(" = ?");
            String string = tempRelationDelete.toString();
        }
        String userGroupRelation = null;
        Object var8_45 = null;
        if (this.isGroupStoreDefined()) {
            tempRelation = new StringBuilder("INSERT INTO ");
            tempRelation.append(this.userGroupTable);
            tempRelation.append('(').append(this.userNameCol).append(", ");
            tempRelation.append(this.groupNameCol);
            tempRelation.append(") VALUES (?, ?)");
            userGroupRelation = tempRelation.toString();
            tempRelationDelete = new StringBuilder("DELETE FROM ");
            tempRelationDelete.append(this.userGroupTable);
            tempRelationDelete.append(" WHERE ");
            tempRelationDelete.append(this.userNameCol);
            tempRelationDelete.append(" = ?");
            String string = tempRelationDelete.toString();
        }
        if (!this.createdUsers.isEmpty()) {
            temp = new StringBuilder("INSERT INTO ");
            temp.append(this.userTable);
            temp.append('(').append(this.userNameCol);
            temp.append(", ").append(this.userCredCol);
            if (this.userFullNameCol != null) {
                temp.append(',').append(this.userFullNameCol);
            }
            temp.append(") VALUES (?, ?");
            if (this.userFullNameCol != null) {
                temp.append(", ?");
            }
            temp.append(')');
            for (User user : this.createdUsers.values()) {
                try {
                    stmt2 = dbConnection.prepareStatement(temp.toString());
                    throwable2 = null;
                    try {
                        stmt2.setString(1, user.getUsername());
                        stmt2.setString(2, user.getPassword());
                        if (this.userFullNameCol != null) {
                            stmt2.setString(3, user.getFullName());
                        }
                        stmt2.executeUpdate();
                    }
                    catch (Throwable throwable33) {
                        throwable2 = throwable33;
                        throw throwable33;
                    }
                    finally {
                        if (stmt2 != null) {
                            if (throwable2 != null) {
                                try {
                                    stmt2.close();
                                }
                                catch (Throwable throwable34) {
                                    throwable2.addSuppressed(throwable34);
                                }
                            } else {
                                stmt2.close();
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                }
                if (userRoleRelation != null) {
                    roles = user.getRoles();
                    while (roles.hasNext()) {
                        role = roles.next();
                        try {
                            stmt = dbConnection.prepareStatement(userRoleRelation);
                            throwable = null;
                            try {
                                stmt.setString(1, user.getUsername());
                                stmt.setString(2, role.getRolename());
                                stmt.executeUpdate();
                            }
                            catch (Throwable throwable35) {
                                throwable = throwable35;
                                throw throwable35;
                            }
                            finally {
                                if (stmt == null) continue;
                                if (throwable != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable throwable36) {
                                        throwable.addSuppressed(throwable36);
                                    }
                                    continue;
                                }
                                stmt.close();
                            }
                        }
                        catch (SQLException e) {
                            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                        }
                    }
                }
                if (userGroupRelation == null) continue;
                Iterator<Group> groups2 = user.getGroups();
                while (groups2.hasNext()) {
                    group = groups2.next();
                    try {
                        stmt = dbConnection.prepareStatement(userGroupRelation);
                        throwable = null;
                        try {
                            stmt.setString(1, user.getUsername());
                            stmt.setString(2, group.getGroupname());
                            stmt.executeUpdate();
                        }
                        catch (Throwable throwable37) {
                            throwable = throwable37;
                            throw throwable37;
                        }
                        finally {
                            if (stmt == null) continue;
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable38) {
                                    throwable.addSuppressed(throwable38);
                                }
                                continue;
                            }
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                    }
                }
            }
            this.createdUsers.clear();
        }
        if (!this.modifiedUsers.isEmpty()) {
            temp = new StringBuilder("UPDATE ");
            temp.append(this.userTable);
            temp.append(" SET ").append(this.userCredCol);
            temp.append(" = ?");
            if (this.userFullNameCol != null) {
                temp.append(", ").append(this.userFullNameCol).append(" = ?");
            }
            temp.append(" WHERE ").append(this.userNameCol);
            temp.append(" = ?");
            for (User user : this.modifiedUsers.values()) {
                try {
                    stmt2 = dbConnection.prepareStatement(temp.toString());
                    group = null;
                    try {
                        stmt2.setString(1, user.getPassword());
                        if (this.userFullNameCol != null) {
                            stmt2.setString(2, user.getFullName());
                            stmt2.setString(3, user.getUsername());
                        } else {
                            stmt2.setString(2, user.getUsername());
                        }
                        stmt2.executeUpdate();
                    }
                    catch (Throwable e) {
                        group = e;
                        throw e;
                    }
                    finally {
                        if (stmt2 != null) {
                            if (group != null) {
                                try {
                                    stmt2.close();
                                }
                                catch (Throwable e) {
                                    ((Throwable)group).addSuppressed(e);
                                }
                            } else {
                                stmt2.close();
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                }
                if (var6_16 != null) {
                    try {
                        stmt2 = dbConnection.prepareStatement((String)var6_16);
                        group = null;
                        try {
                            stmt2.setString(1, user.getUsername());
                            stmt2.executeUpdate();
                        }
                        catch (Throwable e) {
                            group = e;
                            throw e;
                        }
                        finally {
                            if (stmt2 != null) {
                                if (group != null) {
                                    try {
                                        stmt2.close();
                                    }
                                    catch (Throwable e) {
                                        ((Throwable)group).addSuppressed(e);
                                    }
                                } else {
                                    stmt2.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                    }
                }
                if (var8_47 != null) {
                    try {
                        stmt2 = dbConnection.prepareStatement((String)var8_47);
                        group = null;
                        try {
                            stmt2.setString(1, user.getUsername());
                            stmt2.executeUpdate();
                        }
                        catch (Throwable e) {
                            group = e;
                            throw e;
                        }
                        finally {
                            if (stmt2 != null) {
                                if (group != null) {
                                    try {
                                        stmt2.close();
                                    }
                                    catch (Throwable e) {
                                        ((Throwable)group).addSuppressed(e);
                                    }
                                } else {
                                    stmt2.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                    }
                }
                if (userRoleRelation != null) {
                    roles = user.getRoles();
                    while (roles.hasNext()) {
                        role = roles.next();
                        try {
                            stmt = dbConnection.prepareStatement(userRoleRelation);
                            throwable = null;
                            try {
                                stmt.setString(1, user.getUsername());
                                stmt.setString(2, role.getRolename());
                                stmt.executeUpdate();
                            }
                            catch (Throwable throwable39) {
                                throwable = throwable39;
                                throw throwable39;
                            }
                            finally {
                                if (stmt == null) continue;
                                if (throwable != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable throwable40) {
                                        throwable.addSuppressed(throwable40);
                                    }
                                    continue;
                                }
                                stmt.close();
                            }
                        }
                        catch (SQLException e) {
                            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                        }
                    }
                }
                if (userGroupRelation == null) continue;
                Iterator<Group> groups2 = user.getGroups();
                while (groups2.hasNext()) {
                    group = groups2.next();
                    try {
                        stmt = dbConnection.prepareStatement(userGroupRelation);
                        throwable = null;
                        try {
                            stmt.setString(1, user.getUsername());
                            stmt.setString(2, group.getGroupname());
                            stmt.executeUpdate();
                        }
                        catch (Throwable throwable41) {
                            throwable = throwable41;
                            throw throwable41;
                        }
                        finally {
                            if (stmt == null) continue;
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable42) {
                                    throwable.addSuppressed(throwable42);
                                }
                                continue;
                            }
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                    }
                }
            }
            this.modifiedGroups.clear();
        }
        if (!this.removedUsers.isEmpty()) {
            temp = new StringBuilder("DELETE FROM ");
            temp.append(this.userTable);
            temp.append(" WHERE ").append(this.userNameCol);
            temp.append(" = ?");
            for (User user : this.removedUsers.values()) {
                try {
                    throwable2 = null;
                    try (PreparedStatement stmt22 = dbConnection.prepareStatement((String)var6_16);){
                        stmt22.setString(1, user.getUsername());
                        stmt22.executeUpdate();
                    }
                    catch (Throwable throwable43) {
                        throwable2 = throwable43;
                        throw throwable43;
                    }
                }
                catch (SQLException e) {
                    log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                }
                if (var8_47 != null) {
                    try {
                        stmt2 = dbConnection.prepareStatement((String)var8_47);
                        throwable2 = null;
                        try {
                            stmt2.setString(1, user.getUsername());
                            stmt2.executeUpdate();
                        }
                        catch (Throwable throwable44) {
                            throwable2 = throwable44;
                            throw throwable44;
                        }
                        finally {
                            if (stmt2 != null) {
                                if (throwable2 != null) {
                                    try {
                                        stmt2.close();
                                    }
                                    catch (Throwable throwable45) {
                                        throwable2.addSuppressed(throwable45);
                                    }
                                } else {
                                    stmt2.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                    }
                }
                try {
                    stmt2 = dbConnection.prepareStatement(temp.toString());
                    throwable2 = null;
                    try {
                        stmt2.setString(1, user.getUsername());
                        stmt2.executeUpdate();
                    }
                    catch (Throwable throwable46) {
                        throwable2 = throwable46;
                        throw throwable46;
                    }
                    finally {
                        if (stmt2 == null) continue;
                        if (throwable2 != null) {
                            try {
                                stmt2.close();
                            }
                            catch (Throwable throwable47) {
                                throwable2.addSuppressed(throwable47);
                            }
                            continue;
                        }
                        stmt2.close();
                    }
                }
                catch (SQLException e) {
                    log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                }
            }
            this.removedUsers.clear();
        }
    }

    @Override
    public boolean isAvailable() {
        return this.connectionSuccess;
    }

    protected boolean isGroupStoreDefined() {
        return this.groupTable != null && this.userGroupTable != null && this.groupNameCol != null && this.groupRoleTable != null && this.isRoleStoreDefined();
    }

    protected boolean isRoleStoreDefined() {
        return this.roleTable != null && this.userRoleTable != null && this.roleNameCol != null;
    }

    protected Connection openConnection() {
        try {
            Context context = this.namingContext;
            DataSource dataSource = (DataSource)context.lookup(this.dataSourceName);
            Connection connection = dataSource.getConnection();
            this.connectionSuccess = true;
            return connection;
        }
        catch (Exception e) {
            this.connectionSuccess = false;
            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
            return null;
        }
    }

    protected void closeConnection(Connection dbConnection) {
        if (dbConnection == null) {
            return;
        }
        try {
            if (!dbConnection.getAutoCommit()) {
                dbConnection.commit();
            }
        }
        catch (SQLException e) {
            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
        }
        try {
            dbConnection.close();
        }
        catch (SQLException e) {
            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
        }
    }
}

