/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationLiteral<T extends Annotation>
implements Annotation,
Serializable {
    private transient Class<T> annotationType;
    private transient Method[] members;

    protected AnnotationLiteral() {
    }

    private Method[] getMembers() {
        if (this.members == null) {
            this.members = this.annotationType().getDeclaredMethods();
            if (this.members.length > 0 && !this.annotationType().isAssignableFrom(this.getClass())) {
                throw new RuntimeException(this.getClass() + " does not implement the annotation type with members " + this.annotationType().getName());
            }
        }
        return this.members;
    }

    private static Class<?> getAnnotationLiteralSubclass(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass.equals(AnnotationLiteral.class)) {
            return clazz;
        }
        if (superclass.equals(Object.class)) {
            return null;
        }
        return AnnotationLiteral.getAnnotationLiteralSubclass(superclass);
    }

    private static <T> Class<T> getTypeParameter(Class<?> annotationLiteralSuperclass) {
        ParameterizedType parameterizedType;
        Type type = annotationLiteralSuperclass.getGenericSuperclass();
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getActualTypeArguments().length == 1) {
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        if (this.annotationType == null) {
            Class<?> annotationLiteralSubclass = AnnotationLiteral.getAnnotationLiteralSubclass(this.getClass());
            if (annotationLiteralSubclass == null) {
                throw new RuntimeException(this.getClass() + "is not a subclass of AnnotationLiteral");
            }
            this.annotationType = AnnotationLiteral.getTypeParameter(annotationLiteralSubclass);
            if (this.annotationType == null) {
                throw new RuntimeException(this.getClass() + " does not specify the type parameter T of AnnotationLiteral<T>");
            }
        }
        return this.annotationType;
    }

    @Override
    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append('@').append(this.annotationType().getName()).append('(');
        for (int i2 = 0; i2 < this.getMembers().length; ++i2) {
            int j;
            string.append(this.getMembers()[i2].getName()).append('=');
            Object value = AnnotationLiteral.invoke(this.getMembers()[i2], this);
            if (value instanceof boolean[]) {
                this.appendInBraces(string, Arrays.toString((boolean[])value));
            } else if (value instanceof byte[]) {
                this.appendInBraces(string, Arrays.toString((byte[])value));
            } else if (value instanceof short[]) {
                this.appendInBraces(string, Arrays.toString((short[])value));
            } else if (value instanceof int[]) {
                this.appendInBraces(string, Arrays.toString((int[])value));
            } else if (value instanceof long[]) {
                this.appendInBraces(string, Arrays.toString((long[])value));
            } else if (value instanceof float[]) {
                this.appendInBraces(string, Arrays.toString((float[])value));
            } else if (value instanceof double[]) {
                this.appendInBraces(string, Arrays.toString((double[])value));
            } else if (value instanceof char[]) {
                this.appendInBraces(string, Arrays.toString((char[])value));
            } else if (value instanceof String[]) {
                String[] strings = (String[])value;
                Object[] quoted = new String[strings.length];
                for (j = 0; j < strings.length; ++j) {
                    quoted[j] = "\"" + strings[j] + "\"";
                }
                this.appendInBraces(string, Arrays.toString(quoted));
            } else if (value instanceof Class[]) {
                Class[] classes = (Class[])value;
                Object[] names = new String[classes.length];
                for (j = 0; j < classes.length; ++j) {
                    names[j] = classes[j].getName() + ".class";
                }
                this.appendInBraces(string, Arrays.toString(names));
            } else if (value instanceof Object[]) {
                this.appendInBraces(string, Arrays.toString((Object[])value));
            } else if (value instanceof String) {
                string.append('\"').append(value).append('\"');
            } else if (value instanceof Class) {
                string.append(((Class)value).getName()).append(".class");
            } else {
                string.append(value);
            }
            if (i2 >= this.getMembers().length - 1) continue;
            string.append(", ");
        }
        return string.append(')').toString();
    }

    private void appendInBraces(StringBuilder buf, String s) {
        buf.append('{').append(s.substring(1, s.length() - 1)).append('}');
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Annotation) {
            Annotation that = (Annotation)other;
            if (this.annotationType().equals(that.annotationType())) {
                for (Method member : this.getMembers()) {
                    Object thisValue = AnnotationLiteral.invoke(member, this);
                    Object thatValue = AnnotationLiteral.invoke(member, that);
                    if (!(thisValue instanceof byte[] && thatValue instanceof byte[] ? !Arrays.equals((byte[])thisValue, (byte[])thatValue) : (thisValue instanceof short[] && thatValue instanceof short[] ? !Arrays.equals((short[])thisValue, (short[])thatValue) : (thisValue instanceof int[] && thatValue instanceof int[] ? !Arrays.equals((int[])thisValue, (int[])thatValue) : (thisValue instanceof long[] && thatValue instanceof long[] ? !Arrays.equals((long[])thisValue, (long[])thatValue) : (thisValue instanceof float[] && thatValue instanceof float[] ? !Arrays.equals((float[])thisValue, (float[])thatValue) : (thisValue instanceof double[] && thatValue instanceof double[] ? !Arrays.equals((double[])thisValue, (double[])thatValue) : (thisValue instanceof char[] && thatValue instanceof char[] ? !Arrays.equals((char[])thisValue, (char[])thatValue) : (thisValue instanceof boolean[] && thatValue instanceof boolean[] ? !Arrays.equals((boolean[])thisValue, (boolean[])thatValue) : (thisValue instanceof Object[] && thatValue instanceof Object[] ? !Arrays.equals((Object[])thisValue, (Object[])thatValue) : !thisValue.equals(thatValue))))))))))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (Method member : this.getMembers()) {
            int memberNameHashCode = 127 * member.getName().hashCode();
            Object value = AnnotationLiteral.invoke(member, this);
            int memberValueHashCode = value instanceof boolean[] ? Arrays.hashCode((boolean[])value) : (value instanceof short[] ? Arrays.hashCode((short[])value) : (value instanceof int[] ? Arrays.hashCode((int[])value) : (value instanceof long[] ? Arrays.hashCode((long[])value) : (value instanceof float[] ? Arrays.hashCode((float[])value) : (value instanceof double[] ? Arrays.hashCode((double[])value) : (value instanceof byte[] ? Arrays.hashCode((byte[])value) : (value instanceof char[] ? Arrays.hashCode((char[])value) : (value instanceof Object[] ? Arrays.hashCode((Object[])value) : value.hashCode()))))))));
            hashCode += memberNameHashCode ^ memberValueHashCode;
        }
        return hashCode;
    }

    private static Object invoke(Method method, Object instance) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(instance, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
    }
}

