/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms.naming;

import com.tibco.tibjms.TibjmsQueueConnectionFactory;
import com.tibco.tibjms.naming.TibjmsNameParser;
import com.tibco.tibjms.naming.TibjmsNamingConstants;
import com.tibco.tibjms.naming.TibjmsNamingEnvUtil;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.CompoundName;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class TibjmsFederatedQueueConnectionFactory
extends TibjmsQueueConnectionFactory
implements Referenceable,
TibjmsNamingConstants {
    private static final long serialVersionUID = 1L;
    private Hashtable environment;
    private String jndiName;

    public TibjmsFederatedQueueConnectionFactory(String string, String string2, String string3, Map map, Hashtable hashtable) throws NamingException {
        super(string2, string3, map);
        this.jndiName = string;
        if (hashtable == null) {
            throw new IllegalStateException("The JNDI environment is not initialized.");
        }
        this.environment = new Hashtable(hashtable);
    }

    public TibjmsFederatedQueueConnectionFactory() {
    }

    @Override
    public Reference getReference() throws NamingException {
        CompoundName compoundName = (CompoundName)this.getNameParser("").parse("$factories:" + this.jndiName);
        String string = TibjmsNamingEnvUtil.getReferenceURLBase(this.environment) + "/" + compoundName.toString();
        Reference reference = new Reference(this.getClass().getName(), new StringRefAddr("URL", string));
        return reference;
    }

    public NameParser getNameParser(String string) throws NamingException {
        TibjmsNameParser tibjmsNameParser = new TibjmsNameParser();
        tibjmsNameParser.parse(string);
        return tibjmsNameParser;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.environment);
        objectOutput.writeObject(this.jndiName);
        super.writeExternal(objectOutput);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.environment = (Hashtable)objectInput.readObject();
        this.jndiName = (String)objectInput.readObject();
        super.readExternal(objectInput);
    }
}

