/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsxConst;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.JMSException;

public class TibjmsxURL
implements TibjmsxConst {
    String url = null;
    int protocol = 0;
    String host = null;
    int port = 0;

    public static final String getProtocolName(int n) {
        switch (n) {
            case 1: {
                return "TCP";
            }
            case 12: {
                return "TCP2";
            }
            case 2: {
                return "SSL";
            }
            case 3: {
                return "HTTP";
            }
            case 4: {
                return "HTTPS";
            }
            case 10: {
                return "tibjmsnaming";
            }
        }
        return null;
    }

    public TibjmsxURL() {
    }

    public TibjmsxURL(String string, int n, String string2, int n2) {
        this.url = string;
        this.protocol = n;
        this.host = string2;
        this.port = n2;
    }

    public String getFullURL() throws JMSException {
        String string = TibjmsxURL.getProtocolName(this.protocol);
        if (string == null) {
            throw new JMSException("Invalid protocol");
        }
        string = string.toLowerCase();
        return string + "://" + this.host + ":" + String.valueOf(this.port);
    }

    public String getNamingURL() throws JMSException {
        String string = "tibjmsnaming://" + this.host + ":" + String.valueOf(this.port);
        return string;
    }

    public String getURL() {
        return this.url;
    }

    public static Vector parseMultiple(String string) throws JMSException {
        if (string == null) {
            return null;
        }
        Vector<TibjmsxURL> vector = new Vector<TibjmsxURL>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ((string2 = string2.trim()).length() == 0) continue;
            vector.addElement(TibjmsxURL.parse(string2));
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public static TibjmsxURL parse(String string) throws JMSException {
        int n;
        String string2;
        if (string == null) {
            string = "tcp://localhost:7222";
        }
        int n2 = 0;
        String string3 = null;
        String string4 = null;
        String string5 = string.toLowerCase();
        if (string5.startsWith("tcp://")) {
            n2 = 1;
            string5 = string.substring(6, string.length());
        } else if (string5.startsWith("tcp2://")) {
            n2 = 12;
            string5 = string.substring(7, string.length());
        } else if (string5.startsWith("ssl://")) {
            n2 = 2;
            string5 = string.substring(6, string.length());
        } else if (string5.startsWith("http://")) {
            n2 = 3;
            string5 = string.substring(7, string.length());
        } else if (string5.startsWith("https://")) {
            n2 = 4;
            string5 = string.substring(8, string.length());
        } else if (string5.startsWith("tibjmsnaming:")) {
            n2 = 10;
            string5 = string.substring("tibjmsnaming".length() + 3, string.length());
        } else {
            if (string5.indexOf("://") >= 0) {
                throw new JMSException("Invalid protocol specification");
            }
            n2 = 1;
            string5 = string;
        }
        String string6 = string2 = n2 == 2 ? "7243" : "7222";
        if (string5.length() == 0) {
            string3 = "localhost";
            string4 = string2;
        } else {
            int n3;
            int n4 = 0;
            int n5 = string5.indexOf(91);
            if (n5 != -1) {
                n3 = string5.indexOf(93);
                if (n3 > n5 + 2) {
                    n4 = n3 + 1;
                } else {
                    throw new JMSException("Invalid or missing host name");
                }
            }
            if ((n3 = string5.indexOf(58, n4)) < 0) {
                boolean bl = true;
                try {
                    n = Integer.parseInt(string5);
                    if (string5.indexOf(46) < 0) {
                        string3 = "localhost";
                        string4 = string5;
                        bl = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                if (bl) {
                    string3 = string5;
                    string4 = string2;
                }
            } else {
                string3 = string5.substring(0, n3);
                string4 = string5.substring(n3 + 1, string5.length());
            }
            if (string3.length() == 0) {
                throw new JMSException("Invalid or missing host name");
            }
            if (string4.length() == 0) {
                throw new JMSException("Invalid or missing port number");
            }
        }
        try {
            n = Integer.parseInt(string4);
            if (n > 65535) {
                n = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        if (n == 0) {
            throw new JMSException("Invalid port number");
        }
        return new TibjmsxURL(string, n2, string3, n);
    }

    public String toString() {
        if (this.url == null) {
            return "";
        }
        return this.url;
    }
}

