/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsDestination;
import com.tibco.tibjms.TibjmsMapMessage;
import com.tibco.tibjms.TibjmsMessage;
import com.tibco.tibjms.TibjmsQueue;
import com.tibco.tibjms.TibjmsSession;
import com.tibco.tibjms.TibjmsStreamMessage;
import com.tibco.tibjms.TibjmsTopic;
import com.tibco.tibjms.TibjmsxConst;
import java.io.EOFException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;

public class TibjmsxStream
implements Serializable,
Cloneable,
TibjmsxConst {
    private static final long serialVersionUID = -8253400451981113126L;
    byte[] buffer = null;
    int buflen = 0;
    int curpos = 0;
    String encoding = null;
    private transient char[] charbuf = null;
    private transient int _mark = 0;
    private static Object _inflaterLock = new Object();
    private static LinkedList _inflaters = new LinkedList();
    private static final int _max_inflater_count = 7;
    private static int _inflater_count = 0;
    private static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public TibjmsxStream() {
        this.buffer = new byte[256];
        this.buflen = this.buffer.length;
    }

    public TibjmsxStream(int n) {
        this.buffer = new byte[n];
        this.buflen = this.buffer.length;
    }

    public TibjmsxStream(byte[] byArray) {
        this.buffer = byArray;
        this.buflen = byArray.length;
    }

    public TibjmsxStream(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.curpos = n;
        this.buflen = n + n2;
    }

    public Object clone() {
        TibjmsxStream tibjmsxStream = new TibjmsxStream(this.buffer.length);
        if (this.buffer.length > 0) {
            System.arraycopy(this.buffer, 0, tibjmsxStream.buffer, 0, this.buffer.length);
        }
        tibjmsxStream.buflen = this.buflen;
        tibjmsxStream.curpos = this.curpos;
        return tibjmsxStream;
    }

    public void flush() {
    }

    public void close() {
    }

    public int available() {
        return this.buflen - this.curpos;
    }

    public int skip(int n) throws EOFException {
        if (n < 0) {
            return 0;
        }
        int n2 = this.buflen - this.curpos;
        if (n2 <= n) {
            this.curpos = this.buflen;
            return n2;
        }
        this.curpos += n;
        return n;
    }

    public int skipLength(int n) throws EOFException {
        int n2;
        if (n == 2) {
            n2 = this.readUnsignedShort();
        } else if (n == 4) {
            n2 = this.readInt();
        } else {
            throw new InternalError("Invalid length " + n + " in skipLength");
        }
        if (n2 < 0) {
            throw new EOFException();
        }
        int n3 = this.buflen - this.curpos;
        if (n3 <= n2) {
            this.curpos = this.buflen;
            return n3;
        }
        this.curpos += n2;
        return n2;
    }

    void skipWrite(int n) {
        if (this.curpos + n > this.buflen) {
            this.ensure(n);
        }
        this.curpos += n;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this._mark = n;
    }

    public final byte[] getBuffer() {
        return this.buffer;
    }

    public final int getPosition() {
        return this.curpos;
    }

    final void setPosition(int n) {
        this.curpos = n;
    }

    public final void reset() {
        this.curpos = this._mark;
    }

    public void startReading() {
        this.buflen = this.curpos;
        this.curpos = 0;
        this._mark = 0;
    }

    public void startWriting() {
        this.buflen = this.buffer.length;
        this.curpos = 0;
        this._mark = 0;
    }

    final void ensure(int n) {
        if (this.curpos + n <= this.buflen) {
            return;
        }
        int n2 = 0;
        n2 = n > 100000 ? this.curpos + n + 2048 : (this.curpos + n) * 2;
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buffer, 0, byArray, 0, this.curpos);
        this.buffer = byArray;
        this.buflen = n2;
    }

    public final void write(int n) {
        if (this.curpos >= this.buflen) {
            this.ensure(1);
        }
        this.buffer[this.curpos++] = (byte)n;
    }

    public final void write(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.ensure(n2);
        System.arraycopy(byArray, n, this.buffer, this.curpos, n2);
        this.curpos += n2;
    }

    public final void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public final void writeBytes(byte[] byArray) {
        if (byArray == null) {
            this.writeVarLong(-1L);
            return;
        }
        this.writeVarLong(byArray.length);
        if (byArray.length > 0) {
            this.write(byArray, 0, byArray.length);
        }
    }

    public final void writeBytes(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            this.writeVarLong(-1L);
            return;
        }
        this.writeVarLong(n2);
        if (n2 > 0) {
            this.write(byArray, n, n2);
        }
    }

    public final void writeBoolean(boolean bl) {
        if (this.curpos >= this.buflen) {
            this.ensure(1);
        }
        this.buffer[this.curpos++] = bl ? (byte)1 : 0;
    }

    public final void writeByte(int n) {
        if (this.curpos >= this.buflen) {
            this.ensure(1);
        }
        this.buffer[this.curpos++] = (byte)n;
    }

    public final void writeShort(int n) {
        if (this.curpos + 2 > this.buflen) {
            this.ensure(2);
        }
        this.buffer[this.curpos++] = (byte)(n >>> 8);
        this.buffer[this.curpos++] = (byte)n;
    }

    public final void writeChar(int n) {
        if (this.curpos + 2 > this.buflen) {
            this.ensure(2);
        }
        this.buffer[this.curpos++] = (byte)(n >>> 8);
        this.buffer[this.curpos++] = (byte)n;
    }

    public final void writeInt(int n) {
        if (this.curpos + 4 > this.buflen) {
            this.ensure(4);
        }
        this.buffer[this.curpos++] = (byte)(n >> 24);
        this.buffer[this.curpos++] = (byte)(n >> 16);
        this.buffer[this.curpos++] = (byte)(n >> 8);
        this.buffer[this.curpos++] = (byte)n;
    }

    public final void writeIntAt(int n, int n2) {
        if (n + 4 > this.buflen) {
            throw new InternalError("bad position in writeIntAt");
        }
        this.buffer[n++] = (byte)(n2 >> 24);
        this.buffer[n++] = (byte)(n2 >> 16);
        this.buffer[n++] = (byte)(n2 >> 8);
        this.buffer[n++] = (byte)n2;
    }

    public final void writeLong(long l) {
        if (this.curpos + 8 > this.buflen) {
            this.ensure(8);
        }
        int n = (int)(l >> 32);
        int n2 = (int)l;
        this.buffer[this.curpos] = (byte)(n >> 24);
        this.buffer[this.curpos + 1] = (byte)(n >> 16);
        this.buffer[this.curpos + 2] = (byte)(n >> 8);
        this.buffer[this.curpos + 3] = (byte)n;
        this.buffer[this.curpos + 4] = (byte)(n2 >> 24);
        this.buffer[this.curpos + 5] = (byte)(n2 >> 16);
        this.buffer[this.curpos + 6] = (byte)(n2 >> 8);
        this.buffer[this.curpos + 7] = (byte)n2;
        this.curpos += 8;
    }

    public final void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeUTF(String string) throws UTFDataFormatException {
        int n = this.curpos;
        int n2 = 0;
        if (this.curpos + 2 > this.buflen) {
            this.ensure(2 + string.length() * 3);
        }
        this.curpos += 2;
        try {
            n2 = this.writeUTFString(string);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            this.curpos = n;
            throw uTFDataFormatException;
        }
        this.buffer[n] = (byte)(n2 >>> 8 & 0xFF);
        this.buffer[n + 1] = (byte)(n2 & 0xFF);
    }

    public final int writeUTFString(String string) throws UTFDataFormatException {
        int n = 0;
        int n2 = string.length();
        int n3 = this.curpos;
        if (this.curpos + 3 * n2 > this.buflen) {
            this.ensure(n2 * 3);
        }
        if (this.charbuf == null || this.charbuf.length < n2) {
            this.charbuf = new char[n2 != 0 ? n2 : 16];
        }
        string.getChars(0, n2, this.charbuf, 0);
        while (n < n2) {
            char c;
            if ((c = this.charbuf[n++]) >= '\u0001' && c <= '\u007f') {
                this.buffer[this.curpos++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.buffer[this.curpos++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buffer[this.curpos++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buffer[this.curpos++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.buffer[this.curpos++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.buffer[this.curpos++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        int n4 = this.curpos - n3;
        if (n4 > 65535) {
            this.curpos = n3;
            throw new UTFDataFormatException("String is too long");
        }
        return n4;
    }

    public final int writeString(String string) throws JMSException {
        return this.writeString(string, false);
    }

    public final int writeString(String string, boolean bl) throws JMSException {
        if (string == null) {
            throw new JMSException("null parameter");
        }
        return this.writeString(string, 0, string.length(), bl);
    }

    public final int writeString(String string, int n, int n2, boolean bl) throws JMSException {
        String string2;
        int n3 = Encoding.getTibjmsEncoding(this.encoding);
        int n4 = n2;
        int n5 = this.curpos;
        boolean bl2 = false;
        if (n3 != -1) {
            if (this.charbuf == null || this.charbuf.length < n4) {
                this.charbuf = new char[n4 != 0 ? n4 : 16];
            }
            string.getChars(n, n + n2, this.charbuf, 0);
            if (!bl) {
                this.writeVarLong(n4 + 1);
            } else {
                if (n4 > 127) {
                    throw new InvalidDestinationException("destination token longer than 127");
                }
                this.writeByte((byte)(n4 + 2));
            }
            if (this.curpos + n4 + 2 > this.buflen) {
                this.ensure(n4 + 2);
            }
            int n6 = 0;
            if (n3 != 8) {
                while (n6 < n4) {
                    char c = this.charbuf[n6++];
                    this.buffer[this.curpos++] = Encoding.charToByte(c, n3);
                }
            } else {
                while (n6 < n4) {
                    char c;
                    if ((c = this.charbuf[n6++]) != '\u0000' && c <= '\u007f') {
                        this.buffer[this.curpos++] = (byte)c;
                        continue;
                    }
                    bl2 = true;
                    break;
                }
            }
            if (!bl2) {
                this.buffer[this.curpos++] = 0;
                return this.curpos - n5;
            }
            string2 = "UTF8";
        } else {
            string2 = this.encoding;
        }
        try {
            byte[] byArray = null;
            if (!bl) {
                byArray = string.getBytes(string2);
                this.curpos = n5;
                this.writeVarLong(byArray.length + 1);
                this.write(byArray);
                this.writeByte(0);
            } else {
                byArray = n == 0 && n2 == string.length() ? string.getBytes(string2) : string.substring(n, n + n2).getBytes(string2);
                if (byArray.length > 127) {
                    throw new InvalidDestinationException("destination token longer than 127");
                }
                this.curpos = n5;
                this.writeByte((byte)byArray.length + 2);
                this.write(byArray);
                this.writeByte(0);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.curpos = n5;
            throw new MessageFormatException("Invalid encoding '" + string2 + "'");
        }
        return this.curpos - n5;
    }

    public final int read() {
        return this.curpos < this.buflen ? this.buffer[this.curpos++] & 0xFF : -1;
    }

    public int read(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.curpos >= this.buflen) {
            return -1;
        }
        if (this.curpos + n2 > this.buflen) {
            n2 = this.buflen - this.curpos;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buffer, this.curpos, byArray, n, n2);
        this.curpos += n2;
        return n2;
    }

    public final void readFully(byte[] byArray) throws EOFException {
        int n = byArray.length;
        if (n <= 0) {
            return;
        }
        if (this.curpos + n > this.buflen) {
            throw new EOFException();
        }
        System.arraycopy(this.buffer, this.curpos, byArray, 0, n);
        this.curpos += n;
    }

    public final void readFully(byte[] byArray, int n, int n2) throws EOFException {
        if (n2 <= 0) {
            return;
        }
        if (this.curpos + n2 > this.buflen) {
            throw new EOFException();
        }
        System.arraycopy(this.buffer, this.curpos, byArray, n, n2);
        this.curpos += n2;
    }

    public final byte[] readBytes() throws EOFException {
        int n = this.curpos;
        long l = this.readVarLong();
        if (l == -1L) {
            return null;
        }
        if (l == 0L) {
            return new byte[0];
        }
        int n2 = (int)l;
        if (this.curpos + n2 > this.buflen) {
            this.curpos = n;
            throw new EOFException();
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buffer, this.curpos, byArray, 0, n2);
        this.curpos += n2;
        return byArray;
    }

    public final void skipBytes() throws EOFException {
        int n = this.curpos;
        long l = this.readVarLong();
        if (l == -1L) {
            return;
        }
        if (l == 0L) {
            return;
        }
        int n2 = (int)l;
        if (this.curpos + n2 > this.buflen) {
            this.curpos = n;
            throw new EOFException();
        }
        this.curpos += n2;
    }

    public final int getUnsignedByte() throws EOFException {
        if (this.curpos >= this.buflen) {
            throw new EOFException();
        }
        return this.buffer[this.curpos] & 0xFF;
    }

    public final int readUnsignedByte() throws EOFException {
        if (this.curpos >= this.buflen) {
            throw new EOFException();
        }
        return this.buffer[this.curpos++] & 0xFF;
    }

    public final boolean readBoolean() throws EOFException {
        if (this.curpos >= this.buflen) {
            throw new EOFException();
        }
        return this.buffer[this.curpos++] != 0;
    }

    public final byte readByte() throws EOFException {
        if (this.curpos >= this.buflen) {
            throw new EOFException();
        }
        return this.buffer[this.curpos++];
    }

    public final char readChar() throws EOFException {
        if (this.curpos + 2 > this.buflen) {
            throw new EOFException();
        }
        return (char)((this.buffer[this.curpos++] << 8) + (this.buffer[this.curpos++] & 0xFF));
    }

    public final short readShort() throws EOFException {
        if (this.curpos + 2 > this.buflen) {
            throw new EOFException();
        }
        return (short)((this.buffer[this.curpos++] << 8) + (this.buffer[this.curpos++] & 0xFF));
    }

    public final int readUnsignedShort() throws EOFException {
        if (this.curpos + 2 > this.buflen) {
            throw new EOFException();
        }
        int n = (this.buffer[this.curpos++] << 8) + (this.buffer[this.curpos++] & 0xFF);
        return n & 0xFFFF;
    }

    public final int readInt() throws EOFException {
        if (this.curpos + 4 > this.buflen) {
            throw new EOFException();
        }
        return (this.buffer[this.curpos++] << 24) + (this.buffer[this.curpos++] << 16 & 0xFF0000) + (this.buffer[this.curpos++] << 8 & 0xFF00) + (this.buffer[this.curpos++] & 0xFF);
    }

    public final long readLong() throws EOFException {
        if (this.curpos + 8 > this.buflen) {
            throw new EOFException();
        }
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final float readFloat() throws EOFException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws EOFException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readUTF() throws EOFException, UTFDataFormatException {
        int n = this.curpos;
        try {
            int n2 = this.readUnsignedShort();
            return this.readUTFString(n2);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            this.curpos = n;
            throw uTFDataFormatException;
        }
        catch (EOFException eOFException) {
            this.curpos = n;
            throw eOFException;
        }
    }

    public final String readUTFString(int n) throws EOFException, UTFDataFormatException {
        if (this.curpos + n > this.buflen) {
            throw new EOFException();
        }
        int n2 = this.curpos;
        int n3 = 0;
        int n4 = this.curpos + n;
        if (this.charbuf == null || this.charbuf.length < n) {
            this.charbuf = new char[n == 0 ? 16 : n];
        }
        while (this.curpos < n4) {
            byte by;
            int n5;
            int n6;
            if ((n6 = (n5 = this.buffer[this.curpos++] & 0xFF) >> 4) <= 7) {
                this.charbuf[n3++] = (char)n5;
                continue;
            }
            if (n6 == 12 || n6 == 13) {
                if (this.curpos + 1 > n4) {
                    this.curpos = n2;
                    throw new UTFDataFormatException();
                }
                if (((by = this.buffer[this.curpos++]) & 0xC0) != 128) {
                    this.curpos = n2;
                    throw new UTFDataFormatException();
                }
                this.charbuf[n3++] = (char)((n5 & 0x1F) << 6 | by & 0x3F);
                continue;
            }
            if (n6 == 14) {
                if (this.curpos + 2 > n4) {
                    this.curpos = n2;
                    throw new UTFDataFormatException();
                }
                by = this.buffer[this.curpos++];
                byte by2 = this.buffer[this.curpos++];
                if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                    this.curpos = n2;
                    throw new UTFDataFormatException();
                }
                this.charbuf[n3++] = (char)((n5 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                continue;
            }
            this.curpos = n2;
            throw new UTFDataFormatException();
        }
        if (this.curpos != n4) {
            this.curpos = n2;
            throw new UTFDataFormatException();
        }
        return new String(this.charbuf, 0, n3);
    }

    final String _cs(byte[] byArray, int n, int n2, String string) {
        String string2 = null;
        try {
            string2 = new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = null;
        }
        return string2;
    }

    public final String readString() throws EOFException, JMSException {
        return this.readString(false);
    }

    public final String readStringOld(boolean bl) throws EOFException, JMSException {
        int n = this.curpos;
        boolean bl2 = false;
        long l = (int)this.readVarLong();
        if (l == -1L) {
            return null;
        }
        int n2 = (int)l;
        if (bl) {
            --n2;
        }
        if (n2 == 1) {
            this.readByte();
            return "";
        }
        if (this.curpos + n2 > this.buflen) {
            throw new EOFException();
        }
        int n3 = this.curpos;
        if (this.charbuf == null || this.charbuf.length < n2) {
            this.charbuf = new char[n2 != 0 ? n2 : 16];
        }
        for (int j = 0; j < n2 - 1; ++j) {
            int n4;
            if ((n4 = this.buffer[this.curpos++] & 0xFF) == 0 || n4 > 127) {
                bl2 = true;
                break;
            }
            this.charbuf[j] = (char)n4;
        }
        if (!bl2) {
            ++this.curpos;
            return new String(this.charbuf, 0, n2 - 1);
        }
        this.curpos = n3 + n2;
        String string = this._cs(this.buffer, n3, n2 - 1, "UTF8");
        if (string == null) {
            this.curpos = n;
            throw new JMSException("Error occurred decoding the message");
        }
        return string;
    }

    public final String readString(boolean bl) throws EOFException, JMSException {
        String string;
        int n = Encoding.getTibjmsEncoding(this.encoding);
        int n2 = this.curpos;
        int n3 = 0;
        boolean bl2 = false;
        if (bl) {
            n3 = this.readUnsignedByte();
            --n3;
        } else {
            long l = this.readVarLong();
            if (l == -1L) {
                return null;
            }
            n3 = (int)l;
            if (n3 <= 0) {
                throw new EOFException();
            }
        }
        if (n3 == 1) {
            this.readByte();
            return "";
        }
        if (this.curpos + n3 > this.buflen) {
            this.curpos = n2;
            throw new EOFException();
        }
        int n4 = this.curpos;
        if (n != -1) {
            int n5;
            if (this.charbuf == null || this.charbuf.length < n3) {
                this.charbuf = new char[n3 != 0 ? n3 : 16];
            }
            if (n != 8) {
                for (n5 = 0; n5 < n3 - 1; ++n5) {
                    int n6 = this.buffer[this.curpos++] & 0xFF;
                    this.charbuf[n5] = Encoding.byteToChar((byte)n6, n);
                }
            } else {
                for (n5 = 0; n5 < n3 - 1; ++n5) {
                    int n7;
                    if ((n7 = this.buffer[this.curpos++] & 0xFF) == 0 || n7 > 127) {
                        bl2 = true;
                        break;
                    }
                    this.charbuf[n5] = (char)n7;
                }
            }
            if (!bl2) {
                ++this.curpos;
                return new String(this.charbuf, 0, n3 - 1);
            }
            string = "UTF8";
        } else {
            string = this.encoding;
        }
        this.curpos = n4 + n3;
        String string2 = this._cs(this.buffer, n4, n3 - 1, string);
        if (string2 == null) {
            this.curpos = n2;
            throw new MessageFormatException("Error occurred decoding the message or encoding '" + string + "' not supported");
        }
        return string2;
    }

    public long readVarLong() throws EOFException {
        if (this.curpos >= this.buflen) {
            throw new EOFException();
        }
        byte by = this.buffer[this.curpos];
        if (by == -16) {
            ++this.curpos;
            return -1L;
        }
        if ((by & 0xFFFFFF80) == 0) {
            ++this.curpos;
            return by;
        }
        if ((by & 0x40) == 0) {
            if (this.curpos + 2 > this.buflen) {
                throw new EOFException();
            }
            short s = (short)((this.buffer[this.curpos++] << 8) + (this.buffer[this.curpos++] & 0xFF));
            return s & 0x3FFF;
        }
        if ((by & 0x20) == 0) {
            if (this.curpos + 4 > this.buflen) {
                throw new EOFException();
            }
            int n = (this.buffer[this.curpos++] << 24) + (this.buffer[this.curpos++] << 16 & 0xFF0000) + (this.buffer[this.curpos++] << 8 & 0xFF00) + (this.buffer[this.curpos++] & 0xFF);
            return n & 0x1FFFFFFF;
        }
        int n = by & 0xF;
        ++this.curpos;
        if (this.curpos + n > this.buflen) {
            throw new EOFException();
        }
        long l = 0L;
        for (int j = 0; j < n; ++j) {
            l <<= 8;
            l |= (long)(this.buffer[this.curpos++] & 0xFF);
        }
        return l;
    }

    public int getVarLongLength() throws EOFException {
        if (this.curpos >= this.buflen) {
            throw new EOFException();
        }
        byte by = this.buffer[this.curpos];
        if (by == -16) {
            return 1;
        }
        if ((by & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((by & 0x40) == 0) {
            return 2;
        }
        if ((by & 0x20) == 0) {
            return 4;
        }
        int n = by & 0xF;
        return n + 1;
    }

    public final void writeVarLong(long l) {
        int n;
        if (l == -1L) {
            if (this.curpos >= this.buflen) {
                this.ensure(1);
            }
            this.buffer[this.curpos++] = -16;
            return;
        }
        if (l < 0L) {
            throw new InternalError("Can not pack negative long value");
        }
        if (l <= 127L) {
            if (this.curpos >= this.buflen) {
                this.ensure(1);
            }
            this.buffer[this.curpos++] = (byte)l;
            return;
        }
        if (l <= 16383L) {
            if (this.curpos + 2 > this.buflen) {
                this.ensure(2);
            }
            this.buffer[this.curpos++] = (byte)((l |= 0x8000L) >>> 8);
            this.buffer[this.curpos++] = (byte)l;
            return;
        }
        if (l <= 0x1FFFFFFFL) {
            if (this.curpos + 4 > this.buflen) {
                this.ensure(4);
            }
            l |= 0xFFFFFFFFC0000000L;
            this.curpos += 4;
            int n2 = 1;
            while (n2 <= 4) {
                this.buffer[this.curpos - n2] = (byte)l;
                ++n2;
                l >>>= 8;
            }
            return;
        }
        if (this.curpos + 9 > this.buflen) {
            this.ensure(9);
        }
        long l2 = -72057594037927936L;
        int n3 = 8;
        for (n = 0; n < 8 && (l & l2) == 0L; ++n) {
            --n3;
            l2 >>>= 8;
        }
        n = (byte)(n3 | 0xE0);
        this.buffer[this.curpos++] = n;
        this.curpos += n3;
        int n4 = 1;
        while (n4 <= n3) {
            this.buffer[this.curpos - n4] = (byte)l;
            ++n4;
            l >>>= 8;
        }
    }

    public final void writeForcedVarLong(long l, int n) {
        if (l == -1L && n == 1) {
            if (this.curpos >= this.buflen) {
                this.ensure(1);
            }
            this.buffer[this.curpos++] = -16;
            return;
        }
        if (l < 0L) {
            throw new InternalError("Can not pack negative long value");
        }
        if (l <= 127L && n <= 1) {
            if (this.curpos >= this.buflen) {
                this.ensure(1);
            }
            this.buffer[this.curpos++] = (byte)l;
            return;
        }
        if (l <= 16383L && n <= 2) {
            if (this.curpos + 2 > this.buflen) {
                this.ensure(2);
            }
            this.buffer[this.curpos++] = (byte)((l |= 0x8000L) >>> 8);
            this.buffer[this.curpos++] = (byte)l;
            return;
        }
        if (l <= 0x1FFFFFFFL && n <= 4) {
            if (this.curpos + 4 > this.buflen) {
                this.ensure(4);
            }
            l |= 0xFFFFFFFFC0000000L;
            this.curpos += 4;
            int n2 = 1;
            while (n2 <= 4) {
                this.buffer[this.curpos - n2] = (byte)l;
                ++n2;
                l >>>= 8;
            }
            return;
        }
        if (this.curpos + n > this.buflen) {
            this.ensure(n);
        }
        int n3 = n - 1;
        byte by = (byte)(n3 | 0xE0);
        this.buffer[this.curpos++] = by;
        this.curpos += n3;
        int n4 = 1;
        while (n4 <= n3) {
            this.buffer[this.curpos - n4] = (byte)l;
            ++n4;
            l >>>= 8;
        }
    }

    public final int getVarLongLength(long l) {
        if (l == -1L) {
            return 1;
        }
        if (l < 0L) {
            throw new InternalError("Can not pack negative long value");
        }
        if (l <= 127L) {
            return 1;
        }
        if (l <= 16383L) {
            return 2;
        }
        if (l <= 0x1FFFFFFFL) {
            return 4;
        }
        long l2 = -72057594037927936L;
        int n = 8;
        for (int j = 0; j < 8 && (l & l2) == 0L; ++j) {
            --n;
            l2 >>>= 8;
        }
        return n + 1;
    }

    public void writeArray(Object object, int n) throws JMSException {
        short[] sArray = null;
        int[] nArray = null;
        long[] lArray = null;
        float[] fArray = null;
        double[] dArray = null;
        switch (n) {
            case 12: {
                sArray = (short[])object;
                int n2 = sArray.length;
                this.writeVarLong(n2 * 2);
                for (int j = 0; j < n2; ++j) {
                    this.writeShort(sArray[j]);
                }
                return;
            }
            case 13: {
                nArray = (int[])object;
                int n3 = nArray.length;
                this.writeVarLong(n3 * 4);
                for (int j = 0; j < n3; ++j) {
                    this.writeInt(nArray[j]);
                }
                return;
            }
            case 14: {
                lArray = (long[])object;
                int n4 = lArray.length;
                this.writeVarLong(n4 * 8);
                for (int j = 0; j < n4; ++j) {
                    this.writeLong(lArray[j]);
                }
                return;
            }
            case 15: {
                fArray = (float[])object;
                int n5 = fArray.length;
                this.writeVarLong(n5 * 4);
                for (int j = 0; j < n5; ++j) {
                    this.writeFloat(fArray[j]);
                }
                return;
            }
            case 16: {
                dArray = (double[])object;
                int n6 = dArray.length;
                this.writeVarLong(n6 * 8);
                for (int j = 0; j < n6; ++j) {
                    this.writeDouble(dArray[j]);
                }
                return;
            }
        }
        throw new JMSException("Invalid array type");
    }

    public Object readArray(int n) throws JMSException, EOFException {
        short[] sArray = null;
        int[] nArray = null;
        long[] lArray = null;
        float[] fArray = null;
        double[] dArray = null;
        long l = this.readVarLong();
        if (l > Integer.MAX_VALUE) {
            throw new JMSException("Invalid array encoding or array is too long");
        }
        int n2 = (int)l;
        switch (n) {
            case 12: {
                int n3 = n2 / 2;
                sArray = new short[n3];
                for (int j = 0; j < n3; ++j) {
                    sArray[j] = this.readShort();
                }
                return sArray;
            }
            case 13: {
                int n4 = n2 / 4;
                nArray = new int[n4];
                for (int j = 0; j < n4; ++j) {
                    nArray[j] = this.readInt();
                }
                return nArray;
            }
            case 14: {
                int n5 = n2 / 8;
                lArray = new long[n5];
                for (int j = 0; j < n5; ++j) {
                    lArray[j] = this.readLong();
                }
                return lArray;
            }
            case 15: {
                int n6 = n2 / 4;
                fArray = new float[n6];
                for (int j = 0; j < n6; ++j) {
                    fArray[j] = this.readFloat();
                }
                return fArray;
            }
            case 16: {
                int n7 = n2 / 8;
                dArray = new double[n7];
                for (int j = 0; j < n7; ++j) {
                    dArray[j] = this.readDouble();
                }
                return dArray;
            }
        }
        throw new JMSException("Invalid array type in the message body");
    }

    public Object readSubmsg(int n) throws JMSException, EOFException {
        TibjmsMessage tibjmsMessage = null;
        switch (n) {
            case 11: {
                tibjmsMessage = new TibjmsMapMessage();
                break;
            }
            case 18: {
                tibjmsMessage = new TibjmsStreamMessage();
                break;
            }
            default: {
                throw new JMSException("invalid submessage type");
            }
        }
        tibjmsMessage.readBody(this, false);
        return tibjmsMessage;
    }

    public void writeSubmsg(TibjmsMessage tibjmsMessage) throws JMSException {
        int n = this.curpos;
        this.skipWrite(4);
        int n2 = this.curpos;
        tibjmsMessage.writeBody(this, false);
        this.writeIntAt(n, this.curpos - n2);
    }

    public int writeTypedLong(long l) throws JMSException {
        if (l < 0L) {
            throw new JMSException("Negative typed numeric");
        }
        if (l <= 255L) {
            this.writeByte(2);
            this.writeByte((byte)l);
            return 2;
        }
        if (l <= 65535L) {
            this.writeByte(4);
            this.writeShort((short)l);
            return 3;
        }
        if (l <= 0xFFFFFFFFL) {
            this.writeByte(5);
            this.writeInt((int)l);
            return 5;
        }
        this.writeByte(6);
        this.writeLong(l);
        return 9;
    }

    public long readTypedLong() throws JMSException, EOFException {
        int n = this.readUnsignedByte();
        if (n == 2) {
            return this.readUnsignedByte();
        }
        if (n == 4) {
            return this.readUnsignedShort();
        }
        if (n == 5) {
            return (long)this.readInt() & 0xFFFFFFFFFFFFFFFFL;
        }
        return this.readLong();
    }

    public int getTypedLongType() throws EOFException {
        if (this.curpos >= this.buflen) {
            throw new EOFException();
        }
        return this.buffer[this.curpos] & 0xFF;
    }

    public int getTypedLongLength() throws EOFException {
        if (this.curpos >= this.buflen) {
            throw new EOFException();
        }
        int n = this.buffer[this.curpos] & 0xFF;
        if (n == 2) {
            return 2;
        }
        if (n == 4) {
            return 3;
        }
        if (n == 5) {
            return 5;
        }
        if (n == 6) {
            return 9;
        }
        return 0;
    }

    public void writeObject(Object object, int n, boolean bl) throws JMSException {
        if (n == 255 && (n = TibjmsMessage.getFieldType(object)) == 255) {
            n = TibjmsMessage.getExtendedType(object);
        }
        if (bl) {
            if (this.curpos >= this.buflen) {
                this.ensure(1);
            }
            this.buffer[this.curpos++] = (byte)n;
        }
        switch (n) {
            case 0: {
                return;
            }
            case 2: {
                this.writeByte(((Byte)object).byteValue());
                return;
            }
            case 1: {
                this.writeBoolean((Boolean)object);
                return;
            }
            case 3: {
                this.writeChar(((Character)object).charValue());
                return;
            }
            case 4: {
                this.writeShort(((Short)object).shortValue());
                return;
            }
            case 5: {
                this.writeInt((Integer)object);
                return;
            }
            case 6: {
                this.writeLong((Long)object);
                return;
            }
            case 7: {
                this.writeFloat(((Float)object).floatValue());
                return;
            }
            case 8: {
                this.writeDouble((Double)object);
                return;
            }
            case 10: {
                this.writeBytes((byte[])object);
                return;
            }
            case 9: {
                this.writeString((String)object, false);
                return;
            }
            case 11: {
                this.writeSubmsg((TibjmsMessage)object);
                return;
            }
            case 18: {
                this.writeSubmsg((TibjmsMessage)object);
                return;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                this.writeArray(object, n);
                return;
            }
        }
        throw new JMSException("Invalid value of class " + object.getClass().getName());
    }

    public Object readObject() throws EOFException, JMSException {
        int n = this.readUnsignedByte();
        switch (n) {
            case 0: {
                return null;
            }
            case 2: {
                return new Byte(this.readByte());
            }
            case 1: {
                return this.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return new Character(this.readChar());
            }
            case 4: {
                return new Short(this.readShort());
            }
            case 5: {
                return new Integer(this.readInt());
            }
            case 6: {
                return new Long(this.readLong());
            }
            case 7: {
                return new Float(this.readFloat());
            }
            case 8: {
                return new Double(this.readDouble());
            }
            case 10: {
                return this.readBytes();
            }
            case 9: {
                return this.readString(false);
            }
            case 11: {
                return this.readSubmsg(11);
            }
            case 18: {
                return this.readSubmsg(18);
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return this.readArray(n);
            }
            case 17: {
                return new Long(this.readVarLong());
            }
        }
        throw new JMSException("Corrupted message buffer", "Unrecognized object type in the message body");
    }

    public void skipObject() throws EOFException, JMSException {
        int n = this.readUnsignedByte();
        switch (n) {
            case 0: {
                return;
            }
            case 2: {
                this.skip(1);
                return;
            }
            case 1: {
                this.skip(1);
                return;
            }
            case 3: {
                this.skip(2);
                return;
            }
            case 4: {
                this.skip(2);
                return;
            }
            case 5: {
                this.skip(4);
                return;
            }
            case 6: {
                this.skip(8);
                return;
            }
            case 7: {
                this.skip(4);
                return;
            }
            case 8: {
                this.skip(8);
                return;
            }
            case 10: {
                this.skipBytes();
                return;
            }
            case 9: {
                this.readString(false);
                return;
            }
            case 11: {
                this.readSubmsg(n);
                return;
            }
            case 18: {
                this.readSubmsg(n);
                return;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                this.readArray(n);
                return;
            }
            case 17: {
                this.readVarLong();
                return;
            }
        }
        throw new JMSException("Corrupted message buffer", "Unrecognized object type in the message body");
    }

    final int writeRvHeader() {
        return this.writeRvHeader(0, this.curpos);
    }

    final int writeRvHeader(int n, int n2) {
        long l = n2;
        l <<= 32;
        l |= 0x9955EEAAL;
        if (n + 8 > this.buflen) {
            this.ensure(8);
        }
        n += 8;
        int n3 = 1;
        while (n3 <= 8) {
            this.buffer[n - n3] = (byte)l;
            ++n3;
            l >>>= 8;
        }
        return n2;
    }

    final int readRvHeader() throws EOFException, JMSException {
        int n = this.readInt();
        int n2 = this.readInt();
        if (n2 != -1722421590) {
            throw new JMSException("Corrupted message buffer", "Invalid message header");
        }
        return n;
    }

    final int skipRvHeader() throws EOFException {
        return this.skip(8);
    }

    final void writeDestination(TibjmsDestination tibjmsDestination) throws JMSException {
        if (tibjmsDestination == null) {
            this.writeByte(0);
        } else if (tibjmsDestination instanceof TibjmsTopic) {
            this.writeByte(2);
            this.writeRvSubject(tibjmsDestination.getAddress());
        } else if (tibjmsDestination instanceof TibjmsQueue) {
            this.writeByte(1);
            this.writeRvSubject(tibjmsDestination.getAddress());
        } else {
            throw new JMSException("Can not serialize: invalid destination object");
        }
    }

    final TibjmsDestination readDestination() throws EOFException, JMSException {
        int n = this.readUnsignedByte();
        switch (n) {
            case 0: {
                return null;
            }
            case 2: {
                return new TibjmsTopic(this.readRvSubject());
            }
            case 1: {
                return new TibjmsQueue(this.readRvSubject());
            }
        }
        throw new JMSException("Corrupted message buffer", "Unrecognized destination type in the message body");
    }

    final void writeRvSubject(String string) throws JMSException {
        if (this.curpos + 6 >= this.buflen) {
            this.ensure(6);
        }
        if (string == null) {
            this.writeShort(0);
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = this.curpos;
        int n5 = this.curpos + 2;
        this.curpos += 3;
        while (n >= 0 && n < n3) {
            ++n2;
            int n6 = string.indexOf(46, n);
            if (n6 >= 0) {
                this.writeString(string, n, n6 - n, true);
                n = n6 + 1;
                continue;
            }
            this.writeString(string, n, n3 - n, true);
            break;
        }
        this.buffer[n5] = (byte)n2;
        int n7 = this.curpos - n4;
        if (n7 > 255) {
            throw new InvalidDestinationException("destination name too long");
        }
        this.buffer[n4] = (byte)(n7 >>> 8);
        this.buffer[n4 + 1] = (byte)n7;
    }

    String readRvSubject() throws EOFException, JMSException {
        int n = this.readUnsignedShort();
        if (n == 0) {
            return null;
        }
        int n2 = this.readUnsignedByte();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int j = 0; j < n2; ++j) {
            String string = this.readString(true);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(string);
        }
        return new String(stringBuffer);
    }

    boolean writeCompressed(byte[] byArray) {
        if (byArray == null) {
            return this.writeCompressed(null, 0, 0);
        }
        return this.writeCompressed(byArray, 0, byArray.length);
    }

    boolean writeCompressed(byte[] byArray, int n, int n2) {
        return this.writeCompressed((Deflater)null, byArray, n, n2);
    }

    boolean writeCompressed(TibjmsSession tibjmsSession, byte[] byArray, int n, int n2) {
        Deflater deflater = null;
        if (tibjmsSession != null) {
            deflater = tibjmsSession._getDeflater();
        }
        return this.writeCompressed(deflater, byArray, n, n2);
    }

    boolean writeCompressed(Deflater deflater, byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        int n3 = 0;
        boolean bl = false;
        if (byArray == null) {
            return false;
        }
        int n4 = n2;
        int n5 = this.curpos;
        if (n2 > 0) {
            this.writeVarLong(n4);
            int n6 = this.getVarLongLength(n4);
            int n7 = this.curpos;
            this.writeForcedVarLong(0L, n6);
            int n8 = this.curpos;
            Deflater deflater2 = deflater;
            if (deflater2 == null) {
                deflater2 = new Deflater(-1);
                bl = true;
            }
            int n9 = (int)((double)n4 * 1.001) + 12 + 256;
            this.ensure(n9);
            deflater2.setInput(byArray, n, n2);
            deflater2.finish();
            n3 = deflater2.deflate(this.buffer, this.curpos, n9);
            if (!bl) {
                deflater2.reset();
            }
            if (n3 > 0 && n3 + n6 + 1 < n4) {
                this.curpos = n7;
                this.writeForcedVarLong(n3, n6);
                this.curpos = n8 + n3;
                return true;
            }
        }
        this.curpos = n5;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object _getInflater() {
        Object object = _inflaterLock;
        synchronized (object) {
            if (_inflater_count >= 7) {
                if (_inflaters.size() > 0) {
                    return _inflaters.removeFirst();
                }
            } else {
                CInf cInf = new CInf();
                cInf.inflater = new Inflater();
                ++_inflater_count;
                return cInf;
            }
        }
        return new Inflater();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void _returnInflater(Object object) {
        if (object instanceof Inflater) {
            ((Inflater)object).end();
            return;
        }
        Object object2 = _inflaterLock;
        synchronized (object2) {
            ((CInf)object).inflater.reset();
            _inflaters.add(object);
        }
    }

    byte[] readCompressed() throws EOFException {
        long l = 0L;
        l = this.readVarLong();
        if (l == -1L) {
            return null;
        }
        if (l == 0L) {
            return this.readBytes();
        }
        byte[] byArray = null;
        try {
            long l2 = (int)this.readVarLong();
            if (l2 == -1L) {
                return null;
            }
            if (l2 == 0L) {
                return new byte[0];
            }
            int n = (int)l2;
            if (this.curpos + n > this.buflen) {
                throw new EOFException();
            }
            Inflater inflater = null;
            Object object = TibjmsxStream._getInflater();
            inflater = object instanceof Inflater ? (Inflater)object : ((CInf)object).inflater;
            inflater.setInput(this.buffer, this.curpos, n);
            this.curpos += n;
            byArray = new byte[(int)l];
            int n2 = inflater.inflate(byArray);
            TibjmsxStream._returnInflater(object);
            if ((long)n2 != l) {
                throw new EOFException("Corrupt message");
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new EOFException("Corrupt message");
        }
        return byArray;
    }

    public static void printHexData(byte[] byArray) {
        TibjmsxStream.printHexData(System.err, byArray);
    }

    public static void printHexData(PrintStream printStream, byte[] byArray) {
        if (byArray == null) {
            printStream.println("[null byte array]");
            return;
        }
        TibjmsxStream.printHexData(printStream, byArray, 0, byArray.length);
    }

    public static void printHexData(byte[] byArray, int n, int n2) {
        TibjmsxStream.printHexData(System.err, byArray, n, n2);
    }

    private static String _getOffsetStr(int n) {
        String string = String.valueOf(n);
        while (string.length() < 5) {
            string = "0" + string;
        }
        string = string + ": ";
        return string;
    }

    public static void printHexData(PrintStream printStream, byte[] byArray, int n, int n2) {
        if (byArray == null) {
            printStream.println("[null byte array]");
            return;
        }
        if (byArray.length == 0) {
            printStream.println("[zero length byte array]");
            return;
        }
        if (n2 < 0 || n < 0 || n + n2 > byArray.length) {
            printStream.println("[invalid offset and length parameters]");
            return;
        }
        printStream.print(TibjmsxStream._getOffsetStr(0));
        for (int j = 0; j < n2; ++j) {
            int n3 = byArray[n + j];
            int n4 = (n3 &= 0xFF) >> 4;
            int n5 = n3 & 0xF;
            printStream.print(hexchars[n4] + "" + hexchars[n5]);
            if (j != 0 && j % 4 == 3) {
                printStream.print(' ');
            }
            if (j == 0 || j % 16 != 15) continue;
            printStream.println("");
            printStream.print(TibjmsxStream._getOffsetStr(j + 1));
        }
        printStream.println("");
    }

    static class Encoding {
        static final int TIBJMS_ENCODING_UNKNOWN = -1;
        static final int TIBUMS_ENCODING_ASCII = 0;
        static final int TIBJMS_ENCODING_LATIN_1 = 1;
        static final int TIBJMS_ENCODING_CP1252 = 2;
        static final int TIBJMS_ENCODING_UTF_8 = 8;
        static final int TIBJMS_ENCODING_LATIN_9 = 9;
        private static final byte _QUEST = 63;
        private static final char _FFFD = '\ufffd';

        Encoding() {
        }

        private static final byte chartobyte_ASCII(char c) {
            if (c <= '\u007f') {
                return (byte)c;
            }
            return 63;
        }

        private static final char bytetochar_ASCII(byte by) {
            if ((by & 0x80) == 0) {
                return (char)by;
            }
            return '\ufffd';
        }

        private static final byte chartobyte_8859_1(char c) {
            if (c <= '\u00ff') {
                return (byte)c;
            }
            return 63;
        }

        private static final char bytetochar_8859_1(byte by) {
            return (char)(by & 0xFF);
        }

        private static final byte chartobyte_cp1252(char c) {
            if (c <= '\u007f') {
                return (byte)c;
            }
            if (c >= '\u00a0' && c <= '\u00ff') {
                return (byte)c;
            }
            if (c >= '\u0080' && c <= '\u009f') {
                return 63;
            }
            switch (c) {
                case '\u20ac': {
                    return -128;
                }
                case '\u201a': {
                    return -126;
                }
                case '\u0192': {
                    return -125;
                }
                case '\u201e': {
                    return -124;
                }
                case '\u2026': {
                    return -123;
                }
                case '\u2020': {
                    return -122;
                }
                case '\u2021': {
                    return -121;
                }
                case '\u02c6': {
                    return -120;
                }
                case '\u2030': {
                    return -119;
                }
                case '\u0160': {
                    return -118;
                }
                case '\u2039': {
                    return -117;
                }
                case '\u0152': {
                    return -116;
                }
                case '\u017d': {
                    return -114;
                }
                case '\u2018': {
                    return -111;
                }
                case '\u2019': {
                    return -110;
                }
                case '\u201c': {
                    return -109;
                }
                case '\u201d': {
                    return -108;
                }
                case '\u2022': {
                    return -107;
                }
                case '\u2013': {
                    return -106;
                }
                case '\u2014': {
                    return -105;
                }
                case '\u02dc': {
                    return -104;
                }
                case '\u2122': {
                    return -103;
                }
                case '\u0161': {
                    return -102;
                }
                case '\u203a': {
                    return -101;
                }
                case '\u0153': {
                    return -100;
                }
                case '\u017e': {
                    return -98;
                }
                case '\u0178': {
                    return -97;
                }
            }
            return 63;
        }

        private static final char bytetochar_cp1252(byte by) {
            int n = by & 0xFF;
            if (n <= 127 || n >= 160) {
                return (char)n;
            }
            switch (n) {
                case 128: {
                    return '\u20ac';
                }
                case 129: {
                    return '\ufffd';
                }
                case 130: {
                    return '\u201a';
                }
                case 131: {
                    return '\u0192';
                }
                case 132: {
                    return '\u201e';
                }
                case 133: {
                    return '\u2026';
                }
                case 134: {
                    return '\u2020';
                }
                case 135: {
                    return '\u2021';
                }
                case 136: {
                    return '\u02c6';
                }
                case 137: {
                    return '\u2030';
                }
                case 138: {
                    return '\u0160';
                }
                case 139: {
                    return '\u2039';
                }
                case 140: {
                    return '\u0152';
                }
                case 141: {
                    return '\ufffd';
                }
                case 142: {
                    return '\u017d';
                }
                case 143: {
                    return '\ufffd';
                }
                case 144: {
                    return '\ufffd';
                }
                case 145: {
                    return '\u2018';
                }
                case 146: {
                    return '\u2019';
                }
                case 147: {
                    return '\u201c';
                }
                case 148: {
                    return '\u201d';
                }
                case 149: {
                    return '\u2022';
                }
                case 150: {
                    return '\u2013';
                }
                case 151: {
                    return '\u2014';
                }
                case 152: {
                    return '\u02dc';
                }
                case 153: {
                    return '\u2122';
                }
                case 154: {
                    return '\u0161';
                }
                case 155: {
                    return '\u203a';
                }
                case 156: {
                    return '\u0153';
                }
                case 157: {
                    return '\ufffd';
                }
                case 158: {
                    return '\u017e';
                }
                case 159: {
                    return '\u0178';
                }
            }
            return '\ufffd';
        }

        private static final byte chartobyte_8859_15(char c) {
            if (c < '\u00a4') {
                return (byte)c;
            }
            switch (c) {
                case '\u00a4': {
                    return 63;
                }
                case '\u00a6': {
                    return 63;
                }
                case '\u00a8': {
                    return 63;
                }
                case '\u00b4': {
                    return 63;
                }
                case '\u00b8': {
                    return 63;
                }
                case '\u00bc': {
                    return 63;
                }
                case '\u00bd': {
                    return 63;
                }
                case '\u00be': {
                    return 63;
                }
                case '\u0152': {
                    return -68;
                }
                case '\u0153': {
                    return -67;
                }
                case '\u0160': {
                    return -90;
                }
                case '\u0161': {
                    return -88;
                }
                case '\u0178': {
                    return -66;
                }
                case '\u017d': {
                    return -76;
                }
                case '\u017e': {
                    return -72;
                }
                case '\u20ac': {
                    return -92;
                }
            }
            if (c <= '\u00ff') {
                return (byte)c;
            }
            return 63;
        }

        private static final char bytetochar_8859_15(byte by) {
            int n = by & 0xFF;
            switch (n) {
                case 164: {
                    return '\u20ac';
                }
                case 166: {
                    return '\u0160';
                }
                case 168: {
                    return '\u0161';
                }
                case 180: {
                    return '\u017d';
                }
                case 184: {
                    return '\u017e';
                }
                case 188: {
                    return '\u0152';
                }
                case 189: {
                    return '\u0153';
                }
                case 190: {
                    return '\u0178';
                }
            }
            return (char)n;
        }

        static int getTibjmsEncoding(String string) {
            if (string != null) {
                if (string.equals("US-ASCII") || string.equals("ASCII")) {
                    return 0;
                }
                if (string.equals("Cp1252")) {
                    return 2;
                }
                if (string.endsWith("8859-1") || string.endsWith("8859_1")) {
                    return 1;
                }
                if (string.endsWith("8859-15") || string.endsWith("8859_15")) {
                    return 9;
                }
                if (string.equals("UTF8") || string.equals("UTF-8")) {
                    return 8;
                }
                return -1;
            }
            return 8;
        }

        static byte charToByte(char c, int n) throws JMSException {
            switch (n) {
                case 1: {
                    return Encoding.chartobyte_8859_1(c);
                }
                case 2: {
                    return Encoding.chartobyte_cp1252(c);
                }
                case 9: {
                    return Encoding.chartobyte_8859_15(c);
                }
                case 0: {
                    return Encoding.chartobyte_ASCII(c);
                }
            }
            throw new JMSException("Unsupported encoding specified");
        }

        static char byteToChar(byte by, int n) throws JMSException {
            switch (n) {
                case 1: {
                    return Encoding.bytetochar_8859_1(by);
                }
                case 2: {
                    return Encoding.bytetochar_cp1252(by);
                }
                case 9: {
                    return Encoding.bytetochar_8859_15(by);
                }
                case 0: {
                    return Encoding.bytetochar_ASCII(by);
                }
            }
            throw new JMSException("Unsupported encoding specified");
        }
    }

    static class CInf {
        Inflater inflater = null;

        CInf() {
        }
    }
}

