/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsxConst;
import com.tibco.tibjms.TibjmsxSelectorToken;
import com.tibco.tibjms.TibjmsxStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public class TibjmsxSelector
implements TibjmsxConst {
    public static final int OPERAND_UNKNOWN = 0;
    public static final int OPERAND_IDENTIFIER = 1;
    public static final int OPERAND_STRING = 2;
    public static final int OPERAND_ARITHMETIC = 3;
    public static final int OPERAND_LOGICAL = 4;
    public static final int OPERAND_NUMBER = 5;
    public static final int OPERAND_NULL = 6;
    public static final int TOK_ZERO = 0;
    public static final int TOK_NAME = 1;
    public static final int TOK_STRING = 2;
    public static final int TOK_NUMBER_INTEGER = 3;
    public static final int TOK_NUMBER_FLOAT = 4;
    public static final int TOK_COMMA = 5;
    public static final int TOK_EQUAL = 6;
    public static final int TOK_NOT_EQUAL = 7;
    public static final int TOK_BEGIN = 8;
    public static final int TOK_END = 9;
    public static final int TOK_LESS = 10;
    public static final int TOK_LESS_THAN = 11;
    public static final int TOK_GREATER = 12;
    public static final int TOK_GREATER_THAN = 13;
    public static final int TOK_PLUS = 14;
    public static final int TOK_MINUS = 15;
    public static final int TOK_MULTIPLY = 16;
    public static final int TOK_DIVIDE = 17;
    public static final int TOK_EXPRESSION = 22;
    public static final int TOK_IN_ARRAY = 23;
    public static final int TOK_KEY_NULL = 30;
    public static final int TOK_KEY_TRUE = 31;
    public static final int TOK_KEY_FALSE = 32;
    public static final int TOK_KEY_UNKNOWN = 33;
    public static final int TOK_KEY_AND = 40;
    public static final int TOK_KEY_OR = 41;
    public static final int TOK_KEY_NOT = 42;
    public static final int TOK_KEY_IS = 43;
    public static final int TOK_KEY_IN = 44;
    public static final int TOK_KEY_BETWEEN = 45;
    public static final int TOK_KEY_LIKE = 46;
    public static final int TOK_KEY_ESCAPE = 47;
    static final int OPERATION_NOT = 1;
    static final int OPERATION_WAS_BETWEEN = 2;
    public static final int TOKEN_OK = 0;
    public static final int TOKEN_STRING_NOT_TERMINATED = 1;
    public static final int TOKEN_NOT_TERMINATED = 2;
    public static final int TOKEN_INVALID_SYNTAX = 3;
    public static final int TOKEN_STRING_ASCII = 1;
    public static final int TOKEN_STRING_UNICODE = 2;
    public static final int TOKEN_STRING_HAS_ESCAPE = 4;
    static final int NAME_JMSDeliveryMode = 1;
    static final int NAME_JMSPriority = 2;
    static final int NAME_JMSMessageID = 3;
    static final int NAME_JMSTimestamp = 4;
    static final int NAME_JMSCorrelationID = 5;
    static final int NAME_JMSType = 6;
    static final int NAME_JMSDestination = 7;
    static final int NAME_JMSXUserID = 20;
    static final int NAME_JMSXAppID = 21;
    static final int NAME_JMSXDeliveryCount = 22;
    static final int NAME_JMSXGroupID = 23;
    static final int NAME_JMSXGroupSeq = 24;
    static final int NAME_JMSXProducerTXID = 25;
    static final int NAME_JMSXConsumerTXID = 26;
    static final int NAME_JMSXRcvTimestamp = 27;
    static final int NAME_JMSXState = 28;
    static Keyword[] keywords = new Keyword[]{new Keyword("AND", 3, 40), new Keyword("OR", 2, 41), new Keyword("NOT", 3, 42), new Keyword("NULL", 4, 30), new Keyword("TRUE", 4, 31), new Keyword("FALSE", 5, 32), new Keyword("IS", 2, 43), new Keyword("IN", 2, 44), new Keyword("BETWEEN", 7, 45), new Keyword("LIKE", 4, 46), new Keyword("ESCAPE", 6, 47)};
    static final int KEYWORD_MIN_LEN = 2;
    static final int KEYWORD_MAX_LEN = 7;
    static Property[] properties = new Property[]{new Property("JMSDeliveryMode", 1, 2), new Property("JMSPriority", 2, 5), new Property("JMSMessageID", 3, 2), new Property("JMSTimestamp", 4, 5), new Property("JMSCorrelationID", 5, 2), new Property("JMSType", 6, 2), new Property("JMSXUserID", 20, 2), new Property("JMSXAppID", 21, 2), new Property("JMSXDeliveryCount", 22, 5), new Property("JMSXGroupID", 23, 2), new Property("JMSXGroupSeq", 24, 5), new Property("JMSXProducerTXID", 25, 2), new Property("JMSXConsumerTXID", 26, 2), new Property("JMSXRcvTimestamp", 27, 5), new Property("JMSXState", 28, 5), new Property("JMSDestination", 7, 2)};
    static Hashtable propsMap = new Hashtable();
    private String selector = null;
    private int position = 0;
    private int length = 0;
    private TibjmsxSelectorToken root = null;
    private char[] charbuf = null;
    private char[] selchars = null;
    private Object expressionTree = null;
    private String _poserr = "Error at or near position ";
    private String _synerr = "Invalid selector syntax";
    private String _numericTerminators = "+-)*/=<>";
    private String _stringTerminators = "+-)*/=<>,";
    static final int OPERAND_TYPE_NULL = 0;
    static final int OPERAND_TYPE_VALUE = 1;
    static final int OPERAND_TYPE_OPERATION = 2;

    public static String getTypeName(int n) {
        switch (n) {
            case 1: {
                return "NAME    ";
            }
            case 2: {
                return "STRING  ";
            }
            case 3: {
                return "NUM-INT ";
            }
            case 4: {
                return "NUM-REAL";
            }
            case 5: {
                return "COMMA   ";
            }
            case 6: {
                return "EQUAL   ";
            }
            case 7: {
                return "NOT_EQ  ";
            }
            case 8: {
                return "BEGIN   ";
            }
            case 9: {
                return "END     ";
            }
            case 10: {
                return "LESS    ";
            }
            case 11: {
                return "LESS_TH ";
            }
            case 12: {
                return "GREATER ";
            }
            case 13: {
                return "GREAT-TH";
            }
            case 14: {
                return "PLUS    ";
            }
            case 15: {
                return "MINUS   ";
            }
            case 16: {
                return "MULTIPLY";
            }
            case 17: {
                return "DIVIDE  ";
            }
            case 22: {
                return "EXPRESSN";
            }
            case 40: {
                return "Key-AND ";
            }
            case 41: {
                return "Key-OR  ";
            }
            case 42: {
                return "Key-NOT ";
            }
            case 30: {
                return "Key-NULL";
            }
            case 31: {
                return "Key-TRUE";
            }
            case 32: {
                return "Key-FALS";
            }
            case 43: {
                return "Key-IS  ";
            }
            case 44: {
                return "Key-IN  ";
            }
            case 45: {
                return "Key-BETW";
            }
            case 46: {
                return "Key-LIKE";
            }
            case 47: {
                return "Key-ESC ";
            }
        }
        return "????    ";
    }

    static String getOperationName(int n) {
        switch (n) {
            case 6: {
                return "EQUAL";
            }
            case 7: {
                return "NOT EQUAL";
            }
            case 10: {
                return "LESS";
            }
            case 11: {
                return "LESS-THAN";
            }
            case 12: {
                return "GREATER";
            }
            case 13: {
                return "GREATER-THAN";
            }
            case 40: {
                return "AND";
            }
            case 41: {
                return "OR";
            }
            case 42: {
                return "NOT";
            }
            case 43: {
                return "IS";
            }
            case 44: {
                return "IN";
            }
            case 45: {
                return "BETWEEN";
            }
            case 46: {
                return "LIKE";
            }
            case 14: {
                return "PLUS";
            }
            case 15: {
                return "MINUS";
            }
            case 16: {
                return "MULTIPLY";
            }
            case 17: {
                return "DIVIDE";
            }
        }
        return "???(" + n + ")";
    }

    static String errorText(int n) {
        switch (n) {
            case 1: {
                return "String not terminated";
            }
            case 2: {
                return "Unexpected end";
            }
            case 3: {
                return "Syntax error";
            }
        }
        return "Unknown error";
    }

    static int getNameType(String string) {
        int n = string.length();
        if (n < 2 || n > 7) {
            return 1;
        }
        for (int j = 0; j < keywords.length; ++j) {
            if (TibjmsxSelector.keywords[j].length != n || !TibjmsxSelector.keywords[j].text.equalsIgnoreCase(string)) continue;
            return TibjmsxSelector.keywords[j].type;
        }
        return 1;
    }

    static void setIdentifierType(TibjmsxSelectorToken tibjmsxSelectorToken) {
        if (tibjmsxSelectorToken.type != 1 || tibjmsxSelectorToken.value == null || !(tibjmsxSelectorToken.value instanceof String)) {
            return;
        }
        String string = (String)tibjmsxSelectorToken.value;
        if (!string.startsWith("JMS")) {
            return;
        }
        Property property = (Property)propsMap.get(string);
        if (property == null) {
            return;
        }
        tibjmsxSelectorToken.propertyId = property.id;
        tibjmsxSelectorToken.operandType = property.type;
    }

    void ex(String string, Object object) throws InvalidSelectorException {
        int n = -1;
        if (object != null) {
            if (object instanceof Operation) {
                n = ((Operation)object).position;
            } else if (object instanceof TibjmsxSelectorToken) {
                n = ((TibjmsxSelectorToken)object).position;
            }
        }
        if (string == null) {
            string = "Invalid selector syntax";
        }
        if (n >= 0) {
            throw new InvalidSelectorException(string, this._poserr + (n + 1));
        }
        throw new InvalidSelectorException(string);
    }

    public TibjmsxSelector(String string) throws InvalidSelectorException {
        if (string != null) {
            string = string.trim();
        }
        this.selector = string;
        if (string != null && string.length() > 0) {
            this.length = string.length();
            this.selchars = new char[this.length];
            string.getChars(0, this.length, this.selchars, 0);
            this.tokenize();
        }
        this.charbuf = null;
    }

    public Vector getTokens() {
        return (Vector)this.root.value;
    }

    public boolean isEmpty() {
        return ((Vector)this.root.value).size() == 0;
    }

    private TibjmsxSelectorToken readNumber() throws InvalidSelectorException {
        char c;
        TibjmsxSelectorToken tibjmsxSelectorToken = null;
        int n = this.position;
        int n2 = this.position;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n5 = 0;
        int n6 = 10;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n7 = this.length;
        if (this.selchars[n2] == '+' || this.selchars[n2] == '-') {
            if (this.selchars[n2] == '-') {
                bl5 = true;
            } else {
                ++n;
            }
            ++n2;
        }
        if (this.selchars[n2] == '0' && n2 + 1 < n7) {
            if (this.selchars[n2 + 1] == 'x' || this.selchars[n2 + 1] == 'X') {
                n6 = 16;
                n2 += 2;
                n += 2;
                if (bl5) {
                    ++n;
                }
                while (n2 < n7 && (this.selchars[n2] >= '0' && this.selchars[n2] <= '9' || this.selchars[n2] >= 'a' && this.selchars[n2] <= 'f' || this.selchars[n2] >= 'A' && this.selchars[n2] <= 'F')) {
                    ++n3;
                    ++n2;
                }
            } else if (this.selchars[n2 + 1] >= '0' && this.selchars[n2 + 1] <= '7') {
                n6 = 8;
                ++n2;
                while (n2 < n7 && this.selchars[n2] >= '0' && this.selchars[n2] <= '7') {
                    ++n3;
                    ++n2;
                }
            }
        }
        while (n2 < n7 && this.selchars[n2] >= '0' && this.selchars[n2] <= '9') {
            bl4 = true;
            ++n3;
            ++n2;
        }
        if (n2 < n7 && n6 == 10 && (this.selchars[n2] == 'L' || this.selchars[n2] == 'l')) {
            bl6 = true;
            ++n2;
        } else {
            if (n2 < n7 && this.selchars[n2] == '.') {
                if (n6 == 16) {
                    throw new InvalidSelectorException(this._synerr, this._poserr + (n2 + 1));
                }
                bl = true;
                n6 = 10;
                ++n2;
                while (n2 < n7 && this.selchars[n2] >= '0' && this.selchars[n2] <= '9') {
                    ++n4;
                    ++n2;
                }
            }
            if (n2 < n7 && (this.selchars[n2] == 'E' || this.selchars[n2] == 'e')) {
                if (n3 == 0 && n4 == 0) {
                    throw new InvalidSelectorException(this._synerr, this._poserr + (n2 + 1));
                }
                bl2 = true;
                n6 = 10;
                if (++n2 < n7 && (this.selchars[n2] == '+' || this.selchars[n2] == '-')) {
                    bl3 = true;
                    ++n2;
                }
                while (n2 < n7 && this.selchars[n2] >= '0' && this.selchars[n2] <= '9') {
                    ++n5;
                    ++n2;
                }
            } else if (n6 == 8 && bl4) {
                throw new InvalidSelectorException(this._synerr, this._poserr + (n2 + 1));
            }
        }
        if (n2 < this.selchars.length && !Character.isWhitespace(c = this.selchars[n2]) && this._numericTerminators.indexOf(c) < 0) {
            throw new InvalidSelectorException(this._synerr, this._poserr + (n2 + 1));
        }
        if (bl3 && n5 == 0 || n3 == 0 && n4 == 0) {
            throw new InvalidSelectorException(this._synerr, this._poserr + (n2 + 1));
        }
        if (bl6) {
            --n2;
        }
        String string = this.selector.substring(n, n2);
        if (n6 == 16 && bl5) {
            string = "-" + string;
        }
        try {
            if (!bl && !bl2) {
                long l = Long.parseLong(string, n6);
                Long l2 = new Long(l);
                tibjmsxSelectorToken = new TibjmsxSelectorToken(3, l2);
            } else {
                double d = Double.parseDouble(string);
                Double d2 = new Double(d);
                tibjmsxSelectorToken = new TibjmsxSelectorToken(4, d2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidSelectorException(this._synerr, this._poserr + (n2 + 1));
        }
        if (bl6) {
            ++n2;
        }
        this.position = n2;
        return tibjmsxSelectorToken;
    }

    private TibjmsxSelectorToken readStringLiteral() throws InvalidSelectorException {
        TibjmsxSelectorToken tibjmsxSelectorToken = null;
        int n = this.length;
        int n2 = this.position;
        int n3 = 0;
        boolean bl = true;
        if (this.charbuf == null) {
            this.charbuf = new char[48];
        }
        while (n2 < n) {
            Object object;
            if (n3 >= this.charbuf.length - 1) {
                object = new char[this.charbuf.length * 2];
                System.arraycopy(this.charbuf, 0, object, 0, n3);
                this.charbuf = object;
            }
            if (this.selchars[n2] == '\'') {
                char c;
                if (n2 < n - 1 && this.selector.charAt(n2 + 1) == '\'') {
                    this.charbuf[n3] = 39;
                    ++n3;
                    n2 += 2;
                    continue;
                }
                object = new String(this.charbuf, 0, n3);
                this.position = n2 + 1;
                if (n2 + 1 < this.selchars.length && !Character.isWhitespace(c = this.selchars[n2 + 1]) && this._stringTerminators.indexOf(c) < 0) {
                    throw new InvalidSelectorException(this._synerr, this._poserr + (n2 + 2));
                }
                tibjmsxSelectorToken = new TibjmsxSelectorToken(2, object, bl ? 1 : 2);
                return tibjmsxSelectorToken;
            }
            if (this.selchars[n2] > '\u007f') {
                bl = false;
            }
            this.charbuf[n3] = this.selchars[n2];
            ++n3;
            ++n2;
        }
        throw new InvalidSelectorException("String literal not terminated", this._poserr + (n2 + 1));
    }

    private TibjmsxSelectorToken nextToken(TibjmsxSelectorToken tibjmsxSelectorToken) throws InvalidSelectorException {
        int n;
        while (this.position < this.length && Character.isWhitespace(this.selchars[this.position])) {
            ++this.position;
        }
        if (this.position == this.length) {
            return null;
        }
        int n2 = n = this.position;
        boolean bl = true;
        if (this.selchars[n] == '+' || this.selchars[n] == '-') {
            if (n >= this.length - 1) {
                throw new InvalidSelectorException(this._synerr, this._poserr + (n + 1));
            }
            if ((this.selchars[n + 1] == '.' || this.selchars[n + 1] >= '0' && this.selchars[n + 1] <= '9') && (tibjmsxSelectorToken == null || tibjmsxSelectorToken != null && tibjmsxSelectorToken.type != 3 && tibjmsxSelectorToken.type != 4 && tibjmsxSelectorToken.type != 1 && tibjmsxSelectorToken.type != 9)) {
                TibjmsxSelectorToken tibjmsxSelectorToken2 = this.readNumber();
                tibjmsxSelectorToken2.position = n2;
                return tibjmsxSelectorToken2;
            }
        }
        if (this.selchars[n] == '.' || this.selchars[n] >= '0' && this.selchars[n] <= '9') {
            TibjmsxSelectorToken tibjmsxSelectorToken3 = this.readNumber();
            tibjmsxSelectorToken3.position = n2;
            return tibjmsxSelectorToken3;
        }
        this.position = n + 1;
        switch (this.selchars[n]) {
            case '\'': {
                TibjmsxSelectorToken tibjmsxSelectorToken4 = this.readStringLiteral();
                tibjmsxSelectorToken4.position = n2;
                return tibjmsxSelectorToken4;
            }
            case '(': {
                return new TibjmsxSelectorToken(n2, 8);
            }
            case ')': {
                return new TibjmsxSelectorToken(n2, 9);
            }
            case ',': {
                return new TibjmsxSelectorToken(n2, 5);
            }
            case '*': {
                return new TibjmsxSelectorToken(n2, 16);
            }
            case '/': {
                return new TibjmsxSelectorToken(n2, 17);
            }
            case '=': {
                return new TibjmsxSelectorToken(n2, 6);
            }
            case '+': {
                return new TibjmsxSelectorToken(n2, 14);
            }
            case '-': {
                return new TibjmsxSelectorToken(n2, 15);
            }
            case '<': {
                if (n >= this.length - 1) {
                    throw new InvalidSelectorException(this._synerr, this._poserr + (n + 1));
                }
                if (this.selchars[++n] == '=') {
                    this.position = n + 1;
                    return new TibjmsxSelectorToken(n2, 11);
                }
                if (this.selchars[n] == '>') {
                    this.position = n + 1;
                    return new TibjmsxSelectorToken(n2, 7);
                }
                return new TibjmsxSelectorToken(n2, 10);
            }
            case '>': {
                if (n >= this.length - 1) {
                    throw new InvalidSelectorException(this._synerr, this._poserr + (n + 1));
                }
                if (this.selchars[++n] == '=') {
                    this.position = n + 1;
                    return new TibjmsxSelectorToken(n2, 13);
                }
                return new TibjmsxSelectorToken(n2, 12);
            }
        }
        if (!Character.isJavaIdentifierStart(this.selchars[n])) {
            throw new InvalidSelectorException(this._synerr, this._poserr + (n + 1));
        }
        if (this.selchars[n] > '\u007f') {
            bl = false;
        }
        while (++n < this.length && Character.isJavaIdentifierPart(this.selchars[n])) {
            if (this.selchars[n] <= '\u007f') continue;
            bl = false;
        }
        String string = this.selector.substring(n2, n);
        this.position = n;
        TibjmsxSelectorToken tibjmsxSelectorToken5 = new TibjmsxSelectorToken(n2, 1, string, bl ? 1 : 2);
        if (bl) {
            TibjmsxSelector.setIdentifierType(tibjmsxSelectorToken5);
        }
        return tibjmsxSelectorToken5;
    }

    private void tokenize() throws InvalidSelectorException {
        TibjmsxSelectorToken tibjmsxSelectorToken;
        if (this.selector == null || this.selector.length() == 0) {
            return;
        }
        TibjmsxSelectorToken tibjmsxSelectorToken2 = null;
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        while ((tibjmsxSelectorToken = this.nextToken(tibjmsxSelectorToken2)) != null) {
            int n2;
            tibjmsxSelectorToken2 = tibjmsxSelectorToken;
            if (tibjmsxSelectorToken.type == 1 && (tibjmsxSelectorToken.flags & 1) != 0 && (n2 = TibjmsxSelector.getNameType((String)tibjmsxSelectorToken.value)) != 1) {
                tibjmsxSelectorToken.type = n2;
                tibjmsxSelectorToken.value = null;
                tibjmsxSelectorToken.flags = 0;
            }
            if (bl) {
                if (tibjmsxSelectorToken.type != 8) {
                    throw new InvalidSelectorException("Invalid selector syntax", "IN must be followed by opening parenthesis. Error at or near position " + (tibjmsxSelectorToken.position + 1));
                }
                bl2 = true;
                n = 0;
            } else if (bl2) {
                if (tibjmsxSelectorToken.type == 2 && ++n > Short.MAX_VALUE) {
                    throw new InvalidSelectorException("Invalid selector syntax", "IN cannot have more than 32767 string literals. Error at or near position " + (tibjmsxSelectorToken.position + 1));
                }
                if (tibjmsxSelectorToken.type == 9) {
                    bl2 = false;
                    n = 0;
                }
            }
            boolean bl3 = bl = tibjmsxSelectorToken.type == 44;
            if (this.root == null) {
                this.root = new TibjmsxSelectorToken(22, new Vector());
            }
            ((Vector)this.root.value).addElement(tibjmsxSelectorToken);
        }
    }

    int findEnd(TibjmsxSelectorToken tibjmsxSelectorToken, TibjmsxSelectorToken tibjmsxSelectorToken2, int n) throws InvalidSelectorException {
        Vector vector = (Vector)tibjmsxSelectorToken2.value;
        for (int j = n; j < vector.size(); ++j) {
            TibjmsxSelectorToken tibjmsxSelectorToken3 = (TibjmsxSelectorToken)vector.elementAt(j);
            if (tibjmsxSelectorToken3.type == 8) {
                this.processBeginParenthesis(tibjmsxSelectorToken3, tibjmsxSelectorToken2, j);
                continue;
            }
            if (tibjmsxSelectorToken3.type != 9) continue;
            return j;
        }
        throw new InvalidSelectorException("Missing closing parenthesis", this._poserr + (tibjmsxSelectorToken.position + 1));
    }

    void checkExtraEnd(Vector vector) throws InvalidSelectorException {
        for (int j = 0; j < vector.size(); ++j) {
            TibjmsxSelectorToken tibjmsxSelectorToken = (TibjmsxSelectorToken)vector.elementAt(j);
            if (tibjmsxSelectorToken.type == 9) {
                throw new InvalidSelectorException("Unbalanced closing parenthesis", this._poserr + (tibjmsxSelectorToken.position + 1));
            }
            if (tibjmsxSelectorToken.type != 22) continue;
            this.checkExtraEnd((Vector)tibjmsxSelectorToken.value);
        }
    }

    void processParenthesis() throws InvalidSelectorException {
        if (this.root == null) {
            return;
        }
        this.processParenthesis(this.root);
        Vector vector = (Vector)this.root.value;
        while (vector.size() == 1) {
            TibjmsxSelectorToken tibjmsxSelectorToken = (TibjmsxSelectorToken)vector.elementAt(0);
            if (tibjmsxSelectorToken.value == null || !(tibjmsxSelectorToken.value instanceof Vector)) break;
            this.root = (TibjmsxSelectorToken)vector.elementAt(0);
            if (this.root.type != 22) break;
            vector = (Vector)this.root.value;
        }
        if (this.root.value instanceof Vector) {
            vector = (Vector)this.root.value;
            this.checkExtraEnd(vector);
        }
    }

    void processParenthesis(TibjmsxSelectorToken tibjmsxSelectorToken) throws InvalidSelectorException {
        Vector vector = (Vector)tibjmsxSelectorToken.value;
        for (int j = 0; j < vector.size(); ++j) {
            TibjmsxSelectorToken tibjmsxSelectorToken2 = (TibjmsxSelectorToken)vector.elementAt(j);
            if (tibjmsxSelectorToken2.type != 8) continue;
            this.processBeginParenthesis(tibjmsxSelectorToken2, tibjmsxSelectorToken, j);
        }
    }

    void processBeginParenthesis(TibjmsxSelectorToken tibjmsxSelectorToken, TibjmsxSelectorToken tibjmsxSelectorToken2, int n) throws InvalidSelectorException {
        int n2;
        Vector vector = (Vector)tibjmsxSelectorToken2.value;
        int n3 = this.findEnd(tibjmsxSelectorToken, tibjmsxSelectorToken2, n + 1);
        if (n3 == n + 1) {
            vector.removeElementAt(n);
            vector.removeElementAt(n);
            return;
        }
        if (n3 == n + 2) {
            vector.removeElementAt(n);
            vector.removeElementAt(n + 1);
            return;
        }
        Vector vector2 = new Vector();
        for (n2 = n + 1; n2 < n3; ++n2) {
            vector2.addElement(vector.elementAt(n2));
        }
        for (n2 = n; n2 <= n3; ++n2) {
            vector.removeElementAt(n);
        }
        TibjmsxSelectorToken tibjmsxSelectorToken3 = new TibjmsxSelectorToken(22, vector2);
        vector.insertElementAt(tibjmsxSelectorToken3, n);
    }

    Operation splitLogical(Vector vector) throws InvalidSelectorException {
        TibjmsxSelectorToken tibjmsxSelectorToken;
        int n;
        TibjmsxSelectorToken tibjmsxSelectorToken2 = null;
        for (n = 0; n < vector.size(); ++n) {
            if (!(vector.elementAt(n) instanceof TibjmsxSelectorToken)) continue;
            tibjmsxSelectorToken = (TibjmsxSelectorToken)vector.elementAt(n);
            if (tibjmsxSelectorToken.type != 41) continue;
            if (n == 0 || n == vector.size() - 1) {
                throw new InvalidSelectorException("Invalid operation syntax", this._poserr + (tibjmsxSelectorToken.position + 1));
            }
            return new Operation(vector, 41, n, tibjmsxSelectorToken.position);
        }
        for (n = 0; n < vector.size(); ++n) {
            if (!(vector.elementAt(n) instanceof TibjmsxSelectorToken)) continue;
            tibjmsxSelectorToken = (TibjmsxSelectorToken)vector.elementAt(n);
            if (tibjmsxSelectorToken.type != 40) continue;
            if (n == 0 || n == vector.size() - 1) {
                throw new InvalidSelectorException("Invalid operation syntax", this._poserr + (tibjmsxSelectorToken.position + 1));
            }
            for (int j = n - 1; j >= 0; --j) {
                if (!(vector.elementAt(j) instanceof TibjmsxSelectorToken)) continue;
                tibjmsxSelectorToken2 = (TibjmsxSelectorToken)vector.elementAt(j);
                if (tibjmsxSelectorToken2.type == 45 || tibjmsxSelectorToken2.type == 40) break;
            }
            if (tibjmsxSelectorToken2 != null && tibjmsxSelectorToken2.type == 45) continue;
            return new Operation(vector, 40, n, tibjmsxSelectorToken.position);
        }
        if (vector.size() > 0 && vector.elementAt(0) instanceof TibjmsxSelectorToken) {
            tibjmsxSelectorToken = (TibjmsxSelectorToken)vector.elementAt(0);
            if (tibjmsxSelectorToken.type == 42) {
                if (vector.size() == 1) {
                    throw new InvalidSelectorException("Invalid operation syntax", this._poserr + (tibjmsxSelectorToken.position + 1));
                }
                vector.removeElementAt(0);
                return new Operation(tibjmsxSelectorToken.type, vector, null, tibjmsxSelectorToken.position);
            }
        }
        return null;
    }

    void processVector(Vector vector) throws InvalidSelectorException {
        boolean bl = false;
        int n = 0;
        block6: while (n < vector.size()) {
            Vector vector2;
            Object e = vector.elementAt(n);
            bl = false;
            if (e instanceof Vector) {
                vector2 = (Vector)e;
                this.processVector(vector2);
                ++n;
                continue;
            }
            if (!(e instanceof TibjmsxSelectorToken)) {
                ++n;
                continue;
            }
            TibjmsxSelectorToken tibjmsxSelectorToken = (TibjmsxSelectorToken)e;
            switch (tibjmsxSelectorToken.type) {
                case 22: {
                    vector2 = (Vector)tibjmsxSelectorToken.value;
                    this.processVector(vector2);
                    ++n;
                    continue block6;
                }
                case 44: {
                    int n2;
                    Operation operation;
                    if (n == 0) {
                        this.ex("Invalid selector syntax: illegal IN operation", tibjmsxSelectorToken);
                    }
                    TibjmsxSelectorToken tibjmsxSelectorToken2 = (TibjmsxSelectorToken)vector.elementAt(n - 1);
                    int n3 = n - 1;
                    if (tibjmsxSelectorToken2.type == 42) {
                        bl = true;
                        n3 = n - 2;
                        if (n - 1 == 0) {
                            this.ex("Invalid selector syntax: illegal IN operation", tibjmsxSelectorToken2);
                        }
                        tibjmsxSelectorToken2 = (TibjmsxSelectorToken)vector.elementAt(n - 2);
                    }
                    if (tibjmsxSelectorToken2.type != 1) {
                        this.ex("Invalid selector syntax: illegal IN operation", tibjmsxSelectorToken2);
                    }
                    if (n >= vector.size() - 1) {
                        this.ex("Invalid selector syntax: illegal IN operation", tibjmsxSelectorToken);
                    }
                    TibjmsxSelectorToken tibjmsxSelectorToken3 = (TibjmsxSelectorToken)vector.elementAt(n + 1);
                    int n4 = n + 1;
                    if (tibjmsxSelectorToken3.type != 22 && tibjmsxSelectorToken3.type != 2) {
                        this.ex("Invalid selector syntax: illegal IN operation", tibjmsxSelectorToken3);
                    }
                    if (tibjmsxSelectorToken3.type == 2) {
                        Vector<TibjmsxSelectorToken> vector3 = new Vector<TibjmsxSelectorToken>();
                        vector3.addElement(tibjmsxSelectorToken3);
                        operation = new Operation(44, tibjmsxSelectorToken2, vector3, tibjmsxSelectorToken.position);
                    } else {
                        operation = new Operation(44, tibjmsxSelectorToken2, tibjmsxSelectorToken3.value, tibjmsxSelectorToken.position);
                    }
                    operation.not = bl;
                    for (n2 = n3; n2 <= n4; ++n2) {
                        vector.removeElementAt(n3);
                    }
                    vector.insertElementAt(operation, n3);
                    n = n3 + 1;
                    continue block6;
                }
                case 43: {
                    int n2;
                    if (n == 0) {
                        this.ex("Invalid selector syntax: illegal IS operation", tibjmsxSelectorToken);
                    }
                    TibjmsxSelectorToken tibjmsxSelectorToken2 = (TibjmsxSelectorToken)vector.elementAt(n - 1);
                    int n3 = n - 1;
                    if (tibjmsxSelectorToken2.type != 1) {
                        this.ex("Invalid selector syntax: illegal IS operation", tibjmsxSelectorToken2);
                    }
                    if (n >= vector.size() - 1) {
                        this.ex("Invalid selector syntax: illegal IS operation", tibjmsxSelectorToken);
                    }
                    int n4 = n + 1;
                    TibjmsxSelectorToken tibjmsxSelectorToken3 = (TibjmsxSelectorToken)vector.elementAt(n + 1);
                    if (tibjmsxSelectorToken3.type == 42) {
                        bl = true;
                        n4 = n + 2;
                        if (n4 > vector.size() - 1) {
                            this.ex("Invalid selector syntax: illegal IS operation", tibjmsxSelectorToken2);
                        }
                        tibjmsxSelectorToken3 = (TibjmsxSelectorToken)vector.elementAt(n4);
                    }
                    if (tibjmsxSelectorToken3.type != 30) {
                        this.ex("Invalid selector syntax: illegal IS operation", tibjmsxSelectorToken3);
                    }
                    Operation operation = new Operation(43, tibjmsxSelectorToken2, tibjmsxSelectorToken3, tibjmsxSelectorToken.position);
                    operation.not = bl;
                    for (n2 = n3; n2 <= n4; ++n2) {
                        vector.removeElementAt(n3);
                    }
                    vector.insertElementAt(operation, n3);
                    n = n3 + 1;
                    continue block6;
                }
                case 46: {
                    int n2;
                    if (n == 0) {
                        this.ex("Invalid selector syntax: illegal LIKE operation", tibjmsxSelectorToken);
                    }
                    TibjmsxSelectorToken tibjmsxSelectorToken2 = (TibjmsxSelectorToken)vector.elementAt(n - 1);
                    int n3 = n - 1;
                    if (tibjmsxSelectorToken2.type == 42) {
                        bl = true;
                        if (n - 1 == 0) {
                            this.ex("Invalid selector syntax: illegal LIKE operation", tibjmsxSelectorToken2);
                        }
                        tibjmsxSelectorToken2 = (TibjmsxSelectorToken)vector.elementAt(n - 2);
                        n3 = n - 2;
                    }
                    if (tibjmsxSelectorToken2.type != 1) {
                        this.ex("Invalid selector syntax: illegal LIKE operation", tibjmsxSelectorToken2);
                    }
                    if (n + 1 > vector.size() - 1) {
                        this.ex("Invalid selector syntax: illegal LIKE operation", tibjmsxSelectorToken);
                    }
                    int n4 = n + 1;
                    TibjmsxSelectorToken tibjmsxSelectorToken3 = (TibjmsxSelectorToken)vector.elementAt(n + 1);
                    if (tibjmsxSelectorToken3.type != 2) {
                        this.ex("Invalid selector syntax: illegal LIKE operation", tibjmsxSelectorToken3);
                    }
                    if (n + 2 <= vector.size() - 1) {
                        TibjmsxSelectorToken tibjmsxSelectorToken4 = (TibjmsxSelectorToken)vector.elementAt(n + 2);
                        if (tibjmsxSelectorToken4.type == 47) {
                            n4 = n + 3;
                            if (n + 3 > vector.size() - 1) {
                                this.ex("Invalid selector syntax: missing escape character", tibjmsxSelectorToken4);
                            }
                            TibjmsxSelectorToken tibjmsxSelectorToken5 = (TibjmsxSelectorToken)vector.elementAt(n + 3);
                            if (tibjmsxSelectorToken5.type != 2) {
                                this.ex("Invalid selector syntax: missing escape character", tibjmsxSelectorToken4);
                            }
                            if (((String)tibjmsxSelectorToken5.value).length() != 1) {
                                this.ex("Invalid selector syntax: escape character must be a literal string of length 1", tibjmsxSelectorToken4);
                            }
                            String string = (String)tibjmsxSelectorToken3.value;
                            char c = ((String)tibjmsxSelectorToken5.value).charAt(0);
                            tibjmsxSelectorToken3.escapeIndex = string.indexOf(c);
                            if (tibjmsxSelectorToken3.escapeIndex >= 0) {
                                tibjmsxSelectorToken3.flags |= 4;
                            }
                        }
                    }
                    Operation operation = new Operation(46, tibjmsxSelectorToken2, tibjmsxSelectorToken3, tibjmsxSelectorToken.position);
                    operation.not = bl;
                    for (n2 = n3; n2 <= n4; ++n2) {
                        vector.removeElementAt(n3);
                    }
                    vector.insertElementAt(operation, n3);
                    n = n3 + 1;
                    continue block6;
                }
            }
            ++n;
        }
    }

    Object lift(Vector vector) throws InvalidSelectorException {
        int n = 0;
        while (n < vector.size()) {
            Object object;
            Vector vector2;
            Object e = vector.elementAt(n);
            if (e instanceof Vector) {
                vector2 = (Vector)e;
                object = vector2.size() == 1 ? vector2.elementAt(0) : this.lift(vector2);
                vector.setElementAt(object, n);
                ++n;
                continue;
            }
            if (!(e instanceof TibjmsxSelectorToken)) {
                ++n;
                continue;
            }
            TibjmsxSelectorToken tibjmsxSelectorToken = (TibjmsxSelectorToken)e;
            if (tibjmsxSelectorToken.type == 22 && !((object = this.lift(vector2 = (Vector)tibjmsxSelectorToken.value)) instanceof Vector) && object instanceof Operation) {
                vector.setElementAt(object, n);
            }
            ++n;
        }
        if (vector.size() == 1) {
            return vector.elementAt(0);
        }
        return vector;
    }

    Operation splitArithmetic(Vector vector) throws InvalidSelectorException {
        TibjmsxSelectorToken tibjmsxSelectorToken;
        int n;
        if (vector.size() < 2) {
            if (vector.elementAt(0) instanceof Operation) {
                return (Operation)vector.elementAt(0);
            }
            TibjmsxSelectorToken tibjmsxSelectorToken2 = (TibjmsxSelectorToken)vector.elementAt(0);
            throw new InvalidSelectorException("Invalid syntax", this._poserr + (tibjmsxSelectorToken2.position + 1));
        }
        for (n = vector.size() - 1; n >= 0; --n) {
            if (!(vector.elementAt(n) instanceof TibjmsxSelectorToken)) continue;
            tibjmsxSelectorToken = (TibjmsxSelectorToken)vector.elementAt(n);
            if (tibjmsxSelectorToken.type != 14 && tibjmsxSelectorToken.type != 15) continue;
            if (n == 0) {
                vector.removeElementAt(0);
                return new Operation(tibjmsxSelectorToken.type, vector, null, tibjmsxSelectorToken.position);
            }
            if (n == vector.size() - 1) {
                throw new InvalidSelectorException("Invalid syntax", this._poserr + (tibjmsxSelectorToken.position + 1));
            }
            TibjmsxSelectorToken tibjmsxSelectorToken3 = (TibjmsxSelectorToken)vector.elementAt(n - 1);
            if (tibjmsxSelectorToken3.type == 17 || tibjmsxSelectorToken3.type == 16) continue;
            return new Operation(vector, tibjmsxSelectorToken.type, n, tibjmsxSelectorToken.position);
        }
        for (n = vector.size() - 1; n >= 0; --n) {
            if (!(vector.elementAt(n) instanceof TibjmsxSelectorToken)) continue;
            tibjmsxSelectorToken = (TibjmsxSelectorToken)vector.elementAt(n);
            if (tibjmsxSelectorToken.type != 16 && tibjmsxSelectorToken.type != 17) continue;
            if (n == 0 || n == vector.size() - 1) {
                throw new InvalidSelectorException("Invalid syntax", this._poserr + (tibjmsxSelectorToken.position + 1));
            }
            return new Operation(vector, tibjmsxSelectorToken.type, n, tibjmsxSelectorToken.position);
        }
        return null;
    }

    Operation splitOther(Vector vector) throws InvalidSelectorException {
        TibjmsxSelectorToken tibjmsxSelectorToken;
        int n;
        boolean bl = false;
        int n2 = -1;
        boolean bl2 = false;
        for (n = 0; n < vector.size(); ++n) {
            if (!(vector.elementAt(n) instanceof TibjmsxSelectorToken)) continue;
            tibjmsxSelectorToken = (TibjmsxSelectorToken)vector.elementAt(n);
            switch (tibjmsxSelectorToken.type) {
                case 6: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    if (bl2) {
                        throw new InvalidSelectorException("Invalid syntax", this._poserr + (tibjmsxSelectorToken.position + 1));
                    }
                    if (n == 0 || n == vector.size() - 1) {
                        throw new InvalidSelectorException("Invalid syntax");
                    }
                    bl2 = true;
                    n2 = n;
                }
            }
            if (bl2) break;
        }
        if (n2 == -1) {
            for (n = 0; n < vector.size(); ++n) {
                if (!(vector.elementAt(n) instanceof TibjmsxSelectorToken)) continue;
                tibjmsxSelectorToken = (TibjmsxSelectorToken)vector.elementAt(n);
                switch (tibjmsxSelectorToken.type) {
                    case 45: {
                        if (bl2) {
                            throw new InvalidSelectorException("Invalid syntax", this._poserr + (tibjmsxSelectorToken.position + 1));
                        }
                        if (n == 0 || n == vector.size() - 1) {
                            throw new InvalidSelectorException("Invalid syntax");
                        }
                        bl2 = true;
                        n2 = n;
                    }
                }
            }
        }
        if (n2 == -1) {
            return null;
        }
        tibjmsxSelectorToken = (TibjmsxSelectorToken)vector.elementAt(n2);
        bl = false;
        switch (tibjmsxSelectorToken.type) {
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return new Operation(vector, tibjmsxSelectorToken.type, n2, tibjmsxSelectorToken.position);
            }
            case 45: {
                TibjmsxSelectorToken tibjmsxSelectorToken2 = (TibjmsxSelectorToken)vector.elementAt(n2 - 1);
                if (tibjmsxSelectorToken2.type == 42) {
                    if (n2 - 1 == 0) {
                        throw new InvalidSelectorException("Invalid syntax");
                    }
                    bl = true;
                    return new Operation(vector, bl, tibjmsxSelectorToken.type, 0, n2 - 2, n2 + 1, vector.size() - 1, tibjmsxSelectorToken.position);
                }
                return new Operation(vector, bl, tibjmsxSelectorToken.type, 0, n2 - 1, n2 + 1, vector.size() - 1, tibjmsxSelectorToken.position);
            }
        }
        throw new InvalidSelectorException("Invalid syntax");
    }

    Operation splitOperand(Object object) throws InvalidSelectorException {
        Operation operation = null;
        if (object instanceof Vector) {
            operation = this.split((Vector)object);
            if (operation != null) {
                return operation;
            }
        } else if (object instanceof TibjmsxSelectorToken) {
            TibjmsxSelectorToken tibjmsxSelectorToken = (TibjmsxSelectorToken)object;
            if (tibjmsxSelectorToken.type == 22 && (operation = this.split((Vector)tibjmsxSelectorToken.value)) != null) {
                return operation;
            }
        }
        return null;
    }

    void splitOperation(Operation operation) throws InvalidSelectorException {
        Operation operation2 = this.splitOperand(operation.left);
        if (operation2 != null) {
            operation.left = operation2;
        }
        if ((operation2 = this.splitOperand(operation.right)) != null) {
            operation.right = operation2;
        }
    }

    Operation split(Vector vector) throws InvalidSelectorException {
        Operation operation = this.splitLogical(vector);
        if (operation == null) {
            operation = this.splitOther(vector);
        }
        if (operation == null) {
            return null;
        }
        this.splitOperation(operation);
        return operation;
    }

    Object processRightSideOfIn(Object object) throws InvalidSelectorException {
        TibjmsxSelectorToken tibjmsxSelectorToken;
        if (!(object instanceof Vector)) {
            throw new InvalidSelectorException("Invalid selector syntax", "Invalid right part of IN operation");
        }
        Vector vector = (Vector)object;
        if (vector.size() == 1) {
            Object e = vector.elementAt(0);
            if (!(e instanceof TibjmsxSelectorToken)) {
                throw new InvalidSelectorException("Invalid selector syntax", "Invalild right part of IN operation");
            }
            tibjmsxSelectorToken = (TibjmsxSelectorToken)e;
            if (tibjmsxSelectorToken.type == 2) {
                return vector;
            }
            if (tibjmsxSelectorToken.type == 22) {
                vector = (Vector)tibjmsxSelectorToken.value;
            } else {
                throw new InvalidSelectorException("Invalid selector syntax", "Invalild right part of IN operation");
            }
        }
        if (vector.size() % 2 == 0) {
            throw new InvalidSelectorException("Invalid selector syntax", "Invalid right operand of IN operation");
        }
        int n = 0;
        for (n = 0; n < vector.size(); ++n) {
            Object e = vector.elementAt(n);
            if (!(e instanceof TibjmsxSelectorToken)) {
                throw new InvalidSelectorException("Invalid selector syntax", "Invalid right operand of IN operation");
            }
            tibjmsxSelectorToken = (TibjmsxSelectorToken)e;
            if (!(n % 2 == 0 ? tibjmsxSelectorToken.type != 2 : tibjmsxSelectorToken.type != 5)) continue;
            throw new InvalidSelectorException("Invalid selector syntax", "Right operand of IN must be comma separated list of string literals");
        }
        for (n = 1; n < vector.size(); ++n) {
            vector.removeElementAt(n);
        }
        return vector;
    }

    int getOperandType(Object object) throws InvalidSelectorException {
        if (object == null) {
            return 6;
        }
        if (object instanceof Operation) {
            Operation operation = (Operation)object;
            switch (operation.op) {
                case 6: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: {
                    return 4;
                }
                case 30: {
                    return 6;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    return 3;
                }
            }
            throw new InvalidSelectorException("Invalid selector syntax");
        }
        if (object instanceof TibjmsxSelectorToken) {
            TibjmsxSelectorToken tibjmsxSelectorToken = (TibjmsxSelectorToken)object;
            switch (tibjmsxSelectorToken.type) {
                case 1: {
                    if (tibjmsxSelectorToken.operandType != 0) {
                        return tibjmsxSelectorToken.operandType;
                    }
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 30: {
                    return 6;
                }
                case 3: 
                case 4: {
                    return 5;
                }
                case 31: 
                case 32: {
                    return 4;
                }
            }
            throw new InvalidSelectorException("Invalid selector syntax", this._poserr + (tibjmsxSelectorToken.position + 1));
        }
        throw new InvalidSelectorException("Invalid selector syntax");
    }

    boolean isNumberLiteral(Object object) {
        if (object != null && object instanceof TibjmsxSelectorToken) {
            TibjmsxSelectorToken tibjmsxSelectorToken = (TibjmsxSelectorToken)object;
            switch (tibjmsxSelectorToken.type) {
                case 3: 
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    void processOperation(Operation operation) throws InvalidSelectorException {
        Object object;
        if (operation.left instanceof Vector) {
            object = (Vector)operation.left;
            operation.left = ((Vector)object).size() == 1 ? ((Vector)object).elementAt(0) : this.splitArithmetic((Vector)object);
        }
        if (operation.op == 44) {
            operation.right = this.processRightSideOfIn(operation.right);
        } else if (operation.right instanceof Vector) {
            object = (Vector)operation.right;
            operation.right = ((Vector)object).size() == 1 ? ((Vector)object).elementAt(0) : this.splitArithmetic((Vector)object);
        }
        if (operation.left != null && operation.left instanceof Operation) {
            this.processOperation((Operation)operation.left);
        }
        if (operation.right != null && operation.right instanceof Operation) {
            this.processOperation((Operation)operation.right);
        }
        if (operation.op == 45) {
            if (operation.right == null || !(operation.right instanceof Operation)) {
                throw new InvalidSelectorException("Invalid selector syntax", "Invalid right part of BETWEEN operation");
            }
            object = (Operation)operation.right;
            if (((Operation)object).op != 40) {
                throw new InvalidSelectorException("Invalid selector syntax", "Invalid right part of BETWEEN operation");
            }
        }
    }

    int getLogicalValue(Object object) {
        if (!(object instanceof TibjmsxSelectorToken)) {
            return -1;
        }
        TibjmsxSelectorToken tibjmsxSelectorToken = (TibjmsxSelectorToken)object;
        if (tibjmsxSelectorToken.type == 32) {
            return 0;
        }
        if (tibjmsxSelectorToken.type == 31) {
            return 1;
        }
        return -1;
    }

    int compareStrings(Object object, Object object2) {
        if (object == null || object2 == null) {
            return -1;
        }
        if (!(object instanceof TibjmsxSelectorToken) || !(object2 instanceof TibjmsxSelectorToken)) {
            return -1;
        }
        if (((TibjmsxSelectorToken)object).type != 2 || ((TibjmsxSelectorToken)object2).type != 2) {
            return -1;
        }
        String string = (String)((TibjmsxSelectorToken)object).value;
        String string2 = (String)((TibjmsxSelectorToken)object2).value;
        return string.equals(string2) ? 1 : 0;
    }

    Number promote(Number number, Number number2) {
        if (number == null || number2 == null) {
            return number;
        }
        if (number.getClass().equals(number2.getClass())) {
            return number;
        }
        if (number2 instanceof Double) {
            return new Double(number.doubleValue());
        }
        if (number2 instanceof Float) {
            return new Float(number.floatValue());
        }
        if (number2 instanceof Long) {
            return new Long(number.longValue());
        }
        if (number2 instanceof Integer) {
            return new Integer(number.intValue());
        }
        return number;
    }

    int is_equal(Object object, Object object2) {
        if (!this.isNumberLiteral(object) || !this.isNumberLiteral(object2)) {
            return -1;
        }
        Number number = (Number)((TibjmsxSelectorToken)object).value;
        Number number2 = (Number)((TibjmsxSelectorToken)object2).value;
        return (number = this.promote(number, number2 = this.promote(number2, number))).equals(number2) ? 1 : 0;
    }

    int compare(int n, Object object, Object object2) {
        if (!this.isNumberLiteral(object) || !this.isNumberLiteral(object2)) {
            return -1;
        }
        Number number = (Number)((TibjmsxSelectorToken)object).value;
        Number number2 = (Number)((TibjmsxSelectorToken)object2).value;
        number2 = this.promote(number2, number);
        number = this.promote(number, number2);
        boolean bl = false;
        if (number instanceof Integer || number instanceof Long) {
            long l = number.longValue();
            long l2 = number2.longValue();
            switch (n) {
                case 10: {
                    bl = l < l2;
                    break;
                }
                case 11: {
                    bl = l <= l2;
                    break;
                }
                case 12: {
                    bl = l > l2;
                    break;
                }
                case 13: {
                    bl = l >= l2;
                    break;
                }
                default: {
                    throw new InternalError("Invalid operation in compare");
                }
            }
        } else if (number instanceof Float) {
            float f = number.floatValue();
            float f2 = number2.floatValue();
            switch (n) {
                case 10: {
                    bl = f < f2;
                    break;
                }
                case 11: {
                    bl = f <= f2;
                    break;
                }
                case 12: {
                    bl = f > f2;
                    break;
                }
                case 13: {
                    bl = f >= f2;
                    break;
                }
                default: {
                    throw new InternalError("Invalid operation in compare");
                }
            }
        } else {
            double d = number.doubleValue();
            double d2 = number2.doubleValue();
            switch (n) {
                case 10: {
                    bl = d < d2;
                    break;
                }
                case 11: {
                    bl = d <= d2;
                    break;
                }
                case 12: {
                    bl = d > d2;
                    break;
                }
                case 13: {
                    bl = d >= d2;
                    break;
                }
                default: {
                    throw new InternalError("Invalid operation in compare");
                }
            }
        }
        return bl ? 1 : 0;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TibjmsxSelectorToken perform(Operation operation, int n, Object object, Object object2) throws InvalidSelectorException {
        void var7_28;
        if (!this.isNumberLiteral(object) || !this.isNumberLiteral(object2)) {
            return null;
        }
        Number number = (Number)((TibjmsxSelectorToken)object).value;
        Number number2 = (Number)((TibjmsxSelectorToken)object2).value;
        number2 = this.promote(number2, number);
        number = this.promote(number, number2);
        Object var7_7 = null;
        if (number2 == null) {
            if (n == 14) {
                return null;
            }
            if (number instanceof Double) {
                Double d = new Double(-number.doubleValue());
            } else if (number instanceof Float) {
                Float f = new Float(-number.floatValue());
            } else if (number instanceof Long) {
                Long l = new Long(-number.longValue());
            } else {
                if (!(number instanceof Integer)) throw new InternalError("Invalid number object");
                Integer n2 = new Integer(-number.intValue());
            }
        } else {
            switch (n) {
                case 14: {
                    if (number instanceof Double) {
                        Double d = new Double(number.doubleValue() + number2.doubleValue());
                        break;
                    }
                    if (number instanceof Float) {
                        Float f = new Float(number.floatValue() + number2.floatValue());
                        break;
                    }
                    if (number instanceof Long) {
                        Long l = new Long(number.longValue() + number2.longValue());
                        break;
                    }
                    if (!(number instanceof Integer)) break;
                    Integer n3 = new Integer(number.intValue() + number2.intValue());
                    break;
                }
                case 15: {
                    if (number instanceof Double) {
                        Double d = new Double(number.doubleValue() - number2.doubleValue());
                        break;
                    }
                    if (number instanceof Float) {
                        Float f = new Float(number.floatValue() - number2.floatValue());
                        break;
                    }
                    if (number instanceof Long) {
                        Long l = new Long(number.longValue() - number2.longValue());
                        break;
                    }
                    if (!(number instanceof Integer)) break;
                    Integer n4 = new Integer(number.intValue() - number2.intValue());
                    break;
                }
                case 16: {
                    if (number instanceof Double) {
                        Double d = new Double(number.doubleValue() * number2.doubleValue());
                        break;
                    }
                    if (number instanceof Float) {
                        Float f = new Float(number.floatValue() * number2.floatValue());
                        break;
                    }
                    if (number instanceof Long) {
                        Long l = new Long(number.longValue() * number2.longValue());
                        break;
                    }
                    if (!(number instanceof Integer)) break;
                    Integer n5 = new Integer(number.intValue() * number2.intValue());
                    break;
                }
                case 17: {
                    if (number2.doubleValue() == 0.0) {
                        throw new InvalidSelectorException("Division by zero", this._poserr + (operation.position + 1));
                    }
                    if (number instanceof Double) {
                        Double d = new Double(number.doubleValue() / number2.doubleValue());
                        break;
                    }
                    if (number instanceof Float) {
                        Float f = new Float(number.floatValue() / number2.floatValue());
                        break;
                    }
                    if (number instanceof Long) {
                        Long l = new Long(number.longValue() / number2.longValue());
                        break;
                    }
                    if (!(number instanceof Integer)) break;
                    Integer n6 = new Integer(number.intValue() / number2.intValue());
                }
            }
        }
        if (var7_28 instanceof Double) {
            return new TibjmsxSelectorToken(operation.position, 4, var7_28);
        }
        if (var7_28 instanceof Float) {
            return new TibjmsxSelectorToken(operation.position, 4, var7_28);
        }
        if (var7_28 instanceof Long) {
            return new TibjmsxSelectorToken(operation.position, 3, var7_28);
        }
        if (!(var7_28 instanceof Integer)) throw new InternalError("Invalid operation in perform arithmetic");
        return new TibjmsxSelectorToken(operation.position, 3, var7_28);
    }

    Object check_op_equal(boolean bl, Operation operation) throws InvalidSelectorException {
        Object object = operation.left;
        Object object2 = operation.right;
        int n = this.getOperandType(object);
        int n2 = this.getOperandType(object2);
        switch (n) {
            case 1: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 6: {
                        this.ex("Invalid comparison operation", operation);
                    }
                }
                break;
            }
            case 2: {
                switch (n2) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        int n3 = this.compareStrings(object, object2);
                        if (n3 < 0) break;
                        if (bl) {
                            int n4 = n3 = n3 == 0 ? 1 : 0;
                        }
                        if (n3 == 1) {
                            return new TibjmsxSelectorToken(31);
                        }
                        return new TibjmsxSelectorToken(32);
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.ex("Invalid comparison operation", operation);
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: 
                    case 4: 
                    case 6: {
                        this.ex("Invalid comparison operation", operation);
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        this.ex("Invalid comparison operation", operation);
                    }
                    case 4: {
                        int n5 = this.getLogicalValue(object);
                        int n6 = this.getLogicalValue(object2);
                        if (n5 >= 0) {
                            boolean bl2;
                            if (n6 < 0) break;
                            boolean bl3 = bl2 = n5 == n6;
                            if (bl) {
                                boolean bl4 = bl2 = !bl2;
                            }
                            if (bl2) {
                                return new TibjmsxSelectorToken(31);
                            }
                            return new TibjmsxSelectorToken(32);
                        } else {
                            break;
                        }
                    }
                }
                break;
            }
            case 5: {
                switch (n2) {
                    case 2: 
                    case 4: 
                    case 6: {
                        this.ex("Invalid comparison operation", operation);
                    }
                    case 5: {
                        int n7 = this.is_equal(object, object2);
                        if (n7 < 0) break;
                        if (bl) {
                            int n8 = n7 = n7 == 0 ? 1 : 0;
                        }
                        if (n7 == 1) {
                            return new TibjmsxSelectorToken(31);
                        }
                        return new TibjmsxSelectorToken(32);
                    }
                }
                break;
            }
            case 6: {
                throw new InvalidSelectorException("Invalid selector syntax", this._poserr + (operation.position + 1));
            }
        }
        return null;
    }

    Object check_op_compare(Operation operation) throws InvalidSelectorException {
        Object object = operation.left;
        Object object2 = operation.right;
        int n = this.getOperandType(object);
        int n2 = this.getOperandType(object2);
        switch (n) {
            case 1: {
                switch (n2) {
                    case 1: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        this.ex("Invalid comparison operation", operation);
                    }
                }
                break;
            }
            case 2: {
                this.ex("Invalid comparison operation", operation);
                break;
            }
            case 3: {
                switch (n2) {
                    case 2: 
                    case 4: 
                    case 6: {
                        this.ex("Invalid comparison operation", operation);
                    }
                }
                break;
            }
            case 4: {
                this.ex("Invalid comparison operation", operation);
                break;
            }
            case 5: {
                switch (n2) {
                    case 2: 
                    case 4: 
                    case 6: {
                        this.ex("Invalid comparison operation", operation);
                    }
                    case 5: {
                        int n3 = this.compare(operation.op, object, object2);
                        if (n3 < 0) break;
                        if (n3 == 1) {
                            return new TibjmsxSelectorToken(31);
                        }
                        return new TibjmsxSelectorToken(32);
                    }
                }
                break;
            }
            case 6: {
                throw new InvalidSelectorException("Invalid selector syntax", this._poserr + (operation.position + 1));
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    Object check_op_arithmetic(Operation operation) throws InvalidSelectorException {
        TibjmsxSelectorToken tibjmsxSelectorToken = null;
        Object object = operation.left;
        Object object2 = operation.right;
        int n = this.getOperandType(object);
        int n2 = this.getOperandType(object2);
        if (n == 6 || n2 == 6 && operation.op != 14 && operation.op != 15) {
            this.ex("Arithmetic with NULL detected, selector is always false", operation);
        }
        if (n == 2 || n == 4 || n2 == 2 || n2 == 4) {
            this.ex("Invalid arithmetic operation, selector is always false", operation);
        }
        if (n2 == 5 && object2 instanceof TibjmsxSelectorToken && operation.op == 17) {
            TibjmsxSelectorToken tibjmsxSelectorToken2 = (TibjmsxSelectorToken)object2;
            if (((Number)tibjmsxSelectorToken2.value).doubleValue() == 0.0) {
                throw new InvalidSelectorException("Division by zero", this._poserr + (tibjmsxSelectorToken2.position + 1));
            }
        }
        switch (n) {
            case 5: {
                switch (n2) {
                    case 5: 
                    case 6: {
                        tibjmsxSelectorToken = this.perform(operation, operation.op, object, object2);
                        if (tibjmsxSelectorToken == null) return null;
                        return tibjmsxSelectorToken;
                    }
                }
                return null;
            }
        }
        return null;
    }

    Object check_op_logical(Operation operation) throws InvalidSelectorException {
        Object object = operation.left;
        int n = this.getOperandType(object);
        int n2 = this.getLogicalValue(object);
        if (operation.op == 42) {
            if (n2 == 1) {
                return new TibjmsxSelectorToken(32);
            }
            if (n2 == 0) {
                return new TibjmsxSelectorToken(31);
            }
            return null;
        }
        Object object2 = operation.right;
        int n3 = this.getOperandType(object2);
        int n4 = this.getLogicalValue(object2);
        if (operation.op == 40) {
            if (n2 == 0 || n4 == 0) {
                return new TibjmsxSelectorToken(32);
            }
            if (n2 == 1 && n4 == 1) {
                return new TibjmsxSelectorToken(31);
            }
        } else {
            if (n2 == 1 || n4 == 1) {
                return new TibjmsxSelectorToken(31);
            }
            if (n2 == 0 && n4 == 0) {
                return new TibjmsxSelectorToken(32);
            }
        }
        switch (n) {
            case 1: {
                switch (n3) {
                    case 1: 
                    case 4: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        this.ex("Invalid logical operation", operation);
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        this.ex("Invalid logical operation", operation);
                    }
                }
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                this.ex("Invalid logical operation", operation);
            }
        }
        if (operation.op == 40) {
            if (n2 == 1) {
                return object2;
            }
            if (n4 == 1) {
                return object;
            }
        } else {
            if (n2 == 0) {
                return object2;
            }
            if (n4 == 0) {
                return object;
            }
        }
        return null;
    }

    Object check_op_in(Operation operation) throws InvalidSelectorException {
        Object object = operation.left;
        Object object2 = operation.right;
        int n = this.getOperandType(object);
        if (n != 1 && n != 2) {
            this.ex("Invalid left side of IN operator", operation);
        }
        if (!(object2 instanceof Vector)) {
            this.ex("Invalid right side of IN operator", operation);
        }
        return null;
    }

    Object check_op_like(Operation operation) throws InvalidSelectorException {
        Object object = operation.left;
        int n = this.getOperandType(object);
        if (n != 1 && n != 2) {
            this.ex("Invalid left side of LIKE operator", operation);
        }
        return null;
    }

    Object check_op_is(Operation operation) throws InvalidSelectorException {
        TibjmsxSelectorToken tibjmsxSelectorToken;
        Object object = operation.left;
        Object object2 = operation.right;
        int n = this.getOperandType(object);
        int n2 = 0;
        if (object instanceof TibjmsxSelectorToken) {
            tibjmsxSelectorToken = (TibjmsxSelectorToken)object;
            n2 = tibjmsxSelectorToken.type;
        }
        if (n != 1 && n != 2) {
            this.ex("Invalid left side of IS operator", operation);
        }
        if (n2 != 1 && n != 1) {
            this.ex("Invalid left side of IS operator", operation);
        }
        if (!(object2 instanceof TibjmsxSelectorToken)) {
            this.ex("Invalid right side of IS operator", operation);
        }
        tibjmsxSelectorToken = (TibjmsxSelectorToken)object2;
        if (tibjmsxSelectorToken.type != 30) {
            this.ex("Invalid right side of IS operator", operation);
        }
        return null;
    }

    Object collapseOperation(Operation operation) throws InvalidSelectorException {
        if (operation.op == 45) {
            int n = operation.not ? 10 : 13;
            int n2 = operation.not ? 12 : 11;
            int n3 = operation.not ? 41 : 40;
            int n4 = this.getOperandType(operation.left);
            switch (n4) {
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    this.ex("Invalid logical operation", operation);
                }
            }
            if (!(operation.right instanceof Operation)) {
                this.ex("Invalid syntax of BETWEEN operation", operation);
            }
            Operation operation2 = (Operation)operation.right;
            if (operation2.op != 40) {
                this.ex("Invalid syntax of BETWEEN operation", operation);
            }
            int n5 = this.getOperandType(operation2.left);
            int n6 = this.getOperandType(operation2.right);
            if (n5 != 3 && n5 != 5 && n5 != 6 && n5 != 1) {
                this.ex("Invalid operand of BETWEEN operation", operation2.left);
            }
            if (n6 != 3 && n6 != 5 && n6 != 6 && n6 != 1) {
                this.ex("Invalid operand of BETWEEN operation", operation2.right);
            }
            if (n5 == 6 || n6 == 6) {
                if (operation.not) {
                    return new TibjmsxSelectorToken(31);
                }
                return new TibjmsxSelectorToken(32);
            }
            Operation operation3 = new Operation(n, operation.left, operation2.left, operation2.position);
            Operation operation4 = new Operation(n2, operation.left, operation2.right, operation2.position);
            Operation operation5 = new Operation(n3, operation3, operation4, operation.position);
            operation5.between = true;
            operation4.between = true;
            operation3.between = true;
            operation = operation5;
        }
        if (operation.left instanceof Operation) {
            operation.left = this.collapseOperation((Operation)operation.left);
        }
        if (operation.right instanceof Operation) {
            operation.right = this.collapseOperation((Operation)operation.right);
        }
        Object object = null;
        switch (operation.op) {
            case 6: 
            case 7: {
                object = this.check_op_equal(operation.op == 7, operation);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                object = this.check_op_compare(operation);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                object = this.check_op_arithmetic(operation);
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                object = this.check_op_logical(operation);
                break;
            }
            case 44: {
                object = this.check_op_in(operation);
                break;
            }
            case 43: {
                object = this.check_op_is(operation);
                break;
            }
            case 46: {
                object = this.check_op_like(operation);
                break;
            }
            case 45: {
                throw new InvalidSelectorException("Invalid selector syntax");
            }
            default: {
                throw new InvalidSelectorException("Invalid selector syntax");
            }
        }
        return object == null ? operation : object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void buildTree() throws InvalidSelectorException {
        try {
            if (this.selector == null || this.selector.length() == 0) {
                return;
            }
            this.processParenthesis();
            if (this.root == null) {
                this.expressionTree = null;
                return;
            }
            if (!(this.root.value instanceof Vector)) {
                throw new InvalidSelectorException("Invalid selector", "Selector can not be evaluated");
            }
            Vector vector = (Vector)this.root.value;
            if (vector.size() == 0) {
                return;
            }
            this.processVector(vector);
            Object object = this.lift(vector);
            Operation operation = object instanceof Vector ? this.split((Vector)object) : (object instanceof TibjmsxSelectorToken ? new Operation(6, object, new TibjmsxSelectorToken(31), ((TibjmsxSelectorToken)object).position) : (Operation)object);
            if (operation == null) {
                throw new InvalidSelectorException("Invalid syntax", "Selector can not be evaluated: no operations");
            }
            this.processOperation(operation);
            Object object2 = this.collapseOperation(operation);
            if (object2 != null && object2 != operation && !(object2 instanceof Operation)) {
                if (!(object2 instanceof TibjmsxSelectorToken)) throw new InvalidSelectorException("Invalid selector syntax");
                TibjmsxSelectorToken tibjmsxSelectorToken = (TibjmsxSelectorToken)object2;
                if (tibjmsxSelectorToken.type != 31 && tibjmsxSelectorToken.type != 32) {
                    if (tibjmsxSelectorToken.type != 1) throw new InvalidSelectorException("Invalid selector syntax");
                    object2 = new Operation(6, tibjmsxSelectorToken, new TibjmsxSelectorToken(31), tibjmsxSelectorToken.position);
                }
            }
            this.expressionTree = object2;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof InvalidSelectorException) {
                throw (InvalidSelectorException)exception;
            }
            InvalidSelectorException invalidSelectorException = new InvalidSelectorException("Invalid selector syntax");
            invalidSelectorException.setLinkedException(exception);
            throw invalidSelectorException;
        }
    }

    public int getSelectorExpressionType() {
        if (this.expressionTree == null) {
            return 0;
        }
        if (this.expressionTree instanceof Operation) {
            return 22;
        }
        if (this.expressionTree instanceof TibjmsxSelectorToken) {
            TibjmsxSelectorToken tibjmsxSelectorToken = (TibjmsxSelectorToken)this.expressionTree;
            if (tibjmsxSelectorToken.type == 31 || tibjmsxSelectorToken.type == 32) {
                return tibjmsxSelectorToken.type;
            }
        }
        return 0;
    }

    public TibjmsxStream getWire() throws InvalidSelectorException, JMSException {
        if (this.expressionTree == null) {
            return null;
        }
        TibjmsxStream tibjmsxStream = new TibjmsxStream();
        int n = tibjmsxStream.curpos;
        tibjmsxStream.writeInt(0);
        int n2 = tibjmsxStream.curpos;
        this.writeOperand(tibjmsxStream, this.expressionTree);
        if (tibjmsxStream.curpos == 0) {
            throw new InvalidSelectorException("Failed to serialize selector expression tree");
        }
        int n3 = tibjmsxStream.curpos;
        tibjmsxStream.curpos = n;
        tibjmsxStream.writeInt(n3 - n2);
        tibjmsxStream.curpos = n3;
        return tibjmsxStream;
    }

    void writeOperation(TibjmsxStream tibjmsxStream, Operation operation) throws JMSException {
        this.writeOperationOperation(tibjmsxStream, operation);
        this.writeOperand(tibjmsxStream, operation.left);
        this.writeOperand(tibjmsxStream, operation.right);
    }

    void writeOperationOperation(TibjmsxStream tibjmsxStream, Operation operation) throws JMSException {
        tibjmsxStream.writeByte((byte)operation.op);
        int n = 0;
        if (operation.not) {
            n |= 1;
        }
        if (operation.between) {
            n |= 2;
        }
        tibjmsxStream.writeByte((byte)n);
    }

    void writeOperand(TibjmsxStream tibjmsxStream, Object object) throws JMSException {
        if (object == null) {
            tibjmsxStream.writeByte(0);
            return;
        }
        if (object instanceof Operation) {
            tibjmsxStream.writeByte(2);
            this.writeOperation(tibjmsxStream, (Operation)object);
            return;
        }
        tibjmsxStream.writeByte(1);
        this.writeValue(tibjmsxStream, object);
    }

    void writeValue(TibjmsxStream tibjmsxStream, Object object) throws JMSException {
        if (object == null) {
            tibjmsxStream.writeByte(0);
            return;
        }
        if (object instanceof TibjmsxSelectorToken) {
            this.writeToken(tibjmsxStream, (TibjmsxSelectorToken)object);
            return;
        }
        if (object instanceof Vector) {
            this.writeVector(tibjmsxStream, (Vector)object);
            return;
        }
        throw new InvalidSelectorException("Invalid value detected while serializing selector");
    }

    void writeVector(TibjmsxStream tibjmsxStream, Vector vector) throws InvalidSelectorException, JMSException {
        tibjmsxStream.writeByte(23);
        tibjmsxStream.writeVarLong(vector.size());
        for (int j = 0; j < vector.size(); ++j) {
            if (!(vector.elementAt(j) instanceof TibjmsxSelectorToken)) {
                throw new InvalidSelectorException("Invalid object detected while serializing selector");
            }
            TibjmsxSelectorToken tibjmsxSelectorToken = (TibjmsxSelectorToken)vector.elementAt(j);
            if (tibjmsxSelectorToken.type != 2) {
                throw new InvalidSelectorException("Invalid vector token detected while serializing selector");
            }
            tibjmsxStream.writeString((String)tibjmsxSelectorToken.value);
        }
    }

    void writeToken(TibjmsxStream tibjmsxStream, TibjmsxSelectorToken tibjmsxSelectorToken) throws JMSException {
        tibjmsxStream.writeByte((byte)tibjmsxSelectorToken.type);
        switch (tibjmsxSelectorToken.type) {
            case 1: {
                tibjmsxStream.writeByte((byte)tibjmsxSelectorToken.flags);
                tibjmsxStream.writeByte((byte)tibjmsxSelectorToken.operandType);
                tibjmsxStream.writeByte((byte)tibjmsxSelectorToken.propertyId);
                tibjmsxStream.writeString((String)tibjmsxSelectorToken.value);
                break;
            }
            case 2: {
                tibjmsxStream.writeByte((byte)tibjmsxSelectorToken.flags);
                tibjmsxStream.writeString((String)tibjmsxSelectorToken.value);
                if ((tibjmsxSelectorToken.flags & 4) == 0) break;
                tibjmsxStream.writeShort(tibjmsxSelectorToken.escapeIndex);
                break;
            }
            case 3: {
                tibjmsxStream.writeLong(((Number)tibjmsxSelectorToken.value).longValue());
                break;
            }
            case 4: {
                tibjmsxStream.writeDouble(((Number)tibjmsxSelectorToken.value).doubleValue());
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            default: {
                throw new InvalidSelectorException("Invalid token type detected while serializing selector");
            }
        }
    }

    static {
        for (int j = 0; j < properties.length; ++j) {
            propsMap.put(TibjmsxSelector.properties[j].text, properties[j]);
        }
    }

    class Operation {
        boolean not = false;
        int op = 0;
        Object left = null;
        Object right = null;
        int position = -1;
        boolean between = false;

        Object hasValue() {
            return null;
        }

        Object normalizeExpr(Object object) {
            Object e;
            Vector vector;
            if (object != null && object instanceof Vector && (vector = (Vector)object).size() == 1 && (e = vector.elementAt(0)) instanceof TibjmsxSelectorToken) {
                TibjmsxSelectorToken tibjmsxSelectorToken = (TibjmsxSelectorToken)e;
                if (tibjmsxSelectorToken.type == 22) {
                    return tibjmsxSelectorToken.value;
                }
            }
            return object;
        }

        void normalizeExpr() {
            Object object = this.normalizeExpr(this.left);
            while ((object = this.normalizeExpr(this.left)) != this.left) {
                this.left = object;
            }
            while ((object = this.normalizeExpr(this.right)) != this.right) {
                this.right = object;
            }
        }

        Operation(int n, Object object, Object object2, int n2) {
            this.op = n;
            this.left = object;
            this.right = object2;
            this.position = n2;
            this.normalizeExpr();
        }

        Operation(Vector vector, int n, int n2, int n3) throws InvalidSelectorException {
            int n4;
            this.op = n;
            this.position = n3;
            int n5 = vector.size();
            if (n2 < 1 || n2 >= n5 - 1) {
                throw new InvalidSelectorException("Invalid syntax");
            }
            Vector vector2 = new Vector();
            for (n4 = 0; n4 < n2; ++n4) {
                vector2.addElement(vector.elementAt(n4));
            }
            this.left = vector2;
            vector2 = new Vector();
            for (n4 = n2 + 1; n4 < n5; ++n4) {
                vector2.addElement(vector.elementAt(n4));
            }
            this.right = vector2;
            this.normalizeExpr();
        }

        Operation(Vector vector, boolean bl, int n, int n2, int n3, int n4, int n5, int n6) throws InvalidSelectorException {
            int n7;
            this.op = n;
            this.not = bl;
            this.position = n6;
            int n8 = vector.size();
            if (n2 < 0 || n2 > n3 || n3 >= n4 || n4 > n5 || n5 > n8 - 1) {
                throw new InvalidSelectorException("Invalid syntax");
            }
            Vector vector2 = new Vector();
            for (n7 = n2; n7 <= n3; ++n7) {
                vector2.addElement(vector.elementAt(n7));
            }
            this.left = vector2;
            vector2 = new Vector();
            for (n7 = n4; n7 <= n5; ++n7) {
                vector2.addElement(vector.elementAt(n7));
            }
            this.right = vector2;
            this.normalizeExpr();
        }
    }

    static class Property {
        String text;
        int id;
        int type;

        public Property(String string, int n, int n2) {
            this.text = string;
            this.id = n;
            this.type = n2;
        }
    }

    static class Keyword {
        String text;
        int length;
        int type;

        public Keyword(String string, int n, int n2) {
            this.text = string;
            this.length = n;
            this.type = n2;
        }
    }
}

