/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsMessage;
import com.tibco.tibjms.TibjmsxConst;
import java.util.LinkedList;
import java.util.ListIterator;

class TibjmsxPQueue
implements TibjmsxConst {
    LinkedList[] pqueue = null;
    int mcount = 0;
    int max_priority = -1;

    public TibjmsxPQueue() {
        this._create(10);
    }

    public TibjmsxPQueue(int n) {
        this._create(n);
    }

    private void _create(int n) {
        this.pqueue = new LinkedList[n];
        for (int j = 0; j < this.pqueue.length; ++j) {
            this.pqueue[j] = new LinkedList();
        }
        this.mcount = 0;
        this.max_priority = -1;
    }

    public void clear() {
        for (int j = 0; j < this.pqueue.length; ++j) {
            this.pqueue[j].clear();
        }
        this.mcount = 0;
        this.max_priority = -1;
    }

    public void add(Object object, int n) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.pqueue.length) {
            n = this.pqueue.length - 1;
        }
        this.pqueue[n].add(object);
        ++this.mcount;
        if (n > this.max_priority) {
            this.max_priority = n;
        }
    }

    public void addMessage(TibjmsMessage tibjmsMessage) {
        int n = tibjmsMessage._JMSPriority;
        if (n < 0) {
            n = 0;
        }
        if (n >= this.pqueue.length) {
            n = this.pqueue.length - 1;
        }
        if (this.pqueue[n].isEmpty() || ((TibjmsMessage)this.pqueue[n].getLast())._sequenceID <= tibjmsMessage._sequenceID) {
            this.pqueue[n].add(tibjmsMessage);
        } else {
            int n2 = 0;
            ListIterator listIterator = this.pqueue[n].listIterator();
            while (listIterator.hasNext()) {
                TibjmsMessage tibjmsMessage2 = (TibjmsMessage)listIterator.next();
                if (tibjmsMessage2._sequenceID >= tibjmsMessage._sequenceID) {
                    this.pqueue[n].add(n2, tibjmsMessage);
                    break;
                }
                ++n2;
            }
        }
        ++this.mcount;
        if (n > this.max_priority) {
            this.max_priority = n;
        }
    }

    public void push(Object object, int n) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.pqueue.length) {
            n = this.pqueue.length - 1;
        }
        this.pqueue[n].addFirst(object);
        ++this.mcount;
        if (n > this.max_priority) {
            this.max_priority = n;
        }
    }

    public Object get() {
        if (this.mcount == 0 || this.max_priority == -1) {
            return null;
        }
        Object e = this.pqueue[this.max_priority].removeFirst();
        if (--this.mcount == 0) {
            this.max_priority = -1;
        } else {
            while (this.pqueue[this.max_priority].isEmpty()) {
                --this.max_priority;
            }
        }
        return e;
    }

    public Object peek() {
        if (this.mcount == 0 || this.max_priority == -1) {
            return null;
        }
        return this.pqueue[this.max_priority].getFirst();
    }

    public int getPriority() {
        return this.max_priority;
    }

    public int size() {
        return this.mcount;
    }
}

