/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsHTTPAuthenticationException;
import com.tibco.tibjms.TibjmsHTTPException;
import com.tibco.tibjms.TibjmsMessage;
import com.tibco.tibjms.Tibjmsx;
import com.tibco.tibjms.TibjmsxConst;
import com.tibco.tibjms.TibjmsxLink;
import com.tibco.tibjms.TibjmsxResponse;
import com.tibco.tibjms.TibjmsxSocket;
import com.tibco.tibjms.TibjmsxSocket3;
import com.tibco.tibjms.TibjmsxSocket4;
import com.tibco.tibjms.TibjmsxStream;
import com.tibco.tibjms.TibjmsxURL;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.Vector;
import javax.jms.JMSException;

class TibjmsxLinkTcp
extends TibjmsxLink
implements TibjmsxConst {
    Socket _socket = null;
    DataInputStream _input = null;
    DataOutputStream _output = null;
    LinkReader _linkReader = null;
    boolean _needPing = false;
    static Pinger _pinger = null;
    static Object _pingerLock = new Object();
    static Vector _links = new Vector();
    static long _pingInterval = -1L;
    LocalPinger _localPinger = null;
    long _localPingInterval = 60000L;
    boolean _debugMagic = Tibjmsx._debugMagic;
    Vector _bufcache = null;
    static final int _MAX_DEBUG_CACHE = 3;
    private static Object _shutdownLock = new Object();
    private boolean _readerStarted = false;
    volatile boolean _reconnecting = false;
    static int _jdk14 = 0;
    private static final String _codesymbols = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    @Override
    void setPing(int n) {
        if (n <= 0) {
            return;
        }
        this._localPingInterval = n * 1000;
        if (this._localPinger != null) {
            this._localPinger.stop();
        }
        this._localPinger = new LocalPinger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _createPinger() {
        Object object = _pingerLock;
        synchronized (object) {
            if (_pinger == null) {
                if (_pingInterval == -1L) {
                    _pingInterval = Tibjmsx.pingInterval * 1000;
                }
                if (_pingInterval > 0L) {
                    _pinger = new Pinger();
                }
            }
            if (_pinger != null && !_links.contains(this)) {
                _links.add(this);
            }
        }
    }

    TibjmsxLinkTcp(TibjmsxLink.LinkEventHandler linkEventHandler) throws JMSException {
        super(linkEventHandler);
    }

    @Override
    void closeSocket() {
        Socket socket = this._socket;
        if (socket != null) {
            try {
                socket.shutdownInput();
            }
            catch (Exception exception) {
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            try {
                socket.shutdownOutput();
            }
            catch (Exception exception) {
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._socket = null;
        }
    }

    void _sendData(Object object, TibjmsxStream tibjmsxStream, int n, TibjmsxResponse tibjmsxResponse) throws IOException, JMSException {
        Object object2;
        Object object3 = null;
        int n2 = 0;
        int n3 = 0;
        if (this._state == 3) {
            throw new JMSException(this._linkHandler.getTerminatedText());
        }
        if (this._debug || (this._trace & 2) != 0) {
            try {
                object2 = null;
                if (object instanceof TibjmsxStream) {
                    object2 = TibjmsMessage.createFromBytes(((TibjmsxStream)object).buffer);
                } else if (object instanceof byte[]) {
                    object2 = TibjmsMessage.createFromBytes((byte[])object);
                } else if (object instanceof TibjmsMessage) {
                    object2 = (TibjmsMessage)object;
                } else {
                    Tibjmsx.print("Unrecognized object, can not print it...");
                }
                if (object2 != null) {
                    Tibjmsx.print("----------------- outgoing message --------------------");
                    if (this._debugPrintBrief) {
                        Tibjmsx.print(((TibjmsMessage)object2).toString(true));
                    } else {
                        Tibjmsx.print(((TibjmsMessage)object2).toString());
                    }
                }
            }
            catch (JMSException jMSException) {
                jMSException.printStackTrace();
                System.exit(0);
            }
        }
        if (object instanceof TibjmsxStream) {
            object2 = (TibjmsxStream)object;
            object3 = ((TibjmsxStream)object2).buffer;
            n3 = ((TibjmsxStream)object2).curpos;
        } else if (object instanceof byte[]) {
            object2 = (byte[])object;
            object3 = object2;
            n3 = ((Object)object2).length;
        } else if (object instanceof TibjmsMessage) {
            if (tibjmsxStream == null) {
                tibjmsxStream = new TibjmsxStream();
            }
            object2 = (TibjmsMessage)object;
            tibjmsxStream.startWriting();
            try {
                ((TibjmsMessage)object2).write(tibjmsxStream, false);
                object3 = tibjmsxStream.buffer;
                n3 = tibjmsxStream.curpos;
            }
            catch (JMSException jMSException) {
                Tibjmsx.print("TCPLink: error building message buffer");
                throw jMSException;
            }
        } else {
            throw new InternalError("Bad object in send: class=" + object.getClass().getName());
        }
        object2 = this._sendLock;
        synchronized (object2) {
            while (true) {
                try {
                    if (this._output == null || this._state == 3) {
                        throw new JMSException(this._linkHandler.getTerminatedText());
                    }
                    this._needPing = false;
                    this._output.write((byte[])object3, n2, n3);
                    this._output.flush();
                    return;
                }
                catch (IOException iOException) {
                    if (this.isClosing()) {
                        return;
                    }
                    if (n == 1) {
                        return;
                    }
                    if (!this._doReconnect(true)) {
                        throw iOException;
                    }
                    if (tibjmsxResponse != null) {
                        this.recoverResponse(tibjmsxResponse);
                    }
                    if (n != 3) continue;
                    throw new JMSException("Send failed due to fault-tolerant switch");
                    if (n != 4) continue;
                    return;
                }
                break;
            }
        }
    }

    boolean _doReconnect(boolean bl) {
        this.closeSocket();
        if (this._state == 3) {
            return false;
        }
        if (bl) {
            try {
                if (this._reconnecting || !this._readerStarted) {
                    this._state = 3;
                    return false;
                }
                while (this._socket == null && this._state != 3) {
                    this._sendLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            return this._state == 1;
        }
        this._sendLock.notifyAll();
        if (!this._shouldReconnect) {
            this._state = 3;
            return false;
        }
        this._reconnecting = true;
        if (this._linkHandler.onEventReconnect()) {
            this._reconnecting = false;
            return true;
        }
        this._reconnecting = false;
        this._state = 3;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] _readWireMsg() throws IOException {
        DataInputStream dataInputStream = this._input;
        byte[] byArray = null;
        if (dataInputStream == null) {
            return null;
        }
        int n = dataInputStream.readInt();
        this._needPing = false;
        if (this._state == 3) {
            return null;
        }
        int n2 = dataInputStream.readInt();
        this._needPing = false;
        this._lastActiveTime = System.currentTimeMillis();
        if (this._state == 3) {
            return null;
        }
        if (n2 != -1722421590) {
            Tibjmsx.print("TCPLink Error: invalid magic in the message (url=" + this._linkURL.toString() + ")");
            if (this._debugMagic) {
                int n3 = 0;
                try {
                    n3 = dataInputStream.available();
                    byArray = new byte[8 + n3];
                    this.intToBytes(n, byArray, 0);
                    this.intToBytes(n2, byArray, 4);
                    if (n3 > 0) {
                        dataInputStream.readFully(byArray, 8, n3);
                    }
                }
                catch (EOFException eOFException) {
                    Tibjmsx.print("[TIBCO]: EOFException - Error while reading available bytes avail=" + n3);
                    eOFException.printStackTrace();
                }
                catch (IOException iOException) {
                    Tibjmsx.print("[TIBCO]: IOException - Error while reading available bytes avail=" + n3);
                    iOException.printStackTrace();
                }
                Tibjmsx.print("[TIBCO EMS]: dumping recently received and currently read bytes:");
                if (this._bufcache != null) {
                    for (int j = 0; j < this._bufcache.size(); ++j) {
                        byte[] byArray2 = (byte[])this._bufcache.elementAt(j);
                        Tibjmsx.print("\n[TIBCO EMS]: dump of message " + (j + 1) + ", " + byArray2.length + " bytes");
                        TibjmsxStream.printHexData(byArray2);
                        try {
                            TibjmsMessage tibjmsMessage = TibjmsMessage.createFromBytes(byArray2);
                            Tibjmsx.print("         message:\n" + tibjmsMessage);
                            continue;
                        }
                        catch (JMSException jMSException) {
                            Tibjmsx.print("         message: ERROR: unable to print");
                        }
                    }
                }
                Tibjmsx.print("\n[TIBCO EMS]: dump of unrecognized bytes just received, total read " + (byArray == null ? 0 : byArray.length) + " bytes");
                TibjmsxStream.printHexData(byArray);
                Tibjmsx.print("");
            }
            Object object = _shutdownLock;
            synchronized (object) {
                this._readerStarted = false;
                _shutdownLock.notifyAll();
            }
            this.disconnect();
            this.notifySendersOnDisconnect();
            throw new IOException("Detected corrupted data in the socket (url=" + this._linkURL.toString() + "). Connection is terminated.");
        }
        if (n <= 8) {
            return null;
        }
        byArray = new byte[n];
        this.intToBytes(n, byArray, 0);
        this.intToBytes(n2, byArray, 4);
        dataInputStream.readFully(byArray, 8, n - 8);
        this._needPing = false;
        if (this._debug || (this._trace & 1) != 0) {
            try {
                TibjmsMessage tibjmsMessage = TibjmsMessage.createFromBytes(byArray);
                Tibjmsx.print("----------------- incoming message --------------------");
                if (this._debugPrintBrief) {
                    Tibjmsx.print(tibjmsMessage.toString(true));
                } else {
                    Tibjmsx.print(tibjmsMessage.toString());
                }
            }
            catch (JMSException jMSException) {
                jMSException.printStackTrace();
                System.exit(0);
            }
        }
        if (this._debugMagic) {
            if (this._bufcache == null) {
                this._bufcache = new Vector();
            }
            this._bufcache.addElement(byArray);
            if (this._bufcache.size() > 3) {
                this._bufcache.removeElementAt(0);
            }
        }
        return byArray;
    }

    void intToBytes(int n, byte[] byArray, int n2) {
        for (int j = 0; j < 4; ++j) {
            byArray[n2 + j] = (byte)(n >>> 8 * (3 - j) & 0xFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _createSocket() throws JMSException {
        String string;
        int n;
        String string2;
        JMSException jMSException = null;
        if (this._proxyHost != null) {
            string2 = this._proxyHost;
            n = this._proxyPort;
            string = "Failed to connect to the proxy server at " + string2 + ":" + n;
        } else {
            string2 = this._linkURL.host;
            n = this._linkURL.port;
            string = "Failed to connect to the server at " + this._linkURL.url;
        }
        this._state = 0;
        try {
            Object object = _shutdownLock;
            synchronized (object) {
                TibjmsxSocket tibjmsxSocket;
                this._socket = null;
                if (_jdk14 >= 0) {
                    try {
                        tibjmsxSocket = new TibjmsxSocket4();
                        this._socket = tibjmsxSocket.createSocket(string2, n, Tibjmsx.socketConnectTimeout);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        _jdk14 = -1;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        _jdk14 = -1;
                    }
                    catch (IllegalAccessError illegalAccessError) {
                        _jdk14 = -1;
                    }
                }
                if (_jdk14 < 0) {
                    this._socket = null;
                    tibjmsxSocket = new TibjmsxSocket3();
                    this._socket = tibjmsxSocket.createSocket(string2, n, Tibjmsx.socketConnectTimeout);
                }
            }
        }
        catch (IOException iOException) {
            jMSException = new JMSException(string);
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
        try {
            this._socket.setTcpNoDelay(true);
            this._socket.setSoLinger(false, 0);
            this._input = new DataInputStream(new BufferedInputStream(this._socket.getInputStream(), 32768));
            this._output = new DataOutputStream(this._socket.getOutputStream());
            if (this._proxyHost != null) {
                this._doHttpConnect();
            }
        }
        catch (IOException iOException) {
            this.closeSocket();
            jMSException = new JMSException(string);
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    void _doHandshake(boolean bl) throws JMSException {
        JMSException jMSException = null;
        byte[] byArray = null;
        TibjmsxStream tibjmsxStream = null;
        try {
            byArray = new byte[12];
            tibjmsxStream = new TibjmsxStream(byArray);
            tibjmsxStream.startWriting();
            tibjmsxStream.writeInt(2006559453);
            tibjmsxStream.writeInt(0);
            tibjmsxStream.writeInt(0);
            this._output.write(tibjmsxStream.buffer, 0, tibjmsxStream.buflen);
            this._output.flush();
            tibjmsxStream.startReading();
            this._input.readFully(byArray);
            tibjmsxStream.readInt();
            int n = tibjmsxStream.readInt();
            int n2 = tibjmsxStream.readInt();
            this._protocolVersion = n;
            n2 = n2 * 2 / 3;
            tibjmsxStream.startWriting();
            tibjmsxStream.writeInt(bl ? 1 : 0);
            tibjmsxStream.writeInt(Tibjmsx.getIntVersion());
            tibjmsxStream.writeInt(n2);
            this._output.write(tibjmsxStream.buffer, 0, tibjmsxStream.buflen);
            this._output.flush();
            this._createPinger();
        }
        catch (IOException iOException) {
            this.closeSocket();
            jMSException = new JMSException("Failed to connect to the server at " + this._linkURL.url);
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    @Override
    void connect(TibjmsxURL tibjmsxURL) throws JMSException {
        this._linkURL = tibjmsxURL;
        this._createSocket();
        this._doHandshake(false);
        this._state = 1;
    }

    @Override
    boolean isConnected() {
        return this._state == 1;
    }

    @Override
    boolean isClosed() {
        return this._state == 3 && !this._reconnecting;
    }

    @Override
    boolean reconnect(TibjmsxURL tibjmsxURL) {
        if (this._linkURL != null && this._linkURL.protocol != tibjmsxURL.protocol) {
            return false;
        }
        TibjmsxURL tibjmsxURL2 = this._linkURL;
        try {
            this.connect(tibjmsxURL);
            return true;
        }
        catch (JMSException jMSException) {
            this._linkURL = tibjmsxURL2;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void start() throws JMSException {
        this._linkReader = new LinkReader();
        Object object = _shutdownLock;
        synchronized (object) {
            if (this._state == 3) {
                return;
            }
            this._readerStarted = true;
            this._linkReader.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void disconnect() {
        LocalPinger localPinger = this._localPinger;
        this._localPinger = null;
        if (localPinger != null) {
            localPinger.stop();
        }
        Object object = _pingerLock;
        synchronized (object) {
            _links.removeElement(this);
        }
        object = this._sendLock;
        synchronized (object) {
            if (this._state != 3) {
                try {
                    if (this._output != null) {
                        this._output.flush();
                        this._output.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this._state = 3;
            }
            this.closeSocket();
        }
        object = _shutdownLock;
        synchronized (object) {
            while (this._readerStarted && !this._reconnecting && this._linkReader != Thread.currentThread()) {
                try {
                    _shutdownLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    void traceAfterSent() {
    }

    @Override
    TibjmsMessage syncSendRequest(Object object, long l) throws JMSException {
        try {
            this._sendData(object, null, 2, null);
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Connect failed: " + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
        this.traceAfterSent();
        try {
            byte[] byArray = null;
            while (this._input != null && (byArray = this._readWireMsg()) == null) {
            }
            if (this._input == null || byArray == null) {
                throw new JMSException("Connect failed: connection terminated or no response from the server.");
            }
            return new TibjmsMessage(byArray, 1);
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Connect failed: " + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    @Override
    public void send(Object object, int n, TibjmsxResponse tibjmsxResponse) throws JMSException {
        try {
            this._sendData(object, null, n, tibjmsxResponse);
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException(this._linkHandler.getTerminatedText());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    private void _doHttpConnect() throws IOException, JMSException {
        this._output.writeBytes("CONNECT " + this._linkURL.host + ":" + this._linkURL.port + " HTTP/1.1\r\n");
        this._output.writeBytes("Host: " + this._linkURL.host + ":" + this._linkURL.port + "\r\n");
        this._output.writeBytes("User-Agent: TIBCOEMS/10.2.1\r\n");
        if (this._proxyUsername != null) {
            this._output.writeBytes("Proxy-Authorization: Basic " + this._base64Encode(this._proxyUsername + ":" + this._proxyPassword) + "\r\n");
        }
        this._output.writeBytes("\r\n");
        this._output.flush();
        Vector vector = TibjmsxLinkTcp._readLines(this._input);
        _HttpStatus _HttpStatus2 = TibjmsxLinkTcp._processStatusLine((String)vector.firstElement());
        if (_HttpStatus2._statusCode != 200) {
            if (_HttpStatus2._statusCode == 407) {
                if (vector.size() < 2) {
                    throw new JMSException("Invalid HTTP response, not enough lines in response");
                }
                for (int j = 1; j < vector.size(); ++j) {
                    String string = (String)vector.elementAt(j);
                    TibjmsxLinkTcp._processChallenge(string, _HttpStatus2);
                }
                throw new JMSException("Invalid HTTP response, \"Basic\" challenge not found in response");
            }
            throw new TibjmsHTTPException("Proxy rejected connection attempt", _HttpStatus2._statusCode, _HttpStatus2._statusString);
        }
    }

    private static Vector _readLines(DataInputStream dataInputStream) throws IOException, JMSException {
        Vector<String> vector = new Vector<String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
        String string = null;
        while ((string = bufferedReader.readLine()) != null && string.length() > 0) {
            if (string.charAt(0) == ' ' || string.charAt(0) == '\t') {
                if (vector.isEmpty()) {
                    throw new JMSException("Invalid HTTP response, continuation line without previous line");
                }
                String string2 = (String)vector.remove(vector.size() - 1) + " " + string.trim();
                vector.add(string2);
                continue;
            }
            vector.add(string);
        }
        return vector;
    }

    private static _HttpStatus _processStatusLine(String string) throws JMSException {
        _HttpStatus _HttpStatus2 = new _HttpStatus();
        if (!(string = string.trim()).startsWith("HTTP/")) {
            throw new JMSException("Invalid HTTP response, line does not start with \"HTTP/\": " + string);
        }
        int n = string.indexOf(32);
        if (n <= 0) {
            throw new JMSException("Invalid HTTP response, unable to parse HTTP version: " + string);
        }
        _HttpStatus2._HttpVersion = string.substring(0, n).toUpperCase();
        while (string.charAt(n) == ' ' || string.charAt(n) == '\t') {
            ++n;
        }
        int n2 = string.indexOf(32, n);
        if (n2 < 0) {
            n2 = string.length();
        }
        try {
            _HttpStatus2._statusCode = Integer.parseInt(string.substring(n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new JMSException("Invalid HTTP response, unable to parse status code: " + string);
        }
        if (n2 < string.length()) {
            _HttpStatus2._statusString = string.substring(n2).trim();
        }
        return _HttpStatus2;
    }

    private static void _processChallenge(String string, _HttpStatus _HttpStatus2) throws JMSException {
        String string2;
        int n = string.indexOf(58);
        if (n > 0 && (string2 = string.substring(0, n).trim()).equalsIgnoreCase("Proxy-Authenticate")) {
            string = string.substring(n + 1).trim();
            TibjmsxLinkTcp._processAuthenticate(string, _HttpStatus2);
        }
    }

    private static void _processAuthenticate(String string, _HttpStatus _HttpStatus2) throws JMSException {
        String string2 = null;
        String string3 = null;
        do {
            String string4 = null;
            int n = string.indexOf(44);
            if (n > 0) {
                string4 = string.substring(0, n).trim();
            } else {
                string4 = string.trim();
                n = string.length() - 1;
            }
            int n2 = string4.indexOf(32);
            if (n2 > 0) {
                string3 = string4.substring(0, n2);
                if (string3.equalsIgnoreCase("basic")) {
                    string2 = (string4 = string4.substring(n2 + 1).trim()).substring((n2 = string4.indexOf(61)) + 1).trim();
                    if (string2.startsWith("\"") && string2.endsWith("\"")) {
                        string2 = string2.substring(1, string2.length() - 1);
                    }
                    throw new TibjmsHTTPAuthenticationException("Proxy rejected connection attempt", _HttpStatus2._statusCode, _HttpStatus2._statusString, string2);
                }
                string = string.substring(n + 1).trim();
                continue;
            }
            string = string.substring(n + 1).trim();
        } while (string.length() > 0);
        throw new JMSException("Proxy does not allow \"basic\" authentication");
    }

    private String _base64Encode(String string) {
        int n;
        int n2 = string.length();
        int n3 = n2 % 3;
        int n4 = n3 == 0 ? 0 : 3 - n3;
        int n5 = (n2 + n4) / 3 * 4;
        int n6 = n2 / 3;
        boolean bl = n3 != 0;
        byte[] byArray = new byte[3];
        char[] cArray = new char[n5];
        for (n = 0; n < n6; ++n) {
            int n7 = 4 * n;
            byArray[0] = (byte)string.charAt(n * 3);
            byArray[1] = (byte)string.charAt(n * 3 + 1);
            byArray[2] = (byte)string.charAt(n * 3 + 2);
            TibjmsxLinkTcp._encode(cArray, n7, byArray);
        }
        if (bl) {
            for (n = 0; n < n3; ++n) {
                byArray[n] = (byte)string.charAt(n6 * 3 + n);
            }
            for (n = n3; n < 3; ++n) {
                byArray[n] = 0;
            }
            TibjmsxLinkTcp._encode(cArray, n6 * 4, byArray);
        }
        String string2 = new String(cArray);
        return string2;
    }

    private static void _encode(char[] cArray, int n, byte[] byArray) {
        int n2 = byArray[0] >> 2 & 0x3F;
        cArray[n] = _codesymbols.charAt(n2);
        n2 = byArray[0] << 4 & 0x30 | byArray[1] >> 4 & 0xF;
        cArray[n + 1] = _codesymbols.charAt(n2);
        if (byArray[1] != 0) {
            n2 = byArray[1] << 2 & 0x3C | byArray[2] >> 6 & 3;
            cArray[n + 2] = _codesymbols.charAt(n2);
        } else {
            cArray[n + 2] = 61;
        }
        if (byArray[2] != 0) {
            n2 = byArray[2] & 0x3F;
            cArray[n + 3] = _codesymbols.charAt(n2);
        } else {
            cArray[n + 3] = 61;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifySendersOnDisconnect() {
        Object object = this._sendLock;
        synchronized (object) {
            this._sendLock.notifyAll();
        }
    }

    private static class _HttpStatus {
        String _HttpVersion = null;
        int _statusCode = 0;
        String _statusString = null;

        private _HttpStatus() {
        }
    }

    class LinkReader
    extends Thread {
        LinkReader() {
            this.setName("TIBCO EMS TCPLink Reader (" + TibjmsxLinkTcp.this._linkId + ")");
            try {
                this.setDaemon(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.work();
            Object object = _shutdownLock;
            synchronized (object) {
                TibjmsxLinkTcp.this._readerStarted = false;
                _shutdownLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void work() {
            while (true) {
                Object object;
                try {
                    while (true) {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        byte[] byArray = TibjmsxLinkTcp.this._readWireMsg();
                        if (TibjmsxLinkTcp.this._state == 3) {
                            return;
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        if (TibjmsxLinkTcp.this._input == null) {
                            return;
                        }
                        if (byArray == null) continue;
                        TibjmsxLinkTcp.this._linkHandler.onEventProcessMessage(byArray);
                        if (TibjmsxLinkTcp.this._state == 3) {
                            return;
                        }
                        byArray = null;
                    }
                }
                catch (IOException iOException) {
                    if (TibjmsxLinkTcp.this.isClosing()) {
                        object = TibjmsxLinkTcp.this._sendLock;
                        synchronized (object) {
                            TibjmsxLinkTcp.this._state = 3;
                        }
                        TibjmsxLinkTcp.this._linkHandler.onEventDisconnected(iOException, true);
                    } else if (TibjmsxLinkTcp.this._state == 1) {
                        object = TibjmsxLinkTcp.this._sendLock;
                        synchronized (object) {
                            if (TibjmsxLinkTcp.this._state == 1 && TibjmsxLinkTcp.this._doReconnect(false)) {
                                continue;
                            }
                        }
                        TibjmsxLinkTcp.this._state = 3;
                        object = _shutdownLock;
                        synchronized (object) {
                            TibjmsxLinkTcp.this._readerStarted = false;
                            _shutdownLock.notifyAll();
                        }
                        TibjmsxLinkTcp.this._linkHandler.onEventDisconnected(iOException, false);
                    }
                    return;
                }
                catch (JMSException jMSException) {
                    Tibjmsx.print("TCPLink: aborting connection due to errors.");
                    Tibjmsx.print("TCPLink: last exception follows:");
                    jMSException.printStackTrace();
                    if (TibjmsxLinkTcp.this._state == 1) {
                        object = _shutdownLock;
                        synchronized (object) {
                            TibjmsxLinkTcp.this._readerStarted = false;
                            _shutdownLock.notifyAll();
                        }
                        TibjmsxLinkTcp.this.disconnect();
                        TibjmsxLinkTcp.this.notifySendersOnDisconnect();
                        TibjmsxLinkTcp.this._linkHandler.onEventDisconnected(jMSException, false);
                    }
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    if (TibjmsxLinkTcp.this._socket == null) {
                        return;
                    }
                    nullPointerException.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class Pinger
    implements Runnable {
        Thread _t = new Thread(this);

        Pinger() {
            try {
                this._t.setDaemon(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this._t.setName("TIBCO EMS Connections Pinger");
            this._t.start();
        }

        @Override
        public void run() {
            try {
                block4: while (true) {
                    Thread.sleep(_pingInterval);
                    Vector vector = (Vector)_links.clone();
                    int n = 0;
                    while (true) {
                        if (n >= vector.size()) continue block4;
                        TibjmsxLinkTcp tibjmsxLinkTcp = (TibjmsxLinkTcp)vector.elementAt(n);
                        DataOutputStream dataOutputStream = tibjmsxLinkTcp._output;
                        if (dataOutputStream == null || tibjmsxLinkTcp._state == 3) {
                            _links.remove(tibjmsxLinkTcp);
                        } else if (tibjmsxLinkTcp._localPinger != null) {
                            _links.remove(tibjmsxLinkTcp);
                        } else if (tibjmsxLinkTcp._needPing) {
                            TibjmsxStream tibjmsxStream = new TibjmsxStream(16);
                            tibjmsxStream.writeRvHeader(0, 8);
                            try {
                                dataOutputStream.write(tibjmsxStream.buffer, 0, 8);
                                dataOutputStream.flush();
                            }
                            catch (Exception exception) {
                                if (!tibjmsxLinkTcp._reconnecting && tibjmsxLinkTcp._state != 1) {
                                    _links.remove(tibjmsxLinkTcp);
                                }
                            }
                        } else {
                            tibjmsxLinkTcp._needPing = true;
                        }
                        ++n;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    class LocalPinger
    implements Runnable {
        Thread _t = new Thread(this);
        boolean _closed = false;

        LocalPinger() {
            try {
                this._t.setDaemon(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this._t.setName("TIBCO EMS Pinger for connection " + TibjmsxLinkTcp.this._linkId);
            this._t.start();
        }

        void stop() {
            this._closed = true;
            this._t.interrupt();
        }

        boolean sendPing() {
            TibjmsxStream tibjmsxStream = new TibjmsxStream(16);
            tibjmsxStream.writeRvHeader(0, 8);
            try {
                TibjmsxLinkTcp.this._output.write(tibjmsxStream.buffer, 0, 8);
                TibjmsxLinkTcp.this._output.flush();
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    do {
                        Thread.sleep(TibjmsxLinkTcp.this._localPingInterval);
                        if (!this._closed) continue;
                        return;
                    } while (this.sendPing());
                    return;
                }
                catch (InterruptedException interruptedException) {
                    if (!this._closed) continue;
                    Thread.currentThread().interrupt();
                    return;
                }
                break;
            }
        }
    }
}

