/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsSSL;
import com.tibco.tibjms.TibjmsSSLClientIdentity;
import com.tibco.tibjms.TibjmsSSLHostNameVerifier;
import com.tibco.tibjms.TibjmsSSLParams;
import com.tibco.tibjms.TibjmsxLink;
import com.tibco.tibjms.TibjmsxLinkTcp;
import com.tibco.tibjms.TibjmsxURL;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class TibjmsxLinkSSL
extends TibjmsxLinkTcp {
    TibjmsSSLHostNameVerifier _verifier = null;
    boolean _verifyHostName = true;
    Socket _originalSocket = null;
    DataInputStream _originalInput = null;
    DataOutputStream _originalOutput = null;
    Socket _sslSocket = null;
    DataInputStream _sslInput = null;
    DataOutputStream _sslOutput = null;
    boolean _auth_only = false;
    boolean _request_cancel_ssl = false;
    boolean _cancelled = false;
    boolean _sslInitDone = false;
    String _expected_hostname = null;
    List<String> _tryProtocols = null;
    String _sslProtocol = null;
    KeyStore _trustedCerts = null;
    TibjmsSSLClientIdentity _clientIdentity = null;
    TrustManagerFactory _tmf = null;
    TrustManager[] _serverVerifier = null;
    SSLContext _sslContext = null;
    SSLSocketFactory _sslSocketFactory = null;
    String[] _cipherSuites = null;
    PrintStream _ssl_tracer = null;
    PrintStream _ssl_debug_tracer = null;

    PrintStream _getTracer() {
        PrintStream printStream = this._ssl_tracer;
        if (printStream == null) {
            printStream = TibjmsSSL.getDefaultParameters().tracer;
        }
        return printStream;
    }

    PrintStream _getDebugTracer() {
        PrintStream printStream = this._ssl_debug_tracer;
        if (printStream == null) {
            printStream = TibjmsSSL.getDefaultParameters().debug_tracer;
        }
        return printStream;
    }

    void _setTracers() {
        if (this._ssl_tracer == null) {
            this._ssl_tracer = this._getTracer();
        }
        if (this._ssl_debug_tracer == null) {
            this._ssl_debug_tracer = this._getDebugTracer();
        }
    }

    TibjmsxLinkSSL(TibjmsxLink.LinkEventHandler linkEventHandler) throws JMSException {
        super(linkEventHandler);
    }

    void _initSSL() throws JMSException, JMSSecurityException {
        Map map;
        TibjmsSSLParams tibjmsSSLParams;
        block37: {
            tibjmsSSLParams = null;
            map = this._properties;
            if (this._sslInitDone) {
                return;
            }
            if (map != null && !TibjmsSSL._hasSSLParams(map)) {
                map = null;
            }
            if (map != null) {
                tibjmsSSLParams = new TibjmsSSLParams();
                TibjmsSSL.initFromEnvironment(map, tibjmsSSLParams);
                if (tibjmsSSLParams.password == null || tibjmsSSLParams.password.length == 0 || tibjmsSSLParams.password[0] == '\u0000') {
                    TibjmsSSLParams tibjmsSSLParams2 = TibjmsSSL.getDefaultParameters();
                    if (tibjmsSSLParams2.password != null && tibjmsSSLParams2.password.length > 0 && tibjmsSSLParams2.password[0] != '\u0000') {
                        tibjmsSSLParams.password = new char[tibjmsSSLParams2.password.length];
                        System.arraycopy(tibjmsSSLParams2.password, 0, tibjmsSSLParams.password, 0, tibjmsSSLParams2.password.length);
                    } else if (this._password != null) {
                        tibjmsSSLParams.password = this._password.toCharArray();
                    }
                }
            } else {
                tibjmsSSLParams = TibjmsSSL.getDefaultParameters();
            }
            this._ssl_tracer = tibjmsSSLParams.tracer;
            this._auth_only = tibjmsSSLParams.auth_only;
            boolean bl = tibjmsSSLParams.debug_trace;
            if (!bl) {
                bl = TibjmsSSL.getDefaultParameters().debug_trace;
            }
            TibjmsSSL._enableVendorTrace(bl);
            TibjmsSSL.initialize(tibjmsSSLParams, tibjmsSSLParams.vendor);
            this._setTracers();
            this._verifyHostName = tibjmsSSLParams.disable_verify_host ? false : !tibjmsSSLParams.disable_verify_hostname;
            this._expected_hostname = tibjmsSSLParams.expected_hostname;
            if (this._expected_hostname == null) {
                this._expected_hostname = this._linkURL.host;
            }
            if (this._serverVerifier == null) {
                if (tibjmsSSLParams.disable_verify_host) {
                    if (this._ssl_tracer != null) {
                        TibjmsSSL._sslTrace(this._ssl_tracer, "WARNING: server verification is disabled, will trust any server.", null);
                    }
                    this._serverVerifier = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                        }
                    }};
                } else {
                    if (this._ssl_debug_tracer != null) {
                        TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Get our trusted certs for server verification", null);
                    }
                    this._trustedCerts = TibjmsSSL._createTrustedCerts(tibjmsSSLParams);
                    if (this._ssl_debug_tracer != null) {
                        if (this._trustedCerts != null) {
                            try {
                                TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Have '" + this._trustedCerts.size() + "' trusted certs", null);
                            }
                            catch (KeyStoreException keyStoreException) {}
                        } else {
                            TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Have '0' trusted certs", null);
                        }
                    }
                    this._verifier = TibjmsSSL.getHostNameVerifier();
                }
            }
            if (this._clientIdentity == null) {
                if (this._ssl_debug_tracer != null) {
                    TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Create client identity from parameters", null);
                }
                this._clientIdentity = TibjmsSSL.createIdentity(tibjmsSSLParams);
            }
            if (this._tmf == null) {
                try {
                    if (this._ssl_debug_tracer != null) {
                        TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Get a default TrustManagerFactory instance", null);
                    }
                    this._tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    if (this._tmf == null) break block37;
                    try {
                        if (this._ssl_debug_tracer != null) {
                            if (this._trustedCerts == null) {
                                TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Initialize the default TrustManagerFactory with default system trusted certs", null);
                            } else {
                                TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Initialize the default TrustManagerFactory with our trusted certs", null);
                            }
                        }
                        this._tmf.init(this._trustedCerts);
                        if (this._ssl_debug_tracer != null) {
                            TibjmsSSL._sslTrace(this._ssl_debug_tracer, "TLS provider is: " + this._tmf.getProvider().toString(), null);
                        }
                    }
                    catch (KeyStoreException keyStoreException) {
                        JMSSecurityException jMSSecurityException = new JMSSecurityException("Unable to create TrustManagerFactory: " + keyStoreException.getMessage());
                        jMSSecurityException.setLinkedException(keyStoreException);
                        throw jMSSecurityException;
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    JMSSecurityException jMSSecurityException = new JMSSecurityException("Unable to create TrustManagerFactory: " + noSuchAlgorithmException.getMessage());
                    jMSSecurityException.setLinkedException(noSuchAlgorithmException);
                    throw jMSSecurityException;
                }
            }
        }
        this._tryProtocols = new ArrayList<String>();
        Collections.addAll(this._tryProtocols, TibjmsSSL._protocols);
        this._getSSLContext();
        if (this._sslProtocol == null) {
            JMSSecurityException jMSSecurityException = new JMSSecurityException("Can not initialize TLS client: no TLS protocol to use.");
            throw jMSSecurityException;
        }
        if (this._cipherSuites == null) {
            this._cipherSuites = TibjmsSSL._getCipherSuites(tibjmsSSLParams, this._sslSocketFactory);
        }
        if (this._ssl_debug_tracer != null && this._cipherSuites != null && this._cipherSuites.length > 0) {
            TibjmsSSL._sslTrace(this._ssl_debug_tracer, "User specified cipher(s):", null);
            for (int j = 0; j < this._cipherSuites.length; ++j) {
                TibjmsSSL._sslTrace(this._ssl_debug_tracer, "        " + this._cipherSuites[j], null);
            }
        }
        if (map != null) {
            TibjmsSSL._erasePass(tibjmsSSLParams.password);
        }
        this._sslInitDone = true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void _getSSLContext() throws JMSException {
        String[] stringArray;
        int n = this._tryProtocols.size();
        if (n > 0) {
            this._sslProtocol = this._tryProtocols.get(n - 1);
            this._tryProtocols.remove(this._sslProtocol);
            try {
                if (this._ssl_debug_tracer != null) {
                    TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Get SSLContext for protocol: " + this._sslProtocol, null);
                }
                this._sslContext = SSLContext.getInstance(this._sslProtocol);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                JMSException jMSException = new JMSException("Failed to create SSLContext: " + noSuchAlgorithmException.getMessage());
                jMSException.setLinkedException(noSuchAlgorithmException);
                throw jMSException;
            }
        } else {
            if (this._ssl_debug_tracer != null) {
                TibjmsSSL._sslTrace(this._ssl_debug_tracer, "No TLS protocols left to try", null);
            }
            this._sslProtocol = null;
            return;
        }
        try {
            void var2_6;
            Object var2_3 = null;
            if (this._clientIdentity != null && this._clientIdentity.kmf != null) {
                KeyManager[] keyManagerArray = this._clientIdentity.kmf.getKeyManagers();
                if (this._ssl_debug_tracer != null) {
                    TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Have " + keyManagerArray.length + " key managers from client's KeyManagerFactory", null);
                }
            } else {
                try {
                    stringArray = null;
                    if (this._clientIdentity != null) {
                        if (this._ssl_debug_tracer != null) {
                            TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Create a default KeyManagerFactory using the client identity", null);
                        }
                        stringArray = TibjmsSSL.createKMF(null, this._clientIdentity.identity);
                        this._clientIdentity.kmf = stringArray;
                    } else {
                        if (this._ssl_debug_tracer != null) {
                            TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Create a default KeyManagerFactory using no client identity", null);
                        }
                        stringArray = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        stringArray.init(null, null);
                    }
                    KeyManager[] keyManagerArray = stringArray.getKeyManagers();
                    if (this._ssl_debug_tracer != null) {
                        TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Default KeyManagerFactory has " + keyManagerArray.length + " KeyManagers", null);
                    }
                }
                catch (IllegalStateException | NullPointerException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException exception) {
                    JMSException jMSException = new JMSException("Failed to initialize empty KeyManagerFactory: " + exception.getMessage());
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
            }
            if (this._serverVerifier == null && this._tmf != null) {
                this._serverVerifier = this._tmf.getTrustManagers();
            }
            if (var2_6 == null && this._serverVerifier == null) {
                stringArray = new JMSException("Failed to initialize SSLContext, missing key manager or server verifier");
                throw stringArray;
            }
            if (this._ssl_debug_tracer != null) {
                TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Initialize the SSLcontext", null);
            }
            if (TibjmsSSL._pkcs11Provider != null) {
                try {
                    this._sslContext.init((KeyManager[])var2_6, this._serverVerifier, SecureRandom.getInstance("PKCS11", TibjmsSSL._pkcs11Provider));
                }
                catch (IllegalArgumentException | NoSuchAlgorithmException exception) {
                    JMSException jMSException = new JMSException("Failed to initialize SSLContext: " + exception.getMessage());
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
            } else {
                this._sslContext.init((KeyManager[])var2_6, this._serverVerifier, new SecureRandom());
            }
            if (this._ssl_debug_tracer != null) {
                TibjmsSSL._sslTrace(this._ssl_debug_tracer, "SSLcontext initialized", null);
            }
        }
        catch (KeyManagementException keyManagementException) {
            JMSException jMSException = new JMSException("Failed to initialize SSLContext: " + keyManagementException.getMessage());
            jMSException.setLinkedException(keyManagementException);
            throw jMSException;
        }
        if (this._sslContext == null) {
            JMSException jMSException = new JMSException("Failed to create SSLContext");
            throw jMSException;
        }
        this._sslSocketFactory = this._sslContext.getSocketFactory();
        if (this._sslSocketFactory == null) {
            JMSException jMSException = new JMSException("Failed to get SSL SocketFactory");
            throw jMSException;
        }
        if (this._ssl_debug_tracer != null) {
            int n2;
            String[] stringArray2 = this._sslSocketFactory.getSupportedCipherSuites();
            stringArray = this._sslSocketFactory.getDefaultCipherSuites();
            TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Socket supported ciphers:", null);
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                TibjmsSSL._sslTrace(this._ssl_debug_tracer, "        " + stringArray2[n2], null);
            }
            TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Socket default ciphers:", null);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                TibjmsSSL._sslTrace(this._ssl_debug_tracer, "        " + stringArray[n2], null);
            }
        }
    }

    public void setHostNameVerifier(String string) {
        this._expected_hostname = string;
    }

    @Override
    void connect(TibjmsxURL tibjmsxURL) throws JMSException, JMSSecurityException {
        Object var2_2 = null;
        SSLSocket sSLSocket = null;
        this._linkURL = tibjmsxURL;
        this._ssl_failed = false;
        this._request_cancel_ssl = false;
        this._initSSL();
        if (this._sslSocketFactory == null) {
            JMSException jMSException = new JMSException("Failed to create SSL SocketFactory");
            throw jMSException;
        }
        try {
            Object object;
            while (this._sslProtocol != null) {
                String[] stringArray;
                this._createSocket();
                if (this._ssl_debug_tracer != null) {
                    TibjmsSSL._sslTrace(this._ssl_debug_tracer, "initial normal socket: " + this._socket.toString(), null);
                }
                if ((sSLSocket = (SSLSocket)this._sslSocketFactory.createSocket(this._socket, this._socket.getInetAddress().getHostName(), this._socket.getPort(), true)) != null) {
                    stringArray = null;
                    stringArray = this._cipherSuites != null ? this._cipherSuites : sSLSocket.getEnabledCipherSuites();
                    if ((stringArray = TibjmsSSL._filterCipherSuites(stringArray, this._sslSocketFactory, this._ssl_debug_tracer)) == null || stringArray.length == 0) {
                        this._getSSLContext();
                        if (this._sslProtocol != null) continue;
                        object = new JMSException("No cipher suites available");
                        throw object;
                    }
                    sSLSocket.setEnabledCipherSuites(stringArray);
                    object = new String[]{this._sslProtocol};
                    sSLSocket.setEnabledProtocols((String[])object);
                    sSLSocket.setUseClientMode(true);
                    if (this._ssl_debug_tracer != null) {
                        TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Start SSL socket handshake", null);
                    }
                    try {
                        sSLSocket.startHandshake();
                        break;
                    }
                    catch (Exception exception) {
                        if (this._ssl_debug_tracer != null) {
                            TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Failed to connect with protocol: " + this._sslProtocol, null);
                        }
                        this._getSSLContext();
                        if (this._sslProtocol == null) {
                            throw exception;
                        }
                        if (this._ssl_debug_tracer == null) continue;
                        TibjmsSSL._sslTrace(this._ssl_debug_tracer, "Try next protocol", null);
                        continue;
                    }
                }
                stringArray = new JMSException("Failed to create SSL socket");
                throw stringArray;
            }
            if (this._ssl_debug_tracer != null) {
                TibjmsSSL._sslTrace(this._ssl_debug_tracer, "SSL socket handshake completed", null);
            }
            if (this._expected_hostname != null && this._verifyHostName) {
                boolean bl = false;
                object = new HV();
                bl = object.verify(this._expected_hostname, sSLSocket.getSession());
                if (!bl) {
                    this.disconnect();
                    this._ssl_failed = true;
                    JMSException jMSException = new JMSException("Failed to connect via TLS to [" + this._linkURL.url + "]");
                    throw jMSException;
                }
            }
            this._originalSocket = this._socket;
            this._originalInput = this._input;
            this._originalOutput = this._output;
            this._socket = sSLSocket;
            this._socket.setTcpNoDelay(true);
            this._socket.setSoLinger(false, 0);
            this._input = new DataInputStream(new BufferedInputStream(this._socket.getInputStream(), 32768));
            this._output = new DataOutputStream(this._socket.getOutputStream());
            this._state = 1;
            this._doHandshake(true);
        }
        catch (Exception exception) {
            this.disconnect();
            this._ssl_failed = true;
            String string = exception.getClass().getName();
            if (string.contains("JMSSecurityException")) {
                JMSSecurityException jMSSecurityException = new JMSSecurityException("Failed to connect via TLS to [" + this._linkURL.url + "]" + (exception.getMessage() != null ? ": " + exception.getMessage() : ""));
                jMSSecurityException.setLinkedException(exception);
                throw jMSSecurityException;
            }
            JMSException jMSException = new JMSException("Failed to connect via TLS to [" + this._linkURL.url + "]" + (exception.getMessage() != null ? ": " + exception.getMessage() : ""));
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    @Override
    void closeSocket() {
        if (this._sslSocket != null) {
            this._socket = this._sslSocket;
        }
        super.closeSocket();
    }

    void cancelSSL() {
        this._sslSocket = this._socket;
        this._sslInput = this._input;
        this._sslOutput = this._output;
        this._socket = this._originalSocket;
        this._input = this._originalInput;
        this._output = this._originalOutput;
        this._cancelled = true;
        this._request_cancel_ssl = false;
    }

    @Override
    void traceAfterSent() {
        PrintStream printStream = this._getTracer();
        if (printStream != null && this._socket != null) {
            try {
                String string = ((SSLSocket)this._socket).getSession().getCipherSuite();
                TibjmsSSL._sslTrace(printStream, "selected cipher: " + string, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._request_cancel_ssl) {
            this.cancelSSL();
            if (printStream != null) {
                TibjmsSSL._sslTrace(printStream, "TLS reset to TCP for connID=" + this._linkId + ", user='" + (this._userName != null ? this._userName : "???") + "'", null);
            }
            return;
        }
    }

    @Override
    void disconnect() {
        super.disconnect();
        this._sslInitDone = false;
    }

    class HV
    implements HostnameVerifier {
        HV() {
        }

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            String string2 = null;
            List<String> list = null;
            Certificate certificate = null;
            Certificate[] certificateArray = null;
            PrintStream printStream = TibjmsxLinkSSL.this._getTracer();
            if (!TibjmsxLinkSSL.this._verifyHostName) {
                if (printStream != null) {
                    TibjmsSSL._sslTrace(printStream, "Host Name Verification is disabled, accepting without verification", null);
                }
                return true;
            }
            if (sSLSession == null) {
                if (printStream != null) {
                    TibjmsSSL._sslTrace(printStream, "Host Name Verification cannot be performed without a valid session", null);
                }
                return false;
            }
            try {
                certificateArray = sSLSession.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                if (printStream != null) {
                    TibjmsSSL._sslTrace(printStream, "Unable to get server certificates, reason: " + sSLPeerUnverifiedException.getMessage(), null);
                }
                return false;
            }
            if (certificateArray != null && certificateArray.length != 0) {
                certificate = certificateArray[0];
            }
            if (certificate == null) {
                if (printStream != null) {
                    TibjmsSSL._sslTrace(printStream, "Unable to get server certificates, reason: No server side certificate.", null);
                }
                return false;
            }
            string2 = TibjmsSSL.getCertCN((X509Certificate)certificate);
            list = TibjmsSSL.getCertSAN((X509Certificate)certificate);
            if (printStream != null) {
                TibjmsSSL._sslTrace(printStream, "VerifyHostName: expected name: [" + string + "], certificate CN: [" + string2 + "], certificate SAN: [" + String.join((CharSequence)", ", list) + "]", null);
            }
            if (TibjmsxLinkSSL.this._verifier != null) {
                try {
                    TibjmsxLinkSSL.this._verifier.verifyHostName(TibjmsxLinkSSL.this._linkURL.host, string, string2, (X509Certificate)certificate);
                    return true;
                }
                catch (JMSSecurityException jMSSecurityException) {
                    if (printStream != null) {
                        TibjmsSSL._sslTrace(printStream, "host name verification by custom verifier has failed  with exception message: " + jMSSecurityException.getMessage(), null);
                    }
                    return false;
                }
            }
            if (string == null) {
                string = TibjmsxLinkSSL.this._linkURL.host;
            }
            if (!this.hostMatches(string, string2) && !this.SANIncludes(string, list)) {
                if (printStream != null) {
                    String string3 = string2;
                    if (list.size() > 0) {
                        string3 = string3 + ", " + String.join((CharSequence)", ", list);
                    }
                    String string4 = "Names in the certificate [" + string3 + "] do not match expected host name [" + string + "]";
                    TibjmsSSL._sslTrace(printStream, string4, null);
                }
                return false;
            }
            return true;
        }

        private boolean SANIncludes(String string, List<String> list) {
            if (list == null) {
                return false;
            }
            Iterator<String> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                if (!this.hostMatches(string, iterator2.next())) continue;
                return true;
            }
            return false;
        }

        private boolean hostMatches(String string, String string2) {
            if (string2 == null || string2.length() == 0) {
                return false;
            }
            if (string2.charAt(0) != '*') {
                return string.equalsIgnoreCase(string2);
            }
            if (string2.equals("*")) {
                return true;
            }
            if (!string2.startsWith("*.")) {
                return false;
            }
            int n = string.indexOf(46);
            if (n < 0) {
                return false;
            }
            string2 = string2.substring(1);
            string = string.substring(n);
            return string.equalsIgnoreCase(string2);
        }
    }
}

