/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsConnection;
import com.tibco.tibjms.TibjmsJMSContext;
import com.tibco.tibjms.TibjmsQueueConnection;
import com.tibco.tibjms.TibjmsSSL;
import com.tibco.tibjms.TibjmsTopicConnection;
import com.tibco.tibjms.TibjmsXAConnection;
import com.tibco.tibjms.TibjmsXAJMSContext;
import com.tibco.tibjms.TibjmsXAQueueConnection;
import com.tibco.tibjms.TibjmsXATopicConnection;
import com.tibco.tibjms.TibjmsXMLConst;
import com.tibco.tibjms.Tibjmsx;
import com.tibco.tibjms.TibjmsxBetaCheck;
import com.tibco.tibjms.TibjmsxTrace;
import com.tibco.tibjms.naming.TibjmsAdministeredObjectFactory;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class TibjmsxCFImpl
implements TibjmsXMLConst,
Externalizable,
Cloneable {
    private static final int externalUID = 2;
    private static volatile boolean betaCheckInit = false;
    private static volatile long betaExpire = 0L;
    public String _url = null;
    public HashMap<String, Object> _properties = null;
    public String _clientID = null;
    public boolean _wasCreatedByUfo = false;
    boolean _isAdmin = false;
    transient String _currentUrl = null;
    transient Object _lock = new Object();
    transient String[] _urlStrings = null;
    transient String _proxyHost = null;
    transient int _proxyPort = 0;
    transient String _proxyUsername = null;
    transient String _proxyPassword = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String _getCurrentUrl() {
        Object object = this._lock;
        synchronized (object) {
            if (this._currentUrl != null) {
                return this._currentUrl;
            }
            return this._url;
        }
    }

    protected int _getProtocol() {
        if (this._url == null) {
            return 1;
        }
        if (this._url.startsWith("tcp://")) {
            return 1;
        }
        if (this._url.startsWith("tcp2://")) {
            return 12;
        }
        if (this._url.startsWith("ssl://")) {
            return 2;
        }
        if (this._url.startsWith("http://")) {
            return 3;
        }
        if (this._url.startsWith("https://")) {
            return 4;
        }
        if (this._url.startsWith("tibjmsnaming:")) {
            return 10;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TibjmsConnection _createImpl(String string, String string2, String string3, boolean bl) throws JMSException {
        TibjmsConnection tibjmsConnection = null;
        if (!betaCheckInit) {
            try {
                betaExpire = TibjmsxBetaCheck.expireTimeMillis();
            }
            finally {
                betaCheckInit = true;
            }
        }
        if (betaExpire > 0L && System.currentTimeMillis() > betaExpire) {
            throw new JMSException(TibjmsxBetaCheck.betaExpireString());
        }
        if (this instanceof XATopicConnectionFactory) {
            tibjmsConnection = bl ? new TibjmsXATopicConnection(this, string, this._clientID, string2, string3, this._properties) : new TibjmsTopicConnection(this, string, this._clientID, string2, string3, this._properties);
        } else if (this instanceof XAQueueConnectionFactory) {
            tibjmsConnection = bl ? new TibjmsXAQueueConnection(this, string, this._clientID, string2, string3, this._properties) : new TibjmsQueueConnection(this, string, this._clientID, string2, string3, this._properties);
        } else if (this instanceof XAConnectionFactory) {
            tibjmsConnection = new TibjmsXAConnection(this, string, this._clientID, string2, string3, this._properties);
        } else if (this instanceof TopicConnectionFactory) {
            tibjmsConnection = new TibjmsTopicConnection(this, string, this._clientID, string2, string3, this._properties);
        } else if (this instanceof QueueConnectionFactory) {
            tibjmsConnection = new TibjmsQueueConnection(this, string, this._clientID, string2, string3, this._properties);
        } else if (this instanceof ConnectionFactory) {
            tibjmsConnection = new TibjmsConnection(this, string, this._clientID, string2, string3, this._properties);
        } else {
            throw new InternalError("Invalid factory");
        }
        return tibjmsConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TibjmsConnection _createConnection(String string, String string2, boolean bl) throws JMSException {
        TibjmsConnection tibjmsConnection = null;
        Object object = this._lock;
        synchronized (object) {
            if (this._urlStrings == null) {
                if (this._isLoadBalanced()) {
                    this._urlStrings = TibjmsxCFImpl.parseUrls(this._url);
                } else {
                    this._urlStrings = new String[1];
                    this._urlStrings[0] = this._url == null ? "tcp://localhost:7222" : this._url;
                }
            }
        }
        for (int j = 0; j < this._urlStrings.length; ++j) {
            TibjmsConnection tibjmsConnection2;
            block16: {
                String string3 = this._urlStrings[j];
                tibjmsConnection2 = null;
                try {
                    tibjmsConnection2 = this._createImpl(string3, string, string2, bl);
                }
                catch (JMSException jMSException) {
                    if (this._urlStrings.length != 1 && (j + 1 != this._urlStrings.length || tibjmsConnection != null)) break block16;
                    throw jMSException;
                }
            }
            if (tibjmsConnection2 == null) continue;
            Object object2 = this._lock;
            synchronized (object2) {
                if (tibjmsConnection2.getUrlCount() > 1) {
                    this._urlStrings[j] = tibjmsConnection2.getUrls();
                    this._currentUrl = this._urlStrings[j];
                }
            }
            if (this._isBetter(tibjmsConnection2, tibjmsConnection)) {
                if (tibjmsConnection != null) {
                    tibjmsConnection.close();
                }
                tibjmsConnection = tibjmsConnection2;
                continue;
            }
            tibjmsConnection2.close();
        }
        if (tibjmsConnection._traceTarget != 0 && this._proxyHost != null) {
            TibjmsxTrace.write(tibjmsConnection._traceTarget, "{0} Connection conn={1,number,###0.##} is using TLS proxy host={2} port={3,number,###0.##} username={4}", new Object[]{this.toString(), new Long(tibjmsConnection._connid), this._proxyHost, new Long(this._proxyPort), this._proxyUsername != null ? this._proxyUsername : "null"});
        }
        return tibjmsConnection;
    }

    void _processAdmin() {
        if (this._url.startsWith("<$admin>:")) {
            this._isAdmin = true;
            this._url = this._url.substring("<$admin>:".length());
            if (this._url == null || this._url.length() == 0) {
                this._url = "tcp://localhost:7222";
            }
        }
    }

    private boolean _isLoadBalanced() {
        return this._url != null && this._url.indexOf(124) != -1;
    }

    private boolean _isBetter(TibjmsConnection tibjmsConnection, TibjmsConnection tibjmsConnection2) {
        if (tibjmsConnection2 == null) {
            return true;
        }
        if (tibjmsConnection._server_version_major < 4) {
            Random random = new Random(System.currentTimeMillis() / (tibjmsConnection._connid == 0L ? 1L : tibjmsConnection._connid));
            int n = random.nextInt(100);
            return n % 2 == 0;
        }
        switch (this.getMetric()) {
            case 1: {
                return tibjmsConnection._metric_connections < tibjmsConnection2._metric_connections;
            }
            case 2: {
                return tibjmsConnection._metric_byte_rate < tibjmsConnection2._metric_byte_rate;
            }
        }
        return false;
    }

    TibjmsJMSContext _createJMSContext(String string, String string2, int n) {
        return new TibjmsJMSContext(this, string, string2, n);
    }

    TibjmsXAJMSContext _createJMSXAContext(String string, String string2) {
        return new TibjmsXAJMSContext(this, string, string2);
    }

    public TibjmsxCFImpl() {
        this._url = "tcp://localhost:7222";
        this._processAdmin();
    }

    private static String[] parseUrls(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        if (string.indexOf(124) == -1) {
            vector.add(string);
        } else {
            while (n < string.length()) {
                int n2 = string.indexOf(124, n);
                String string2 = n2 == -1 ? string.substring(n) : string.substring(n, n2);
                vector.add(string2);
                if (n2 == -1) break;
                n = n2 + 1;
            }
        }
        String[] stringArray = new String[vector.size()];
        for (int j = 0; j < vector.size(); ++j) {
            stringArray[j] = (String)vector.elementAt(j);
        }
        return stringArray;
    }

    public TibjmsxCFImpl(String string, String string2, Map map) {
        this._url = string;
        this._clientID = string2;
        if (map != null) {
            this._properties = new HashMap();
            this._properties.putAll(map);
        }
        if (this._url == null) {
            this._url = "tcp://localhost:7222";
        }
        this._processAdmin();
    }

    public Object clone() throws CloneNotSupportedException {
        TibjmsxCFImpl tibjmsxCFImpl = (TibjmsxCFImpl)super.clone();
        return tibjmsxCFImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUrl() {
        Object object = this._lock;
        synchronized (object) {
            return this._url;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentUrl() {
        Object object = this._lock;
        synchronized (object) {
            if (this._currentUrl != null) {
                return this._currentUrl;
            }
            return this._url;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientID() {
        Object object = this._lock;
        synchronized (object) {
            return this._clientID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMetric() {
        Object object = this._lock;
        synchronized (object) {
            Object object2;
            if (!this._isLoadBalanced()) {
                return 0;
            }
            int n = 1;
            if (this._properties != null && (object2 = this._properties.get("com.tibco.tibjms.factory.metric")) != null && object2 instanceof Integer) {
                n = (Integer)object2;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getProperties() {
        Object object = this._lock;
        synchronized (object) {
            if (this._properties != null) {
                return (Map)this._properties.clone();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _addProperty(String string, Object object) throws IllegalArgumentException {
        Object object2 = this._lock;
        synchronized (object2) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("null or empty name");
            }
            if (this._properties == null) {
                this._properties = new HashMap();
            }
            this._properties.put(string, object);
        }
    }

    public Reference getReference() throws NamingException {
        Object object;
        Reference reference = new Reference(this.getClass().getName(), new StringRefAddr("address", this._url), TibjmsAdministeredObjectFactory.class.getName(), null);
        StringRefAddr stringRefAddr = new StringRefAddr("clientID", this._clientID);
        reference.add(stringRefAddr);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = new ObjectOutputStream(byteArrayOutputStream);
            ((ObjectOutputStream)object).writeObject(this._properties);
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException("Unable to serialize properties object");
            namingException.setRootCause(iOException);
            throw namingException;
        }
        object = new BinaryRefAddr("properties", byteArrayOutputStream.toByteArray());
        reference.add((RefAddr)object);
        return reference;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(new Integer(2));
        objectOutput.writeObject(this._url);
        objectOutput.writeObject(this._clientID);
        if (this._properties != null) {
            objectOutput.writeObject(new Byte(1));
            objectOutput.writeObject(this._properties);
        } else {
            objectOutput.writeObject(new Byte(0));
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Byte by;
        Integer n = (Integer)objectInput.readObject();
        int n2 = n;
        if (n2 != 1 && n2 != 2) {
            throw new IOException("Corrupted input buffer");
        }
        this._url = (String)objectInput.readObject();
        this._clientID = (String)objectInput.readObject();
        if (n2 > 1 && (by = (Byte)objectInput.readObject()) != 0) {
            this._properties = (HashMap)objectInput.readObject();
        }
    }

    public String toString() {
        String string = "";
        try {
            string = this instanceof XATopicConnectionFactory ? string + "XATopicConnectionFactory" : (this instanceof XAQueueConnectionFactory ? string + "XAQueueConnectionFactory" : (this instanceof XAConnectionFactory ? string + "XAConnectionFactory" : (this instanceof TopicConnectionFactory ? string + "TopicConnectionFactory" : (this instanceof QueueConnectionFactory ? string + "QueueConnectionFactory" : string + "ConnectionFactory"))));
            string = string + "[URL=" + this._url + ";clientID=" + this._clientID;
            if (this._properties != null) {
                string = string + ";Properties=" + this._properties;
            }
            string = string + "]";
        }
        catch (Exception exception) {
            return "";
        }
        return string;
    }

    public String buildXML() throws IOException, InternalError, JMSException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("administered-object");
            document.appendChild(element);
            Element element2 = this._confactNode(document);
            element.appendChild(element2);
            element = element2;
            if (this._properties != null) {
                this._genParamsNode(document, element);
                this._secParamsNode(document, element);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("doctype-system", "http://www.tibco.com/dtd/administered-object.dtd");
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            return stringWriter.toString();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(parserConfigurationException);
            parserConfigurationException.printStackTrace();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.err.println(transformerConfigurationException);
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            System.err.println(transformerException);
            transformerException.printStackTrace();
        }
        return null;
    }

    private void _authNode(Document document, Element element) throws JMSSecurityException, IOException {
        Element element2 = document.createElement("authorities");
        this._authNodeEx(document, element2, "issuer");
        this._authNodeEx(document, element2, "trusted");
        element.appendChild(element2);
    }

    private void _authNodeEx(Document document, Element element, String string) throws IOException, JMSSecurityException {
        String string2 = "";
        if (string.equalsIgnoreCase("trusted")) {
            string2 = "com.tibco.tibjms.ssl.trusted_certs";
        } else if (string.equalsIgnoreCase("issuer")) {
            string2 = "com.tibco.tibjms.ssl.issuer_certs";
        } else {
            return;
        }
        Object object = this._properties.get(string2);
        if (object == null) {
            return;
        }
        Element element2 = document.createElement(string);
        boolean bl = false;
        if (object instanceof String) {
            Element element3 = document.createElement("certificate");
            element3.setAttribute("encoding", String.valueOf(0));
            element3.setAttribute("base64-data", new String("file://" + (String)object));
            element2.appendChild(element3);
        } else if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = 0;
            while (n < vector.size()) {
                int n2 = 0;
                String string3 = null;
                Object e = vector.elementAt(n);
                ++n;
                if (e == null) {
                    bl = true;
                    break;
                }
                if (e instanceof String) {
                    n2 = TibjmsSSL.encodingNameToInt((String)e);
                }
                if (e instanceof Number || n2 != 0) {
                    if (n > vector.size() - 1) {
                        bl = true;
                        break;
                    }
                    if (n2 == 0) {
                        n2 = ((Number)e).intValue();
                    }
                }
                Object e2 = vector.elementAt(n);
                ++n;
                if (e2 instanceof String) {
                    string3 = new String("file://" + (String)e2);
                } else if (e2 instanceof byte[]) {
                    string3 = Tibjmsx.base64Encode((byte[])e2, true);
                }
                Element element4 = document.createElement("certificate");
                element4.setAttribute("encoding", String.valueOf(n2));
                element4.setAttribute("base64-data", string3);
                element2.appendChild(element4);
            }
        } else {
            bl = true;
        }
        if (bl) {
            throw new JMSSecurityException("Invalid content of '" + string2 + "'");
        }
        element.appendChild(element2);
    }

    private void _secParamsNode(Document document, Element element) throws IOException {
        Element element2 = document.createElement("security-parameters");
        this._sslParamsNode(document, element2);
        Object object = this._properties.get("com.tibco.tibjms.ssl.identity");
        if (object != null) {
            String string = null;
            Element element3 = document.createElement("certificates");
            Element element4 = null;
            Element element5 = document.createElement("client-identity");
            try {
                element4 = document.createElement("certificate");
                Integer n = TibjmsSSL._getEnvEncoding(this._properties, "com.tibco.tibjms.ssl.identity_encoding");
                if (n != null) {
                    element4.setAttribute("encoding", String.valueOf(n));
                } else {
                    element4.setAttribute("encoding", "0");
                }
                if (object instanceof String) {
                    string = new String("file://" + (String)object);
                } else if (object instanceof byte[]) {
                    string = Tibjmsx.base64Encode((byte[])object, true);
                } else {
                    throw new JMSSecurityException("Invalid certificate data");
                }
                element4.setAttribute("base64-data", string);
                element5.appendChild(element4);
                this._pkeyNode(document, element5);
                Object object2 = this._properties.get("com.tibco.tibjms.ssl.password");
                if (object2 != null) {
                    if (!(object2 instanceof String)) {
                        throw new JMSSecurityException("Invalid value of 'com.tibco.tibjms.ssl.password': must be a String");
                    }
                    element5.setAttribute("password", (String)object2);
                }
                element3.appendChild(element5);
                this._authNode(document, element3);
                element2.appendChild(element3);
            }
            catch (JMSException jMSException) {
                System.err.println(jMSException);
                jMSException.printStackTrace();
            }
        }
        element.appendChild(element2);
    }

    private void _sslParamsNode(Document document, Element element) {
        Element element2 = null;
        Object object = this._properties.get("com.tibco.tibjms.ssl.vendor");
        if (object != null && object instanceof String) {
            if (element2 == null) {
                element2 = document.createElement("SSL-parameters");
            }
            element2.setAttribute("vendor", (String)object);
        }
        if ((object = this._properties.get("com.tibco.tibjms.ssl.cipher_suites")) != null && object instanceof String) {
            if (element2 == null) {
                element2 = document.createElement("SSL-parameters");
            }
            element2.setAttribute("ciphers", (String)object);
        }
        if ((object = this._properties.get("com.tibco.tibjms.ssl.trace")) != null && object instanceof Boolean) {
            if (element2 == null) {
                element2 = document.createElement("SSL-parameters");
            }
            if (((Boolean)object).booleanValue()) {
                element2.setAttribute("trace", "enabled");
            } else {
                element2.setAttribute("trace", "disabled");
            }
        }
        if ((object = this._properties.get("com.tibco.tibjms.ssl.debug_trace")) != null && object instanceof Boolean) {
            if (element2 == null) {
                element2 = document.createElement("SSL-parameters");
            }
            if (((Boolean)object).booleanValue()) {
                element2.setAttribute("debug-trace", "enabled");
            } else {
                element2.setAttribute("debug-trace", "disabled");
            }
        }
        if ((object = this._properties.get("com.tibco.tibjms.ssl.enable_verify_host")) != null && object instanceof Boolean) {
            if (element2 == null) {
                element2 = document.createElement("SSL-parameters");
            }
            if (((Boolean)object).booleanValue()) {
                element2.setAttribute("verify-host", "enabled");
            } else {
                element2.setAttribute("verify-host", "disabled");
            }
        }
        if ((object = this._properties.get("com.tibco.tibjms.ssl.enable_verify_hostname")) != null && object instanceof Boolean) {
            if (element2 == null) {
                element2 = document.createElement("SSL-parameters");
            }
            if (((Boolean)object).booleanValue()) {
                element2.setAttribute("verify-hostname", "enabled");
            } else {
                element2.setAttribute("verify-hostname", "disabled");
            }
        }
        if ((object = this._properties.get("com.tibco.tibjms.ssl.expected_hostname")) != null && object instanceof String) {
            if (element2 == null) {
                element2 = document.createElement("SSL-parameters");
            }
            element2.setAttribute("expected-hostname", (String)object);
        }
        if (element2 != null) {
            element.appendChild(element2);
        }
    }

    private void _pkeyNode(Document document, Element element) throws JMSException, JMSSecurityException, IOException {
        String string = null;
        Object object = this._properties.get("com.tibco.tibjms.ssl.private_key");
        if (object != null) {
            Element element2 = document.createElement("private-key");
            Integer n = TibjmsSSL._getEnvEncoding(this._properties, "com.tibco.tibjms.ssl.private_key_encoding");
            if (n != null) {
                element2.setAttribute("encoding", n.toString());
            } else {
                element2.setAttribute("encoding", "0");
            }
            if (object instanceof String) {
                string = new String("file://" + (String)object);
            } else if (object instanceof byte[]) {
                string = Tibjmsx.base64Encode((byte[])object, true);
            } else {
                throw new JMSSecurityException("Invalid private key data");
            }
            element2.setAttribute("base64-data", string);
            element.appendChild(element2);
        }
    }

    private void _genParamsNode(Document document, Element element) {
        Element element2;
        Element element3 = null;
        Object object = this._properties.get("com.tibco.tibjms.factory.metric");
        if (object != null && object instanceof Integer) {
            if (element3 == null) {
                element3 = document.createElement("general-parameters");
            }
            element2 = document.createElement("parameter");
            element2.setAttribute("name", "load-balance-metric");
            element2.setAttribute("value", ((Integer)object).toString());
            element3.appendChild(element2);
        }
        if ((object = this._properties.get("com.tibco.tibjms.connect.attemptcount")) != null && object instanceof Integer) {
            if (element3 == null) {
                element3 = document.createElement("general-parameters");
            }
            element2 = document.createElement("parameter");
            element2.setAttribute("name", "connect-attempt-count");
            element2.setAttribute("value", ((Integer)object).toString());
            element3.appendChild(element2);
        }
        if ((object = this._properties.get("com.tibco.tibjms.connect.attemptdelay")) != null && object instanceof Integer) {
            if (element3 == null) {
                element3 = document.createElement("general-parameters");
            }
            element2 = document.createElement("parameter");
            element2.setAttribute("name", "connect-attempt-delay");
            element2.setAttribute("value", ((Integer)object).toString());
            element3.appendChild(element2);
        }
        if ((object = this._properties.get("com.tibco.tibjms.connect.attempttimeout")) != null && object instanceof Integer) {
            if (element3 == null) {
                element3 = document.createElement("general-parameters");
            }
            element2 = document.createElement("parameter");
            element2.setAttribute("name", "connect-attempt-timeout");
            element2.setAttribute("value", ((Integer)object).toString());
            element3.appendChild(element2);
        }
        if ((object = this._properties.get("com.tibco.tibjms.reconnect.attemptcount")) != null && object instanceof Integer) {
            if (element3 == null) {
                element3 = document.createElement("general-parameters");
            }
            element2 = document.createElement("parameter");
            element2.setAttribute("name", "reconnect-attempt-count");
            element2.setAttribute("value", ((Integer)object).toString());
            element3.appendChild(element2);
        }
        if ((object = this._properties.get("com.tibco.tibjms.reconnect.attemptdelay")) != null && object instanceof Integer) {
            if (element3 == null) {
                element3 = document.createElement("general-parameters");
            }
            element2 = document.createElement("parameter");
            element2.setAttribute("name", "reconnect-attempt-delay");
            element2.setAttribute("value", ((Integer)object).toString());
            element3.appendChild(element2);
        }
        if ((object = this._properties.get("com.tibco.tibjms.reconnect.attempttimeout")) != null && object instanceof Integer) {
            if (element3 == null) {
                element3 = document.createElement("general-parameters");
            }
            element2 = document.createElement("parameter");
            element2.setAttribute("name", "reconnect-attempt-timeout");
            element2.setAttribute("value", ((Integer)object).toString());
            element3.appendChild(element2);
        }
        if ((object = this._properties.get("com.tibco.tibjms.multicast.enabled")) != null && object instanceof Boolean) {
            if (element3 == null) {
                element3 = document.createElement("general-parameters");
            }
            element2 = document.createElement("parameter");
            element2.setAttribute("name", "multicast");
            if (((Boolean)object).booleanValue()) {
                element2.setAttribute("value", "enabled");
            } else {
                element2.setAttribute("value", "disabled");
            }
            element3.appendChild(element2);
        }
        if ((object = this._properties.get("com.tibco.tibjms.multicast.daemon")) != null && object instanceof String) {
            if (element3 == null) {
                element3 = document.createElement("general-parameters");
            }
            element2 = document.createElement("parameter");
            element2.setAttribute("name", "multicast-daemon");
            element2.setAttribute("value", (String)object);
            element3.appendChild(element2);
        }
        if ((object = this._properties.get("com.tibco.tibjms.ssl.auth_only")) != null && object instanceof Boolean) {
            if (element3 == null) {
                element3 = document.createElement("general-parameters");
            }
            element2 = document.createElement("parameter");
            element2.setAttribute("name", "auth-only");
            if (((Boolean)object).booleanValue()) {
                element2.setAttribute("value", "enabled");
            } else {
                element2.setAttribute("value", "disabled");
            }
            element3.appendChild(element2);
        }
        if (element3 != null) {
            element.appendChild(element3);
        }
    }

    private Element _confactNode(Document document) throws InternalError, JMSException {
        Element element = document.createElement("connection-factory");
        if (this._url == null) {
            throw new JMSException("URL name must not be NULL.");
        }
        element.setAttribute("URL", this._url);
        if (this._clientID != null) {
            element.setAttribute("client-ID", this._clientID);
        }
        if (this instanceof XATopicConnectionFactory || this instanceof TopicConnectionFactory) {
            element.setAttribute("destination-type", "topic");
        } else if (this instanceof XAQueueConnectionFactory || this instanceof QueueConnectionFactory) {
            element.setAttribute("destination-type", "queue");
        } else if (this instanceof ConnectionFactory || this instanceof XAConnectionFactory) {
            element.setAttribute("destination-type", "generic");
        } else {
            throw new InternalError("Invalid factory");
        }
        if (this instanceof XATopicConnectionFactory || this instanceof XAQueueConnectionFactory || this instanceof XAConnectionFactory) {
            element.setAttribute("XA", "enabled");
        } else {
            element.setAttribute("XA", "disabled");
        }
        return element;
    }
}

