/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsSSLCI;
import com.tibco.tibjms.TibjmsSSLCipherInfo;
import com.tibco.tibjms.TibjmsSSLClientIdentity;
import com.tibco.tibjms.TibjmsSSLHostNameVerifier;
import com.tibco.tibjms.TibjmsSSLParams;
import com.tibco.tibjms.TibjmsSSLPlatform;
import com.tibco.tibjms.Tibjmsx;
import com.tibco.tibjms.TibjmsxLinkSSL;
import com.tibco.tibjms.TibjmsxTrace;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.x500.X500Principal;

public class TibjmsSSL {
    public static final int TLS_RSA_WITH_AES_128_CBC_SHA256 = 60;
    public static final int TLS_RSA_WITH_AES_256_CBC_SHA256 = 61;
    public static final int TLS_DHE_RSA_WITH_AES_128_CBC_SHA256 = 103;
    public static final int TLS_DHE_RSA_WITH_AES_256_CBC_SHA256 = 107;
    public static final int TLS_RSA_WITH_AES_128_GCM_SHA256 = 156;
    public static final int TLS_RSA_WITH_AES_256_GCM_SHA384 = 157;
    public static final int TLS_DHE_RSA_WITH_AES_128_GCM_SHA256 = 158;
    public static final int TLS_DHE_RSA_WITH_AES_256_GCM_SHA384 = 159;
    public static final int TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 = 49187;
    public static final int TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384 = 49188;
    public static final int TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256 = 49191;
    public static final int TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384 = 49192;
    public static final int TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = 49195;
    public static final int TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = 49196;
    public static final int TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = 49199;
    public static final int TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = 49200;
    public static final int TLS_PSK_WITH_AES_128_GCM_SHA256 = 168;
    public static final int TLS_PSK_WITH_AES_256_GCM_SHA384 = 169;
    public static final int TLS_DHE_PSK_WITH_AES_128_GCM_SHA256 = 170;
    public static final int TLS_DHE_PSK_WITH_AES_256_GCM_SHA384 = 171;
    public static final int TLS_RSA_PSK_WITH_AES_128_GCM_SHA256 = 172;
    public static final int TLS_RSA_PSK_WITH_AES_256_GCM_SHA384 = 173;
    public static final int TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = 52392;
    public static final int TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256 = 52393;
    public static final int TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = 52394;
    public static final int TLS_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52395;
    public static final int TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52396;
    public static final int TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52397;
    public static final int TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52398;
    public static final int TLS_AES_128_GCM_SHA256 = 4865;
    public static final int TLS_AES_256_GCM_SHA384 = 4866;
    public static final int TLS_CHACHA20_POLY1305_SHA256 = 4867;
    public static final int TLS_AES_128_CCM_SHA256 = 4868;
    public static final int TLS_AES_128_CCM_8_SHA256 = 4869;
    public static final int SSL_RSA_WITH_RC4_128_MD5 = 4;
    public static final int SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = 6;
    public static final int SSL_RSA_EXPORT_WITH_RC4_40_MD5 = 3;
    public static final int SSL_RSA_EXPORT_WITH_DES_40_CBC_SHA = 7;
    public static final int SSL_DHE_RSA_EXPORT_WITH_DES_40_CBC_SHA = 210;
    public static final int SSL_DHE_DSS_EXPORT_WITH_DES_40_CBC_SHA = 100;
    public static final int SSL_RSA_WITH_NULL_MD5 = 1;
    public static final int SSL_RSA_WITH_NULL_SHA = 2;
    public static final int SSL_RSA_WITH_DES_CBC_SHA = 8;
    public static final int SSL_DHE_DSS_WITH_DES_CBC_SHA = 101;
    public static final int SSL_DHE_RSA_WITH_DES_CBC_SHA = 211;
    public static final int SSL_RSA_WITH_RC4_128_SHA = 5;
    public static final int SSL_RSA_WITH_3DES_EDE_CBC_SHA = 9;
    public static final int SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 102;
    public static final int SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 212;
    public static final int TLS_RSA_WITH_AES_128_CBC_SHA = 20;
    public static final int TLS_RSA_WITH_AES_256_CBC_SHA = 21;
    public static final int TLS_DHE_DSS_WITH_AES_128_CBC_SHA = 120;
    public static final int TLS_DHE_DSS_WITH_AES_256_CBC_SHA = 121;
    public static final int TLS_DHE_RSA_WITH_AES_128_CBC_SHA = 220;
    public static final int TLS_DHE_RSA_WITH_AES_256_CBC_SHA = 221;
    public static final int TLS_DHE_DSS_WITH_AES_128_CBC_SHA256 = 64;
    public static final int TLS_DHE_DSS_WITH_AES_256_CBC_SHA256 = 106;
    public static final int TLS_DHE_DSS_WITH_AES_128_GCM_SHA256 = 162;
    public static final int TLS_DHE_DSS_WITH_AES_256_GCM_SHA384 = 163;
    public static final int TLS_ECDHE_ECDSA_WITH_RC4_128_SHA = 49159;
    public static final int TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA = 49160;
    public static final int TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = 49161;
    public static final int TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = 49162;
    public static final int TLS_ECDHE_RSA_WITH_RC4_128_SHA = 49169;
    public static final int TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA = 49170;
    public static final int TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA = 49171;
    public static final int TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA = 49172;
    static TibjmsSSLCipherInfo[] _ciphersList = new TibjmsSSLCipherInfo[]{new TibjmsSSLCipherInfo("150", "TLS_RSA_WITH_AES_128_CBC_SHA256", "SSL_RSA_WITH_AES_128_CBC_SHA256", 60, "AES128-SHA256", "TLSv1.2 Kx=RSA Au=RSA Enc=AES(128) Mac=SHA256"), new TibjmsSSLCipherInfo("151", "TLS_RSA_WITH_AES_256_CBC_SHA256", "SSL_RSA_WITH_AES_256_CBC_SHA256", 61, "AES256-SHA256", "TLSv1.2 Kx=RSA Au=RSA Enc=AES(256) Mac=SHA256"), new TibjmsSSLCipherInfo("160", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA256", 103, "DHE-RSA-AES128-SHA256", "TLSv1.2 Kx=DH Au=RSA Enc=AES(128) Mac=SHA256"), new TibjmsSSLCipherInfo("162", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "SSL_DHE_RSA_WITH_AES_256_CBC_SHA256", 107, "DHE-RSA-AES256-SHA256", "TLSv1.2 Kx=DH Au=RSA Enc=AES(256) Mac=SHA256"), new TibjmsSSLCipherInfo("170", "TLS_RSA_WITH_AES_128_GCM_SHA256", "SSL_RSA_WITH_AES_128_GCM_SHA256", 156, "AES128-GCM-SHA256", "TLSv1.2 Kx=RSA Au=RSA Enc=AESGCM(128) Mac=AEAD"), new TibjmsSSLCipherInfo("171", "TLS_RSA_WITH_AES_256_GCM_SHA384", "SSL_RSA_WITH_AES_256_GCM_SHA384", 157, "AES256-GCM-SHA384", "TLSv1.2 Kx=RSA Au=RSA Enc=AESGCM(256) Mac=AEAD"), new TibjmsSSLCipherInfo("172", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "SSL_DHE_RSA_WITH_AES_128_GCM_SHA256", 158, "DHE-RSA-AES128-GCM-SHA256", "TLSv1.2 Kx=DH Au=RSA Enc=AESGCM(128) Mac=AEAD"), new TibjmsSSLCipherInfo("173", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "SSL_DHE_RSA_WITH_AES_256_GCM_SHA384", 159, "DHE-RSA-AES256-GCM-SHA384", "TLSv1.2 Kx=DH Au=RSA Enc=AESGCM(256) Mac=AEAD"), new TibjmsSSLCipherInfo("333", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", 49187, "ECDHE-ECDSA-AES128-SHA256", "TLSv1.2 Kx=ECDH Au=ECDSA Enc=AES(128) Mac=SHA256"), new TibjmsSSLCipherInfo("334", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", 49188, "ECDHE-ECDSA-AES256-SHA384", "TLSv1.2 Kx=ECDH Au=ECDSA Enc=AES(256) Mac=SHA384"), new TibjmsSSLCipherInfo("337", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA256", 49191, "ECDHE-RSA-AES128-SHA256", "TLSv1.2 Kx=ECDH Au=RSA Enc=AES(128) Mac=SHA256"), new TibjmsSSLCipherInfo("338", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA384", 49192, "ECDHE-RSA-AES256-SHA384", "TLSv1.2 Kx=ECDH Au=RSA Enc=AES(256) Mac=SHA384"), new TibjmsSSLCipherInfo("341", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "SSL_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", 49195, "ECDHE-ECDSA-AES128-GCM-SHA256", "TLSv1.2 Kx=ECDH Au=ECDSA Enc=AESGCM(128) Mac=AEAD"), new TibjmsSSLCipherInfo("342", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "SSL_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", 49196, "ECDHE-ECDSA-AES256-GCM-SHA384", "TLSv1.2 Kx=ECDH Au=ECDSA Enc=AESGCM(256) Mac=AEAD"), new TibjmsSSLCipherInfo("345", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "SSL_ECDHE_RSA_WITH_AES_128_GCM_SHA256", 49199, "ECDHE-RSA-AES128-GCM-SHA256", "TLSv1.2 Kx=ECDH Au=RSA Enc=AESGCM(128) Mac=AEAD"), new TibjmsSSLCipherInfo("346", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "SSL_ECDHE_RSA_WITH_AES_256_GCM_SHA384", 49200, "ECDHE-RSA-AES256-GCM-SHA384", "TLSv1.2 Kx=ECDH Au=RSA Enc=AESGCM(256) Mac=AEAD"), new TibjmsSSLCipherInfo("347", "TLS_PSK_WITH_AES_128_GCM_SHA256", "SSL_PSK_WITH_AES_128_GCM_SHA256", 168, "PSK-AES128-GCM-SHA256", "TLSv1.2 Kx=PSK Au=PSK Enc=AESGCM(128) Mac=AEAD"), new TibjmsSSLCipherInfo("348", "TLS_PSK_WITH_AES_256_GCM_SHA384", "SSL_PSK_WITH_AES_256_GCM_SHA384", 169, "PSK-AES256-GCM-SHA384", "TLSv1.2 Kx=PSK Au=PSK Enc=AESGCM(256) Mac=AEAD"), new TibjmsSSLCipherInfo("349", "TLS_DHE_PSK_WITH_AES_128_GCM_SHA256", "SSL_DHE_PSK_WITH_AES_128_GCM_SHA256", 170, "DHE-PSK-AES128-GCM-SHA256", "TLSv1.2 Kx=DHEPSK Au=PSK Enc=AESGCM(128) Mac=AEAD"), new TibjmsSSLCipherInfo("350", "TLS_DHE_PSK_WITH_AES_256_GCM_SHA384", "SSL_DHE_PSK_WITH_AES_256_GCM_SHA384", 171, "DHE-PSK-AES256-GCM-SHA384", "TLSv1.2 Kx=DHEPSK Au=PSK Enc=AESGCM(256) Mac=AEAD"), new TibjmsSSLCipherInfo("351", "TLS_RSA_PSK_WITH_AES_128_GCM_SHA256", "SSL_RSA_PSK_WITH_AES_128_GCM_SHA256", 172, "RSA-PSK-AES128-GCM-SHA256", "TLSv1.2 Kx=RSAPSK Au=RSA Enc=AESGCM(128) Mac=AEAD"), new TibjmsSSLCipherInfo("352", "TLS_RSA_PSK_WITH_AES_256_GCM_SHA384", "SSL_RSA_PSK_WITH_AES_256_GCM_SHA384", 173, "RSA-PSK-AES256-GCM-SHA384", "TLSv1.2 Kx=RSAPSK Au=RSA Enc=AESGCM(256) Mac=AEAD"), new TibjmsSSLCipherInfo("353", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "SSL_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", 52392, "ECDHE-RSA-CHACHA20-POLY1305", "TLSv1.2 Kx=ECDH Au=RSA Enc=CHACHA20/POLY1305(256) Mac=AEAD"), new TibjmsSSLCipherInfo("354", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "SSL_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", 52393, "ECDHE-ECDSA-CHACHA20-POLY1305", "TLSv1.2 Kx=ECDH Au=ECDSA Enc=CHACHA20/POLY1305(256) Mac=AEAD"), new TibjmsSSLCipherInfo("355", "TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "SSL_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256", 52394, "DHE-RSA-CHACHA20-POLY1305", "TLSv1.2 Kx=DH Au=RSA Enc=CHACHA20/POLY1305(256) Mac=AEAD"), new TibjmsSSLCipherInfo("356", "TLS_PSK_WITH_CHACHA20_POLY1305_SHA256", "SSL_PSK_WITH_CHACHA20_POLY1305_SHA256", 52395, "PSK-CHACHA20-POLY1305", "TLSv1.2 Kx=PSK Au=PSK Enc=CHACHA20/POLY1305(256) Mac=AEAD"), new TibjmsSSLCipherInfo("357", "TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256", "SSL_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256", 52396, "ECDHE-PSK-CHACHA20-POLY1305", "TLSv1.2 Kx=ECDHEPSK Au=PSK Enc=CHACHA20/POLY1305(256) Mac=AEAD"), new TibjmsSSLCipherInfo("358", "TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256", "SSL_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256", 52397, "DHE-PSK-CHACHA20-POLY1305", "TLSv1.2 Kx=DHEPSK Au=PSK Enc=CHACHA20/POLY1305(256) Mac=AEAD"), new TibjmsSSLCipherInfo("359", "TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256", "SSL_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256", 52398, "RSA-PSK-CHACHA20-POLY1305", "TLSv1.2 Kx=RSAPSK Au=RSA Enc=CHACHA20/POLY1305(256) Mac=AEAD"), new TibjmsSSLCipherInfo("360", "TLS_AES_128_GCM_SHA256", "SSL_AES_128_GCM_SHA256", 4865, "TLS_AES_128_GCM_SHA256", "TLSv1.3 Enc=AESGCM(128) Mac=SHA256"), new TibjmsSSLCipherInfo("361", "TLS_AES_256_GCM_SHA384", "SSL_AES_256_GCM_SHA384", 4866, "TLS_AES_256_GCM_SHA384", "TLSv1.3 Enc=AESGCM(256) Mac=SHA384"), new TibjmsSSLCipherInfo("362", "TLS_CHACHA20_POLY1305_SHA256", "SSL_CHACHA20_POLY1305_SHA256", 4867, "TLS_CHACHA20_POLY1305_SHA256", "TLSv1.3 Enc=CHACHA20/POLY1305 Mac=SHA256"), new TibjmsSSLCipherInfo("363", "TLS_AES_128_CCM_SHA256", "SSL_AES_128_CCM_SHA256", 4868, "TLS_AES_128_CCM_SHA256", "TLSv1.3 Enc=AESCCM(128) Mac=SHA256"), new TibjmsSSLCipherInfo("364", "TLS_AES_128_CCM_8_SHA256", "SSL_AES_128_CCM_8_SHA256", 4869, "TLS_AES_128_CCM_8_SHA256", "TLSv1.3 Enc=AESCCM8(128) Mac=SHA256")};
    static Hashtable _ciphersHash = null;
    public static final String J2SE_DEFAULT = "j2se-default";
    public static final String J2SE_PROVIDER = "j2se";
    public static final String IBM_PROVIDER = "ibm";
    private static final String PKCS11 = "com.tibco.tibjms.ssl.PKCS11";
    private static final String PKCS11CONFIG = "com.tibco.tibjms.ssl.PKCS11Config";
    private static final String OLD_FIPS = "com.tibco.security.FIPS";
    private static int trustedCertAliasInc = 0;
    public static String[] _vendors = new String[]{"j2se", "j2se-default"};
    static String[] _protocols = new String[]{"TLSv1.2", "TLSv1.3"};
    static Provider _pkcs11Provider = null;
    @Deprecated
    public static final boolean client_enableSSLv3 = Boolean.getBoolean("com.tibco.security.ssl.client.EnableSSLv3");
    static final int _COP_NONE = 0;
    static final int _COP_REMOVE = 1;
    static final int _COP_ADD = 2;
    static final int _COP_MOVE_END = 3;
    static final int _COP_MOVE_FRONT = 4;
    static final char _COP_REMOVE_CHAR = '-';
    static final char _COP_ADD_CHAR = '+';
    public static final String VENDOR = "com.tibco.tibjms.ssl.vendor";
    public static final String TRACE = "com.tibco.tibjms.ssl.trace";
    public static final String AUTH_ONLY = "com.tibco.tibjms.ssl.auth_only";
    public static final String DEBUG_TRACE = "com.tibco.tibjms.ssl.debug_trace";
    public static final String TRUSTED_CERTIFICATES = "com.tibco.tibjms.ssl.trusted_certs";
    public static final String ENABLE_VERIFY_HOST = "com.tibco.tibjms.ssl.enable_verify_host";
    public static final String ENABLE_VERIFY_HOST_NAME = "com.tibco.tibjms.ssl.enable_verify_hostname";
    public static final String EXPECTED_HOST_NAME = "com.tibco.tibjms.ssl.expected_hostname";
    public static final String HOST_NAME_VERIFIER = "com.tibco.tibjms.ssl.hostname_verifier";
    public static final String IDENTITY = "com.tibco.tibjms.ssl.identity";
    public static final String IDENTITY_ENCODING = "com.tibco.tibjms.ssl.identity_encoding";
    public static final String ISSUER_CERTIFICATES = "com.tibco.tibjms.ssl.issuer_certs";
    public static final String PRIVATE_KEY = "com.tibco.tibjms.ssl.private_key";
    public static final String PRIVATE_KEY_ENCODING = "com.tibco.tibjms.ssl.private_key_encoding";
    public static final String PASSWORD = "com.tibco.tibjms.ssl.password";
    public static final String CIPHER_SUITES = "com.tibco.tibjms.ssl.cipher_suites";
    public static final String CIPHERS = "com.tibco.tibjms.ssl.ciphers";
    public static final int ENCODING_AUTO = 0;
    public static final int ENCODING_PEM = 1;
    public static final int ENCODING_DER = 2;
    static final int ENCODING_BER = 4;
    public static final int ENCODING_PKCS7 = 16;
    public static final int ENCODING_PKCS8 = 32;
    public static final int ENCODING_PKCS12 = 64;
    public static final int ENCODING_KEYSTORE = 512;
    private static String _DEFAULT_SSL_VENDOR = "j2se-default";
    private static boolean _sslInitialized = false;
    private static Object _sslLock = new Object();
    static TibjmsSSLParams _default = new TibjmsSSLParams();
    private static SecureRandom secureRandom = null;
    private static final String _noinit = "Security is not initialized";
    private static final String _NAMING_SSL_PREFIX = "com.tibco.tibjms.naming.ssl_";
    private static final String _TIBJMS_SSL_PREFIX = "com.tibco.tibjms.ssl.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void _initCiphers() {
        Object object = _sslLock;
        synchronized (object) {
            if (_ciphersHash != null) {
                return;
            }
            _ciphersHash = new Hashtable();
            for (int j = 0; j < _ciphersList.length; ++j) {
                TibjmsSSLCipherInfo tibjmsSSLCipherInfo = _ciphersList[j];
                _ciphersHash.put(tibjmsSSLCipherInfo.tibjmsName, tibjmsSSLCipherInfo);
                _ciphersHash.put(tibjmsSSLCipherInfo.javaName, tibjmsSSLCipherInfo);
                _ciphersHash.put(tibjmsSSLCipherInfo.javaAltName, tibjmsSSLCipherInfo);
                _ciphersHash.put(tibjmsSSLCipherInfo.opensslName, tibjmsSSLCipherInfo);
                _ciphersHash.put(tibjmsSSLCipherInfo.javaID, tibjmsSSLCipherInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TibjmsSSLCipherInfo _getCipher(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Object object = _sslLock;
        synchronized (object) {
            TibjmsSSL._initCiphers();
            return (TibjmsSSLCipherInfo)_ciphersHash.get(string);
        }
    }

    static String[] _ciphersFromSpec(TibjmsSSLParams tibjmsSSLParams, SSLSocketFactory sSLSocketFactory) throws JMSSecurityException {
        Object object;
        int n;
        if (tibjmsSSLParams.cipher_specs == null) {
            return null;
        }
        PrintStream printStream = TibjmsSSL._getTracer(tibjmsSSLParams);
        PrintStream printStream2 = TibjmsSSL._getDebugTracer(tibjmsSSLParams);
        Vector<String> vector = new Vector<String>();
        String[] stringArray = sSLSocketFactory.getSupportedCipherSuites();
        for (n = 0; n < stringArray.length; ++n) {
            vector.addElement(new String(stringArray[n]));
        }
        int n2 = -1;
        StringTokenizer stringTokenizer = new StringTokenizer(tibjmsSSLParams.cipher_specs, ":,");
        while (stringTokenizer.hasMoreTokens()) {
            int n3;
            TibjmsSSLCipherInfo tibjmsSSLCipherInfo;
            object = stringTokenizer.nextToken();
            if (((String)object).length() < 2) continue;
            n = 0;
            if (((String)object).charAt(0) == '-') {
                n = 1;
            }
            if (((String)object).charAt(0) == '+') {
                n = 2;
            }
            if (((String)object).charAt(0) == '>') {
                n = 3;
            }
            if (((String)object).charAt(0) == '<') {
                n = 4;
            }
            if (n != 0) {
                object = ((String)object).substring(1);
            } else if (n2 == -1) {
                n2 = 0;
            }
            if (printStream2 != null) {
                switch (n) {
                    case 0: {
                        TibjmsSSL._sslTrace(printStream2, "Cipher operation = NONE", null);
                        break;
                    }
                    case 1: {
                        TibjmsSSL._sslTrace(printStream2, "Cipher operation = REMOVE", null);
                        break;
                    }
                    case 2: {
                        TibjmsSSL._sslTrace(printStream2, "Cipher operation = ADD", null);
                        break;
                    }
                    case 3: {
                        TibjmsSSL._sslTrace(printStream2, "Cipher operation = MOVE_END", null);
                        break;
                    }
                    case 4: {
                        TibjmsSSL._sslTrace(printStream2, "Cipher operation = MOVE_FRONT", null);
                        break;
                    }
                    default: {
                        TibjmsSSL._sslTrace(printStream2, "Cipher operation = unknown(" + n + ")", null);
                    }
                }
            }
            if (((String)object).equalsIgnoreCase("all")) {
                if (n != 1) continue;
                if (printStream2 != null) {
                    TibjmsSSL._sslTrace(printStream2, "Remove all ciphers", null);
                }
                vector.removeAllElements();
                continue;
            }
            if (n2 == 0) {
                if (printStream2 != null) {
                    TibjmsSSL._sslTrace(printStream2, "Replace all ciphers", null);
                }
                vector.removeAllElements();
            }
            if (n2 == 0) {
                n2 = 1;
            }
            if ((tibjmsSSLCipherInfo = TibjmsSSL._getCipher((String)object)) == null) {
                if (printStream == null) continue;
                TibjmsSSL._sslTrace(printStream, "WARNING: Ignoring invalid cipher suite name: " + (String)object, null);
                continue;
            }
            if (printStream2 != null) {
                TibjmsSSL._sslTrace(printStream2, "Specified cipher: '" + (String)object + "', cipher java name: '" + tibjmsSSLCipherInfo.javaName + "'", null);
            }
            boolean bl = false;
            for (n3 = 0; n3 < vector.size(); ++n3) {
                String string = (String)vector.elementAt(n3);
                if (!string.equalsIgnoreCase(tibjmsSSLCipherInfo.javaName) && !string.equalsIgnoreCase(tibjmsSSLCipherInfo.javaAltName)) continue;
                bl = true;
                if (n == 1) {
                    if (printStream2 != null) {
                        TibjmsSSL._sslTrace(printStream2, "Found cipher at index " + n3 + ", remove it", null);
                    }
                    vector.removeElementAt(n3);
                    break;
                }
                if (n == 3) {
                    if (printStream2 != null) {
                        TibjmsSSL._sslTrace(printStream2, "Found cipher at index " + n3 + ", move it to the end", null);
                    }
                    vector.removeElementAt(n3);
                    vector.addElement(string);
                    break;
                }
                if (n == 4) {
                    if (printStream2 != null) {
                        TibjmsSSL._sslTrace(printStream2, "Found cipher at index " + n3 + ", move it to the front", null);
                    }
                    vector.removeElementAt(n3);
                    vector.insertElementAt(string, 0);
                    break;
                }
                if (printStream2 == null) break;
                TibjmsSSL._sslTrace(printStream2, "Found cipher at index " + n3 + ", do nothing", null);
                break;
            }
            if (bl) continue;
            n3 = 0;
            if (tibjmsSSLCipherInfo.javaAltName != null && !tibjmsSSLCipherInfo.javaAltName.equals("") && ((String)object).equalsIgnoreCase(tibjmsSSLCipherInfo.javaAltName)) {
                n3 = 1;
            }
            if (n == 2 || n == 0) {
                if (printStream2 != null) {
                    TibjmsSSL._sslTrace(printStream2, "Cipher not found, add it to the end", null);
                }
                if (n3 == 0) {
                    vector.addElement(new String(tibjmsSSLCipherInfo.javaName));
                    continue;
                }
                vector.addElement(new String(tibjmsSSLCipherInfo.javaAltName));
                continue;
            }
            if (n == 3) {
                if (printStream2 != null) {
                    TibjmsSSL._sslTrace(printStream2, "Cipher not found, add it to the end", null);
                }
                if (n3 == 0) {
                    vector.addElement(new String(tibjmsSSLCipherInfo.javaName));
                    continue;
                }
                vector.addElement(new String(tibjmsSSLCipherInfo.javaAltName));
                continue;
            }
            if (n == 4) {
                if (printStream2 != null) {
                    TibjmsSSL._sslTrace(printStream2, "Cipher not found, add it to the front", null);
                }
                if (n3 == 0) {
                    vector.insertElementAt(new String(tibjmsSSLCipherInfo.javaName), 0);
                    continue;
                }
                vector.insertElementAt(new String(tibjmsSSLCipherInfo.javaAltName), 0);
                continue;
            }
            if (printStream2 == null) continue;
            TibjmsSSL._sslTrace(printStream2, "Cipher not found, do nothing", null);
        }
        if (vector.size() == 0) {
            throw new JMSSecurityException("Unable to proceed: all ciphers have been removed by user preference");
        }
        object = new String[vector.size()];
        for (int j = 0; j < vector.size(); ++j) {
            String string;
            object[j] = string = (String)vector.elementAt(j);
        }
        if (printStream2 != null) {
            TibjmsSSL._sslTrace(printStream2, "Final cipher list: " + Arrays.toString((Object[])object), null);
        }
        return object;
    }

    static String[] _ciphersFromSuites(TibjmsSSLParams tibjmsSSLParams) throws JMSSecurityException {
        String string = null;
        String[] stringArray = null;
        if (tibjmsSSLParams.cipher_suites == null || tibjmsSSLParams.cipher_suites.length == 0) {
            return null;
        }
        PrintStream printStream = TibjmsSSL._getTracer(tibjmsSSLParams);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int n : tibjmsSSLParams.cipher_suites) {
            try {
                string = TibjmsSSL.getCipherSuiteName(n);
                if (string != null) {
                    arrayList.add(string);
                    continue;
                }
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
            if (printStream == null) continue;
            TibjmsSSL._sslTrace(printStream, "WARNING: Ignoring invalid cipher suite number: " + n, null);
        }
        stringArray = new String[arrayList.size()];
        for (int j = 0; j < arrayList.size(); ++j) {
            stringArray[j] = (String)arrayList.get(j);
        }
        return stringArray;
    }

    static boolean _hasSSLParams(Map map) {
        if (map == null) {
            return false;
        }
        for (Object k : map.keySet()) {
            String string;
            if (k == null || !(k instanceof String) || !(string = (String)k).startsWith(_NAMING_SSL_PREFIX) && !string.startsWith(_TIBJMS_SSL_PREFIX)) continue;
            return true;
        }
        return false;
    }

    private static PrintStream _tracerValue(Map map, String string, PrintStream printStream) throws JMSSecurityException {
        Object object = TibjmsSSL._getDual(map, string);
        if (object != null) {
            if (object instanceof PrintStream) {
                return (PrintStream)object;
            }
            if (object instanceof String) {
                String string2 = (String)object;
                if (string2.equalsIgnoreCase("out")) {
                    return System.out;
                }
                if (string2.equalsIgnoreCase("err")) {
                    return System.err;
                }
                Boolean bl = new Boolean(string2);
                if (bl.booleanValue()) {
                    return System.err;
                }
                return printStream;
            }
            if (!(object instanceof Boolean)) {
                throw new JMSSecurityException("Invalid value of " + string);
            }
            if (((Boolean)object).booleanValue()) {
                return System.err;
            }
        }
        return printStream;
    }

    static Object _getDual(Map map, String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Object v = map.get(string);
        if (v == null && (string = string.startsWith(_NAMING_SSL_PREFIX) ? _TIBJMS_SSL_PREFIX + string.substring(_NAMING_SSL_PREFIX.length()) : (string.startsWith(_TIBJMS_SSL_PREFIX) ? _NAMING_SSL_PREFIX + string.substring(_TIBJMS_SSL_PREFIX.length()) : null)) != null) {
            v = map.get(string);
        }
        return v;
    }

    private static boolean _getEnvBool(Map map, String string, boolean bl) throws JMSException {
        boolean bl2 = bl;
        Object object = TibjmsSSL._getDual(map, string);
        if (object != null) {
            if (object instanceof String) {
                return new Boolean((String)object);
            }
            if (!(object instanceof Boolean)) {
                throw new JMSException("Invalid value of '" + string + "': must be Boolean value or String representing a Boolean");
            }
            bl2 = (Boolean)object;
        }
        return bl2;
    }

    private static String _getEnvString(Map map, String string, String string2) throws JMSException {
        String string3 = string2;
        Object object = TibjmsSSL._getDual(map, string);
        if (object != null) {
            if (!(object instanceof String)) {
                throw new JMSException("Invalid value of '" + string + "': must be String value");
            }
            string3 = (String)object;
        }
        return string3;
    }

    static Integer _getEnvEncoding(Map map, String string) throws JMSException {
        Object object = TibjmsSSL._getDual(map, string);
        if (object != null) {
            if (object instanceof String) {
                try {
                    int n = TibjmsSSL.encodingNameToInt((String)object);
                    if (n != 0) {
                        return new Integer(n);
                    }
                    return new Integer((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JMSException("Invalid value of '" + string + "': must be Number value or String representing a number or encoding");
                }
            }
            if (!(object instanceof Number)) {
                throw new JMSException("Invalid value of '" + string + "': must be Number value or String representing a number or encoding");
            }
            return new Integer(((Number)object).intValue());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initFromEnvironment(Map map, TibjmsSSLParams tibjmsSSLParams) throws JMSException {
        if (map == null) {
            throw new IllegalArgumentException("null parameter");
        }
        Object object = _sslLock;
        synchronized (object) {
            Object object2;
            char[] cArray;
            int n;
            Object object3;
            tibjmsSSLParams.vendor = TibjmsSSL._getEnvString(map, VENDOR, tibjmsSSLParams.vendor);
            tibjmsSSLParams.tracer = TibjmsSSL._tracerValue(map, TRACE, tibjmsSSLParams.tracer);
            tibjmsSSLParams.debug_trace = TibjmsSSL._getEnvBool(map, DEBUG_TRACE, tibjmsSSLParams.debug_trace);
            tibjmsSSLParams.expected_hostname = TibjmsSSL._getEnvString(map, EXPECTED_HOST_NAME, tibjmsSSLParams.expected_hostname);
            tibjmsSSLParams.disable_verify_host = !TibjmsSSL._getEnvBool(map, ENABLE_VERIFY_HOST, !tibjmsSSLParams.disable_verify_host);
            tibjmsSSLParams.disable_verify_hostname = !TibjmsSSL._getEnvBool(map, ENABLE_VERIFY_HOST_NAME, !tibjmsSSLParams.disable_verify_hostname);
            tibjmsSSLParams.auth_only = TibjmsSSL._getEnvBool(map, AUTH_ONLY, tibjmsSSLParams.auth_only);
            Object object4 = TibjmsSSL._getDual(map, HOST_NAME_VERIFIER);
            if (object4 != null) {
                if (!(object4 instanceof TibjmsSSLHostNameVerifier)) {
                    throw new JMSSecurityException("Invalid value of 'com.tibco.tibjms.ssl.hostname_verifier': must be instance of class " + TibjmsSSLHostNameVerifier.class.getName());
                }
                tibjmsSSLParams.verifier = (TibjmsSSLHostNameVerifier)object4;
            }
            if ((object4 = TibjmsSSL._getDual(map, CIPHER_SUITES)) != null) {
                if (object4 instanceof String) {
                    object3 = (String)object4;
                    if (((String)object3).length() > 0) {
                        TibjmsSSL._setCipherSuites(tibjmsSSLParams, (String)object4);
                    }
                } else {
                    if (!(object4 instanceof int[])) {
                        throw new JMSSecurityException("Invalid value of 'com.tibco.tibjms.ssl.cipher_suites': must be a String or int[]");
                    }
                    object3 = (int[])object4;
                    if (((Object)object3).length > 0) {
                        int[] nArray = new int[((Object)object3).length];
                        System.arraycopy(object3, 0, nArray, 0, ((Object)object3).length);
                        TibjmsSSL._setCipherSuites(tibjmsSSLParams, nArray);
                        tibjmsSSLParams.cipher_suites = nArray;
                    }
                }
            }
            if ((object4 = TibjmsSSL._getDual(map, TRUSTED_CERTIFICATES)) != null) {
                if (object4 instanceof String) {
                    TibjmsSSL._addTrustedCertsToParams(tibjmsSSLParams, (String)object4, 0);
                } else {
                    if (!(object4 instanceof Vector)) {
                        throw new JMSSecurityException("Invalid value of 'com.tibco.tibjms.ssl.trusted_certs': must be Vector");
                    }
                    object3 = (Vector)object4;
                    int n2 = 0;
                    while (n2 < ((Vector)object3).size()) {
                        n = 0;
                        cArray = (char[])((Vector)object3).elementAt(n2);
                        ++n2;
                        if (cArray == null) {
                            throw new JMSSecurityException("Invalid content of 'com.tibco.tibjms.ssl.trusted_certs'");
                        }
                        if (cArray instanceof String) {
                            n = TibjmsSSL.encodingNameToInt((String)cArray);
                        }
                        if (cArray instanceof Number || n != 0) {
                            if (n2 > ((Vector)object3).size() - 1) {
                                throw new JMSSecurityException("Invalid content of 'com.tibco.tibjms.ssl.trusted_certs'");
                            }
                            object2 = ((Vector)object3).elementAt(n2);
                            if (n == 0) {
                                n = ((Number)cArray).intValue();
                            }
                            ++n2;
                            TibjmsSSL._addTrustedCertsToParams(tibjmsSSLParams, object2, n);
                            continue;
                        }
                        TibjmsSSL._addTrustedCertsToParams(tibjmsSSLParams, cArray, 0);
                    }
                }
            }
            if ((object4 = TibjmsSSL._getDual(map, ISSUER_CERTIFICATES)) != null) {
                if (object4 instanceof String) {
                    TibjmsSSL._addIssuerCerts(tibjmsSSLParams, (String)object4, 0);
                } else {
                    if (!(object4 instanceof Vector)) {
                        throw new JMSSecurityException("Invalid value of 'com.tibco.tibjms.ssl.issuer_certs': must be Vector");
                    }
                    object3 = (Vector)object4;
                    int n3 = 0;
                    while (n3 < ((Vector)object3).size()) {
                        n = 0;
                        cArray = (char[])((Vector)object3).elementAt(n3);
                        ++n3;
                        if (cArray == null) {
                            throw new JMSSecurityException("Invalid content of 'com.tibco.tibjms.ssl.issuer_certs'");
                        }
                        if (cArray instanceof String) {
                            n = TibjmsSSL.encodingNameToInt((String)cArray);
                        }
                        if (cArray instanceof Number || n != 0) {
                            if (n3 > ((Vector)object3).size() - 1) {
                                throw new JMSSecurityException("Invalid content of 'com.tibco.tibjms.ssl.issuer_certs'");
                            }
                            object2 = ((Vector)object3).elementAt(n3);
                            if (n == 0) {
                                n = ((Number)cArray).intValue();
                            }
                            ++n3;
                            TibjmsSSL._addIssuerCerts(tibjmsSSLParams, object2, n);
                            continue;
                        }
                        TibjmsSSL._addIssuerCerts(tibjmsSSLParams, cArray, 0);
                    }
                }
            }
            if ((object3 = TibjmsSSL._getDual(map, IDENTITY)) != null) {
                int n4 = 0;
                n = 0;
                cArray = null;
                object2 = null;
                Object object5 = null;
                Integer n5 = TibjmsSSL._getEnvEncoding(map, IDENTITY_ENCODING);
                if (n5 != null) {
                    n4 = n5;
                }
                if ((object2 = TibjmsSSL._getDual(map, PRIVATE_KEY)) != null && (n5 = TibjmsSSL._getEnvEncoding(map, PRIVATE_KEY_ENCODING)) != null) {
                    n = n5;
                }
                if ((object5 = TibjmsSSL._getDual(map, PASSWORD)) != null) {
                    if (!(object5 instanceof String) && !(object5 instanceof char[])) {
                        throw new JMSSecurityException("Invalid value of 'com.tibco.tibjms.ssl.password': must be a String or char[]");
                    }
                    cArray = object5 instanceof String ? ((String)object5).toCharArray() : (char[])object5;
                }
                if (object2 != null) {
                    TibjmsSSL._setIdentity(tibjmsSSLParams, object3, n4, object2, n, cArray);
                } else {
                    TibjmsSSL._setIdentity(tibjmsSSLParams, object3, n4, null, 0, cArray);
                }
            }
        }
    }

    static void _enableVendorTrace(boolean bl) {
        if (bl) {
            try {
                if (System.getProperty("javax.net.debug") == null) {
                    System.setProperty("javax.net.debug", "ssl:handshake:trustmanager");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVendor() {
        Object object = _sslLock;
        synchronized (object) {
            return TibjmsSSL._default.vendor != null ? TibjmsSSL._default.vendor : _DEFAULT_SSL_VENDOR;
        }
    }

    public static void setVendor(String string) throws JMSSecurityException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty String");
        }
        Object object = _sslLock;
        synchronized (object) {
            String string2 = TibjmsSSL._default.vendor;
            if (string2 != null) {
                if (string.equalsIgnoreCase(string2)) {
                    return;
                }
                return;
            }
            for (int j = 0; j < _vendors.length; ++j) {
                if (!string.equalsIgnoreCase(_vendors[j])) continue;
                TibjmsSSL._default.vendor = string;
                return;
            }
            throw new JMSSecurityException("Security vendor '" + string + "' not supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() throws JMSSecurityException {
        Object object = _sslLock;
        synchronized (object) {
            TibjmsSSL.initialize(null);
        }
    }

    public static void initialize(String string) throws JMSSecurityException {
        TibjmsSSL.initialize(_default, string);
    }

    private static void put_if(Hashtable hashtable, String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            hashtable.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void initialize(TibjmsSSLParams tibjmsSSLParams, String string) throws JMSSecurityException {
        try {
            if (TibjmsSSL._default.tracer == null && Tibjmsx.sslTrace) {
                TibjmsSSL._default.tracer = System.out;
            }
            if (TibjmsSSL._default.debug_tracer == null && Tibjmsx.sslDebugTrace) {
                TibjmsSSL._default.debug_tracer = System.out;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        PrintStream printStream = TibjmsSSL._getTracer(tibjmsSSLParams);
        PrintStream printStream2 = TibjmsSSL._getDebugTracer(tibjmsSSLParams);
        Object object = _sslLock;
        synchronized (object) {
            String string2;
            block48: {
                Object object2;
                block47: {
                    if (printStream2 != null) {
                        TibjmsSSL._sslTrace(printStream2, "TibjmsSSL.initialize() entry: params = " + Integer.toHexString(System.identityHashCode(tibjmsSSLParams)) + ", _default = " + Integer.toHexString(System.identityHashCode(_default)), null);
                        if (tibjmsSSLParams != _default) {
                            TibjmsSSL._sslTrace(printStream2, " params   contains: " + tibjmsSSLParams.toString(), null);
                        }
                        TibjmsSSL._sslTrace(printStream2, " _default contains: " + _default.toString(), null);
                    }
                    if (_sslInitialized) {
                        if (tibjmsSSLParams == _default) {
                            if (printStream2 == null) return;
                            TibjmsSSL._sslTrace(printStream2, "TLS default object already initialized, so return", null);
                            return;
                        }
                        if (printStream2 != null) {
                            TibjmsSSL._sslTrace(printStream2, "Start partial TLS reinitialization", null);
                        }
                    } else if (printStream2 != null) {
                        TibjmsSSL._sslTrace(printStream2, "Start TLS initialization", null);
                    }
                    Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                    TibjmsSSL.put_if(hashtable, VENDOR, Tibjmsx.ssl_vendor);
                    TibjmsSSL.put_if(hashtable, TRACE, Tibjmsx.ssl_trace);
                    TibjmsSSL.put_if(hashtable, DEBUG_TRACE, Tibjmsx.ssl_debug_trace);
                    TibjmsSSL.put_if(hashtable, ENABLE_VERIFY_HOST, Tibjmsx.ssl_verify_host);
                    TibjmsSSL.put_if(hashtable, ENABLE_VERIFY_HOST_NAME, Tibjmsx.ssl_verify_hostname);
                    TibjmsSSL.put_if(hashtable, EXPECTED_HOST_NAME, Tibjmsx.ssl_expected_hostname);
                    TibjmsSSL.put_if(hashtable, AUTH_ONLY, Tibjmsx.ssl_auth_only);
                    TibjmsSSL.put_if(hashtable, IDENTITY, Tibjmsx.ssl_identity);
                    TibjmsSSL.put_if(hashtable, PRIVATE_KEY, Tibjmsx.ssl_private_key);
                    TibjmsSSL.put_if(hashtable, PASSWORD, Tibjmsx.ssl_password);
                    TibjmsSSL.put_if(hashtable, CIPHER_SUITES, Tibjmsx.ssl_ciphers);
                    if (Tibjmsx.ssl_trusted != null) {
                        object2 = new Vector<String>();
                        ((Vector)object2).addElement(Tibjmsx.ssl_trusted);
                        if (Tibjmsx.ssl_trusted1 != null) {
                            ((Vector)object2).addElement(Tibjmsx.ssl_trusted1);
                        }
                        if (Tibjmsx.ssl_trusted2 != null) {
                            ((Vector)object2).addElement(Tibjmsx.ssl_trusted2);
                        }
                        if (Tibjmsx.ssl_trusted3 != null) {
                            ((Vector)object2).addElement(Tibjmsx.ssl_trusted3);
                        }
                        hashtable.put(TRUSTED_CERTIFICATES, object2);
                    }
                    if (Tibjmsx.ssl_issuer != null) {
                        object2 = new Vector();
                        ((Vector)object2).addElement(Tibjmsx.ssl_issuer);
                        if (Tibjmsx.ssl_issuer1 != null) {
                            ((Vector)object2).addElement(Tibjmsx.ssl_issuer1);
                        }
                        if (Tibjmsx.ssl_issuer2 != null) {
                            ((Vector)object2).addElement(Tibjmsx.ssl_issuer2);
                        }
                        if (Tibjmsx.ssl_issuer3 != null) {
                            ((Vector)object2).addElement(Tibjmsx.ssl_issuer3);
                        }
                        hashtable.put(ISSUER_CERTIFICATES, object2);
                    }
                    if (hashtable.size() > 0) {
                        try {
                            TibjmsSSL.initFromEnvironment(hashtable, _default);
                            if (printStream2 != null) {
                                TibjmsSSL._sslTrace(printStream2, "_default after initFromEnvironment: " + _default.toString(), null);
                            }
                            if (tibjmsSSLParams == _default) break block47;
                            TibjmsSSL.initFromEnvironment(hashtable, tibjmsSSLParams);
                            if (printStream2 != null) {
                                TibjmsSSL._sslTrace(printStream2, "params after initFromEnvironment: " + tibjmsSSLParams.toString(), null);
                            }
                        }
                        catch (JMSException jMSException) {
                            throw new JMSSecurityException(jMSException.getMessage());
                        }
                    }
                }
                if ((object2 = string) == null) {
                    object2 = TibjmsSSL._default.vendor;
                }
                if (object2 == null) {
                    object2 = _DEFAULT_SSL_VENDOR;
                }
                if (printStream != null) {
                    TibjmsSSL._sslTrace(printStream, "initializing security with vendor '" + (String)object2 + "'", null);
                }
                TibjmsSSL.setVendor((String)object2);
                tibjmsSSLParams.vendor = TibjmsSSL._default.vendor;
                if (_sslInitialized) {
                    if (printStream2 == null) return;
                    TibjmsSSL._sslTrace(printStream2, "Partial TLS reinitialization is complete.", null);
                    return;
                }
                try {
                    int n;
                    block52: {
                        block53: {
                            Provider[] providerArray;
                            Object object3;
                            Object object4;
                            block54: {
                                block50: {
                                    int n2;
                                    String string3;
                                    int n3;
                                    block51: {
                                        boolean bl;
                                        block49: {
                                            string2 = null;
                                            String string4 = null;
                                            String string5 = null;
                                            bl = false;
                                            string2 = System.getProperty(OLD_FIPS);
                                            if (string2 != null) {
                                                throw new JMSSecurityException("Property 'com.tibco.security.FIPS' is no longer supported. See documentation for current FIPS support.");
                                            }
                                            string4 = System.getProperty(PKCS11, "FALSE");
                                            if (string4.toUpperCase().equals("TRUE")) {
                                                bl = true;
                                            }
                                            if ((string5 = System.getProperty(PKCS11CONFIG)) == null || string5.isEmpty()) break block49;
                                            if (printStream2 != null) {
                                                TibjmsSSL._sslTrace(printStream2, "Dynamic PKCS11 Config file: " + string5, null);
                                            }
                                            if ((_pkcs11Provider = TibjmsSSLPlatform.getPKCS11ProviderFromConfig(string5)) == null) break block50;
                                            n3 = -1;
                                            n = 0;
                                            string3 = null;
                                            object4 = null;
                                            object3 = Security.getProviders();
                                            n2 = ((Provider[])object3).length;
                                            break block51;
                                        }
                                        if (!bl) break block52;
                                        providerArray = Security.getProviders();
                                        if (providerArray == null || providerArray.length <= 0) break block53;
                                        break block54;
                                    }
                                    for (int j = 0; j < n2; ++n, ++j) {
                                        Provider provider = object3[j];
                                        if (!provider.getName().contains("JSSE")) continue;
                                        n3 = n + 1;
                                        string3 = provider.getName();
                                        break;
                                    }
                                    if (printStream2 != null) {
                                        TibjmsSSL._sslTrace(printStream2, "JSSE position in provider list: " + n3, null);
                                    }
                                    if ((object4 = TibjmsSSLPlatform.getFIPSProviderFromProvider(_pkcs11Provider)) == null) {
                                        object3 = new JMSSecurityException("FIPS provider not created.");
                                        throw object3;
                                    }
                                    TibjmsSSLPlatform.putFIPSProviderInProviderList((Provider)object4, n3, string3, printStream2);
                                }
                                if (_pkcs11Provider != null && printStream2 != null) {
                                    TibjmsSSL._sslTrace(printStream2, "Using dynamic PKCS11 provider", null);
                                }
                                break block52;
                            }
                            for (n = 0; n < providerArray.length; ++n) {
                                int n4 = n + 1;
                                object4 = providerArray[n].getName();
                                object3 = providerArray[n].getInfo();
                                if (object3 == null || !((String)object3).toUpperCase().contains("PKCS11")) continue;
                                _pkcs11Provider = providerArray[n];
                                if (printStream2 == null) break;
                                TibjmsSSL._sslTrace(printStream2, "Using static PKCS11 provider", null);
                                break;
                            }
                        }
                        if (_pkcs11Provider == null) {
                            JMSSecurityException jMSSecurityException = new JMSSecurityException("No PKCS11 provider found.");
                            throw jMSSecurityException;
                        }
                    }
                    if (printStream2 == null) break block48;
                    if (_pkcs11Provider == null) {
                        TibjmsSSL._sslTrace(printStream2, "Using normal JSSE provider", null);
                    }
                    TibjmsSSL._sslTrace(printStream2, "Available providers are:", null);
                    Provider[] providerArray = Security.getProviders();
                    if (providerArray != null && providerArray.length > 0) {
                        for (n = 0; n < providerArray.length; ++n) {
                            TibjmsSSL._sslTrace(printStream2, "        " + providerArray[n].getName(), null);
                        }
                        if (_pkcs11Provider != null) {
                            TibjmsSSL._sslTrace(printStream2, "PKCS11 Provider: " + _pkcs11Provider.getName() + ": " + _pkcs11Provider.getInfo(), null);
                        }
                        break block48;
                    }
                    TibjmsSSL._sslTrace(printStream2, "No providers equipped.", null);
                }
                catch (Exception exception) {
                    JMSSecurityException jMSSecurityException = new JMSSecurityException("Failed to initialize security environment for vendor " + tibjmsSSLParams.vendor + ", reason: " + exception.getMessage());
                    jMSSecurityException.setLinkedException(exception);
                    throw jMSSecurityException;
                }
            }
            if (printStream != null) {
                string2 = System.getProperty("java.version");
                TibjmsSSL._sslTrace(printStream, "client version 10.2.1, security version " + string2 + ", TLS initialized with vendor '" + tibjmsSSLParams.vendor + "'", null);
            }
            if (printStream2 != null) {
                TibjmsSSL._sslTrace(printStream2, "TLS initialization is complete", null);
            }
            _sslInitialized = true;
            return;
        }
    }

    static TibjmsSSLParams getDefaultParameters() {
        return _default;
    }

    public static void setDebugTraceEnabled(boolean bl) {
        TibjmsSSL._default.debug_trace = bl;
    }

    public static void setAuthOnly(boolean bl) {
        TibjmsSSL._default.auth_only = bl;
    }

    public static boolean isAuthOnly() {
        return TibjmsSSL._default.auth_only;
    }

    public static boolean getDebugTraceEnabled() {
        return TibjmsSSL._default.debug_trace;
    }

    public static void setClientTracer(PrintStream printStream) {
        TibjmsSSL._default.tracer = printStream;
    }

    public static PrintStream getClientTracer() {
        return TibjmsSSL._default.tracer;
    }

    public static void setSecureRandom(SecureRandom secureRandom) {
        TibjmsSSL.secureRandom = secureRandom;
    }

    public static String getCipherSuiteName(int n) throws JMSSecurityException {
        if (!_sslInitialized) {
            throw new JMSSecurityException(_noinit);
        }
        try {
            TibjmsSSL._initCiphers();
            TibjmsSSLCipherInfo tibjmsSSLCipherInfo = (TibjmsSSLCipherInfo)_ciphersHash.get(n);
            if (tibjmsSSLCipherInfo != null) {
                return tibjmsSSLCipherInfo.javaName;
            }
            throw new JMSSecurityException("Unknown cipher suite");
        }
        catch (Exception exception) {
            throw new JMSSecurityException("Unknown cipher suite");
        }
    }

    public static int getCipherSuiteNumber(String string) throws JMSSecurityException {
        if (!_sslInitialized) {
            throw new JMSSecurityException(_noinit);
        }
        try {
            TibjmsSSL._initCiphers();
            TibjmsSSLCipherInfo tibjmsSSLCipherInfo = (TibjmsSSLCipherInfo)_ciphersHash.get(string);
            if (tibjmsSSLCipherInfo != null) {
                return tibjmsSSLCipherInfo.javaID;
            }
            String string2 = null;
            string2 = string.startsWith("TLS") ? string.replaceFirst("TLS", "SSL") : string.replaceFirst("SSL", "TLS");
            tibjmsSSLCipherInfo = (TibjmsSSLCipherInfo)_ciphersHash.get(string2);
            if (tibjmsSSLCipherInfo != null) {
                return tibjmsSSLCipherInfo.javaID;
            }
            throw new JMSSecurityException("Unknown cipher suite");
        }
        catch (Exception exception) {
            throw new JMSSecurityException("Unknown cipher suite");
        }
    }

    public static boolean isCipherSuiteSupported(int n) throws JMSSecurityException {
        TibjmsxLinkSSL tibjmsxLinkSSL = TibjmsSSL.simulateConnection();
        return TibjmsSSL.isCipherSuiteSupported(n, tibjmsxLinkSSL._sslSocketFactory);
    }

    static boolean isCipherSuiteSupported(int n, SSLSocketFactory sSLSocketFactory) throws JMSSecurityException {
        String string = null;
        string = TibjmsSSL.getCipherSuiteName(n);
        if (string == null) {
            return false;
        }
        if (sSLSocketFactory == null) {
            throw new JMSSecurityException(_noinit);
        }
        String[] stringArray = sSLSocketFactory.getSupportedCipherSuites();
        return TibjmsSSL.isCipherSuiteSocSupported(string, stringArray);
    }

    public static boolean isCipherSuiteSupported(String string) throws JMSSecurityException {
        TibjmsxLinkSSL tibjmsxLinkSSL = TibjmsSSL.simulateConnection();
        return TibjmsSSL.isCipherSuiteSupported(string, tibjmsxLinkSSL._sslSocketFactory);
    }

    static boolean isCipherSuiteSupported(String string, SSLSocketFactory sSLSocketFactory) throws JMSSecurityException {
        int n = 0;
        n = TibjmsSSL.getCipherSuiteNumber(string);
        if (n == 0) {
            return false;
        }
        if (sSLSocketFactory == null) {
            throw new JMSSecurityException(_noinit);
        }
        String[] stringArray = sSLSocketFactory.getSupportedCipherSuites();
        return TibjmsSSL.isCipherSuiteSocSupported(string, stringArray);
    }

    static boolean isCipherSuiteSocSupported(String string, String[] stringArray) throws JMSSecurityException {
        String string2 = null;
        String string3 = null;
        if (string.startsWith("TLS")) {
            string2 = string;
            string3 = string.replaceFirst("TLS", "SSL");
        } else {
            string3 = string;
            string2 = string.replaceFirst("SSL", "TLS");
        }
        for (int j = 0; j < stringArray.length; ++j) {
            if (!string2.equals(stringArray[j]) && !string3.equals(stringArray[j])) continue;
            return true;
        }
        return false;
    }

    public static int[] getSupportedCipherSuites() throws JMSSecurityException {
        if (!_sslInitialized) {
            throw new JMSSecurityException(_noinit);
        }
        String[] stringArray = TibjmsSSL.getSupportedCipherNames();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String[] objectArray = stringArray;
        int n = objectArray.length;
        for (int j = 0; j < n; ++j) {
            String string = objectArray[j];
            int n2 = 0;
            try {
                n2 = TibjmsSSL.getCipherSuiteNumber(string);
            }
            catch (JMSSecurityException jMSSecurityException) {
                continue;
            }
            if (n2 == 0) continue;
            arrayList.add(n2);
        }
        int[] nArray = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            nArray[n] = (Integer)arrayList.get(n);
        }
        return nArray;
    }

    static TibjmsxLinkSSL simulateConnection() throws JMSSecurityException {
        try {
            TibjmsxLinkSSL tibjmsxLinkSSL = new TibjmsxLinkSSL(null);
            String string = TibjmsSSL.getExpectedHostName();
            TibjmsSSL.setExpectedHostName("");
            tibjmsxLinkSSL._initSSL();
            TibjmsSSL.setExpectedHostName(string);
            return tibjmsxLinkSSL;
        }
        catch (JMSException jMSException) {
            JMSSecurityException jMSSecurityException = new JMSSecurityException("Failed to set up simulated connection" + (jMSException.getMessage() != null ? ": " + jMSException.getMessage() : ""));
            jMSSecurityException.setLinkedException(jMSException);
            throw jMSSecurityException;
        }
    }

    public static String[] getSupportedCipherNames() throws JMSSecurityException {
        String[] stringArray = null;
        try {
            TibjmsxLinkSSL tibjmsxLinkSSL = TibjmsSSL.simulateConnection();
            stringArray = tibjmsxLinkSSL._sslSocketFactory.getSupportedCipherSuites();
            stringArray = TibjmsSSL._filterCipherSuites(stringArray, tibjmsxLinkSSL._sslSocketFactory, null);
        }
        catch (JMSException jMSException) {
            JMSSecurityException jMSSecurityException = new JMSSecurityException("Failed to retrieve supported cipher suites" + (jMSException.getMessage() != null ? ": " + jMSException.getMessage() : ""));
            jMSSecurityException.setLinkedException(jMSException);
            throw jMSSecurityException;
        }
        return stringArray;
    }

    public static void setCipherSuites(int[] nArray) throws JMSSecurityException {
        TibjmsSSL._setCipherSuites(_default, nArray);
    }

    static void _setCipherSuites(TibjmsSSLParams tibjmsSSLParams, int[] nArray) throws JMSSecurityException {
        if (nArray != null && nArray.length == 0) {
            throw new IllegalArgumentException("Parameter can not be zero-length array");
        }
        if (nArray == null) {
            tibjmsSSLParams.cipher_suites = null;
        } else {
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            tibjmsSSLParams.cipher_suites = nArray2;
        }
    }

    public static void setCipherSuites(String string) throws JMSSecurityException {
        TibjmsSSL._setCipherSuites(_default, string);
    }

    static void _setCipherSuites(TibjmsSSLParams tibjmsSSLParams, String string) throws JMSSecurityException {
        if (string != null && string.length() == 0) {
            throw new IllegalArgumentException("Parameter can not be empty String");
        }
        tibjmsSSLParams.cipher_specs = string;
    }

    static String[] _getCipherSuites(TibjmsSSLParams tibjmsSSLParams, SSLSocketFactory sSLSocketFactory) throws JMSSecurityException {
        PrintStream printStream;
        String[] stringArray = null;
        if (tibjmsSSLParams == null) {
            return null;
        }
        PrintStream printStream2 = TibjmsSSL._getDebugTracer(tibjmsSSLParams);
        if (tibjmsSSLParams.cipher_specs != null) {
            stringArray = TibjmsSSL._ciphersFromSpec(tibjmsSSLParams, sSLSocketFactory);
            if (printStream2 != null && stringArray != null) {
                TibjmsSSL._sslTrace(printStream2, "cipher_specs has " + stringArray.length + " user specified cipher(s)", null);
            }
        }
        if ((stringArray == null || stringArray.length == 0) && tibjmsSSLParams.cipher_suites != null && tibjmsSSLParams.cipher_suites.length > 0) {
            stringArray = TibjmsSSL._ciphersFromSuites(tibjmsSSLParams);
            if (printStream2 != null && stringArray != null) {
                TibjmsSSL._sslTrace(printStream2, "cipher_suites has " + stringArray.length + " user specified cipher(s)", null);
            }
        }
        if ((printStream = TibjmsSSL._getTracer(tibjmsSSLParams)) != null && stringArray != null) {
            if (!_sslInitialized) {
                throw new JMSSecurityException(_noinit);
            }
            for (int j = 0; j < stringArray.length; ++j) {
                try {
                    if (TibjmsSSL.isCipherSuiteSupported(stringArray[j], sSLSocketFactory)) {
                        continue;
                    }
                }
                catch (JMSSecurityException jMSSecurityException) {
                    // empty catch block
                }
                TibjmsSSL._sslTrace(printStream, "Warning: specified cipher suite not supported: suite=" + stringArray[j], null);
            }
        }
        return stringArray;
    }

    static String[] _filterCipherSuites(String[] stringArray, SSLSocketFactory sSLSocketFactory, PrintStream printStream) {
        if (stringArray != null) {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray2 = sSLSocketFactory.getSupportedCipherSuites();
            for (n = 0; n < stringArray.length; ++n) {
                try {
                    if (!TibjmsSSL.isCipherSuiteSupported(stringArray[n], sSLSocketFactory)) continue;
                    boolean bl = false;
                    if (TibjmsSSL.isCipherSuiteSocSupported(stringArray[n], stringArray2)) {
                        arrayList.add(stringArray[n]);
                        continue;
                    }
                    if (printStream == null) continue;
                    TibjmsSSL._sslTrace(printStream, "Ignore unsupported cipher: " + stringArray[n], null);
                    continue;
                }
                catch (JMSSecurityException jMSSecurityException) {
                    if (printStream == null) continue;
                    TibjmsSSL._sslTrace(printStream, "Ignore disallowed cipher: " + stringArray[n], null);
                }
            }
            stringArray = new String[arrayList.size()];
            if (printStream != null) {
                TibjmsSSL._sslTrace(printStream, "Enable connection ciphers:", null);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                stringArray[n] = (String)arrayList.get(n);
                if (printStream == null) continue;
                TibjmsSSL._sslTrace(printStream, "        " + stringArray[n], null);
            }
        }
        return stringArray;
    }

    public static String[] getClientCipherSuites() throws JMSException {
        String[] stringArray = null;
        try {
            TibjmsxLinkSSL tibjmsxLinkSSL = TibjmsSSL.simulateConnection();
            stringArray = tibjmsxLinkSSL._cipherSuites != null ? tibjmsxLinkSSL._cipherSuites : tibjmsxLinkSSL._sslSocketFactory.getDefaultCipherSuites();
            stringArray = TibjmsSSL._filterCipherSuites(stringArray, tibjmsxLinkSSL._sslSocketFactory, null);
        }
        catch (JMSException jMSException) {
            JMSException jMSException2 = new JMSException("Failed to retrieve client cipher suites" + (jMSException.getMessage() != null ? ": " + jMSException.getMessage() : ""));
            jMSException2.setLinkedException(jMSException);
            throw jMSException2;
        }
        return stringArray;
    }

    public static void setVerifyHost(boolean bl) {
        TibjmsSSL._default.disable_verify_host = !bl;
    }

    public static boolean getVerifyHost() {
        return !TibjmsSSL._default.disable_verify_host;
    }

    public static void setExpectedHostName(String string) {
        TibjmsSSL._default.expected_hostname = string;
    }

    public static String getExpectedHostName() {
        return TibjmsSSL._default.expected_hostname;
    }

    public static void setVerifyHostName(boolean bl) {
        TibjmsSSL._default.disable_verify_hostname = !bl;
    }

    public static boolean getVerifyHostName() {
        return !TibjmsSSL._default.disable_verify_hostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setHostNameVerifier(TibjmsSSLHostNameVerifier tibjmsSSLHostNameVerifier) {
        Object object = _sslLock;
        synchronized (object) {
            TibjmsSSL._default.verifier = tibjmsSSLHostNameVerifier;
        }
    }

    public static TibjmsSSLHostNameVerifier getHostNameVerifier() {
        return TibjmsSSL._default.verifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTrustedCerts() throws JMSSecurityException {
        Object object = _sslLock;
        synchronized (object) {
            TibjmsSSL._default.trusted = null;
        }
    }

    public static void addTrustedCerts(Object object) throws JMSSecurityException {
        TibjmsSSL.addTrustedCerts(object, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTrustedCerts(Object object, int n) throws JMSSecurityException {
        Object object2 = _sslLock;
        synchronized (object2) {
            TibjmsSSL._addTrustedCertsToParams(_default, object, n);
        }
    }

    static void _addTrustedCertsToParams(TibjmsSSLParams tibjmsSSLParams, Object object, int n) throws JMSSecurityException {
        if (object == null || tibjmsSSLParams == null) {
            throw new IllegalArgumentException("null parameter");
        }
        n = TibjmsSSL.encodingToPrecise(n);
        TibjmsSSL.checkValidTrustedEncoding(n);
        TibjmsSSLCI tibjmsSSLCI = new TibjmsSSLCI(object, n);
        if (tibjmsSSLParams.trusted == null) {
            tibjmsSSLParams.trusted = new Vector();
        }
        tibjmsSSLParams.trusted.addElement(tibjmsSSLCI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearIssuerCerts() throws JMSSecurityException {
        Object object = _sslLock;
        synchronized (object) {
            TibjmsSSL._default.issuers = null;
        }
    }

    public static void addIssuerCerts(Object object) throws JMSSecurityException {
        TibjmsSSL.addIssuerCerts(object, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIssuerCerts(Object object, int n) throws JMSSecurityException {
        Object object2 = _sslLock;
        synchronized (object2) {
            TibjmsSSL._addIssuerCerts(_default, object, n);
        }
    }

    static void _addIssuerCerts(TibjmsSSLParams tibjmsSSLParams, Object object, int n) throws JMSSecurityException {
        if (object == null || tibjmsSSLParams == null) {
            throw new IllegalArgumentException("null parameter");
        }
        n = TibjmsSSL.encodingToPrecise(n);
        TibjmsSSLCI tibjmsSSLCI = new TibjmsSSLCI(object, n);
        if (tibjmsSSLParams.issuers == null) {
            tibjmsSSLParams.issuers = new Vector();
        }
        tibjmsSSLParams.issuers.addElement(tibjmsSSLCI);
    }

    static PrintStream _getTracer(TibjmsSSLParams tibjmsSSLParams) {
        if (tibjmsSSLParams != null && tibjmsSSLParams.tracer != null) {
            return tibjmsSSLParams.tracer;
        }
        return TibjmsSSL._default.tracer;
    }

    static PrintStream _getDebugTracer(TibjmsSSLParams tibjmsSSLParams) {
        if (tibjmsSSLParams != null && tibjmsSSLParams.debug_tracer != null) {
            return tibjmsSSLParams.debug_tracer;
        }
        return TibjmsSSL._default.debug_tracer;
    }

    public static void setIdentity(Object object, char[] cArray) throws JMSSecurityException {
        TibjmsSSL.setIdentity(object, 0, null, 0, cArray);
    }

    public static void setIdentity(Object object, Object object2, char[] cArray) throws JMSSecurityException {
        TibjmsSSL.setIdentity(object, 0, object2, 0, cArray);
    }

    public static void setIdentity(Object object, int n, char[] cArray) throws JMSSecurityException {
        TibjmsSSL.setIdentity(object, n, null, 0, cArray);
    }

    public static void setIdentity(Object object, int n, Object object2, char[] cArray) throws JMSSecurityException {
        TibjmsSSL.setIdentity(object, n, object2, 0, cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setIdentity(Object object, int n, Object object2, int n2, char[] cArray) throws JMSSecurityException {
        Object object3 = _sslLock;
        synchronized (object3) {
            TibjmsSSL._setIdentity(_default, object, n, object2, n2, cArray);
        }
    }

    public static void setPassword(char[] cArray) {
        TibjmsSSL._setPassword(_default, cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void _setPassword(TibjmsSSLParams tibjmsSSLParams, char[] cArray) {
        Object object = _sslLock;
        synchronized (object) {
            if (tibjmsSSLParams == null || cArray != null && cArray.length == 0) {
                throw new IllegalArgumentException("invalid parameters");
            }
            if (tibjmsSSLParams.password != null) {
                for (int j = 0; j < tibjmsSSLParams.password.length; ++j) {
                    tibjmsSSLParams.password[j] = '\u0000';
                }
            }
            tibjmsSSLParams.password = cArray;
        }
    }

    static void _setIdentity(TibjmsSSLParams tibjmsSSLParams, Object object, int n, Object object2, int n2, char[] cArray) throws JMSSecurityException {
        if (tibjmsSSLParams == null) {
            throw new IllegalArgumentException("null parameter");
        }
        n = TibjmsSSL.encodingToPrecise(n);
        n2 = TibjmsSSL.encodingToPrecise(n2);
        if (object != null) {
            tibjmsSSLParams.identity_data = new TibjmsSSLCI(object, n);
        }
        if (object2 != null) {
            tibjmsSSLParams.pk_key_data = new TibjmsSSLCI(object2, n2);
        }
        tibjmsSSLParams.password = cArray;
    }

    static KeyStore _createTrustedCerts(TibjmsSSLParams tibjmsSSLParams) throws JMSSecurityException {
        KeyStore keyStore = null;
        Object object = _sslLock;
        synchronized (object) {
            if (!_sslInitialized) {
                throw new JMSSecurityException(_noinit);
            }
            PrintStream printStream = TibjmsSSL._getDebugTracer(tibjmsSSLParams);
            try {
                keyStore = KeyStore.getInstance("JKS");
            }
            catch (KeyStoreException keyStoreException) {
                JMSSecurityException jMSSecurityException = new JMSSecurityException("Failed to create keystore for trusted certs, reason: " + keyStoreException.getMessage());
                jMSSecurityException.setLinkedException(keyStoreException);
                throw jMSSecurityException;
            }
            if (printStream != null) {
                TibjmsSSL._sslTrace(printStream, "Initialize empty JKS keystore for trusted certs.", null);
            }
            try {
                keyStore.load(null, null);
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException exception) {
                JMSSecurityException jMSSecurityException = new JMSSecurityException("Failed to initialize keystore for trusted certs, reason: " + exception.getMessage());
                jMSSecurityException.setLinkedException(exception);
                throw jMSSecurityException;
            }
            if (tibjmsSSLParams.trusted != null) {
                if (printStream != null) {
                    TibjmsSSL._sslTrace(printStream, "Add " + tibjmsSSLParams.trusted.size() + " user provided trusted certs.", null);
                }
                Object var4_6 = null;
                for (int j = 0; j < tibjmsSSLParams.trusted.size(); ++j) {
                    try {
                        TibjmsSSL._addTrustedCertsFromParams(tibjmsSSLParams, keyStore, (TibjmsSSLCI)tibjmsSSLParams.trusted.elementAt(j));
                        continue;
                    }
                    catch (JMSSecurityException jMSSecurityException) {
                        JMSSecurityException jMSSecurityException2 = new JMSSecurityException("Error in params trusted certificate (" + (j + 1) + " of " + tibjmsSSLParams.trusted.size() + ") ('" + jMSSecurityException.getMessage() + "')");
                        jMSSecurityException2.setLinkedException(jMSSecurityException);
                        throw jMSSecurityException2;
                    }
                }
            } else if (printStream != null) {
                TibjmsSSL._sslTrace(printStream, "No user provided trusted certs.", null);
            }
            if (printStream != null) {
                try {
                    TibjmsSSL._sslTrace(printStream, "trustedCerts now contains " + keyStore.size() + " entries", null);
                }
                catch (KeyStoreException keyStoreException) {
                    // empty catch block
                }
            }
            try {
                if (keyStore.size() == 0) {
                    return null;
                }
                return keyStore;
            }
            catch (KeyStoreException keyStoreException) {
                JMSSecurityException jMSSecurityException = new JMSSecurityException("Detected corrupted keystore for trusted certificates, reason: " + keyStoreException.getMessage());
                jMSSecurityException.setLinkedException(keyStoreException);
                throw jMSSecurityException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _addTrustedCertsFromParams(TibjmsSSLParams tibjmsSSLParams, KeyStore keyStore, TibjmsSSLCI tibjmsSSLCI) throws JMSSecurityException {
        X509Certificate[] x509CertificateArray = null;
        Object object = _sslLock;
        synchronized (object) {
            if (tibjmsSSLCI == null || tibjmsSSLCI.data == null) {
                throw new IllegalArgumentException("null parameter");
            }
            if (!_sslInitialized) {
                throw new JMSSecurityException(_noinit);
            }
            TibjmsSSL.checkValidTrustedEncoding(tibjmsSSLCI.encoding);
            try {
                x509CertificateArray = TibjmsSSL._readCerts(tibjmsSSLParams, "trusted", tibjmsSSLCI.data, tibjmsSSLCI.encoding);
            }
            catch (JMSSecurityException jMSSecurityException) {
                JMSSecurityException jMSSecurityException2 = new JMSSecurityException("No trusted certificates found");
                jMSSecurityException2.setLinkedException(jMSSecurityException);
                throw jMSSecurityException2;
            }
            if (x509CertificateArray != null && x509CertificateArray.length > 0) {
                for (int j = 0; j < x509CertificateArray.length; ++j) {
                    X509Certificate x509Certificate = x509CertificateArray[j];
                    String string = "trustedCertAlias" + String.valueOf(++trustedCertAliasInc);
                    if (string == null) continue;
                    try {
                        keyStore.setCertificateEntry(string, x509Certificate);
                        continue;
                    }
                    catch (KeyStoreException keyStoreException) {
                        String string2 = "'" + keyStoreException.getMessage();
                        Throwable throwable = null;
                        Throwable throwable2 = keyStoreException;
                        while ((throwable = throwable2.getCause()) != null) {
                            string2 = string2 + "' + '" + throwable.getMessage();
                            throwable2 = throwable;
                        }
                        string2 = string2 + "'";
                        JMSSecurityException jMSSecurityException = new JMSSecurityException("Error processing trusted certificates (" + (j + 1) + " of " + x509CertificateArray.length + ", name = '" + string + "') (" + string2 + ")");
                        jMSSecurityException.setLinkedException(keyStoreException);
                        throw jMSSecurityException;
                    }
                }
            }
        }
    }

    static X509Certificate[] _readCerts(TibjmsSSLParams tibjmsSSLParams, String string, Object object, int n) throws JMSSecurityException {
        X509Certificate[] x509CertificateArray;
        block36: {
            Object object2;
            if (object == null) {
                throw new IllegalArgumentException("null parameter");
            }
            InputStream inputStream2 = null;
            boolean bl = false;
            x509CertificateArray = null;
            String string2 = null;
            ArrayList<X509Certificate> arrayList = null;
            PrintStream printStream = TibjmsSSL._getTracer(tibjmsSSLParams);
            if ((n & 0x20) != 0) {
                throw new JMSSecurityException("PKCS8 can not be used as certificate encoding");
            }
            if (object instanceof String) {
                string2 = (String)object;
                if (printStream != null && string != null) {
                    TibjmsSSL._sslTrace(printStream, "reading " + string + " certificate(s) from file '" + string2 + "', format=" + TibjmsSSL.encodingToName(n), null);
                }
                inputStream2 = TibjmsSSL._fileToStream(string2);
            } else if (object instanceof byte[]) {
                if (printStream != null && string != null) {
                    TibjmsSSL._sslTrace(printStream, "reading " + string + " certificate(s) from byte array, format=" + TibjmsSSL.encodingToName(n), null);
                }
                inputStream2 = new ByteArrayInputStream((byte[])object);
            } else if (object instanceof InputStream) {
                if (printStream != null && string != null) {
                    object2 = "PEM or DER";
                    if (n != 0) {
                        object2 = TibjmsSSL.encodingToName(n);
                    }
                    TibjmsSSL._sslTrace(printStream, "reading " + string + " certificate(s) from byte array, format=" + (String)object2, null);
                }
                inputStream2 = (InputStream)object;
                bl = true;
            } else if (object instanceof X509Certificate[]) {
                if (printStream != null && string != null) {
                    TibjmsSSL._sslTrace(printStream, "reading " + string + " certificate(s) from array of X509Certificate objects", null);
                }
                try {
                    return (X509Certificate[])((X509Certificate[])object).clone();
                }
                catch (Exception exception) {
                    String string3 = "Error reading certs from X509Certificate[] object";
                    JMSSecurityException jMSSecurityException = new JMSSecurityException(string3);
                    jMSSecurityException.setLinkedException(exception);
                    throw jMSSecurityException;
                }
            }
            try {
                if (inputStream2 != null) {
                    if (inputStream2.available() == 0) {
                        object2 = new JMSSecurityException("No certificates in stream");
                        throw object2;
                    }
                    arrayList = new ArrayList<X509Certificate>();
                    if ((n & 0x40) != 0) {
                        object2 = KeyStore.getInstance("pkcs12");
                        ((KeyStore)object2).load(inputStream2, tibjmsSSLParams.password);
                        Enumeration<String> enumeration = ((KeyStore)object2).aliases();
                        while (enumeration.hasMoreElements()) {
                            String string4 = enumeration.nextElement();
                            X509Certificate x509Certificate = (X509Certificate)((KeyStore)object2).getCertificate(string4);
                            arrayList.add(x509Certificate);
                        }
                    } else {
                        object2 = CertificateFactory.getInstance("X.509");
                        Collection<? extends Certificate> collection = ((CertificateFactory)object2).generateCertificates(inputStream2);
                        for (X509Certificate x509Certificate : collection) {
                            arrayList.add(x509Certificate);
                        }
                    }
                    x509CertificateArray = new X509Certificate[arrayList.size()];
                    arrayList.toArray(x509CertificateArray);
                    break block36;
                }
                if (object instanceof X509Certificate) {
                    if (printStream != null && string != null) {
                        TibjmsSSL._sslTrace(printStream, "reading " + string + " certificate from X509Certificate object", null);
                    }
                    x509CertificateArray = new X509Certificate[]{(X509Certificate)object};
                } else {
                    if (printStream != null && string != null) {
                        TibjmsSSL._sslTrace(printStream, "reading " + string + " certificate(s) from object of class " + object.getClass().getName() + ", format=" + TibjmsSSL.encodingToName(n), null);
                    }
                    x509CertificateArray = new X509Certificate[]{(X509Certificate)object};
                }
            }
            catch (Exception exception) {
                String string5 = "Error reading certs from ";
                string5 = string2 != null ? string5 + "file '" + string2 : string5 + object.getClass().getName() + " object";
                string5 = string5 + ": " + exception.getMessage();
                JMSSecurityException jMSSecurityException = new JMSSecurityException(string5);
                jMSSecurityException.setLinkedException(exception);
                throw jMSSecurityException;
            }
            finally {
                if (!bl && inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return x509CertificateArray;
    }

    static KeyManagerFactory createKMF(char[] cArray, KeyStore keyStore) throws JMSSecurityException {
        KeyManagerFactory keyManagerFactory = null;
        try {
            keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (GeneralSecurityException generalSecurityException) {
            JMSSecurityException jMSSecurityException = new JMSSecurityException("Error creating KeyManagerFactory: " + generalSecurityException.getMessage());
            jMSSecurityException.setLinkedException(generalSecurityException);
            throw jMSSecurityException;
        }
        try {
            if (keyManagerFactory != null && keyStore != null) {
                keyManagerFactory.init(keyStore, cArray);
            } else {
                keyManagerFactory = null;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            JMSSecurityException jMSSecurityException = new JMSSecurityException("Error initializing KeyManagerFactory: " + generalSecurityException.getMessage());
            jMSSecurityException.setLinkedException(generalSecurityException);
            throw jMSSecurityException;
        }
        return keyManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TibjmsSSLClientIdentity createIdentity() throws JMSSecurityException {
        Object object = _sslLock;
        synchronized (object) {
            return TibjmsSSL.createIdentity(_default);
        }
    }

    static TibjmsSSLClientIdentity createIdentity(TibjmsSSLParams tibjmsSSLParams) throws JMSSecurityException {
        TibjmsSSLClientIdentity tibjmsSSLClientIdentity = new TibjmsSSLClientIdentity();
        PrintStream printStream = TibjmsSSL._getTracer(tibjmsSSLParams);
        if (_pkcs11Provider != null) {
            if (printStream != null) {
                TibjmsSSL._sslTrace(printStream, "Create PKCS11 identity via provider: " + _pkcs11Provider.getName(), null);
            }
            try {
                tibjmsSSLClientIdentity.identity = KeyStore.getInstance("PKCS11", _pkcs11Provider);
            }
            catch (Exception exception) {
                JMSSecurityException jMSSecurityException = new JMSSecurityException("Error occured creating Keystore: " + exception.getMessage());
                jMSSecurityException.setLinkedException(exception);
                throw jMSSecurityException;
            }
            try {
                tibjmsSSLClientIdentity.identity.load(null, tibjmsSSLParams.password);
            }
            catch (Exception exception) {
                JMSSecurityException jMSSecurityException = new JMSSecurityException("Error occured creating Keystore: " + exception.getMessage());
                jMSSecurityException.setLinkedException(exception);
                throw jMSSecurityException;
            }
            tibjmsSSLClientIdentity.kmf = TibjmsSSL.createKMF(tibjmsSSLParams.password, tibjmsSSLClientIdentity.identity);
            return tibjmsSSLClientIdentity;
        }
        if (tibjmsSSLParams.identity_data == null) {
            if (printStream != null) {
                TibjmsSSL._sslTrace(printStream, "client identity not set, using empty identity.", null);
            }
            try {
                tibjmsSSLClientIdentity.identity = KeyStore.getInstance("pkcs12");
                tibjmsSSLClientIdentity.identity.load(null, null);
            }
            catch (IOException | GeneralSecurityException exception) {
                JMSSecurityException jMSSecurityException = new JMSSecurityException("Error occured creating Keystore: " + exception.getMessage());
                jMSSecurityException.setLinkedException(exception);
                throw jMSSecurityException;
            }
            tibjmsSSLClientIdentity.kmf = null;
            return tibjmsSSLClientIdentity;
        }
        String string = null;
        InputStream inputStream2 = null;
        boolean bl = false;
        Object object = null;
        tibjmsSSLParams.identity_data.encoding = TibjmsSSL.encodingToPrecise(tibjmsSSLParams.identity_data.encoding);
        if (tibjmsSSLParams.pk_key_data != null) {
            tibjmsSSLParams.pk_key_data.encoding = TibjmsSSL.encodingToPrecise(tibjmsSSLParams.pk_key_data.encoding);
        }
        try {
            object = tibjmsSSLParams.identity_data.data;
            if (tibjmsSSLParams.identity_data.data instanceof String) {
                string = (String)tibjmsSSLParams.identity_data.data;
                if (printStream != null) {
                    TibjmsSSL._sslTrace(printStream, "reading client identity from file '" + string + "', format=" + TibjmsSSL.encodingToName(tibjmsSSLParams.identity_data.encoding), null);
                }
                inputStream2 = TibjmsSSL._fileToStream(string);
            } else if (tibjmsSSLParams.identity_data.data instanceof byte[]) {
                if (printStream != null) {
                    TibjmsSSL._sslTrace(printStream, "reading client identity from byte array, format=" + TibjmsSSL.encodingToName(tibjmsSSLParams.identity_data.encoding), null);
                }
                inputStream2 = new ByteArrayInputStream((byte[])tibjmsSSLParams.identity_data.data);
            } else if (tibjmsSSLParams.identity_data.data instanceof InputStream) {
                bl = true;
                inputStream2 = (InputStream)tibjmsSSLParams.identity_data.data;
                if (printStream != null) {
                    TibjmsSSL._sslTrace(printStream, "reading client identity from input stream, format=" + TibjmsSSL.encodingToName(tibjmsSSLParams.identity_data.encoding), null);
                }
            }
            if (inputStream2 != null) {
                object = inputStream2;
            }
            if (tibjmsSSLParams.pk_key_data != null && (tibjmsSSLParams.identity_data.encoding == 512 || tibjmsSSLParams.identity_data.encoding == 64)) {
                throw new JMSSecurityException("Conflicting parameters: private key should not be specified when identity is a store");
            }
            tibjmsSSLClientIdentity.identity = tibjmsSSLParams.pk_key_data == null ? TibjmsSSL._identityFromStore(tibjmsSSLParams, object, tibjmsSSLParams.identity_data.encoding, tibjmsSSLParams.password) : TibjmsSSL._identityFromCertAndKey(tibjmsSSLParams, object, tibjmsSSLParams.identity_data.encoding, tibjmsSSLParams.pk_key_data.data, tibjmsSSLParams.pk_key_data.encoding, tibjmsSSLParams.password);
        }
        catch (JMSSecurityException jMSSecurityException) {
            throw jMSSecurityException;
        }
        finally {
            if (!bl && inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
        }
        tibjmsSSLClientIdentity.kmf = TibjmsSSL.createKMF(tibjmsSSLParams.password, tibjmsSSLClientIdentity.identity);
        return tibjmsSSLClientIdentity;
    }

    static KeyStore _identityFromStore(TibjmsSSLParams tibjmsSSLParams, Object object, int n, char[] cArray) throws JMSSecurityException {
        KeyStore keyStore = null;
        PrintStream printStream = TibjmsSSL._getTracer(tibjmsSSLParams);
        try {
            if (n == 512 && object instanceof InputStream) {
                if (printStream != null) {
                    TibjmsSSL._sslTrace(printStream, "creating KeyStore from input stream", null);
                }
                keyStore = KeyStore.getInstance("JKS");
                try {
                    keyStore.load((InputStream)object, cArray);
                }
                catch (Exception exception) {
                    JMSSecurityException jMSSecurityException = new JMSSecurityException("Failed to read KeyStore object: " + exception.getMessage());
                    jMSSecurityException.setLinkedException(exception);
                    throw jMSSecurityException;
                }
            }
            if (object instanceof KeyStore) {
                if (printStream != null) {
                    TibjmsSSL._sslTrace(printStream, "reading client identity from KeyStore object", null);
                }
                keyStore = (KeyStore)object;
            } else {
                if (object instanceof InputStream && n == 64) {
                    if (printStream != null) {
                        TibjmsSSL._sslTrace(printStream, "reading client identity from PKCS12 input stream", null);
                    }
                    try {
                        keyStore = KeyStore.getInstance("pkcs12");
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        JMSSecurityException jMSSecurityException = new JMSSecurityException("Error creating identity data: " + generalSecurityException.getMessage());
                        jMSSecurityException.setLinkedException(generalSecurityException);
                        throw jMSSecurityException;
                    }
                    try {
                        keyStore.load((InputStream)object, tibjmsSSLParams.password);
                    }
                    catch (Exception exception) {
                        JMSSecurityException jMSSecurityException = new JMSSecurityException("Error occured while reading identity data: " + exception.getMessage());
                        jMSSecurityException.setLinkedException(exception);
                        throw jMSSecurityException;
                    }
                }
                if (object instanceof InputStream && n == 1) {
                    if (printStream != null) {
                        TibjmsSSL._sslTrace(printStream, "reading client identity from PEM input stream", null);
                    }
                    try {
                        keyStore = KeyStore.getInstance("pkcs12");
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        JMSSecurityException jMSSecurityException = new JMSSecurityException("Error creating identity data: " + generalSecurityException.getMessage());
                        jMSSecurityException.setLinkedException(generalSecurityException);
                        throw jMSSecurityException;
                    }
                    try {
                        keyStore.load((InputStream)object, tibjmsSSLParams.password);
                    }
                    catch (Exception exception) {
                        JMSSecurityException jMSSecurityException = new JMSSecurityException("Error occured while reading identity data: " + exception.getMessage());
                        jMSSecurityException.setLinkedException(exception);
                        throw jMSSecurityException;
                    }
                }
                throw new JMSSecurityException("Invalid or not supported identity data");
            }
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (Exception exception) {
            JMSSecurityException jMSSecurityException = new JMSSecurityException("Error occured while reading identity data: " + exception.getMessage());
            jMSSecurityException.setLinkedException(exception);
            throw jMSSecurityException;
        }
    }

    static KeyStore _identityFromCertAndKey(TibjmsSSLParams tibjmsSSLParams, Object object, int n, Object object2, int n2, char[] cArray) throws JMSSecurityException {
        JMSSecurityException jMSSecurityException = new JMSSecurityException("PKCS#8 private key not supported - use PKCS#12 or JKS");
        throw jMSSecurityException;
    }

    static String getDNField(String string, String string2) {
        String string3;
        if (string == null) {
            return null;
        }
        String string4 = string.toLowerCase();
        int n = string4.indexOf((string3 = string2.toLowerCase()) + "=");
        if (n < 0) {
            return null;
        }
        if ((n += string2.length() + 1) >= string.length()) {
            return "";
        }
        int n2 = string.indexOf(",", n);
        if (n2 < 0) {
            return string.substring(n, string.length());
        }
        return string.substring(n, n2);
    }

    static String getCertCN(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return null;
        }
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        if (x500Principal == null) {
            return null;
        }
        return TibjmsSSL.getDNField(x500Principal.getName(), "CN");
    }

    static List<String> getCertSAN(X509Certificate x509Certificate) {
        Collection<List<?>> collection;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            collection = x509Certificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException certificateParsingException) {
            return arrayList;
        }
        if (collection == null) {
            return arrayList;
        }
        for (List<?> list : collection) {
            switch ((Integer)list.get(0)) {
                case 2: {
                    arrayList.add((String)list.get(1));
                    break;
                }
                case 7: {
                    Object obj = list.get(1);
                    if (obj instanceof String) {
                        arrayList.add((String)obj);
                        break;
                    }
                    if (!(obj instanceof byte[])) break;
                    try {
                        InetAddress inetAddress = InetAddress.getByAddress((byte[])list.get(1));
                        arrayList.add(inetAddress.getHostAddress());
                    }
                    catch (UnknownHostException unknownHostException) {}
                    break;
                }
            }
        }
        return arrayList;
    }

    static String getCertDescription(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "null";
        }
        String string = "CertCN=";
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
        string = x500Principal == null ? string + "[no subject]" : string + TibjmsSSL.getDNField(x500Principal.getName(), "CN");
        string = string + ", IssuerCN=";
        string = x500Principal2 == null ? string + "[no issuer]" : string + TibjmsSSL.getDNField(x500Principal2.getName(), "CN");
        return string;
    }

    static void checkValidTrustedEncoding(int n) throws JMSSecurityException {
        n = TibjmsSSL.encodingToPrecise(n);
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 17: 
            case 20: 
            case 64: 
            case 512: {
                return;
            }
        }
        throw new JMSSecurityException("Invalid encoding of trusted certificates: " + TibjmsSSL.encodingToName(n));
    }

    static String encodingToName(int n) {
        switch (n) {
            case 0: {
                return "AUTO";
            }
            case 1: {
                return "PEM";
            }
            case 2: {
                return "DER";
            }
            case 4: {
                return "BER";
            }
            case 16: {
                return "PKCS7";
            }
            case 17: {
                return "PKCS7(PEM)";
            }
            case 20: {
                return "PKCS7(BER)";
            }
            case 32: {
                return "PKCS8";
            }
            case 33: {
                return "PKCS8(PEM)";
            }
            case 36: {
                return "PKCS8(BER)";
            }
            case 64: {
                return "PKCS12";
            }
            case 512: {
                return "KEYSTORE";
            }
        }
        return "UNKNOWN";
    }

    static void isValidEncoding(int n) throws JMSSecurityException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 17: 
            case 20: 
            case 33: 
            case 36: 
            case 64: 
            case 512: {
                return;
            }
        }
        throw new JMSSecurityException("Invalid encoding");
    }

    static int encodingToPrecise(int n) {
        if (n == 16) {
            return 20;
        }
        if (n == 32) {
            return 33;
        }
        return n;
    }

    static int encodingNameToInt(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase("pem")) {
            return 1;
        }
        if (string.equalsIgnoreCase("der")) {
            return 2;
        }
        if (string.equalsIgnoreCase("p7") || string.equalsIgnoreCase("pkcs7") || string.equalsIgnoreCase("pkcs#7")) {
            return 17;
        }
        if (string.equalsIgnoreCase("p7b") || string.equalsIgnoreCase("pkcs7b") || string.equalsIgnoreCase("pkcs#7b")) {
            return 20;
        }
        if (string.equalsIgnoreCase("p8") || string.equalsIgnoreCase("pkcs8") || string.equalsIgnoreCase("pkcs#8")) {
            return 33;
        }
        if (string.equalsIgnoreCase("p8b") || string.equalsIgnoreCase("pkcs8b") || string.equalsIgnoreCase("pkcs#8b")) {
            return 36;
        }
        if (string.equalsIgnoreCase("p12") || string.equalsIgnoreCase("pkcs12") || string.equalsIgnoreCase("pkcs#12")) {
            return 64;
        }
        if (string.equalsIgnoreCase("jks")) {
            return 512;
        }
        return 0;
    }

    static String removeEncoding(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n > 0 && TibjmsSSL.encodingNameToInt(string.substring(0, n)) != 0) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    static int encodingFromFilename(String string) {
        int n;
        if (string == null) {
            return 0;
        }
        int n2 = string.indexOf(58);
        if (n2 > 0 && (n = TibjmsSSL.encodingNameToInt(string.substring(0, n2))) != 0) {
            return n;
        }
        n2 = string.lastIndexOf(46);
        if (n2 >= 0) {
            String string2 = string.substring(n2 + 1, string.length());
            return TibjmsSSL.encodingNameToInt(string2);
        }
        return 0;
    }

    static InputStream _fileToStream(String string) throws JMSSecurityException {
        if (string == null || string.length() == 0) {
            throw new JMSSecurityException("empty file name");
        }
        try {
            return new FileInputStream(string);
        }
        catch (IOException iOException) {
            JMSSecurityException jMSSecurityException = new JMSSecurityException("File not found or access denied: '" + string + "'");
            jMSSecurityException.setLinkedException(iOException);
            throw jMSSecurityException;
        }
    }

    static void _erasePass(char[] cArray) {
        if (cArray != null) {
            for (int j = 0; j < cArray.length; ++j) {
                cArray[j] = '\u0000';
            }
        }
    }

    static void _erasePass() {
        TibjmsSSL._erasePass(TibjmsSSL._default.password);
    }

    static void _sslTrace(PrintStream printStream, String string, Object[] objectArray) {
        TibjmsxTrace.write(printStream, "[TLS] " + string, objectArray);
    }
}

