/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsBlockingCompletionEvent;
import com.tibco.tibjms.TibjmsCompletionEventProcessor;
import com.tibco.tibjms.TibjmsDestination;
import com.tibco.tibjms.TibjmsMessage;
import com.tibco.tibjms.Tibjmsx;
import com.tibco.tibjms.TibjmsxCallbackThreadInfo;
import com.tibco.tibjms.TibjmsxConst;
import com.tibco.tibjms.TibjmsxLinkSendCallback;
import com.tibco.tibjms.TibjmsxMRD;
import com.tibco.tibjms.TibjmsxResponse;
import com.tibco.tibjms.TibjmsxSessionImp;
import com.tibco.tibjms.TibjmsxTrace;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

public class TibjmsMessageProducer
implements MessageProducer,
TibjmsxConst,
TibjmsxLinkSendCallback {
    TibjmsDestination _destination = null;
    protected TibjmsxSessionImp _session = null;
    boolean _disableMsgID = false;
    boolean _disableMsgTimestamp = false;
    int _deliveryMode = 2;
    int _priority = 4;
    long _ttl = 0L;
    long _deliveryDelay = 0L;
    long _prodid = 0L;
    int _npsend_mode = 0;
    Object _lock = new Object();
    boolean _closed = false;
    Object _trateData = null;
    Object _qrateData = null;
    long _lastCleanupMRD = 0L;
    static final long _FC_CLEANUP_TIME = 3000L;
    static final int _FC_MAX_MSGS = 1024;
    static final int _FC_MAX_BYTES = 65536;
    static final long _FC_MAX_INTERVAL = 250L;
    TibjmsCompletionEventProcessor _clEventProcessor = null;
    Message _asyncMessage = null;
    CompletionListener _asyncCompletionListener = null;

    TibjmsxMRD _getMRD(TibjmsMessage tibjmsMessage, boolean bl) {
        TibjmsxMRD tibjmsxMRD = null;
        if (this._destination != null) {
            if (this._trateData == null && bl) {
                this._trateData = new TibjmsxMRD();
            }
            return (TibjmsxMRD)this._trateData;
        }
        HashMap hashMap = null;
        if (tibjmsMessage._JMSDestination instanceof Topic) {
            if (this._trateData == null) {
                if (!bl) {
                    return null;
                }
                this._trateData = new HashMap();
            }
            hashMap = (HashMap)this._trateData;
        } else {
            if (this._qrateData == null) {
                if (!bl) {
                    return null;
                }
                this._qrateData = new HashMap();
            }
            hashMap = (HashMap)this._qrateData;
        }
        tibjmsxMRD = (TibjmsxMRD)hashMap.get(((TibjmsDestination)tibjmsMessage._JMSDestination)._address);
        if (tibjmsxMRD == null) {
            if (!bl) {
                return null;
            }
            tibjmsxMRD = new TibjmsxMRD();
            hashMap.put(((TibjmsDestination)tibjmsMessage._JMSDestination)._address, tibjmsxMRD);
        }
        return tibjmsxMRD;
    }

    void _cleanupMRD(long l) {
        if (this._destination != null) {
            return;
        }
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        if (this._lastCleanupMRD == 0L) {
            this._lastCleanupMRD = l;
            return;
        }
        if (l - this._lastCleanupMRD < 3000L) {
            return;
        }
        this._lastCleanupMRD = l;
        this._cleanupMRDHash(this._trateData, l);
        this._cleanupMRDHash(this._qrateData, l);
    }

    void _cleanupMRDHash(Object object, long l) {
        if (object == null || !(object instanceof HashMap)) {
            return;
        }
        HashMap hashMap = (HashMap)object;
        if (hashMap.size() < 1024) {
            return;
        }
        Set set = hashMap.keySet();
        Iterator iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            String string = (String)iterator2.next();
            TibjmsxMRD tibjmsxMRD = (TibjmsxMRD)hashMap.get(string);
            if (tibjmsxMRD.fc_time == 0L) {
                tibjmsxMRD.fc_time = l;
                continue;
            }
            if (l - tibjmsxMRD.fc_time < 3000L) continue;
            iterator2.remove();
        }
    }

    boolean _isClosed() {
        return this._closed || this._session._closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TibjmsMessage _publish(Destination destination, Message message, boolean bl, int n, int n2, long l, boolean bl2, CompletionListener completionListener) throws JMSException {
        TibjmsDestination tibjmsDestination = null;
        TibjmsMessage tibjmsMessage = null;
        boolean bl3 = false;
        Object object = this._lock;
        synchronized (object) {
            if (this._isClosed()) {
                throw new IllegalStateException("Producer is closed");
            }
            if (bl) {
                if (destination == null) {
                    throw new InvalidDestinationException("Destination not specified");
                }
                if (this._destination != null) {
                    throw new UnsupportedOperationException("Illegal to use destination for this producer");
                }
                if (Tibjmsx.TXSendDestCheck && this._session.getTransacted()) {
                    TibjmsMessageProducer tibjmsMessageProducer = (TibjmsMessageProducer)this._session.createProducer(destination);
                    tibjmsMessageProducer.close();
                }
            } else if (this._destination == null) {
                throw new UnsupportedOperationException("A destination is required for this producer");
            }
            if (destination != null && !(destination instanceof TibjmsDestination)) {
                throw new InvalidDestinationException("Foreign destinations not supported");
            }
            tibjmsDestination = destination == null ? this._destination : (TibjmsDestination)destination;
            if (message == null) {
                throw new MessageFormatException("Null message object");
            }
            if (!Tibjmsx.checkDeliveryMode(n, this)) {
                throw new JMSException("Invalid delivery mode: " + n);
            }
            if (n2 < 0 || n2 > 9) {
                throw new JMSException("Invalid priority value: " + n2);
            }
            if (l < 0L) {
                throw new JMSException("Invalid time to live value: " + l);
            }
            if (!(message instanceof TibjmsMessage)) {
                tibjmsMessage = TibjmsMessage._convertForeign(message);
                bl3 = true;
            } else {
                tibjmsMessage = (TibjmsMessage)message;
            }
            tibjmsMessage._prodid = this._prodid;
            tibjmsMessage._JMSPriority = n2;
            tibjmsMessage._JMSDeliveryMode = n;
            tibjmsMessage._JMSDestination = tibjmsDestination;
            tibjmsMessage._JMSMessageID = !this._disableMsgID ? this._session._msgid + Tibjmsx.getClientIDSeq() : null;
            long l2 = System.currentTimeMillis();
            long l3 = l2 + this._session._connection._getUTCoffset();
            if (!this._disableMsgTimestamp || this._deliveryDelay != 0L) {
                tibjmsMessage._JMSTimestamp = l3;
            }
            tibjmsMessage._JMSDeliveryTime = l3 + this._deliveryDelay;
            if (this._deliveryDelay != 0L) {
                tibjmsMessage._userSetdeliveryTime = true;
            }
            tibjmsMessage._JMSExpiration = l == 0L ? 0L : l3 + l;
            if (completionListener != null && this._clEventProcessor == null) {
                this._enableAsyncSending();
            }
            this._session._publish(this, tibjmsMessage, l2, completionListener);
            if (bl3) {
                message.setJMSPriority(tibjmsMessage.getJMSPriority());
                message.setJMSDeliveryMode(tibjmsMessage.getJMSDeliveryMode());
                message.setJMSDestination(tibjmsMessage.getJMSDestination());
                message.setJMSMessageID(tibjmsMessage.getJMSMessageID());
                message.setJMSTimestamp(tibjmsMessage.getJMSTimestamp());
                message.setJMSExpiration(tibjmsMessage.getJMSExpiration());
                message.setJMSDeliveryTime(tibjmsMessage.getJMSDeliveryTime());
            }
        }
        if (this._session._connection._traceTarget != 0) {
            if (destination == null && !bl2) {
                TibjmsxTrace.write(this._session._connection._traceTarget, "{0} Send conn={1,number,###0.##} sess={2,number,###0.##} prod={3,number,###0.##} msgid={4}", new Object[]{this._getTypeStr(), new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._prodid), tibjmsMessage._JMSMessageID != null ? tibjmsMessage._JMSMessageID : "{not set}"});
            } else if (destination == null && bl2) {
                TibjmsxTrace.write(this._session._connection._traceTarget, "{0} Send conn={1,number,###0.##} sess={2,number,###0.##} prod={3,number,###0.##} msgid={4} dlvmode={5,number,###0.##} pri={6,number,###0.##} ttl={7,number,###0.##}", new Object[]{this._getTypeStr(), new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._prodid), tibjmsMessage._JMSMessageID != null ? tibjmsMessage._JMSMessageID : "{not set}", new Integer(n), new Integer(n2), new Long(l)});
            } else if (destination != null && !bl2) {
                TibjmsxTrace.write(this._session._connection._traceTarget, "{0} Send conn={1,number,###0.##} sess={2,number,###0.##} prod={3,number,###0.##} dest={4} msgid={5}", new Object[]{this._getTypeStr(), new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._prodid), tibjmsDestination._address, tibjmsMessage._JMSMessageID != null ? tibjmsMessage._JMSMessageID : "{not set}"});
            } else if (destination != null && bl2) {
                TibjmsxTrace.write(this._session._connection._traceTarget, "{0} Send conn={1,number,###0.##} sess={2,number,###0.##} prod={3,number,###0.##} dest={4} msgid={5} dlvmode={6,number,###0.##} pri={7,number,###0.##} ttl={8,number,###0.##}", new Object[]{this._getTypeStr(), new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._prodid), tibjmsDestination._address, tibjmsMessage._JMSMessageID != null ? tibjmsMessage._JMSMessageID : "{not set}", new Integer(n), new Integer(n2), new Long(l)});
            }
        }
        return tibjmsMessage;
    }

    TibjmsMessageProducer(TibjmsxSessionImp tibjmsxSessionImp, long l, TibjmsDestination tibjmsDestination) throws JMSException {
        this._session = tibjmsxSessionImp;
        this._destination = tibjmsDestination;
        this._prodid = l;
    }

    protected String _getTypeStr() {
        String string = "";
        string = this instanceof TopicPublisher ? "TopicPublisher" : (this instanceof QueueSender ? "QueueSender" : "Producer");
        return string;
    }

    @Override
    public Destination getDestination() throws JMSException {
        if (this._isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
        return this._destination;
    }

    @Override
    public void setDisableMessageID(boolean bl) throws JMSException {
        if (this._isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
        this._disableMsgID = bl;
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "Producer Set DisableMessageId={0} conn={1,number,###0.##} sess={2,number,###0.##} prod={3,number,###0.##}", new Object[]{this._disableMsgID ? "true" : "false", new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._prodid)});
        }
    }

    @Override
    public boolean getDisableMessageID() throws JMSException {
        if (this._isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
        return this._disableMsgID;
    }

    @Override
    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        if (this._isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
        this._disableMsgTimestamp = bl;
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "Producer Set DisableTimeStamp={0} conn={1,number,###0.##} sess={2,number,###0.##} prod={3,number,###0.##}", new Object[]{this._disableMsgTimestamp ? "true" : "false", new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._prodid)});
        }
    }

    @Override
    public boolean getDisableMessageTimestamp() throws JMSException {
        if (this._isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
        return this._disableMsgTimestamp;
    }

    @Override
    public void setDeliveryMode(int n) throws JMSException {
        if (!Tibjmsx.checkDeliveryMode(n, this)) {
            throw new JMSException("Invalid delivery mode");
        }
        if (this._isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
        this._deliveryMode = n;
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "Producer Set DeliveryMode={0,number,###0.##} conn={1,number,###0.##} sess={2,number,###0.##} prod={3,number,###0.##}", new Object[]{new Integer(n), new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._prodid)});
        }
    }

    @Override
    public int getDeliveryMode() throws JMSException {
        if (this._isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
        return this._deliveryMode;
    }

    @Override
    public void setPriority(int n) throws JMSException {
        if (n < 0 || n > 9) {
            throw new JMSException("Invalid priority value: " + n);
        }
        if (this._isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
        this._priority = n;
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "Producer Set Priority={0,number,###0.##} conn={1,number,###0.##} sess={2,number,###0.##} prod={3,number,###0.##}", new Object[]{new Integer(this._priority), new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._prodid)});
        }
    }

    @Override
    public int getPriority() throws JMSException {
        if (this._isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
        return this._priority;
    }

    @Override
    public void setTimeToLive(long l) throws JMSException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative value");
        }
        if (this._isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
        this._ttl = l;
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "Producer Set TimeToLive={0,number,###0.##} conn={1,number,###0.##} sess={2,number,###0.##} prod={3,number,###0.##}", new Object[]{new Long(this._ttl), new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._prodid)});
        }
    }

    @Override
    public long getTimeToLive() throws JMSException {
        if (this._isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
        return this._ttl;
    }

    @Override
    public void setDeliveryDelay(long l) throws JMSException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative value");
        }
        if (this._isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
        this._deliveryDelay = l;
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "Producer Set DeliveryDelay={0,number,###0.##} conn={1,number,###0.##} sess={2,number,###0.##} prod={3,number,###0.##}", new Object[]{new Long(this._deliveryDelay), new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._prodid)});
        }
    }

    @Override
    public long getDeliveryDelay() throws JMSException {
        if (this._isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
        return this._deliveryDelay;
    }

    @Override
    public void send(Destination destination, Message message) throws JMSException {
        this._publish(destination, message, true, this._deliveryMode, this._priority, this._ttl, false, null);
    }

    @Override
    public void send(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        this._publish(destination, message, true, n, n2, l, true, null);
    }

    @Override
    public void send(Message message) throws JMSException {
        this._publish(null, message, false, this._deliveryMode, this._priority, this._ttl, false, null);
    }

    @Override
    public void send(Message message, int n, int n2, long l) throws JMSException {
        this._publish(null, message, false, n, n2, l, true, null);
    }

    @Override
    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        if (completionListener == null) {
            throw new IllegalArgumentException("null completion listener");
        }
        this._publish(destination, message, true, this._deliveryMode, this._priority, this._ttl, false, completionListener);
    }

    @Override
    public void send(Destination destination, Message message, int n, int n2, long l, CompletionListener completionListener) throws JMSException {
        if (completionListener == null) {
            throw new IllegalArgumentException("null completion listener");
        }
        this._publish(destination, message, true, n, n2, l, true, completionListener);
    }

    @Override
    public void send(Message message, CompletionListener completionListener) throws JMSException {
        if (completionListener == null) {
            throw new IllegalArgumentException("null completion listener");
        }
        this._publish(null, message, false, this._deliveryMode, this._priority, this._ttl, false, completionListener);
    }

    @Override
    public void send(Message message, int n, int n2, long l, CompletionListener completionListener) throws JMSException {
        if (completionListener == null) {
            throw new IllegalArgumentException("null completion listener");
        }
        this._publish(null, message, false, n, n2, l, true, completionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        this._checkLegalAPIUse(5);
        Object object = this._lock;
        synchronized (object) {
            if (this._closed || this._session._closed) {
                return;
            }
            this._closed = true;
        }
        if (this._session._connection._traceTarget != 0) {
            TibjmsxTrace.write(this._session._connection._traceTarget, "Producer Close conn={0,number,###0.##} sess={1,number,###0.##} prod={2,number,###0.##}", new Object[]{new Long(this._session._connection._connid), new Long(this._session._sessid), new Long(this._prodid)});
        }
        this._disableAsyncSending();
        this._session._closeProducer(this);
    }

    public String toString() {
        try {
            String string = null;
            string = this._destination == null ? (this instanceof TopicPublisher ? "topic=null" : (this instanceof QueueSender ? "queue=null" : "null")) : (this._destination instanceof Topic ? "topic=" + ((Topic)((Object)this._destination)).getTopicName() : (this._destination instanceof Queue ? "queue=" + ((Queue)((Object)this._destination)).getQueueName() : "destination=" + this._destination.toString()));
            return this._getTypeStr() + "[" + string + "]";
        }
        catch (JMSException jMSException) {
            return "MessageProducer";
        }
    }

    boolean _isAsyncSendingEnabled() {
        return this._clEventProcessor != null;
    }

    private void _enableAsyncSending() {
        if (this._clEventProcessor == null) {
            this._clEventProcessor = new TibjmsCompletionEventProcessor(this);
            this._session._addAsyncProducer(this);
        }
    }

    private void _disableAsyncSending() {
        if (this._clEventProcessor != null) {
            this._clEventProcessor.close();
            this._clEventProcessor = null;
            this._session._removeAsyncProducer(this);
        }
    }

    private void _checkLegalAPIUse(int n) throws IllegalStateException {
        TibjmsxCallbackThreadInfo tibjmsxCallbackThreadInfo = Tibjmsx.ListenerCallbackArgs.get();
        if (tibjmsxCallbackThreadInfo == null) {
            return;
        }
        if (tibjmsxCallbackThreadInfo.getProducer() == this) {
            throw new IllegalStateException("Illegal to " + TibjmsxCallbackThreadInfo.actions[n] + " in a completion listener.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _waitForCompletionListeners(boolean bl, boolean bl2) {
        TibjmsBlockingCompletionEvent tibjmsBlockingCompletionEvent = null;
        Object object = this._lock;
        synchronized (object) {
            if (!this._isAsyncSendingEnabled()) {
                return;
            }
            if (!this._clEventProcessor.isEmpty() && bl) {
                tibjmsBlockingCompletionEvent = this._clEventProcessor.addBlockingEvent();
            }
        }
        if (tibjmsBlockingCompletionEvent != null) {
            try {
                tibjmsBlockingCompletionEvent.block();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (bl2) {
            object = this._lock;
            synchronized (object) {
                this._disableAsyncSending();
            }
        }
    }

    void _setAsyncSendData(TibjmsMessage tibjmsMessage, CompletionListener completionListener) {
        this._asyncCompletionListener = completionListener;
        this._asyncMessage = tibjmsMessage;
    }

    @Override
    public void linkPreSend(TibjmsxResponse tibjmsxResponse) {
        if (tibjmsxResponse.id > 0) {
            tibjmsxResponse.completionEvent = this._clEventProcessor.registerServerResponse(this._asyncCompletionListener, this._asyncMessage);
        }
    }

    @Override
    public boolean linkSendError(TibjmsxResponse tibjmsxResponse) {
        if (tibjmsxResponse.completionEvent == null) {
            return true;
        }
        return tibjmsxResponse.completionEvent.cancel();
    }
}

