/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsBytesMessage;
import com.tibco.tibjms.TibjmsDestination;
import com.tibco.tibjms.TibjmsMapMessage;
import com.tibco.tibjms.TibjmsObjectMessage;
import com.tibco.tibjms.TibjmsSession;
import com.tibco.tibjms.TibjmsStreamMessage;
import com.tibco.tibjms.TibjmsTextMessage;
import com.tibco.tibjms.Tibjmsx;
import com.tibco.tibjms.TibjmsxConst;
import com.tibco.tibjms.TibjmsxStream;
import java.io.EOFException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class TibjmsMessage
implements Message,
Serializable,
Cloneable,
TibjmsxConst {
    private static final long serialVersionUID = -1496498797568484644L;
    static final String _NR = "Message not readable";
    static final String _NW = "Message not writeable";
    static final String _NB = "Message body not writeable";
    static final String _NP = "Message properties not writeable";
    static final String _NN = "null or empty name";
    static final String _EOM = "End of message stream";
    int _type = 6;
    transient int _responseID = 0;
    long _sequenceID = 0L;
    private static int _cmid_ = 0;
    private static Object _cmidLock = new Object();
    final int _cmid = TibjmsMessage._getCMID();
    transient MessageConsumer _consumer = null;
    transient boolean _inXA = false;
    transient TibjmsSession _session = null;
    transient long _sessid = 0L;
    transient long _prodid = 0L;
    int _linkType = -1;
    byte[] _wire = null;
    boolean _propsLifted = true;
    int _propsOffset = 0;
    boolean _bodyLifted = true;
    int _bodyOffset = 0;
    int _totalSize = 0;
    int _headersSize = 0;
    int _propsSize = 0;
    int _bodySize = 0;
    String _JMSMessageID = null;
    long _JMSTimestamp = 0L;
    String _JMSCorrelationID = null;
    Destination _JMSDestination = null;
    Destination _JMSReplyTo = null;
    int _JMSDeliveryMode = 2;
    boolean _JMSRedelivered = false;
    String _JMSType = null;
    long _JMSExpiration = 0L;
    int _JMSPriority = 4;
    long _JMSDeliveryTime = 0L;
    boolean _compressed = false;
    boolean _userSetdeliveryTime = false;
    int _deliveryCount = 0;
    String _encoding = null;
    boolean _nbAsyncSendRequest = false;
    HashMap _props = null;
    transient boolean _propsReadOnly = false;
    transient boolean _readState = false;
    static EmptyEnum emptyEnum = new EmptyEnum();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int _getCMID() {
        Object object = _cmidLock;
        synchronized (object) {
            return ++_cmid_;
        }
    }

    public Object clone() {
        TibjmsMessage tibjmsMessage;
        try {
            tibjmsMessage = (TibjmsMessage)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        tibjmsMessage._wire = this._wire;
        tibjmsMessage._compressed = this._compressed;
        tibjmsMessage._propsLifted = this._propsLifted;
        tibjmsMessage._propsOffset = this._propsOffset;
        tibjmsMessage._bodyLifted = this._bodyLifted;
        tibjmsMessage._bodyOffset = this._bodyOffset;
        tibjmsMessage._encoding = this._encoding;
        tibjmsMessage._type = this._type;
        tibjmsMessage._sequenceID = this._sequenceID;
        tibjmsMessage._JMSMessageID = this._JMSMessageID;
        tibjmsMessage._JMSTimestamp = this._JMSTimestamp;
        tibjmsMessage._JMSCorrelationID = this._JMSCorrelationID;
        tibjmsMessage._JMSDestination = this._JMSDestination;
        tibjmsMessage._JMSReplyTo = this._JMSReplyTo;
        tibjmsMessage._JMSDeliveryMode = this._JMSDeliveryMode;
        tibjmsMessage._JMSRedelivered = this._JMSRedelivered;
        tibjmsMessage._JMSType = this._JMSType;
        tibjmsMessage._JMSExpiration = this._JMSExpiration;
        tibjmsMessage._JMSPriority = this._JMSPriority;
        tibjmsMessage._propsReadOnly = this._propsReadOnly;
        if (this._props != null) {
            tibjmsMessage._props = (HashMap)this._props.clone();
        }
        tibjmsMessage._readState = this._readState;
        return tibjmsMessage;
    }

    static int getPropType(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            return 9;
        }
        if (object instanceof Integer) {
            return 5;
        }
        if (object instanceof Long) {
            return 6;
        }
        if (object instanceof Boolean) {
            return 1;
        }
        if (object instanceof Short) {
            return 4;
        }
        if (object instanceof Byte) {
            return 2;
        }
        if (object instanceof Double) {
            return 8;
        }
        if (object instanceof Float) {
            return 7;
        }
        return 255;
    }

    static int getFieldType(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            return 9;
        }
        if (object instanceof Integer) {
            return 5;
        }
        if (object instanceof Long) {
            return 6;
        }
        if (object instanceof Boolean) {
            return 1;
        }
        if (object instanceof Short) {
            return 4;
        }
        if (object instanceof Double) {
            return 8;
        }
        if (object instanceof byte[]) {
            return 10;
        }
        if (object instanceof Byte) {
            return 2;
        }
        if (object instanceof Float) {
            return 7;
        }
        if (object instanceof Character) {
            return 3;
        }
        return 255;
    }

    static int getExtendedType(Object object) {
        if (object == null) {
            return 255;
        }
        if (object instanceof TibjmsMapMessage) {
            return 11;
        }
        if (object instanceof TibjmsStreamMessage) {
            return 18;
        }
        if (object instanceof short[]) {
            return 12;
        }
        if (object instanceof int[]) {
            return 13;
        }
        if (object instanceof long[]) {
            return 14;
        }
        if (object instanceof float[]) {
            return 15;
        }
        if (object instanceof double[]) {
            return 16;
        }
        return 255;
    }

    static String getTypeName(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof byte[]) {
            return "byte[]";
        }
        String string = object.getClass().getName();
        if (string.length() < 1) {
            return string;
        }
        int n = string.lastIndexOf(46, string.length() - 1);
        if (n >= 0 && n < string.length() - 1) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }

    byte[] _copyBytes(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return new byte[0];
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    TibjmsMessage() {
        this._propsReadOnly = false;
    }

    TibjmsMessage(int n) {
        this._type = n;
        this._propsReadOnly = false;
    }

    TibjmsMessage(int n, int n2, int n3) {
        this._type = n;
        this._propsReadOnly = false;
        this._responseID = n2;
        this._JMSPriority = n3;
    }

    TibjmsMessage(TibjmsSession tibjmsSession) {
        this._session = tibjmsSession;
        this._propsReadOnly = false;
    }

    TibjmsMessage(TibjmsSession tibjmsSession, int n) {
        this._type = n;
        this._session = tibjmsSession;
        this._propsReadOnly = false;
    }

    TibjmsMessage(byte[] byArray, int n) throws JMSException {
        this._read(byArray, n);
    }

    void _read(byte[] byArray, int n) throws JMSException {
        this._wire = byArray;
        this._read(n);
        this._propsReadOnly = true;
    }

    public static TibjmsMessage createFromBytes(byte[] byArray) throws JMSException {
        return TibjmsMessage._createFromBytes(byArray, 1);
    }

    static TibjmsMessage createFromBytes(byte[] byArray, int n) throws JMSException {
        return TibjmsMessage._createFromBytes(byArray, n);
    }

    @Override
    public String getJMSMessageID() throws JMSException {
        return this._JMSMessageID;
    }

    @Override
    public void setJMSMessageID(String string) throws JMSException {
        this._JMSMessageID = string;
    }

    @Override
    public long getJMSTimestamp() throws JMSException {
        return this._JMSTimestamp;
    }

    @Override
    public void setJMSTimestamp(long l) throws JMSException {
        this._JMSTimestamp = l;
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        throw new UnsupportedOperationException("CorrelationID as byte array is not supported");
    }

    @Override
    public void setJMSCorrelationIDAsBytes(byte[] byArray) throws JMSException {
        throw new UnsupportedOperationException("CorrelationID as byte array is not supported");
    }

    @Override
    public void setJMSCorrelationID(String string) throws JMSException {
        this._JMSCorrelationID = string;
    }

    @Override
    public String getJMSCorrelationID() throws JMSException {
        return this._JMSCorrelationID;
    }

    @Override
    public Destination getJMSReplyTo() throws JMSException {
        return this._JMSReplyTo;
    }

    @Override
    public void setJMSReplyTo(Destination destination) throws JMSException {
        this._JMSReplyTo = destination;
    }

    @Override
    public Destination getJMSDestination() throws JMSException {
        return this._JMSDestination;
    }

    @Override
    public void setJMSDestination(Destination destination) throws JMSException {
        this._JMSDestination = destination;
    }

    @Override
    public int getJMSDeliveryMode() throws JMSException {
        return this._JMSDeliveryMode;
    }

    @Override
    public void setJMSDeliveryMode(int n) throws JMSException {
        if (!Tibjmsx.checkDeliveryMode(n, this._session)) {
            throw new JMSException("Invalid delivery mode");
        }
        this._JMSDeliveryMode = n;
    }

    @Override
    public boolean getJMSRedelivered() throws JMSException {
        return this._JMSRedelivered;
    }

    @Override
    public void setJMSRedelivered(boolean bl) throws JMSException {
        this._JMSRedelivered = bl;
    }

    @Override
    public String getJMSType() throws JMSException {
        return this._JMSType;
    }

    @Override
    public void setJMSType(String string) throws JMSException {
        this._JMSType = string;
    }

    @Override
    public long getJMSExpiration() throws JMSException {
        return this._JMSExpiration;
    }

    @Override
    public void setJMSExpiration(long l) throws JMSException {
        this._JMSExpiration = l;
    }

    @Override
    public int getJMSPriority() throws JMSException {
        return this._JMSPriority;
    }

    @Override
    public void setJMSPriority(int n) throws JMSException {
        if (n < 0 || n > 9) {
            throw new JMSException("Priority out of range");
        }
        this._JMSPriority = n;
    }

    @Override
    public long getJMSDeliveryTime() throws JMSException {
        return this._JMSDeliveryTime;
    }

    @Override
    public void setJMSDeliveryTime(long l) throws JMSException {
        this._JMSDeliveryTime = l;
    }

    @Override
    public void clearProperties() throws JMSException {
        if (this._props != null) {
            this._props.clear();
        }
        this._propsReadOnly = false;
        this._propsLifted = true;
        this._checkCache();
    }

    @Override
    public boolean propertyExists(String string) throws JMSException {
        if (!this._propsLifted) {
            this._liftProperties();
        }
        return this._props != null ? this._props.containsKey(string) : false;
    }

    @Override
    public boolean getBooleanProperty(String string) throws JMSException {
        if (!this._propsLifted) {
            this._liftProperties();
        }
        return TibjmsMessage.asBoolean(this._props == null ? null : this._props.get(string), string);
    }

    @Override
    public byte getByteProperty(String string) throws JMSException {
        if (!this._propsLifted) {
            this._liftProperties();
        }
        return TibjmsMessage.asByte(this._props == null ? null : this._props.get(string), string);
    }

    @Override
    public short getShortProperty(String string) throws JMSException {
        if (!this._propsLifted) {
            this._liftProperties();
        }
        return TibjmsMessage.asShort(this._props == null ? null : this._props.get(string), string);
    }

    @Override
    public int getIntProperty(String string) throws JMSException {
        if (!this._propsLifted) {
            this._liftProperties();
        }
        return TibjmsMessage.asInteger(this._props == null ? null : this._props.get(string), string);
    }

    @Override
    public long getLongProperty(String string) throws JMSException {
        if (!this._propsLifted) {
            this._liftProperties();
        }
        return TibjmsMessage.asLong(this._props == null ? null : this._props.get(string), string);
    }

    @Override
    public float getFloatProperty(String string) throws JMSException {
        if (!this._propsLifted) {
            this._liftProperties();
        }
        return TibjmsMessage.asFloat(this._props == null ? null : this._props.get(string), string);
    }

    @Override
    public double getDoubleProperty(String string) throws JMSException {
        if (!this._propsLifted) {
            this._liftProperties();
        }
        return TibjmsMessage.asDouble(this._props == null ? null : this._props.get(string), string);
    }

    @Override
    public String getStringProperty(String string) throws JMSException {
        if (!this._propsLifted) {
            this._liftProperties();
        }
        return TibjmsMessage.asString(this._props == null ? null : this._props.get(string), string);
    }

    @Override
    public Object getObjectProperty(String string) throws JMSException {
        if (!this._propsLifted) {
            this._liftProperties();
        }
        return this._props != null ? this._props.get(string) : null;
    }

    byte[] _getBytesProperty(String string) throws JMSException {
        Object var2_2;
        if (!this._propsLifted) {
            this._liftProperties();
        }
        Object v0 = var2_2 = this._props != null ? this._props.get(string) : null;
        if (var2_2 == null || var2_2 instanceof byte[]) {
            return var2_2;
        }
        throw new MessageFormatException("Invalid object type");
    }

    @Override
    public Enumeration getPropertyNames() throws JMSException {
        if (!this._propsLifted) {
            this._liftProperties();
        }
        if (this._props != null) {
            return Collections.enumeration(this._props.keySet());
        }
        return emptyEnum;
    }

    @Override
    public void setBooleanProperty(String string, boolean bl) throws JMSException {
        if (this._propsReadOnly) {
            throw new MessageNotWriteableException(_NP);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(_NN);
        }
        if (this._props == null) {
            this._props = new HashMap();
        }
        this._props.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setByteProperty(String string, byte by) throws JMSException {
        if (this._propsReadOnly) {
            throw new MessageNotWriteableException(_NP);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(_NN);
        }
        if (this._props == null) {
            this._props = new HashMap();
        }
        this._props.put(string, new Byte(by));
    }

    @Override
    public void setShortProperty(String string, short s) throws JMSException {
        if (this._propsReadOnly) {
            throw new MessageNotWriteableException(_NP);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(_NN);
        }
        if (this._props == null) {
            this._props = new HashMap();
        }
        this._props.put(string, new Short(s));
    }

    @Override
    public void setIntProperty(String string, int n) throws JMSException {
        if (this._propsReadOnly) {
            throw new MessageNotWriteableException(_NP);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(_NN);
        }
        if (this._props == null) {
            this._props = new HashMap();
        }
        this._props.put(string, new Integer(n));
    }

    @Override
    public void setLongProperty(String string, long l) throws JMSException {
        if (this._propsReadOnly) {
            throw new MessageNotWriteableException(_NP);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(_NN);
        }
        if (this._props == null) {
            this._props = new HashMap();
        }
        this._props.put(string, new Long(l));
    }

    @Override
    public void setFloatProperty(String string, float f) throws JMSException {
        if (this._propsReadOnly) {
            throw new MessageNotWriteableException(_NP);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(_NN);
        }
        if (this._props == null) {
            this._props = new HashMap();
        }
        this._props.put(string, new Float(f));
    }

    @Override
    public void setDoubleProperty(String string, double d) throws JMSException {
        if (this._propsReadOnly) {
            throw new MessageNotWriteableException(_NP);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(_NN);
        }
        if (this._props == null) {
            this._props = new HashMap();
        }
        this._props.put(string, new Double(d));
    }

    @Override
    public void setStringProperty(String string, String string2) throws JMSException {
        if (this._propsReadOnly) {
            throw new MessageNotWriteableException(_NP);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(_NN);
        }
        if (this._props == null) {
            this._props = new HashMap();
        }
        this._props.put(string, string2);
    }

    @Override
    public void setObjectProperty(String string, Object object) throws JMSException {
        if (this._propsReadOnly) {
            throw new MessageNotWriteableException(_NP);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(_NN);
        }
        if (object != null && TibjmsMessage.getPropType(object) == 255) {
            throw new MessageFormatException("Invalid property value of class " + object.getClass().getName());
        }
        if (this._props == null) {
            this._props = new HashMap();
        }
        this._props.put(string, object);
    }

    void _setBytesProperty(String string, byte[] byArray, int n, int n2) throws JMSException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.setBytesProperty(string, byArray2);
    }

    public void setBytesProperty(String string, byte[] byArray) throws JMSException {
        if (this._propsReadOnly) {
            throw new MessageNotWriteableException(_NP);
        }
        if (this._props == null) {
            this._props = new HashMap();
        }
        this._props.put(string, byArray);
    }

    @Override
    public void acknowledge() throws JMSException, IllegalStateException {
        TibjmsSession tibjmsSession = this._session;
        if (tibjmsSession != null && tibjmsSession.shouldTrace()) {
            tibjmsSession.getTracer().trace_CLI_TRC_MESSAGE_ACKNOWLEDGE(this);
        }
        if (tibjmsSession == null || this._sequenceID == 0L) {
            return;
        }
        tibjmsSession._confirmNonAuto(this);
    }

    void recover() throws JMSException, IllegalStateException {
        TibjmsSession tibjmsSession = this._session;
        if (tibjmsSession != null && tibjmsSession.shouldTrace()) {
            tibjmsSession.getTracer().trace_CLI_TRC_MESSAGE_RECOVER(this);
        }
        if (tibjmsSession == null || this._sequenceID == 0L) {
            throw new IllegalArgumentException("null or invalid message");
        }
        tibjmsSession._recoverOneMsg(this);
    }

    @Override
    public void clearBody() throws JMSException {
        this._bodyLifted = true;
        this._checkCache();
        this._readState = false;
    }

    static MessageFormatException _makeEx(Object object, String string, String string2) {
        String string3;
        String string4 = string3 = object == null ? "null" : object.getClass().getName();
        if (string == null) {
            return new MessageFormatException("Invalid conversion", "Can not convert " + string3 + " to " + string2 + " value");
        }
        return new MessageFormatException("Invalid conversion", "Name='" + string + "'. Can not convert " + string3 + " to " + string2 + " value");
    }

    final char asChar(Object object, String string) throws JMSException {
        if (object != null) {
            if (object instanceof Character) {
                return ((Character)object).charValue();
            }
            throw TibjmsMessage._makeEx(object, string, "char");
        }
        throw new NullPointerException("Not found");
    }

    static final boolean asBoolean(Object object, String string) throws JMSException {
        if (object == null) {
            return Boolean.valueOf(null);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw TibjmsMessage._makeEx(object, string, "boolean");
    }

    static final byte asByte(Object object, String string) throws JMSException {
        if (object == null) {
            return Byte.parseByte(null);
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof String) {
            return Byte.parseByte((String)object);
        }
        throw TibjmsMessage._makeEx(object, string, "byte");
    }

    static final short asShort(Object object, String string) throws JMSException {
        if (object == null) {
            return Short.parseShort(null);
        }
        if (object instanceof Short) {
            return (Short)object;
        }
        if (object instanceof String) {
            return Short.parseShort((String)object);
        }
        if (object instanceof Byte) {
            return ((Byte)object).shortValue();
        }
        throw TibjmsMessage._makeEx(object, string, "short");
    }

    static final int asInteger(Object object, String string) throws JMSException {
        if (object == null) {
            return Integer.parseInt(null);
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Short) {
            return ((Short)object).intValue();
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        if (object instanceof Byte) {
            return ((Byte)object).intValue();
        }
        throw TibjmsMessage._makeEx(object, string, "int");
    }

    static final long asLong(Object object, String string) throws JMSException {
        if (object == null) {
            return Long.parseLong(null);
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Short) {
            return ((Short)object).longValue();
        }
        if (object instanceof String) {
            return Long.parseLong((String)object);
        }
        if (object instanceof Byte) {
            return ((Byte)object).longValue();
        }
        throw TibjmsMessage._makeEx(object, string, "long");
    }

    static final float asFloat(Object object, String string) throws JMSException {
        if (object == null) {
            return Float.parseFloat(null);
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof String) {
            return Float.parseFloat((String)object);
        }
        throw TibjmsMessage._makeEx(object, string, "float");
    }

    static final double asDouble(Object object, String string) throws JMSException {
        if (object == null) {
            return Double.parseDouble(null);
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        throw TibjmsMessage._makeEx(object, string, "double");
    }

    static final String asString(Object object, String string) throws JMSException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof byte[]) {
            throw TibjmsMessage._makeEx(object, string, "String");
        }
        return object.toString();
    }

    final byte[] asBytes(Object object, String string, boolean bl) throws JMSException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            if (!bl) {
                return (byte[])object;
            }
            byte[] byArray = (byte[])object;
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            return byArray2;
        }
        throw TibjmsMessage._makeEx(object, string, "byte[]");
    }

    static String getDeliveryModeName(int n) {
        if (n == 2) {
            return "PERSISTENT";
        }
        if (n == 1) {
            return "NON_PERSISTENT";
        }
        return String.valueOf(n);
    }

    static String getTimeName(long l) {
        if (l == 0L) {
            return "0";
        }
        return new Date(l).toString();
    }

    String _getMsgTypeName(int n) {
        String string = "[" + n + "]";
        switch (n) {
            case 1: {
                return string + "_BYTES_MSG_";
            }
            case 2: {
                return string + "_STREAM_MSG_";
            }
            case 3: {
                return string + "_TEXT_MSG_";
            }
            case 4: {
                return string + "_OBJECT_MSG_";
            }
            case 5: {
                return string + "_MAP_MSG_";
            }
            case 6: {
                return string + "_DATA_MSG_";
            }
            case 9: {
                return string + "_CONFIRM_";
            }
            case 10: {
                return string + "_RESPONSE_OK_";
            }
            case 11: {
                return string + "_RESPONSE_ERR_";
            }
            case 12: {
                return string + "_INIT_CONNECTION_";
            }
            case 13: {
                return string + "_DESTROY_CONNECTION_";
            }
            case 14: {
                return string + "_START_CONNECTION_";
            }
            case 15: {
                return string + "_STOP_CONNECTION_";
            }
            case 16: {
                return string + "_INIT_SESSION_";
            }
            case 17: {
                return string + "_DESTROY_SESSION_";
            }
            case 18: {
                return string + "_RECOVER_SESSION_";
            }
            case 105: {
                return string + "_RECOVER_MSG_";
            }
            case 19: {
                return string + "_COMMIT_SESSION_";
            }
            case 20: {
                return string + "_ROLLBACK_SESSION_";
            }
            case 21: {
                return string + "_INIT_CONSUMER_";
            }
            case 22: {
                return string + "_DESTROY_CONSUMER_";
            }
            case 23: {
                return string + "_INIT_PRODUCER_";
            }
            case 24: {
                return string + "_DESTROY_PRODUCER_";
            }
            case 25: {
                return string + "_UNSUBSCRIBE_CONSUMER_";
            }
            case 30: {
                return string + "_FLOW_REQUEST_";
            }
            case 31: {
                return string + "_FLOW_RESPONSE_";
            }
            case 32: {
                return string + "_INIT_BROWSER_";
            }
            case 33: {
                return string + "_DESTROY_BROWSER_";
            }
            case 34: {
                return string + "_BROWSER_RETRIEVE_";
            }
            case 35: {
                return string + "_TMP_DEST_DESTROY_";
            }
            case 36: {
                return string + "_PURGE_RECORD_";
            }
            case 37: {
                return string + "_SET_CLIENTID_";
            }
        }
        return string + "???";
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        String string = "";
        if (bl) {
            string = string + "Type=" + this._getMsgTypeName(this._type) + " rID=" + this._responseID + " seqID=" + this._sequenceID;
        }
        int n = this._type;
        if (!bl && n <= 6) {
            string = string + " Header={";
            string = string + " JMSMessageID={" + this._JMSMessageID + "}";
            string = string + " JMSDestination={" + this._JMSDestination + "}";
            string = string + " JMSReplyTo={" + this._JMSReplyTo + "}";
            string = string + " JMSDeliveryMode={" + TibjmsMessage.getDeliveryModeName(this._JMSDeliveryMode) + "}";
            string = string + " JMSRedelivered={" + this._JMSRedelivered + "}";
            string = string + " JMSCorrelationID={" + this._JMSCorrelationID + "}";
            string = string + " JMSType={" + this._JMSType + "}";
            string = string + " JMSTimestamp={" + TibjmsMessage.getTimeName(this._JMSTimestamp) + "}";
            string = string + " JMSDeliveryTime={" + TibjmsMessage.getTimeName(this._JMSDeliveryTime) + "}";
            string = string + " JMSExpiration={" + TibjmsMessage.getTimeName(this._JMSExpiration) + "}";
            string = string + " JMSPriority={" + this._JMSPriority + "}";
            string = string + " }";
        }
        try {
            Enumeration enumeration = this.getPropertyNames();
            string = string + " Properties={";
            while (this._props != null && enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                string = string + " " + string2 + "={" + this._toTypedString(this._props.get(string2)) + "}";
            }
            string = string + " }";
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return string;
    }

    String _toString(Object object) {
        if (object != null && TibjmsMessage.getFieldType(object) == 10) {
            byte[] byArray = (byte[])object;
            return "byte[] length=" + byArray.length;
        }
        return "" + object;
    }

    String _toTypedString(Object object) {
        if (object == null) {
            return null;
        }
        String string = "";
        String string2 = "";
        int n = TibjmsMessage.getFieldType(object);
        if (n != 255) {
            string2 = TibjmsMessage.getTypeName(object);
        } else {
            n = TibjmsMessage.getExtendedType(object);
        }
        switch (n) {
            case 10: {
                byte[] byArray = (byte[])object;
                string = String.valueOf(byArray.length) + " bytes";
                return string2 + ":" + string;
            }
            case 11: {
                return "MapMsg:{" + ((TibjmsMapMessage)object)._fieldsToString() + " }";
            }
            case 18: {
                return "StreamMsg:{" + ((TibjmsStreamMessage)object)._fieldsToString() + " }";
            }
            case 12: {
                return "short-array:[" + ((short[])object).length + " elements]";
            }
            case 13: {
                return "int-array:[" + ((int[])object).length + " elements]";
            }
            case 14: {
                return "long-array:[" + ((long[])object).length + " elements]";
            }
            case 15: {
                return "float-array:[" + ((float[])object).length + " elements]";
            }
            case 16: {
                return "double-array:[" + ((double[])object).length + " elements]";
            }
            case 255: {
                return "<unknown type>";
            }
        }
        return string2 + ":" + object.toString();
    }

    int writeHeaders(TibjmsxStream tibjmsxStream, boolean bl) throws JMSException {
        int n;
        boolean bl2;
        if (this._JMSDestination != null && !(this._JMSDestination instanceof TibjmsDestination)) {
            throw new InvalidDestinationException("Foreign Destinations not supported");
        }
        if (this._JMSReplyTo != null && !(this._JMSReplyTo instanceof TibjmsDestination)) {
            throw new InvalidDestinationException("Foreign Destinations not supported in JMSReplyTo");
        }
        int n2 = 0;
        int n3 = 0;
        tibjmsxStream.writeByte(22);
        int n4 = tibjmsxStream.curpos;
        tibjmsxStream.skipWrite(2);
        int n5 = tibjmsxStream.curpos;
        Object object = this.getObjectProperty("JMS_TIBCO_PRESERVE_UNDELIVERED");
        if (object != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
            n3 |= 1;
        }
        if ((object = this.getObjectProperty("JMS_TIBCO_DISABLE_SENDER")) != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
            n3 |= 2;
        }
        if (this._props != null && this._props.containsKey("JMS_TIBCO_MSG_TRACE")) {
            n3 |= 4;
            object = this.getObjectProperty("JMS_TIBCO_MSG_TRACE");
            if (object != null && object instanceof String && ((String)object).equalsIgnoreCase("body")) {
                n3 |= 8;
            }
        }
        if (this._inXA) {
            n3 |= 0x10;
        }
        if (this._userSetdeliveryTime) {
            n3 |= 0x20;
        }
        boolean bl3 = bl2 = this._session != null ? this._session._useJMS20CompliantDeliveryCount() : true;
        if (bl2) {
            n3 |= 0x40;
        }
        if (this._nbAsyncSendRequest) {
            n3 |= 0x100;
        }
        tibjmsxStream.writeByte((byte)this._JMSPriority);
        tibjmsxStream.writeByte((byte)this._JMSDeliveryMode);
        tibjmsxStream.writeByte(this._JMSRedelivered ? 1 : 0);
        tibjmsxStream.writeVarLong(this._session != null ? this._session._getSessid() : 0L);
        tibjmsxStream.writeDestination((TibjmsDestination)this._JMSDestination);
        tibjmsxStream.writeVarLong(this._JMSExpiration);
        if (this._prodid != 0L) {
            tibjmsxStream.writeByte(62);
            tibjmsxStream.writeTypedLong(this._prodid);
        }
        if (this._JMSTimestamp != 0L) {
            tibjmsxStream.writeByte(50);
            tibjmsxStream.writeLong(this._JMSTimestamp);
        }
        if (this._JMSReplyTo != null) {
            tibjmsxStream.writeByte(52);
            tibjmsxStream.writeDestination((TibjmsDestination)this._JMSReplyTo);
        }
        if (this._JMSType != null) {
            tibjmsxStream.writeByte(53);
            tibjmsxStream.writeString(this._JMSType, false);
        }
        if (this._JMSMessageID != null) {
            tibjmsxStream.writeByte(54);
            tibjmsxStream.writeString(this._JMSMessageID, false);
        }
        if (this._JMSCorrelationID != null) {
            tibjmsxStream.writeByte(55);
            tibjmsxStream.writeString(this._JMSCorrelationID, false);
        }
        if (bl) {
            tibjmsxStream.writeByte(61);
            n2 = tibjmsxStream.curpos;
            tibjmsxStream.writeByte(1);
        }
        tibjmsxStream.writeByte(63);
        tibjmsxStream.writeTypedLong(n3);
        String string = this._encoding;
        if (string == null) {
            string = Tibjmsx.encoding;
        }
        if (string != null) {
            tibjmsxStream.writeByte(65);
            tibjmsxStream.writeString(string);
        }
        tibjmsxStream.writeByte(73);
        tibjmsxStream.writeByte(6);
        tibjmsxStream.writeLong(this._JMSDeliveryTime);
        if (bl2) {
            tibjmsxStream.writeByte(64);
            tibjmsxStream.writeByte(5);
            tibjmsxStream.writeInt(0);
        }
        if ((n = tibjmsxStream.curpos) - n5 > 65536) {
            throw new JMSException("Insufficient buffer for message header");
        }
        tibjmsxStream.curpos = n4;
        tibjmsxStream.writeShort(n - n5);
        tibjmsxStream.curpos = n;
        this._headersSize = n - n5;
        if (string != null) {
            tibjmsxStream.encoding = string;
        }
        return n2;
    }

    void readHeaders(TibjmsxStream tibjmsxStream) throws EOFException, JMSException {
        int n;
        this._headersSize = n = tibjmsxStream.readUnsignedShort();
        int n2 = tibjmsxStream.curpos;
        this._JMSPriority = tibjmsxStream.readByte();
        this._JMSDeliveryMode = tibjmsxStream.readByte();
        this._deliveryCount = tibjmsxStream.readUnsignedByte() + 1;
        this._JMSRedelivered = this._deliveryCount != 1;
        this._sessid = tibjmsxStream.readVarLong();
        this._JMSDestination = tibjmsxStream.readDestination();
        this._JMSExpiration = tibjmsxStream.readVarLong();
        if (tibjmsxStream.curpos > n2 + n) {
            throw new JMSException("Corrupted message headers");
        }
        block12: while (tibjmsxStream.curpos < n2 + n) {
            int n3 = tibjmsxStream.readUnsignedByte();
            switch (n3) {
                case 62: {
                    tibjmsxStream.skipObject();
                    continue block12;
                }
                case 50: {
                    this._JMSTimestamp = tibjmsxStream.readLong();
                    continue block12;
                }
                case 73: {
                    this._JMSDeliveryTime = tibjmsxStream.readTypedLong();
                    continue block12;
                }
                case 53: {
                    this._JMSType = tibjmsxStream.readString(false);
                    continue block12;
                }
                case 54: {
                    this._JMSMessageID = tibjmsxStream.readString(false);
                    continue block12;
                }
                case 55: {
                    this._JMSCorrelationID = tibjmsxStream.readString(false);
                    continue block12;
                }
                case 52: {
                    this._JMSReplyTo = tibjmsxStream.readDestination();
                    continue block12;
                }
                case 61: {
                    this._compressed = tibjmsxStream.readByte() == 1;
                    continue block12;
                }
                case 64: {
                    int n4 = (int)tibjmsxStream.readTypedLong() + 1;
                    if (n4 <= this._deliveryCount) continue block12;
                    this._deliveryCount = n4;
                    continue block12;
                }
                case 65: {
                    this._encoding = tibjmsxStream.readString(false);
                    continue block12;
                }
            }
            tibjmsxStream.readObject();
        }
        if (this._encoding != null) {
            tibjmsxStream.encoding = this._encoding;
        }
        if (tibjmsxStream.curpos != n2 + n) {
            throw new JMSException("Corrupted message headers");
        }
    }

    void writeProperties(TibjmsxStream tibjmsxStream) throws JMSException {
        if (this._props == null) {
            return;
        }
        if (this._props.size() == 0) {
            return;
        }
        tibjmsxStream.writeByte(23);
        int n = tibjmsxStream.curpos;
        tibjmsxStream.skipWrite(4);
        int n2 = tibjmsxStream.curpos;
        Set set = this._props.entrySet();
        for (Map.Entry entry : set) {
            tibjmsxStream.writeString((String)entry.getKey(), false);
            tibjmsxStream.writeObject(entry.getValue(), 255, true);
        }
        int n3 = tibjmsxStream.curpos;
        tibjmsxStream.curpos = n;
        tibjmsxStream.writeInt(n3 - n2);
        tibjmsxStream.curpos = n3;
        this._propsSize = n3 - n2;
    }

    private final void readProperties(TibjmsxStream tibjmsxStream) throws JMSException {
        try {
            int n = tibjmsxStream.readInt();
            int n2 = tibjmsxStream.curpos;
            if (tibjmsxStream.curpos == n2 + n) {
                return;
            }
            if (this._props == null) {
                this._props = new HashMap();
            }
            while (tibjmsxStream.curpos < n2 + n) {
                String string = tibjmsxStream.readString(false);
                Object object = tibjmsxStream.readObject();
                if (string == null || string.equals("JMSXDeliveryCount")) continue;
                this._props.put(string, object);
            }
            if (tibjmsxStream.curpos != n2 + n) {
                throw new JMSException("Corrupted message properties");
            }
        }
        catch (EOFException eOFException) {
            throw new JMSException("Corrupted message");
        }
    }

    public void write(TibjmsxStream tibjmsxStream, boolean bl) throws JMSException {
        Object object;
        int n = 0;
        boolean bl2 = this._hasBody();
        tibjmsxStream.encoding = null;
        if (!bl && bl2 && this._type <= 6 && (object = this.getObjectProperty("JMS_TIBCO_COMPRESS")) != null && object instanceof Boolean) {
            bl = (Boolean)object;
        }
        if (bl && !bl2) {
            bl = false;
        }
        if (bl && (this._session == null || !this._session._allowsCompression())) {
            bl = false;
        }
        tibjmsxStream.skipWrite(8);
        tibjmsxStream.writeByte(this._type);
        tibjmsxStream.writeInt(this._responseID);
        if (this._type <= 6) {
            n = this.writeHeaders(tibjmsxStream, bl);
        }
        this.writeProperties(tibjmsxStream);
        this._bodySize = 0;
        if (bl2) {
            int n2 = tibjmsxStream.curpos;
            tibjmsxStream.writeByte(24);
            int n3 = tibjmsxStream.curpos;
            tibjmsxStream.skipWrite(4);
            int n4 = tibjmsxStream.curpos;
            boolean bl3 = this.writeBody(tibjmsxStream, bl);
            if (!bl3 && n > 0) {
                int n5 = tibjmsxStream.curpos;
                tibjmsxStream.curpos = n;
                tibjmsxStream.writeByte(0);
                tibjmsxStream.curpos = n5;
            }
            if (tibjmsxStream.curpos > n4) {
                tibjmsxStream.writeIntAt(n3, tibjmsxStream.curpos - n4);
                this._bodySize = tibjmsxStream.curpos - n4;
            } else {
                tibjmsxStream.curpos = n2;
            }
        }
        this._totalSize = tibjmsxStream.writeRvHeader();
    }

    static int startControlWire(TibjmsxStream tibjmsxStream, int n, int n2) {
        tibjmsxStream.skipWrite(8);
        tibjmsxStream.writeByte((byte)n);
        tibjmsxStream.writeInt(n2);
        tibjmsxStream.writeByte(23);
        int n3 = tibjmsxStream.curpos;
        tibjmsxStream.skipWrite(4);
        return n3;
    }

    static void endControlWire(TibjmsxStream tibjmsxStream, int n) {
        int n2 = tibjmsxStream.curpos;
        tibjmsxStream.curpos = n;
        tibjmsxStream.writeInt(n2 - n - 4);
        tibjmsxStream.curpos = n2;
        tibjmsxStream.writeRvHeader();
    }

    boolean _hasBody() throws JMSException {
        return false;
    }

    void readBody(TibjmsxStream tibjmsxStream, boolean bl) throws EOFException, JMSException {
        tibjmsxStream.readInt();
    }

    boolean writeBody(TibjmsxStream tibjmsxStream, boolean bl) throws JMSException {
        tibjmsxStream.writeInt(0);
        return false;
    }

    void _liftProperties() throws JMSException {
        if (this._propsLifted) {
            return;
        }
        this._propsLifted = true;
        if (this._wire == null || this._propsOffset == 0) {
            return;
        }
        TibjmsxStream tibjmsxStream = new TibjmsxStream(this._wire);
        tibjmsxStream.encoding = this._encoding;
        tibjmsxStream.curpos = this._propsOffset;
        this.readProperties(tibjmsxStream);
        this._checkCache();
    }

    void _checkCache() {
        if (this._propsOffset == 0) {
            this._propsLifted = true;
        }
        if (this._bodyOffset == 0) {
            this._bodyLifted = true;
        }
        if (this._propsLifted && this._bodyLifted) {
            this._wire = null;
        }
    }

    void _liftBody() throws JMSException {
        if (this._bodyLifted) {
            return;
        }
        this._liftProperties();
        this._bodyLifted = true;
        if (this._wire == null || this._bodyOffset == 0) {
            this._checkCache();
            return;
        }
        TibjmsxStream tibjmsxStream = new TibjmsxStream(this._wire);
        tibjmsxStream.curpos = this._bodyOffset;
        tibjmsxStream.encoding = this._encoding;
        try {
            this.readBody(tibjmsxStream, this._compressed);
        }
        catch (EOFException eOFException) {
            throw new JMSException("Corrupted message");
        }
        this._checkCache();
    }

    private void _read(int n) throws JMSException {
        int n2 = 0;
        this._propsLifted = false;
        this._bodyLifted = false;
        this._bodySize = 0;
        this._propsSize = 0;
        this._headersSize = 0;
        TibjmsxStream tibjmsxStream = new TibjmsxStream(this._wire);
        try {
            this._totalSize = n2 = tibjmsxStream.readRvHeader();
            this._type = tibjmsxStream.readUnsignedByte();
            this._responseID = tibjmsxStream.readInt();
            block9: while (tibjmsxStream.curpos < n2) {
                int n3 = tibjmsxStream.readUnsignedByte();
                switch (n3) {
                    case 22: {
                        this.readHeaders(tibjmsxStream);
                        continue block9;
                    }
                    case 23: {
                        this._propsOffset = tibjmsxStream.curpos;
                        this._propsSize = tibjmsxStream.skipLength(4);
                        continue block9;
                    }
                    case 24: {
                        this._bodyOffset = tibjmsxStream.curpos;
                        this._bodySize = tibjmsxStream.skipLength(4);
                        continue block9;
                    }
                    case 26: {
                        this._sequenceID = tibjmsxStream.readVarLong();
                        continue block9;
                    }
                    case 25: {
                        int n4 = tibjmsxStream.readUnsignedShort();
                        tibjmsxStream.skip(n4);
                        continue block9;
                    }
                }
                long l = tibjmsxStream.readVarLong();
                if (l == -1L) continue;
                tibjmsxStream.skip((int)l);
            }
        }
        catch (EOFException eOFException) {
            throw new JMSException("Corrupted message");
        }
        tibjmsxStream = null;
        this._readState = true;
        if (this._props == null) {
            this._props = new HashMap();
        }
        this._props.put("JMSXDeliveryCount", new Integer(this._deliveryCount));
        this._checkCache();
    }

    void _setWriteable() throws JMSException {
        this._liftProperties();
        this._propsReadOnly = false;
        this._propsLifted = true;
        this._checkCache();
        this._liftBody();
        this._bodyLifted = true;
        this._checkCache();
        this._setBodyWriteable();
    }

    void _setBodyWriteable() throws JMSException {
        this._readState = false;
    }

    static TibjmsMessage _createFromBytes(byte[] byArray, int n) throws JMSException {
        if (byArray.length < 9) {
            throw new JMSException("Corrupted message buffer");
        }
        int n2 = byArray[8] & 0xFF;
        switch (n2) {
            case 1: {
                return new TibjmsBytesMessage(byArray, n);
            }
            case 2: {
                return new TibjmsStreamMessage(byArray, n);
            }
            case 3: {
                return new TibjmsTextMessage(byArray, n);
            }
            case 4: {
                return new TibjmsObjectMessage(byArray, n);
            }
            case 5: {
                return new TibjmsMapMessage(byArray, n);
            }
            case 6: {
                return new TibjmsMessage(byArray, n);
            }
        }
        return new TibjmsMessage(byArray, n);
    }

    static void _copyBytesMsg(BytesMessage bytesMessage, TibjmsBytesMessage tibjmsBytesMessage) throws JMSException {
        int n;
        bytesMessage.reset();
        tibjmsBytesMessage.clearBody();
        byte[] byArray = new byte[1024];
        do {
            if ((n = bytesMessage.readBytes(byArray)) <= 0) continue;
            tibjmsBytesMessage.writeBytes(byArray, 0, n);
        } while (n >= byArray.length);
    }

    static void _copyStreamMsg(StreamMessage streamMessage, TibjmsStreamMessage tibjmsStreamMessage) throws JMSException {
        streamMessage.reset();
        tibjmsStreamMessage.clearBody();
        try {
            while (true) {
                Object object = streamMessage.readObject();
                tibjmsStreamMessage.writeObject(object);
            }
        }
        catch (MessageEOFException messageEOFException) {
            return;
        }
    }

    static void _copyTextMsg(TextMessage textMessage, TibjmsTextMessage tibjmsTextMessage) throws JMSException {
        tibjmsTextMessage.clearBody();
        tibjmsTextMessage.setText(textMessage.getText());
    }

    static void _copyObjectMsg(ObjectMessage objectMessage, TibjmsObjectMessage tibjmsObjectMessage) throws JMSException {
        tibjmsObjectMessage.clearBody();
        tibjmsObjectMessage.setObject(objectMessage.getObject());
    }

    static void _copyMapMsg(MapMessage mapMessage, TibjmsMapMessage tibjmsMapMessage) throws JMSException {
        tibjmsMapMessage.clearBody();
        Enumeration enumeration = mapMessage.getMapNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            tibjmsMapMessage.setObject(string, mapMessage.getObject(string));
        }
    }

    static TibjmsMessage _convertForeign(Message message) throws JMSException {
        if (message == null) {
            return null;
        }
        TibjmsMessage tibjmsMessage = null;
        if (message instanceof BytesMessage) {
            tibjmsMessage = new TibjmsBytesMessage();
        } else if (message instanceof ObjectMessage) {
            tibjmsMessage = new TibjmsObjectMessage();
        } else if (message instanceof MapMessage) {
            tibjmsMessage = new TibjmsMapMessage();
        } else if (message instanceof StreamMessage) {
            tibjmsMessage = new TibjmsStreamMessage();
        } else if (message instanceof TextMessage) {
            tibjmsMessage = new TibjmsTextMessage();
        } else if (message instanceof Message) {
            tibjmsMessage = new TibjmsMessage();
        } else {
            throw new JMSException("Invalid message object");
        }
        tibjmsMessage._JMSMessageID = message.getJMSMessageID();
        tibjmsMessage._JMSTimestamp = message.getJMSTimestamp();
        tibjmsMessage._JMSRedelivered = message.getJMSRedelivered();
        tibjmsMessage._JMSType = message.getJMSType();
        tibjmsMessage._JMSExpiration = message.getJMSExpiration();
        tibjmsMessage._JMSPriority = message.getJMSPriority();
        String string = message.getJMSCorrelationID();
        tibjmsMessage._JMSCorrelationID = string instanceof String ? string : null;
        tibjmsMessage._JMSDeliveryMode = message.getJMSDeliveryMode();
        if (!Tibjmsx.checkDeliveryMode(tibjmsMessage._JMSDeliveryMode, message)) {
            tibjmsMessage._JMSDeliveryMode = 2;
        }
        tibjmsMessage._JMSDestination = message.getJMSDestination();
        tibjmsMessage._JMSReplyTo = message.getJMSReplyTo();
        Enumeration enumeration = message.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            tibjmsMessage.setObjectProperty(string2, message.getObjectProperty(string2));
        }
        switch (tibjmsMessage._type) {
            case 1: {
                TibjmsMessage._copyBytesMsg((BytesMessage)message, (TibjmsBytesMessage)tibjmsMessage);
                break;
            }
            case 2: {
                TibjmsMessage._copyStreamMsg((StreamMessage)message, (TibjmsStreamMessage)tibjmsMessage);
                break;
            }
            case 3: {
                TibjmsMessage._copyTextMsg((TextMessage)message, (TibjmsTextMessage)tibjmsMessage);
                break;
            }
            case 4: {
                TibjmsMessage._copyObjectMsg((ObjectMessage)message, (TibjmsObjectMessage)tibjmsMessage);
                break;
            }
            case 5: {
                TibjmsMessage._copyMapMsg((MapMessage)message, (TibjmsMapMessage)tibjmsMessage);
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new JMSException("Failed to convert foreign message");
            }
        }
        return tibjmsMessage;
    }

    @Override
    public <T> T getBody(Class<T> clazz) throws JMSException {
        if (clazz == null) {
            throw new IllegalArgumentException("null class");
        }
        return null;
    }

    @Override
    public boolean isBodyAssignableTo(Class clazz) throws JMSException {
        if (clazz == null) {
            throw new IllegalArgumentException("null class");
        }
        return true;
    }

    static class EmptyEnum
    implements Enumeration {
        EmptyEnum() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    }
}

