/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsConnection;
import com.tibco.tibjms.TibjmsMessage;
import com.tibco.tibjms.TibjmsMessageConsumer;
import com.tibco.tibjms.TibjmsQueue;
import com.tibco.tibjms.TibjmsQueueConnection;
import com.tibco.tibjms.TibjmsTopic;
import com.tibco.tibjms.TibjmsTopicConnection;
import com.tibco.tibjms.TibjmsXAConnection;
import com.tibco.tibjms.TibjmsXAQueueConnection;
import com.tibco.tibjms.TibjmsXATopicConnection;
import com.tibco.tibjms.Tibjmsx;
import com.tibco.tibjms.TibjmsxSessionImp;
import com.tibco.tibjms.TibjmsxStream;
import com.tibco.tibjms.TibjmsxTrace;
import java.util.Vector;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;

class TibjmsConnectionConsumer
implements ConnectionConsumer {
    TibjmsConnection _connection = null;
    Destination _destination = null;
    String _subName = null;
    boolean _isDurable = false;
    boolean _isShared = false;
    String _selector = null;
    ServerSessionPool _pool = null;
    int _max_messages = 0;
    TibjmsxSessionImp _session = null;
    TibjmsMessageConsumer _consumer = null;
    Thread _receiver = null;
    Object _lock = new Object();
    boolean _closed = false;
    Vector _messages = new Vector();

    void _onFTSwitch(TibjmsxStream tibjmsxStream) {
        TibjmsxSessionImp tibjmsxSessionImp = this._session;
        if (tibjmsxSessionImp != null) {
            tibjmsxSessionImp._onFTSwitch(tibjmsxStream);
        }
    }

    boolean _dispatchMessages() {
        int n = 0;
        this._messages.removeAllElements();
        try {
            int n2;
            TibjmsMessage tibjmsMessage = (TibjmsMessage)this._session._receive(this._consumer, 0L, null);
            if (tibjmsMessage == null) {
                return false;
            }
            do {
                this._messages.addElement(tibjmsMessage);
                int n3 = n2 = this._max_messages > 0 ? this._max_messages : 1;
            } while (++n < n2 && (tibjmsMessage = (TibjmsMessage)this._session._receive(this._consumer, -2L, null)) != null);
            ServerSession serverSession = this._pool.getServerSession();
            Session session = serverSession.getSession();
            if (!(session instanceof TibjmsxSessionImp)) {
                throw new JMSException("ServerSession returned foreign Session object");
            }
            TibjmsxSessionImp tibjmsxSessionImp = (TibjmsxSessionImp)session;
            if (tibjmsxSessionImp.getTransacted() && !tibjmsxSessionImp.getXa() && tibjmsxSessionImp._connection._server_version_numeric < 40400) {
                throw new JMSException("ServerSession returned transacted session. Must use non-transacted sessions for ServerSessionPool when EMS server version is less that 4.4");
            }
            if (tibjmsxSessionImp._consumers.size() > 1) {
                throw new JMSException("ServerSession returned a Session which already has consumers.");
            }
            TibjmsxSessionImp tibjmsxSessionImp2 = tibjmsxSessionImp._connectionConsumerSession;
            tibjmsxSessionImp._connectionConsumerSession = this._session;
            TibjmsMessageConsumer tibjmsMessageConsumer = tibjmsxSessionImp._getTempConsumer();
            if (tibjmsMessageConsumer != null && tibjmsxSessionImp2 != null && tibjmsxSessionImp2 != this._session) {
                tibjmsxSessionImp._removeConsumer(tibjmsMessageConsumer);
                tibjmsMessageConsumer._clearMessages();
                tibjmsMessageConsumer = null;
            }
            if (tibjmsMessageConsumer == null) {
                tibjmsMessageConsumer = tibjmsxSessionImp._addConsumer(this._consumer._consid, tibjmsxSessionImp, this._destination, this._subName, this._isDurable, this._isShared, this._selector, false);
                tibjmsMessageConsumer._isFake = true;
            }
            for (int j = 0; j < this._messages.size(); ++j) {
                tibjmsMessage = (TibjmsMessage)this._messages.elementAt(j);
                tibjmsxSessionImp._postMessage(tibjmsMessageConsumer, tibjmsMessage, false);
            }
            try {
                if (this._connection._traceTarget != 0) {
                    TibjmsxTrace.write(this._connection._traceTarget, "Server Session Start conn={0,number,###0.##} sess={1,number,###0.##} msgcnt={2,number,###0.##}", new Object[]{new Long(this._connection._connid), new Long(tibjmsxSessionImp._sessid), new Integer(this._messages.size())});
                }
                serverSession.start();
            }
            catch (JMSException jMSException) {
                Tibjmsx.print("Exception has been thrown by ServerSession.start() method:");
                jMSException.printStackTrace();
                if (jMSException.getLinkedException() != null) {
                    Tibjmsx.print("LinkedException:");
                    jMSException.getLinkedException().printStackTrace();
                }
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            if (!this._session._closed && !this._connection._closed) {
                Tibjmsx.print("*** Unexpected Exception in ConnectionConsumer for " + this._destination.toString() + " ***:");
                jMSException.printStackTrace(System.err);
                if (jMSException.getLinkedException() != null) {
                    Tibjmsx.print("Linked exception:");
                    jMSException.getLinkedException().printStackTrace(System.err);
                }
            }
            this._messages.removeAllElements();
            return false;
        }
        return true;
    }

    void _create() throws JMSException {
        String string = "Consumer";
        try {
            if (this._connection instanceof TibjmsXAConnection) {
                if (this._connection instanceof TibjmsXATopicConnection) {
                    if (this._destination == null || !(this._destination instanceof TibjmsTopic)) {
                        throw new InvalidDestinationException("Invalid topic");
                    }
                    TibjmsXATopicConnection tibjmsXATopicConnection = (TibjmsXATopicConnection)this._connection;
                    this._session = (TibjmsxSessionImp)((Object)tibjmsXATopicConnection.createXATopicSession());
                } else if (this._connection instanceof TibjmsXAQueueConnection) {
                    if (this._destination == null || !(this._destination instanceof TibjmsQueue)) {
                        throw new InvalidDestinationException("Invalid queue");
                    }
                    TibjmsXAQueueConnection tibjmsXAQueueConnection = (TibjmsXAQueueConnection)this._connection;
                    this._session = (TibjmsxSessionImp)((Object)tibjmsXAQueueConnection.createXAQueueSession());
                } else {
                    if (this._destination == null) {
                        throw new InvalidDestinationException("Invalid destination");
                    }
                    TibjmsXAConnection tibjmsXAConnection = (TibjmsXAConnection)this._connection;
                    this._session = (TibjmsxSessionImp)((Object)tibjmsXAConnection.createXASession());
                }
            } else if (this._connection instanceof TibjmsTopicConnection) {
                if (this._destination == null || !(this._destination instanceof TibjmsTopic)) {
                    throw new InvalidDestinationException("Invalid topic");
                }
                TibjmsTopicConnection tibjmsTopicConnection = (TibjmsTopicConnection)this._connection;
                this._session = (TibjmsxSessionImp)((Object)tibjmsTopicConnection.createTopicSession(true, 23));
            } else if (this._connection instanceof TibjmsQueueConnection) {
                if (this._destination == null || !(this._destination instanceof TibjmsQueue)) {
                    throw new InvalidDestinationException("Invalid queue");
                }
                TibjmsQueueConnection tibjmsQueueConnection = (TibjmsQueueConnection)this._connection;
                this._session = (TibjmsxSessionImp)((Object)tibjmsQueueConnection.createQueueSession(true, 23));
            } else {
                if (this._destination == null) {
                    throw new InvalidDestinationException("Invalid destination");
                }
                TibjmsConnection tibjmsConnection = this._connection;
                this._session = (TibjmsxSessionImp)tibjmsConnection.createSession(true, 23);
            }
            if (this._isDurable) {
                string = "Durable";
            }
            this._consumer = this._session._createConsumer(this._destination, this._subName, this._isDurable, this._isShared, this._selector, false, true, string);
        }
        catch (JMSException jMSException) {
            if (this._session != null) {
                try {
                    this._session.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw jMSException;
        }
        this._receiver = new Thread(new MR());
        this._receiver.start();
        this._connection._addConnectionConsumer(this);
    }

    private TibjmsConnectionConsumer() {
    }

    TibjmsConnectionConsumer(TibjmsConnection tibjmsConnection, Destination destination, String string, boolean bl, boolean bl2, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        this._connection = tibjmsConnection;
        this._destination = destination;
        this._subName = string;
        this._isDurable = bl;
        this._isShared = bl2;
        this._selector = string2;
        this._pool = serverSessionPool;
        this._max_messages = n;
        this._create();
    }

    @Override
    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this._pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        Object object = this._lock;
        synchronized (object) {
            if (this._closed) {
                return;
            }
            this._receiver = null;
            if (this._session != null) {
                this._session.close();
            }
            this._connection._removeConnectionConsumer(this);
            this._closed = true;
        }
    }

    class MR
    implements Runnable {
        MR() {
        }

        @Override
        public void run() {
            while (TibjmsConnectionConsumer.this._dispatchMessages()) {
            }
        }
    }
}

