/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsMessage;
import com.tibco.tibjms.TibjmsSession;
import com.tibco.tibjms.TibjmsxConst;
import com.tibco.tibjms.TibjmsxStream;
import java.io.EOFException;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class TibjmsBytesMessage
extends TibjmsMessage
implements BytesMessage,
Serializable,
Cloneable,
TibjmsxConst {
    private static final long serialVersionUID = -8522940922962349119L;
    TibjmsxStream _stream = null;

    @Override
    final boolean _hasBody() throws JMSException {
        if (!this._bodyLifted) {
            this._liftBody();
        }
        if (this._stream == null) {
            return false;
        }
        int n = !this._readState ? this._stream.curpos : this._stream.buflen;
        return n > 0;
    }

    @Override
    final boolean writeBody(TibjmsxStream tibjmsxStream, boolean bl) throws JMSException {
        if (!this._bodyLifted) {
            this._liftBody();
        }
        int n = 0;
        if (this._stream == null) {
            tibjmsxStream.writeVarLong(-1L);
            return false;
        }
        n = !this._readState ? this._stream.curpos : this._stream.buflen;
        if (bl && n > 0 && tibjmsxStream.writeCompressed(this._session, this._stream.buffer, 0, n)) {
            return true;
        }
        tibjmsxStream.writeBytes(this._stream.buffer, 0, n);
        return false;
    }

    @Override
    final void readBody(TibjmsxStream tibjmsxStream, boolean bl) throws EOFException, JMSException {
        int n = tibjmsxStream.readInt();
        int n2 = tibjmsxStream.curpos;
        if (!bl) {
            long l = tibjmsxStream.readVarLong();
            this._stream = l == -1L ? null : new TibjmsxStream((int)l);
            if (l > 0L) {
                tibjmsxStream.readFully(this._stream.buffer, 0, (int)l);
            }
        } else {
            byte[] byArray = tibjmsxStream.readCompressed();
            this._stream = byArray == null ? null : new TibjmsxStream(byArray, 0, byArray.length);
        }
        this._readState = true;
        if (this._stream != null) {
            this._stream.curpos = 0;
        }
        if (tibjmsxStream.curpos != n2 + n) {
            throw new JMSException("Corrupted BytesMessage body");
        }
    }

    @Override
    void _setBodyWriteable() throws JMSException {
        if (this._stream == null) {
            this._stream = new TibjmsxStream(128);
            this._stream.startWriting();
        } else if (this._readState) {
            this._stream.curpos = this._stream.buflen;
            this._stream.buflen = this._stream.buffer.length;
        }
        this._readState = false;
    }

    TibjmsBytesMessage() {
        super(1);
        this._stream = new TibjmsxStream(128);
        this._readState = false;
    }

    TibjmsBytesMessage(TibjmsSession tibjmsSession) {
        super(tibjmsSession, 1);
        this._stream = new TibjmsxStream(128);
        this._readState = false;
    }

    TibjmsBytesMessage(byte[] byArray, int n) throws JMSException {
        super(1);
        this._read(byArray, n);
    }

    void resetMessageAfterOnMessageException() {
        try {
            this.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public long getBodyLength() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (!this._bodyLifted) {
            this._liftBody();
        }
        return this._stream == null ? 0L : (long)this._stream.buflen;
    }

    @Override
    public Object clone() {
        TibjmsBytesMessage tibjmsBytesMessage = (TibjmsBytesMessage)super.clone();
        if (tibjmsBytesMessage == null) {
            return tibjmsBytesMessage;
        }
        if (this._stream != null) {
            tibjmsBytesMessage._stream = (TibjmsxStream)this._stream.clone();
        }
        return tibjmsBytesMessage;
    }

    @Override
    public boolean readBoolean() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (!this._bodyLifted) {
            this._liftBody();
        }
        try {
            if (this._stream != null) {
                return this._stream.readBoolean();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        throw new MessageEOFException("End of message stream");
    }

    @Override
    public byte readByte() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (!this._bodyLifted) {
            this._liftBody();
        }
        try {
            if (this._stream != null) {
                return this._stream.readByte();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        throw new MessageEOFException("End of message stream");
    }

    @Override
    public int readUnsignedByte() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (!this._bodyLifted) {
            this._liftBody();
        }
        try {
            if (this._stream != null) {
                return this._stream.readUnsignedByte();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        throw new MessageEOFException("End of message stream");
    }

    @Override
    public short readShort() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (!this._bodyLifted) {
            this._liftBody();
        }
        try {
            if (this._stream != null) {
                return this._stream.readShort();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        throw new MessageEOFException("End of message stream");
    }

    @Override
    public int readUnsignedShort() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (!this._bodyLifted) {
            this._liftBody();
        }
        try {
            if (this._stream != null) {
                short s = this._stream.readShort();
                return s & 0xFFFF;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        throw new MessageEOFException("End of message stream");
    }

    @Override
    public char readChar() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (!this._bodyLifted) {
            this._liftBody();
        }
        try {
            if (this._stream != null) {
                return this._stream.readChar();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        throw new MessageEOFException("End of message stream");
    }

    @Override
    public int readInt() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (!this._bodyLifted) {
            this._liftBody();
        }
        try {
            if (this._stream != null) {
                return this._stream.readInt();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        throw new MessageEOFException("End of message stream");
    }

    @Override
    public long readLong() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (!this._bodyLifted) {
            this._liftBody();
        }
        try {
            if (this._stream != null) {
                return this._stream.readLong();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        throw new MessageEOFException("End of message stream");
    }

    @Override
    public float readFloat() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (!this._bodyLifted) {
            this._liftBody();
        }
        try {
            if (this._stream != null) {
                return this._stream.readFloat();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        throw new MessageEOFException("End of message stream");
    }

    @Override
    public double readDouble() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (!this._bodyLifted) {
            this._liftBody();
        }
        try {
            if (this._stream != null) {
                return this._stream.readDouble();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        throw new MessageEOFException("End of message stream");
    }

    @Override
    public String readUTF() throws JMSException {
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (!this._bodyLifted) {
            this._liftBody();
        }
        if (this._stream == null) {
            throw new MessageEOFException("End of message stream");
        }
        try {
            return this._stream.readUTF();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException("End of message stream");
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            throw new MessageFormatException("Invalid UTF data");
        }
    }

    @Override
    public int readBytes(byte[] byArray) throws JMSException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (!this._bodyLifted) {
            this._liftBody();
        }
        return this._readBytes(byArray, byArray.length);
    }

    @Override
    public int readBytes(byte[] byArray, int n) throws JMSException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (!this._readState) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (!this._bodyLifted) {
            this._liftBody();
        }
        return this._readBytes(byArray, n);
    }

    private int _readBytes(byte[] byArray, int n) throws JMSException {
        if (!this._bodyLifted) {
            this._liftBody();
        }
        if (n == 0) {
            return 0;
        }
        if (this._stream == null) {
            return -1;
        }
        int n2 = this._stream.buflen - this._stream.curpos;
        if (n2 <= 0) {
            return -1;
        }
        int n3 = n2 >= n ? n : n2;
        System.arraycopy(this._stream.buffer, this._stream.curpos, byArray, 0, n3);
        this._stream.curpos += n3;
        return n3;
    }

    @Override
    public void writeBoolean(boolean bl) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._stream.writeBoolean(bl);
    }

    @Override
    public void writeByte(byte by) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._stream.writeByte(by);
    }

    @Override
    public void writeShort(short s) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._stream.writeShort(s);
    }

    @Override
    public void writeChar(char c) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._stream.writeChar(c);
    }

    @Override
    public void writeInt(int n) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._stream.writeInt(n);
    }

    @Override
    public void writeLong(long l) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._stream.writeLong(l);
    }

    @Override
    public void writeFloat(float f) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._stream.writeFloat(f);
    }

    @Override
    public void writeDouble(double d) throws JMSException {
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._stream.writeDouble(d);
    }

    @Override
    public void writeUTF(String string) throws JMSException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        try {
            this._stream.writeUTF(string);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            throw new MessageFormatException("String is too long");
        }
    }

    @Override
    public void writeBytes(byte[] byArray) throws JMSException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        this._stream.write(byArray);
    }

    @Override
    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 > 0) {
            this._stream.write(byArray, n, n2);
        }
    }

    @Override
    public void writeObject(Object object) throws JMSException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this._readState) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        int n = TibjmsBytesMessage.getFieldType(object);
        if (n == 255) {
            throw new MessageFormatException("Invalid value of class " + object.getClass().getName());
        }
        switch (n) {
            case 2: {
                this._stream.writeByte(((Byte)object).byteValue());
                return;
            }
            case 1: {
                this._stream.writeBoolean((Boolean)object);
                return;
            }
            case 3: {
                this._stream.writeChar(((Character)object).charValue());
                return;
            }
            case 4: {
                this._stream.writeShort(((Short)object).shortValue());
                return;
            }
            case 5: {
                this._stream.writeInt((Integer)object);
                return;
            }
            case 6: {
                this._stream.writeLong((Long)object);
                return;
            }
            case 7: {
                this._stream.writeFloat(((Float)object).floatValue());
                return;
            }
            case 8: {
                this._stream.writeDouble((Double)object);
                return;
            }
            case 10: {
                this._stream.write((byte[])object);
                return;
            }
            case 9: {
                try {
                    this._stream.writeUTF((String)object);
                }
                catch (UTFDataFormatException uTFDataFormatException) {
                    throw new MessageFormatException("String is too long");
                }
                return;
            }
        }
        throw new MessageFormatException("Invalid value of class " + object.getClass().getName());
    }

    @Override
    public void reset() throws JMSException {
        if (!this._bodyLifted) {
            this._liftBody();
        }
        if (!this._readState && this._stream != null) {
            this._stream.buflen = this._stream.curpos;
        }
        this._readState = true;
        if (this._stream != null) {
            this._stream.curpos = 0;
        }
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        if (this._stream == null) {
            this._stream = new TibjmsxStream(128);
        }
        this._readState = false;
        this._stream.curpos = 0;
        this._stream.buflen = this._stream.buffer.length;
    }

    @Override
    public String toString() {
        try {
            if (!this._bodyLifted) {
                this._liftBody();
            }
        }
        catch (JMSException jMSException) {
            return "JMSException occurred while converting message into string: " + jMSException.getMessage();
        }
        String string = "BytesMessage={" + super.toString();
        int n = 0;
        if (this._stream != null) {
            n = this._readState ? this._stream.buflen : this._stream.curpos;
        }
        string = string + " Bytes={" + n + " bytes} }";
        return string;
    }

    @Override
    public <T> T getBody(Class<T> clazz) throws JMSException {
        if (clazz == null) {
            throw new IllegalArgumentException("null class");
        }
        if (!this.isBodyAssignableTo(clazz)) {
            throw new MessageFormatException("Cannot convert body into " + clazz.getSimpleName() + ".");
        }
        if (!this._hasBody()) {
            return null;
        }
        this.reset();
        long l = this.getBodyLength();
        byte[] byArray = new byte[(int)l];
        this.readBytes(byArray);
        this.reset();
        return (T)byArray;
    }

    @Override
    public boolean isBodyAssignableTo(Class clazz) throws JMSException {
        if (clazz == null) {
            throw new IllegalArgumentException("null class");
        }
        if (!this._hasBody()) {
            return true;
        }
        return clazz == byte[].class || clazz == Object.class;
    }
}

