/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibjms;

import com.tibco.tibjms.TibjmsConnection;
import com.tibco.tibjms.TibjmsJMSContext;
import com.tibco.tibjms.TibjmsJMSProducer;
import com.tibco.tibjms.TibjmsMessage;
import com.tibco.tibjms.TibjmsMessageConsumer;
import com.tibco.tibjms.TibjmsMessageProducer;
import com.tibco.tibjms.TibjmsMulticastExceptionListener;
import com.tibco.tibjms.Tibjmsx;
import com.tibco.tibjms.TibjmsxStream;
import com.tibco.tibjms.TibjmsxTrace;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.jms.Connection;
import javax.jms.IllegalStateException;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;

public class Tibjms {
    public static final int RELIABLE_DELIVERY = 22;
    public static final int NO_ACKNOWLEDGE = 22;
    public static final int EXPLICIT_CLIENT_ACKNOWLEDGE = 23;
    public static final int EXPLICIT_CLIENT_DUPS_OK_ACKNOWLEDGE = 24;
    public static final int NPSEND_CHECK_DEFAULT = 0;
    public static final int NPSEND_CHECK_ALWAYS = 1;
    public static final int NPSEND_CHECK_NEVER = 2;
    public static final int NPSEND_CHECK_TEMP_DEST = 3;
    public static final int NPSEND_CHECK_AUTH = 4;
    public static final int NPSEND_CHECK_TEMP_AUTH = 5;
    public static final String JMS_TIBCO_IMPORTED = "JMS_TIBCO_IMPORTED";
    public static final String JMS_TIBCO_SENDER = "JMS_TIBCO_SENDER";
    public static final String JMS_TIBCO_DISABLE_SENDER = "JMS_TIBCO_DISABLE_SENDER";
    @Deprecated
    public static final String JMS_TIBCO_SS_SENDER = "JMS_TIBCO_SS_SENDER";
    public static final String JMS_TIBCO_CM_PUBLISHER = "JMS_TIBCO_CM_PUBLISHER";
    public static final String JMS_TIBCO_CM_SEQUENCE = "JMS_TIBCO_CM_SEQUENCE";
    public static final String JMS_TIBCO_MSG_EXT = "JMS_TIBCO_MSG_EXT";
    public static final String JMS_TIBCO_MSG_TRACE = "JMS_TIBCO_MSG_TRACE";
    public static final String JMS_TIBCO_COMPRESS = "JMS_TIBCO_COMPRESS";
    public static final String JMS_TIBCO_PRESERVE_UNDELIVERED = "JMS_TIBCO_PRESERVE_UNDELIVERED";
    public static final String PROP_MESSAGE_ENCODING = "tibco.tibjms.message.encoding";
    public static final String PROP_SOCKET_RECEIVE = "tibco.tibjms.socket.receive";
    public static final String PROP_SOCKET_SEND = "tibco.tibjms.socket.send";
    public static final String PROP_DAEMON_DISPATCHER = "tibco.tibjms.daemon.dispatcher";
    public static final String PROP_FT_SWITCH_EXCEPTION = "tibco.tibjms.ft.switch.exception";
    public static final String PROP_FT_EVENTS_EXCEPTION = "tibco.tibjms.ft.events.exception";
    public static final String PROP_CLOSE_IN_CALLBACK = "tibco.tibjms.close.in.callback";
    public static final String PROP_SOCKET_CONNECT_TIMEOUT = "tibco.tibjms.socket.connect.timeout";
    public static final String PROP_CONNECT_ATTEMPTS = "tibco.tibjms.connect.attempts";
    public static final String PROP_RECONNECT_ATTEMPTS = "tibco.tibjms.reconnect.attempts";
    public static final String PROP_PING_INTERVAL = "tibco.tibjms.ping.interval";
    public static final String PROP_CONNECT_ATTEMPT_TIMEOUT = "tibco.tibjms.connect.attempt.timeout";
    public static final String PROP_RECONNECT_ATTEMPT_TIMEOUT = "tibco.tibjms.reconnect.attempt.timeout";
    public static final String PROP_RESTORE_8_3_0_CONNECT_BEHAVIOR = "tibco.tibems.ufo.restore.8.3.0.connect.behavior";
    public static final String PROP_TX_SEND_DEST_CHECK = "tibco.tibjms.tx.send.dest.check";
    public static final String PROP_SSL_TRACE = "tibco.tibjms.ssl.trace";
    public static final String PROP_SSL_DEBUG_TRACE = "tibco.tibjms.ssl.debug.trace";
    @Deprecated
    public static final String PROP_MULTICAST_ENABLED = "tibco.tibjms.multicast.enabled";
    @Deprecated
    public static final String PROP_MULTICAST_DAEMON = "tibco.tibjms.multicast.daemon";
    public static final String PROP_TRACE_FILE = "tibco.tibjms.trace.file";
    public static final String DEFAULT_FACTORY_USERNAME = "com.tibco.tibjms.factory.username";
    public static final String DEFAULT_FACTORY_PASSWORD = "com.tibco.tibjms.factory.password";
    public static final String FACTORY_LOAD_BALANCE_METRIC = "com.tibco.tibjms.factory.metric";
    public static final int FACTORY_LOAD_BALANCE_METRIC_NONE = 0;
    public static final int FACTORY_LOAD_BALANCE_METRIC_CONNECTIONS = 1;
    public static final int FACTORY_LOAD_BALANCE_METRIC_BYTE_RATE = 2;
    public static final String FACTORY_CONNECT_ATTEMPT_COUNT = "com.tibco.tibjms.connect.attemptcount";
    public static final String FACTORY_CONNECT_ATTEMPT_DELAY = "com.tibco.tibjms.connect.attemptdelay";
    public static final String FACTORY_CONNECT_ATTEMPT_TIMEOUT = "com.tibco.tibjms.connect.attempttimeout";
    static final String FACTORY_CONNECT_ATTEMPT_TIMEOUT_PRE50_VALUE = "com.tibco.tibjms.connect.attempt.timeout";
    public static final String FACTORY_RECONNECT_ATTEMPT_COUNT = "com.tibco.tibjms.reconnect.attemptcount";
    public static final String FACTORY_RECONNECT_ATTEMPT_DELAY = "com.tibco.tibjms.reconnect.attemptdelay";
    public static final String FACTORY_RECONNECT_ATTEMPT_TIMEOUT = "com.tibco.tibjms.reconnect.attempttimeout";
    @Deprecated
    public static final String FACTORY_MULTICAST_ENABLED = "com.tibco.tibjms.multicast.enabled";
    @Deprecated
    public static final String FACTORY_MULTICAST_DAEMON = "com.tibco.tibjms.multicast.daemon";

    private Tibjms() {
    }

    public static int getMessageSize(Message message) {
        if (message == null || !(message instanceof TibjmsMessage)) {
            throw new IllegalArgumentException("null or foreign message");
        }
        return ((TibjmsMessage)message)._totalSize;
    }

    public static int getMessageHeadersSize(Message message) {
        if (message == null || !(message instanceof TibjmsMessage)) {
            throw new IllegalArgumentException("null or foreign message");
        }
        return ((TibjmsMessage)message)._headersSize;
    }

    public static int getMessagePropertiesSize(Message message) {
        if (message == null || !(message instanceof TibjmsMessage)) {
            throw new IllegalArgumentException("null or foreign message");
        }
        return ((TibjmsMessage)message)._propsSize;
    }

    public static int getMessageBodySize(Message message) {
        if (message == null || !(message instanceof TibjmsMessage)) {
            throw new IllegalArgumentException("null or foreign message");
        }
        return ((TibjmsMessage)message)._bodySize;
    }

    public static int calculateMessageSize(Message message) throws JMSException {
        if (message == null || !(message instanceof TibjmsMessage)) {
            throw new IllegalArgumentException("null or foreign message");
        }
        TibjmsxStream tibjmsxStream = new TibjmsxStream(128);
        ((TibjmsMessage)message).write(tibjmsxStream, false);
        return ((TibjmsMessage)message)._totalSize;
    }

    public static void setAllowCloseInCallback(boolean bl) {
        Tibjmsx.allowCallbackClose = bl;
    }

    public static boolean getAllowCloseInCallback() {
        return Tibjmsx.allowCallbackClose;
    }

    @Deprecated
    public static void setAllowCallbackInClose(boolean bl) {
        Tibjms.setAllowCloseInCallback(bl);
    }

    @Deprecated
    public static boolean getAllowCallbackInClose() {
        return Tibjms.getAllowCloseInCallback();
    }

    public static void setExceptionOnFTSwitch(boolean bl) {
        Tibjmsx.ftSwitchException = bl;
    }

    public static boolean getExceptionOnFTSwitch() {
        return Tibjmsx.ftSwitchException;
    }

    public static void setExceptionOnFTEvents(boolean bl) {
        Tibjmsx.ftEventsException = bl;
    }

    public static boolean getExceptionOnFTEvents() {
        return Tibjmsx.ftEventsException;
    }

    public static void setSessionDispatcherDaemon(boolean bl) {
        Tibjmsx.daemonDispatcher = bl;
    }

    public static boolean getSessionDispatcherDaemon() {
        return Tibjmsx.daemonDispatcher;
    }

    public static void setConnectAttempts(String string) {
        Tibjmsx.connectAttempts = string;
    }

    public static String getConnectAttempts() {
        return Tibjmsx.connectAttempts;
    }

    public static void setReconnectAttempts(String string) {
        Tibjmsx.reconnectAttempts = string;
    }

    public static String getReconnectAttempts() {
        return Tibjmsx.reconnectAttempts;
    }

    public static void setConnectAttemptTimeout(int n) {
        Tibjmsx.connectAttemptTimeout = n;
    }

    public static int getConnectAttemptTimeout() {
        return Tibjmsx.connectAttemptTimeout;
    }

    public static void setReconnectAttemptTimeout(int n) {
        Tibjmsx.reconnectAttemptTimeout = n;
    }

    public static int getReconnectAttemptTimeout() {
        return Tibjmsx.reconnectAttemptTimeout;
    }

    public static void setSocketReceiveBufferSize(int n) {
        if (n < -1) {
            throw new IllegalArgumentException("invalid value");
        }
        Tibjmsx.socketReceiveSize = n;
    }

    public static int getSocketReceiveBufferSize() {
        return Tibjmsx.socketReceiveSize;
    }

    public static void setSocketSendBufferSize(int n) {
        if (n < -1) {
            throw new IllegalArgumentException("invalid value");
        }
        Tibjmsx.socketSendSize = n;
    }

    public static int getSocketSendBufferSize() {
        return Tibjmsx.socketSendSize;
    }

    public static void setPingInterval(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative value");
        }
        Tibjmsx.pingInterval = n;
    }

    public static int getPingInterval() {
        return Tibjmsx.pingInterval;
    }

    public static void setSocketConnectTimeout(long l) {
        if (l < 0L || l > 600000L) {
            throw new IllegalArgumentException("value out of range");
        }
        Tibjmsx.socketConnectTimeout = (int)l;
    }

    public static long getSocketConnectTimeout() {
        return Tibjmsx.socketConnectTimeout;
    }

    public static void setEncoding(String string) throws JMSException {
        try {
            String string2 = "";
            string2.getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JMSException("Encoding '" + string + "' not supported");
        }
        Tibjmsx.encoding = string;
    }

    public static String getEncoding() {
        return Tibjmsx.encoding;
    }

    public static void setMessageEncoding(Message message, String string) throws JMSException {
        if (message == null || string == null) {
            return;
        }
        try {
            String string2 = "";
            string2.getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JMSException("Encoding '" + string + "' not supported");
        }
        if (!(message instanceof TibjmsMessage)) {
            return;
        }
        ((TibjmsMessage)message)._encoding = string;
    }

    public static String getMessageEncoding(Message message) {
        if (message != null && message instanceof TibjmsMessage) {
            return ((TibjmsMessage)message)._encoding;
        }
        return null;
    }

    public static byte[] getAsBytes(Message message) throws JMSException {
        if (!(message instanceof TibjmsMessage)) {
            throw new JMSException("Foreign messages can not be converted to byte array");
        }
        TibjmsxStream tibjmsxStream = new TibjmsxStream(256);
        ((TibjmsMessage)message).write(tibjmsxStream, false);
        byte[] byArray = new byte[tibjmsxStream.curpos];
        System.arraycopy(tibjmsxStream.buffer, 0, byArray, 0, tibjmsxStream.curpos);
        return byArray;
    }

    public static Message createFromBytes(byte[] byArray) throws JMSException {
        return TibjmsMessage._createFromBytes(byArray, 1);
    }

    public static void makeWriteable(Message message) throws JMSException {
        if (!(message instanceof TibjmsMessage)) {
            throw new JMSException("Foreign messages not supported");
        }
        ((TibjmsMessage)message)._setWriteable();
    }

    public static String getConnectionActiveURL(Connection connection) throws JMSException {
        if (!(connection instanceof TibjmsConnection)) {
            throw new JMSException("Foreign connections not supported");
        }
        return ((TibjmsConnection)connection).getActiveURL();
    }

    public static String getConnectionActiveURL(JMSContext jMSContext) {
        if (!(jMSContext instanceof TibjmsJMSContext)) {
            throw new JMSRuntimeException("null of foreign context");
        }
        return ((TibjmsJMSContext)jMSContext)._getActiveURL();
    }

    public static void setNPSendCheckMode(MessageProducer messageProducer, int n) {
        if (messageProducer == null || !(messageProducer instanceof TibjmsMessageProducer)) {
            throw new IllegalArgumentException("null or alien producer");
        }
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4 && n != 5) {
            throw new IllegalArgumentException("invalid mode");
        }
        ((TibjmsMessageProducer)messageProducer)._npsend_mode = n;
    }

    public static void setNPSendCheckMode(JMSProducer jMSProducer, int n) {
        if (jMSProducer == null || !(jMSProducer instanceof TibjmsJMSProducer)) {
            throw new IllegalArgumentException("null or alien producer");
        }
        Tibjms.setNPSendCheckMode(((TibjmsJMSProducer)jMSProducer)._producer, n);
    }

    public static int getNPSendCheckMode(MessageProducer messageProducer) {
        if (messageProducer == null || !(messageProducer instanceof TibjmsMessageProducer)) {
            throw new IllegalArgumentException("null or alien producer");
        }
        return ((TibjmsMessageProducer)messageProducer)._npsend_mode;
    }

    public static int getNPSendCheckMode(JMSProducer jMSProducer) {
        if (jMSProducer == null || !(jMSProducer instanceof TibjmsJMSProducer)) {
            throw new IllegalArgumentException("null or alien producer");
        }
        return Tibjms.getNPSendCheckMode(((TibjmsJMSProducer)jMSProducer)._producer);
    }

    @Deprecated
    public static void setMulticastEnabled(boolean bl) {
        Tibjmsx.multicastEnabled = bl;
    }

    @Deprecated
    public static boolean getMulticastEnabled() {
        return Tibjmsx.multicastEnabled;
    }

    @Deprecated
    public static void setMulticastDaemon(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Tibjmsx.multicastDaemon = string;
            return;
        }
        Tibjmsx.multicastDaemon = "tcp://localhost:" + string;
    }

    @Deprecated
    public static String getMulticastDaemon() {
        return Tibjmsx.multicastDaemon;
    }

    @Deprecated
    public static boolean isConsumerMulticast(MessageConsumer messageConsumer) {
        if (messageConsumer == null || !(messageConsumer instanceof TibjmsMessageConsumer)) {
            throw new IllegalArgumentException("null or alien consumer");
        }
        return ((TibjmsMessageConsumer)messageConsumer)._isMulticast;
    }

    @Deprecated
    public static void setMulticastExceptionListener(TibjmsMulticastExceptionListener tibjmsMulticastExceptionListener) {
        Tibjmsx.mcExListener = tibjmsMulticastExceptionListener;
    }

    public static void setTraceFile(String string) throws IOException {
        TibjmsxTrace.setTraceFile(string);
    }

    public static void recoverMsg(Message message) throws JMSException, IllegalStateException, IllegalArgumentException {
        if (message == null || !(message instanceof TibjmsMessage)) {
            throw new IllegalArgumentException("null or invalid message");
        }
        ((TibjmsMessage)message).recover();
    }
}

