/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.sdk.api;

import com.google.gson.reflect.TypeToken;
import com.redhat.parodos.sdk.api.ApiCallback;
import com.redhat.parodos.sdk.api.ApiClient;
import com.redhat.parodos.sdk.api.ApiException;
import com.redhat.parodos.sdk.api.ApiResponse;
import com.redhat.parodos.sdk.api.Configuration;
import com.redhat.parodos.sdk.api.Pair;
import com.redhat.parodos.sdk.model.ProjectRequestDTO;
import com.redhat.parodos.sdk.model.ProjectResponseDTO;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ProjectApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProjectApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createProjectCall(ProjectRequestDTO projectRequestDTO, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProjectRequestDTO localVarPostBody = projectRequestDTO;
        String localVarPath = "/api/v1/projects";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createProjectValidateBeforeCall(ProjectRequestDTO projectRequestDTO, ApiCallback _callback) throws ApiException {
        if (projectRequestDTO == null) {
            throw new ApiException("Missing the required parameter 'projectRequestDTO' when calling createProject(Async)");
        }
        Call localVarCall = this.createProjectCall(projectRequestDTO, _callback);
        return localVarCall;
    }

    public ProjectResponseDTO createProject(ProjectRequestDTO projectRequestDTO) throws ApiException {
        ApiResponse<ProjectResponseDTO> localVarResp = this.createProjectWithHttpInfo(projectRequestDTO);
        return localVarResp.getData();
    }

    public ApiResponse<ProjectResponseDTO> createProjectWithHttpInfo(ProjectRequestDTO projectRequestDTO) throws ApiException {
        Call localVarCall = this.createProjectValidateBeforeCall(projectRequestDTO, null);
        Type localVarReturnType = new TypeToken<ProjectResponseDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createProjectAsync(ProjectRequestDTO projectRequestDTO, ApiCallback<ProjectResponseDTO> _callback) throws ApiException {
        Call localVarCall = this.createProjectValidateBeforeCall(projectRequestDTO, _callback);
        Type localVarReturnType = new TypeToken<ProjectResponseDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProjectByIdCall(String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/projects/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProjectByIdValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProjectById(Async)");
        }
        Call localVarCall = this.getProjectByIdCall(id, _callback);
        return localVarCall;
    }

    public ProjectResponseDTO getProjectById(String id) throws ApiException {
        ApiResponse<ProjectResponseDTO> localVarResp = this.getProjectByIdWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ProjectResponseDTO> getProjectByIdWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getProjectByIdValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ProjectResponseDTO>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProjectByIdAsync(String id, ApiCallback<ProjectResponseDTO> _callback) throws ApiException {
        Call localVarCall = this.getProjectByIdValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ProjectResponseDTO>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProjectsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/projects";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProjectsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getProjectsCall(_callback);
        return localVarCall;
    }

    public List<ProjectResponseDTO> getProjects() throws ApiException {
        ApiResponse<List<ProjectResponseDTO>> localVarResp = this.getProjectsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<ProjectResponseDTO>> getProjectsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getProjectsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<ProjectResponseDTO>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProjectsAsync(ApiCallback<List<ProjectResponseDTO>> _callback) throws ApiException {
        Call localVarCall = this.getProjectsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<ProjectResponseDTO>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

