/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal.checksum;

import com.googlecode.download.maven.plugin.internal.ChecksumUtils;
import com.googlecode.download.maven.plugin.internal.checksum.Checksum;
import java.io.File;
import java.security.MessageDigest;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.maven.plugin.logging.Log;

public final class Checksums {
    private final Map<Checksum, String> supplied;

    public Checksums(@Nullable String md5, @Nullable String sha1, @Nullable String sha256, @Nullable String sha512, Log log) {
        this.supplied = Checksums.create(md5, sha1, sha256, sha512);
        if (this.supplied.isEmpty()) {
            log.debug("No checksums were supplied, skipping file validation");
        } else if (this.supplied.size() > 1) {
            log.warn("More than one checksum is supplied. This may be slow for big files. Consider using a single checksum.");
        }
    }

    public boolean isValid(File file) {
        boolean valid = true;
        try {
            this.validate(file);
        }
        catch (Exception ex) {
            valid = false;
        }
        return valid;
    }

    public void validate(File file) throws Exception {
        for (Map.Entry<Checksum, String> entry : this.supplied.entrySet()) {
            ChecksumUtils.verifyChecksum(file, entry.getValue(), MessageDigest.getInstance(entry.getKey().algo()));
        }
    }

    private static Map<Checksum, String> create(@Nullable String md5, @Nullable String sha1, @Nullable String sha256, @Nullable String sha512) {
        EnumMap<Checksum, String> digests = new EnumMap<Checksum, String>(Checksum.class);
        if (md5 != null) {
            digests.put(Checksum.MD5, md5);
        }
        if (sha1 != null) {
            digests.put(Checksum.SHA1, sha1);
        }
        if (sha256 != null) {
            digests.put(Checksum.SHA256, sha256);
        }
        if (sha512 != null) {
            digests.put(Checksum.SHA512, sha512);
        }
        return digests;
    }
}

