/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.boolex;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.boolex.JaninoEventEvaluatorBase;
import ch.qos.logback.core.boolex.Matcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;

public class JaninoEventEvaluator
extends JaninoEventEvaluatorBase<ILoggingEvent> {
    public static final String IMPORT_LEVEL = "import ch.qos.logback.classic.Level;\r\n";
    public static final List<String> DEFAULT_PARAM_NAME_LIST = new ArrayList<String>();
    public static final List<Class> DEFAULT_PARAM_TYPE_LIST = new ArrayList<Class>();

    @Override
    protected String getDecoratedExpression() {
        String expression = this.getExpression();
        if (!expression.contains("return")) {
            expression = "return " + expression + ";";
            this.addInfo("Adding [return] prefix and a semicolon suffix. Expression becomes [" + expression + "]");
            this.addInfo("See also http://logback.qos.ch/codes.html#block");
        }
        return IMPORT_LEVEL + expression;
    }

    @Override
    protected String[] getParameterNames() {
        ArrayList<String> fullNameList = new ArrayList<String>();
        fullNameList.addAll(DEFAULT_PARAM_NAME_LIST);
        for (int i2 = 0; i2 < this.matcherList.size(); ++i2) {
            Matcher m3 = (Matcher)this.matcherList.get(i2);
            fullNameList.add(m3.getName());
        }
        return fullNameList.toArray(CoreConstants.EMPTY_STRING_ARRAY);
    }

    @Override
    protected Class[] getParameterTypes() {
        ArrayList<Class<Matcher>> fullTypeList = new ArrayList<Class<Matcher>>();
        fullTypeList.addAll(DEFAULT_PARAM_TYPE_LIST);
        for (int i2 = 0; i2 < this.matcherList.size(); ++i2) {
            fullTypeList.add(Matcher.class);
        }
        return fullTypeList.toArray(CoreConstants.EMPTY_CLASS_ARRAY);
    }

    @Override
    protected Object[] getParameterValues(ILoggingEvent loggingEvent) {
        int matcherListSize = this.matcherList.size();
        int i2 = 0;
        Object[] values2 = new Object[DEFAULT_PARAM_NAME_LIST.size() + matcherListSize];
        values2[i2++] = Level.DEBUG_INTEGER;
        values2[i2++] = Level.INFO_INTEGER;
        values2[i2++] = Level.WARN_INTEGER;
        values2[i2++] = Level.ERROR_INTEGER;
        values2[i2++] = loggingEvent;
        values2[i2++] = loggingEvent.getMessage();
        values2[i2++] = loggingEvent.getFormattedMessage();
        values2[i2++] = loggingEvent.getLoggerName();
        values2[i2++] = loggingEvent.getLoggerContextVO();
        values2[i2++] = loggingEvent.getLevel().toInteger();
        values2[i2++] = loggingEvent.getTimeStamp();
        values2[i2++] = loggingEvent.getMarker();
        values2[i2++] = loggingEvent.getMDCPropertyMap();
        IThrowableProxy iThrowableProxy = loggingEvent.getThrowableProxy();
        if (iThrowableProxy != null) {
            values2[i2++] = iThrowableProxy;
            values2[i2++] = iThrowableProxy instanceof ThrowableProxy ? ((ThrowableProxy)iThrowableProxy).getThrowable() : null;
        } else {
            values2[i2++] = null;
            values2[i2++] = null;
        }
        for (int j = 0; j < matcherListSize; ++j) {
            values2[i2++] = (Matcher)this.matcherList.get(j);
        }
        return values2;
    }

    static {
        DEFAULT_PARAM_NAME_LIST.add("DEBUG");
        DEFAULT_PARAM_NAME_LIST.add("INFO");
        DEFAULT_PARAM_NAME_LIST.add("WARN");
        DEFAULT_PARAM_NAME_LIST.add("ERROR");
        DEFAULT_PARAM_NAME_LIST.add("event");
        DEFAULT_PARAM_NAME_LIST.add("message");
        DEFAULT_PARAM_NAME_LIST.add("formattedMessage");
        DEFAULT_PARAM_NAME_LIST.add("logger");
        DEFAULT_PARAM_NAME_LIST.add("loggerContext");
        DEFAULT_PARAM_NAME_LIST.add("level");
        DEFAULT_PARAM_NAME_LIST.add("timeStamp");
        DEFAULT_PARAM_NAME_LIST.add("marker");
        DEFAULT_PARAM_NAME_LIST.add("mdc");
        DEFAULT_PARAM_NAME_LIST.add("throwableProxy");
        DEFAULT_PARAM_NAME_LIST.add("throwable");
        DEFAULT_PARAM_TYPE_LIST.add(Integer.TYPE);
        DEFAULT_PARAM_TYPE_LIST.add(Integer.TYPE);
        DEFAULT_PARAM_TYPE_LIST.add(Integer.TYPE);
        DEFAULT_PARAM_TYPE_LIST.add(Integer.TYPE);
        DEFAULT_PARAM_TYPE_LIST.add(ILoggingEvent.class);
        DEFAULT_PARAM_TYPE_LIST.add(String.class);
        DEFAULT_PARAM_TYPE_LIST.add(String.class);
        DEFAULT_PARAM_TYPE_LIST.add(String.class);
        DEFAULT_PARAM_TYPE_LIST.add(LoggerContextVO.class);
        DEFAULT_PARAM_TYPE_LIST.add(Integer.TYPE);
        DEFAULT_PARAM_TYPE_LIST.add(Long.TYPE);
        DEFAULT_PARAM_TYPE_LIST.add(Marker.class);
        DEFAULT_PARAM_TYPE_LIST.add(Map.class);
        DEFAULT_PARAM_TYPE_LIST.add(IThrowableProxy.class);
        DEFAULT_PARAM_TYPE_LIST.add(Throwable.class);
    }
}

