/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.escalation;

import com.redhat.parodos.examples.escalation.checker.SimpleTaskOneChecker;
import com.redhat.parodos.examples.escalation.task.SimpleTaskOne;
import com.redhat.parodos.examples.escalation.task.SimpleTaskOneEscalator;
import com.redhat.parodos.examples.escalation.task.SimpleTaskTwo;
import com.redhat.parodos.workflow.annotation.Checker;
import com.redhat.parodos.workflow.annotation.Escalation;
import com.redhat.parodos.workflow.annotation.Infrastructure;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.workflow.SequentialFlow;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.Date;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EscalationWorkFlowConfiguration {
    @Bean
    @Infrastructure
    public WorkFlow workflowStartingCheckingAndEscalation(SimpleTaskOne simpleTaskOne) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("workflowStartingCheckingAndEscalation").execute((Work)simpleTaskOne).build();
    }

    @Bean
    public SimpleTaskOne simpleTaskOne(@Qualifier(value="simpleTaskOneCheckerWorkflow") WorkFlow simpleTaskOneCheckerWorkflow) {
        SimpleTaskOne taskOne = new SimpleTaskOne();
        taskOne.setWorkFlowChecker(simpleTaskOneCheckerWorkflow);
        return taskOne;
    }

    @Bean
    @Checker(cronExpression="*/5 * * * * ?")
    public WorkFlow simpleTaskOneCheckerWorkflow(@Qualifier(value="simpleTaskOneCheckerTask") SimpleTaskOneChecker simpleTaskOneCheckerTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("simpleTaskOneCheckerWorkflow").execute((Work)simpleTaskOneCheckerTask).build();
    }

    @Bean
    public SimpleTaskOneChecker simpleTaskOneCheckerTask(@Qualifier(value="simpleTaskOneEscalatorWorkflow") WorkFlow simpleTaskOneEscalatorWorkflow) {
        return new SimpleTaskOneChecker(simpleTaskOneEscalatorWorkflow, new Date().getTime() / 1000L + 30L);
    }

    @Bean
    @Escalation
    public WorkFlow simpleTaskOneEscalatorWorkflow(@Qualifier(value="simpleTaskOneEscalator") SimpleTaskOneEscalator simpleTaskOneEscalator) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("simpleTaskOneEscalatorWorkflow").execute((Work)simpleTaskOneEscalator).build();
    }

    @Bean
    public SimpleTaskOneEscalator simpleTaskOneEscalator() {
        return new SimpleTaskOneEscalator();
    }

    @Bean
    @Infrastructure
    public WorkFlow workflowContinuesAfterCheckingEscalation(SimpleTaskTwo simpleTaskTwo) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("workflowContinuesAfterCheckingEscalation").execute((Work)simpleTaskTwo).build();
    }

    @Bean
    public SimpleTaskTwo simpleTaskTwo() {
        return new SimpleTaskTwo();
    }
}

