/*
 * Decompiled with CFR 0.152.
 */
package org.parodos.workflow.examples.custom;

import com.redhat.parodos.workflow.annotation.Checker;
import com.redhat.parodos.workflow.annotation.Infrastructure;
import com.redhat.parodos.workflow.annotation.Parameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.workflow.SequentialFlow;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.List;
import org.parodos.workflow.examples.custom.task.CustomWorkFlowTask;
import org.parodos.workflow.examples.custom.task.SimpleWorkFlowCheckerTask;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CustomWorkFlowConfiguration {
    @Bean
    CustomWorkFlowTask customWorkFlowTaskOne(@Qualifier(value="simpleWorkFlowChecker") WorkFlow simpleWorkFlowChecker) {
        CustomWorkFlowTask customWorkFlowTaskOne = new CustomWorkFlowTask();
        customWorkFlowTaskOne.setWorkFlowCheckers(List.of(simpleWorkFlowChecker));
        return customWorkFlowTaskOne;
    }

    @Bean
    CustomWorkFlowTask customWorkFlowTaskTwo() {
        return new CustomWorkFlowTask();
    }

    @Bean(name={"customWorkflow_INFRASTRUCTURE_WORKFLOW"})
    @Infrastructure(parameters={@Parameter(key="workloadId", description="The workload id", type=WorkParameterType.TEXT, optional=false), @Parameter(key="projectUrl", description="The project url", type=WorkParameterType.URI, optional=true)})
    WorkFlow customWorkflow(@Qualifier(value="customWorkFlowTaskOne") CustomWorkFlowTask customWorkFlowTaskOne, @Qualifier(value="customWorkFlowTaskTwo") CustomWorkFlowTask customWorkFlowTaskTwo) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("customWorkflow_INFRASTRUCTURE_WORKFLOW").execute((Work)customWorkFlowTaskOne).then((Work)customWorkFlowTaskTwo).build();
    }

    @Bean
    SimpleWorkFlowCheckerTask simpleCustomCheckerTask() {
        return new SimpleWorkFlowCheckerTask();
    }

    @Bean(name={"simpleWorkFlowChecker"})
    @Checker(cronExpression="*/5 * * * * ?")
    WorkFlow simpleWorkFlowChecker(@Qualifier(value="simpleCustomCheckerTask") SimpleWorkFlowCheckerTask simpleCustomCheckerTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("simpleWorkFlowChecker").execute((Work)simpleCustomCheckerTask).build();
    }
}

