/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.vmonboarding.task;

import com.redhat.parodos.examples.vmonboarding.dto.ServiceNowRequestDTO;
import com.redhat.parodos.examples.vmonboarding.dto.ServiceNowResponseDTO;
import com.redhat.parodos.utils.RestUtils;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class ServiceNowTicketCreationWorkFlowTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceNowTicketCreationWorkFlowTask.class);
    private final String serviceNowUrl;
    private final String username;
    private final String password;
    private static final String CREATE_INCIDENT_CONTEXT_PATH = "/api/now/table/incident";

    public ServiceNowTicketCreationWorkFlowTask(String serviceNowUrl, String username, String password) {
        this.serviceNowUrl = serviceNowUrl;
        this.username = username;
        this.password = password;
    }

    public WorkReport execute(WorkContext workContext) {
        log.info("Start ServiceNowTicketCreationWorkFlowTask...");
        try {
            String urlString = this.serviceNowUrl + CREATE_INCIDENT_CONTEXT_PATH;
            String vmName = this.getOptionalParameterValue("hostname", "snowrhel");
            String vmType = this.getRequiredParameterValue("VM_TYPE");
            log.info("vm name: {}", (Object)vmName);
            ServiceNowRequestDTO request = ServiceNowRequestDTO.builder().callerId(this.username).shortDescription(String.format("Azure %s Vm Onboarding", vmType)).build();
            ResponseEntity response = RestUtils.executePost((String)urlString, (Object)request, (String)this.username, (String)this.password, ServiceNowResponseDTO.class);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                String sysId = ((ServiceNowResponseDTO)response.getBody()).getResult().getSysId();
                String number = ((ServiceNowResponseDTO)response.getBody()).getResult().getNumber();
                log.info("Rest call completed, sys id: {}, incident number: {}", (Object)sysId, (Object)number);
                this.addParameter("INCIDENT_ID", sysId);
                return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
            }
            log.error("Call to the API was not successful. Response: {}", (Object)response.getStatusCode());
        }
        catch (Exception e) {
            log.error("There was an issue with the REST call: {}", (Object)e.getMessage());
        }
        return new DefaultWorkReport(WorkStatus.FAILED, workContext);
    }
}

