/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.vmonboarding.task;

import com.redhat.parodos.infrastructure.Notifier;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationWorkFlowTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationWorkFlowTask.class);
    private final Notifier notifier;
    private final String subject;

    public NotificationWorkFlowTask(Notifier notifier, String subject) {
        this.notifier = notifier;
        this.subject = subject;
    }

    public WorkReport execute(WorkContext workContext) {
        this.notifier.send(this.subject, this.buildMessage(this.subject));
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    private String buildMessage(String subject) {
        String message = this.getOptionalParameterValue("NOTIFICATION_MESSAGE", "");
        this.taskLogger.logInfoWithSlf4j(message, new String[0]);
        return "Task %s completed with success. %n".formatted(subject) + message;
    }
}

