/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.vmonboarding.task;

import com.redhat.parodos.tasks.ansible.AapGetJobResponseDTO;
import com.redhat.parodos.tasks.ansible.AapLaunchJobWorkFlowTask;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AapInstallToolsWorkFlowTask
extends AapLaunchJobWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AapInstallToolsWorkFlowTask.class);

    public AapInstallToolsWorkFlowTask(String aapUrl, String installToolsJobTemplateId, String username, String password) {
        super(aapUrl, username, password);
        this.jobTemplateId = installToolsJobTemplateId;
    }

    public WorkReport execute(WorkContext workContext) {
        String vmType;
        log.info("Start AapInstallToolsWorkFlowTask...");
        try {
            vmType = this.getRequiredParameterValue("VM_TYPE");
        }
        catch (MissingParameterException e) {
            log.error("parameter VM_TYPE was not found");
            return new DefaultWorkReport(WorkStatus.FAILED, workContext);
        }
        boolean skipChecker = "WINDOWS".equalsIgnoreCase(vmType);
        this.addParameter("SKIP", String.valueOf(skipChecker));
        return skipChecker ? new DefaultWorkReport(WorkStatus.COMPLETED, workContext) : super.execute(workContext);
    }

    protected void responseAction(AapGetJobResponseDTO responseDTO) {
        String jobId = responseDTO.getJobId();
        log.info("Rest call completed, job id: {}", (Object)jobId);
        this.addParameter("TOOLS_JOB_ID", jobId);
    }
}

