/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.vmonboarding.task;

import com.redhat.parodos.tasks.ansible.AapGetJobResponseDTO;
import com.redhat.parodos.tasks.ansible.AapLaunchJobWorkFlowTask;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AapCreateVMWorkFlowTask
extends AapLaunchJobWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AapCreateVMWorkFlowTask.class);
    private final String windowsJobTemplateId;
    private final String rhelJobTemplateId;

    public AapCreateVMWorkFlowTask(String aapUrl, String windowsJobTemplateId, String rhelJobTemplateId, String username, String password) {
        super(aapUrl, username, password);
        this.windowsJobTemplateId = windowsJobTemplateId;
        this.rhelJobTemplateId = rhelJobTemplateId;
    }

    public WorkReport execute(WorkContext workContext) {
        String vmType;
        log.info("Start AapCreateVMWorkFlowTask...");
        try {
            vmType = this.getRequiredParameterValue("VM_TYPE");
        }
        catch (MissingParameterException e) {
            log.error("parameter VM_TYPE was not found");
            return new DefaultWorkReport(WorkStatus.FAILED, workContext);
        }
        this.jobTemplateId = "WINDOWS".equalsIgnoreCase(vmType) ? this.windowsJobTemplateId : this.rhelJobTemplateId;
        this.addParameter("VM_TYPE", vmType);
        return super.execute(workContext);
    }

    protected void responseAction(AapGetJobResponseDTO responseDTO) {
        String jobId = responseDTO.getJobId();
        log.info("Rest call completed, job id: {}", (Object)jobId);
        this.addParameter("JOB_ID", jobId);
    }
}

