/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.vmonboarding.checker;

import com.redhat.parodos.examples.vmonboarding.dto.ServiceNowResponseDTO;
import com.redhat.parodos.utils.RestUtils;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.checker.BaseWorkFlowCheckerTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;

public class ServiceNowTicketApprovalWorkFlowCheckerTask
extends BaseWorkFlowCheckerTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceNowTicketApprovalWorkFlowCheckerTask.class);
    private final String serviceNowUrl;
    private final String username;
    private final String password;

    public ServiceNowTicketApprovalWorkFlowCheckerTask(String serviceNowUrl, String username, String password) {
        this.serviceNowUrl = serviceNowUrl;
        this.username = username;
        this.password = password;
    }

    public WorkReport checkWorkFlowStatus(WorkContext workContext) {
        block6: {
            log.info("Start ServiceNowTicketApprovalWorkFlowCheckerTask...");
            try {
                String incidentId = this.getRequiredParameterValue("INCIDENT_ID");
                log.info("INCIDENT id: {}", (Object)incidentId);
                String urlString = this.serviceNowUrl + "/api/now/table/incident/" + incidentId;
                ResponseEntity result = RestUtils.restExchange((String)urlString, (String)this.username, (String)this.password, ServiceNowResponseDTO.class);
                ServiceNowResponseDTO responseDto = (ServiceNowResponseDTO)result.getBody();
                if (!result.getStatusCode().is2xxSuccessful() || responseDto == null) {
                    log.error("Call to the API was not successful. Response: {} ", (Object)result.getStatusCode());
                    break block6;
                }
                if ("1".equalsIgnoreCase(responseDto.getResult().getState())) {
                    log.error("incident is not approved.  Status: {}", (Object)responseDto.getResult().getState());
                    break block6;
                }
                if ("8".equalsIgnoreCase(responseDto.getResult().getState())) {
                    log.error("incident is failed.  Status: {}", (Object)responseDto.getResult().getState());
                    return new DefaultWorkReport(WorkStatus.REJECTED, workContext);
                }
                log.info("incident completed: {}", (Object)responseDto.getResult().getState());
                return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
            }
            catch (RestClientException e) {
                log.error("There was an issue with the REST call: {}", (Object)e.getMessage());
            }
            catch (MissingParameterException e) {
                log.error("There was an error getting parameter(s): {}", (Object)e.getMessage());
            }
        }
        return new DefaultWorkReport(WorkStatus.FAILED, workContext);
    }
}

