/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.vmonboarding.checker;

import com.redhat.parodos.tasks.ansible.AapGetJobResponseDTO;
import com.redhat.parodos.tasks.ansible.AnsibleCompletionWorkFlowCheckerTask;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnsibleVMCreationWorkFlowCheckerTask
extends AnsibleCompletionWorkFlowCheckerTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnsibleVMCreationWorkFlowCheckerTask.class);

    public AnsibleVMCreationWorkFlowCheckerTask(String aapUrl, String username, String password) {
        super(aapUrl, username, password);
    }

    public WorkReport checkWorkFlowStatus(WorkContext workContext) {
        log.info("Start AnsibleVMCreationWorkFlowCheckerTask ...");
        try {
            this.jobId = this.getRequiredParameterValue("JOB_ID");
            log.info("job id: {}", (Object)this.jobId);
        }
        catch (MissingParameterException e) {
            log.error("parameter JOB_ID is not found!");
            return new DefaultWorkReport(WorkStatus.REJECTED, workContext);
        }
        return super.checkWorkFlowStatus(workContext);
    }

    protected void responseAction(AapGetJobResponseDTO responseDTO) {
        String message;
        String ip = responseDTO.getArtifacts().getAzureVmPublicIp();
        this.addParameter("VM_IP", ip);
        String vmType = null;
        try {
            vmType = this.getRequiredParameterValue("VM_TYPE");
        }
        catch (MissingParameterException e) {
            log.error("parameter VM_TYPE is not found");
        }
        String envVars = responseDTO.getExtraVars().replace("\\", "");
        if ("WINDOWS".equalsIgnoreCase(vmType)) {
            String vmUsername = envVars.split("\"win_admin_user\": \"")[1].split("\"")[0];
            String vmPassword = envVars.split("\"win_admin_password\": \"")[1].split("\"")[0];
            message = String.format("please use the information below to connect to your windows VM: ip: %s, username: %s, password: %s", ip, vmUsername, vmPassword);
        } else {
            String vmUsername = envVars.split("\"rhel_admin_user\": \"")[1].split("\"")[0];
            message = String.format("please run this cmd to connect to your vm: ssh -i id_rsa %s@%s", vmUsername, ip);
        }
        this.addParameter("NOTIFICATION_MESSAGE", message);
    }
}

