/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.vmonboarding.checker;

import com.redhat.parodos.examples.vmonboarding.checker.AnsibleVMCreationWorkFlowCheckerTask;
import com.redhat.parodos.tasks.ansible.AapGetJobResponseDTO;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnsibleJobCompletionWorkFlowCheckerTask
extends AnsibleVMCreationWorkFlowCheckerTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnsibleJobCompletionWorkFlowCheckerTask.class);

    public AnsibleJobCompletionWorkFlowCheckerTask(String aapUrl, String username, String password) {
        super(aapUrl, username, password);
    }

    @Override
    public WorkReport checkWorkFlowStatus(WorkContext workContext) {
        log.info("Start AnsibleJobCompletionWorkFlowCheckerTask ...");
        String skipChecker = null;
        try {
            skipChecker = this.getRequiredParameterValue("SKIP");
        }
        catch (MissingParameterException e) {
            log.error("parameter SKIP was not found");
        }
        if ("true".equalsIgnoreCase(skipChecker)) {
            return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
        }
        try {
            this.jobId = this.getRequiredParameterValue("TOOLS_JOB_ID");
            log.info("job id: {}", (Object)this.jobId);
        }
        catch (MissingParameterException e) {
            log.error("parameter TOOLS_JOB_ID is not found!");
            return new DefaultWorkReport(WorkStatus.REJECTED, workContext);
        }
        return super.checkWorkFlowStatus(workContext);
    }

    @Override
    protected void responseAction(AapGetJobResponseDTO responseDTO) {
        String message = "java and tomcat has been installed in your VM!";
        this.addParameter("NOTIFICATION_MESSAGE", message);
        this.taskLogger.logInfoWithSlf4j(message, new String[0]);
    }
}

