/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.prebuilt.project;

import com.redhat.parodos.infrastructure.Notifier;
import com.redhat.parodos.tasks.project.ProjectAccessRequestApprovalWorkFlowTask;
import com.redhat.parodos.tasks.project.ProjectAccessRequestWorkFlowTask;
import com.redhat.parodos.tasks.project.checker.ProjectAccessRequestApprovalWorkFlowCheckerTask;
import com.redhat.parodos.tasks.project.escalation.ProjectAccessRequestEscalationWorkFlowTask;
import com.redhat.parodos.workflow.annotation.Checker;
import com.redhat.parodos.workflow.annotation.Escalation;
import com.redhat.parodos.workflow.annotation.Infrastructure;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.workflow.SequentialFlow;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ProjectAccessRequestWorkFlowConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectAccessRequestWorkFlowConfiguration.class);

    @Bean
    ProjectAccessRequestEscalationWorkFlowTask projectAccessRequestEscalationWorkFlowTask(@Value(value="${SERVICE_URL:http://localhost:8080}") String serviceUrl, Notifier notifier) {
        return new ProjectAccessRequestEscalationWorkFlowTask(serviceUrl, notifier);
    }

    @Bean(name={"projectAccessRequestEscalationWorkFlow"})
    @Escalation
    WorkFlow projectAccessRequestEscalationWorkFlow(@Qualifier(value="projectAccessRequestEscalationWorkFlowTask") ProjectAccessRequestEscalationWorkFlowTask projectAccessRequestEscalationWorkFlowTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("projectAccessRequestEscalationWorkFlow").execute((Work)projectAccessRequestEscalationWorkFlowTask).build();
    }

    @Bean
    ProjectAccessRequestApprovalWorkFlowCheckerTask projectAccessRequestApprovalWorkFlowCheckerTask(@Qualifier(value="projectAccessRequestEscalationWorkFlow") WorkFlow projectAccessRequestEscalationWorkFlow, @Value(value="${SERVICE_URL:http://localhost:8080}") String serviceUrl, @Value(value="${SERVICE_USERNAME:test}") String serviceUsername, @Value(value="${SERVICE_PASSWORD:test}") String servicePassword) {
        return new ProjectAccessRequestApprovalWorkFlowCheckerTask(projectAccessRequestEscalationWorkFlow, new Date().getTime() / 1000L + 30L, serviceUrl, serviceUsername, servicePassword);
    }

    @Bean(name={"projectAccessRequestApprovalWorkFlowChecker"})
    @Checker(cronExpression="*/5 * * * * ?")
    WorkFlow projectAccessRequestApprovalWorkFlowChecker(@Qualifier(value="projectAccessRequestApprovalWorkFlowCheckerTask") ProjectAccessRequestApprovalWorkFlowCheckerTask projectAccessRequestApprovalWorkFlowCheckerTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("projectAccessRequestApprovalWorkFlowChecker").execute((Work)projectAccessRequestApprovalWorkFlowCheckerTask).build();
    }

    @Bean
    ProjectAccessRequestWorkFlowTask projectAccessRequestWorkFlowTask(@Value(value="${SERVICE_URL:http://localhost:8080}") String serviceUrl, @Value(value="${SERVICE_USERNAME:test}") String serviceUsername, @Value(value="${SERVICE_PASSWORD:test}") String servicePassword) {
        return new ProjectAccessRequestWorkFlowTask(serviceUrl, serviceUsername, servicePassword);
    }

    @Bean
    ProjectAccessRequestApprovalWorkFlowTask projectAccessRequestApprovalWorkFlowTask(@Value(value="${SERVICE_URL:http://localhost:8080}") String serviceUrl, Notifier notifier, @Qualifier(value="projectAccessRequestApprovalWorkFlowChecker") WorkFlow projectAccessRequestApprovalWorkFlowChecker) {
        ProjectAccessRequestApprovalWorkFlowTask projectAccessRequestApprovalWorkFlowTask = new ProjectAccessRequestApprovalWorkFlowTask(serviceUrl, notifier);
        projectAccessRequestApprovalWorkFlowTask.setWorkFlowCheckers(List.of(projectAccessRequestApprovalWorkFlowChecker));
        return projectAccessRequestApprovalWorkFlowTask;
    }

    @Bean(name={"projectAccessRequestWorkFlow"})
    @Infrastructure
    WorkFlow projectAccessRequestWorkFlow(@Qualifier(value="projectAccessRequestWorkFlowTask") ProjectAccessRequestWorkFlowTask projectAccessRequestWorkFlowTask, @Qualifier(value="projectAccessRequestApprovalWorkFlowTask") ProjectAccessRequestApprovalWorkFlowTask projectAccessRequestApprovalWorkFlowTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("projectAccessRequestWorkFlow").execute((Work)projectAccessRequestWorkFlowTask).then((Work)projectAccessRequestApprovalWorkFlowTask).build();
    }
}

