/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.prebuilt.migrationtoolkit;

import com.redhat.parodos.examples.prebuilt.migrationtoolkit.ProcessAnalysisTask;
import com.redhat.parodos.infrastructure.Notifier;
import com.redhat.parodos.tasks.migrationtoolkit.CreateApplicationTask;
import com.redhat.parodos.tasks.migrationtoolkit.GetAnalysisTask;
import com.redhat.parodos.tasks.migrationtoolkit.GetApplicationTask;
import com.redhat.parodos.tasks.migrationtoolkit.SubmitAnalysisTask;
import com.redhat.parodos.workflow.annotation.Assessment;
import com.redhat.parodos.workflow.annotation.Checker;
import com.redhat.parodos.workflow.annotation.Parameter;
import com.redhat.parodos.workflow.option.WorkFlowOption;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.workflow.SequentialFlow;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.net.URI;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MigrationAssessmentWorkflow {
    @Value(value="${workflows.mta.url}")
    private String mtaUrl;

    @Bean
    public CreateApplicationTask createApplicationTask() {
        return new CreateApplicationTask(URI.create(this.mtaUrl), "");
    }

    @Bean
    public GetApplicationTask getApplicationTask() {
        return new GetApplicationTask(URI.create(this.mtaUrl), "");
    }

    @Bean
    public SubmitAnalysisTask submitAnalysisTask(WorkFlow fetchReportURL) {
        SubmitAnalysisTask t = new SubmitAnalysisTask(URI.create(this.mtaUrl), "");
        t.setWorkFlowCheckers(List.of(fetchReportURL));
        return t;
    }

    @Bean
    public GetAnalysisTask getAnalysisTask(Notifier notifier) {
        return new GetAnalysisTask(URI.create(this.mtaUrl), "", notifier);
    }

    @Bean
    ProcessAnalysisTask processAnalysisTask(WorkFlowOption move2kube, WorkFlowOption defaultOption, Notifier notifier) {
        return new ProcessAnalysisTask(move2kube, defaultOption, analysisIncidents -> analysisIncidents.mandatory() == 0 && analysisIncidents.cloudMandatory() == 0, notifier);
    }

    @Bean
    WorkFlowOption defaultOption() {
        return new WorkFlowOption.Builder("defaultOption", "AnalyzeApplicationAssessment").addToDetails("Rerun Analysis").displayName("Run Migration Analysis").setDescription("This application didn't meet the expected analysis score. Update or apply the relevant fixes and re-run the analysis").build();
    }

    @Bean(name={"AnalyzeApplicationAssessment"})
    @Assessment(parameters={@Parameter(key="repositoryURL", description="The repository with the code to analyze", type=WorkParameterType.URI, optional=false), @Parameter(key="applicationName", description="The name of the application to analyze", type=WorkParameterType.TEXT, optional=false), @Parameter(key="branch", description="The repository branch to analyze", type=WorkParameterType.TEXT, optional=true), @Parameter(key="identity", description="The identity of ssh key in MTA", type=WorkParameterType.TEXT, optional=true)})
    public WorkFlow AnalyzeApplicationAssessment(CreateApplicationTask createApplicationTask, GetApplicationTask getAppTask, SubmitAnalysisTask submitAnalysisTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("AnalyzeApplicationAssessment").execute((Work)createApplicationTask).then((Work)getAppTask).then((Work)submitAnalysisTask).build();
    }

    @Bean(value={"fetchReportURL"})
    @Checker(cronExpression="*/5 * * * * ?")
    public WorkFlow fetchReportURL(GetAnalysisTask getAnalysisTask, ProcessAnalysisTask processAnalysisTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("fetchReportURL").execute((Work)getAnalysisTask).then((Work)processAnalysisTask).build();
    }
}

