/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.ocponboarding.task;

import com.redhat.parodos.infrastructure.Notifier;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraTicketUpdateNotificationWorkFlowTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JiraTicketUpdateNotificationWorkFlowTask.class);
    private static final String ISSUE_LINK_PARAMETER_NAME = "ISSUE_LINK";
    private static final String NOTIFICATION_SUBJECT = "Jira ticket update notification";
    private final Notifier notifier;

    public JiraTicketUpdateNotificationWorkFlowTask(Notifier notifier) {
        this.notifier = notifier;
    }

    public WorkReport execute(WorkContext workContext) {
        String jiraTicketUrl;
        log.info("Start jiraTicketUpdateNotificationWorkFlowTask...");
        try {
            jiraTicketUrl = this.getRequiredParameterValue(ISSUE_LINK_PARAMETER_NAME);
        }
        catch (MissingParameterException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext);
        }
        this.notifier.send(NOTIFICATION_SUBJECT, this.buildMessage(jiraTicketUrl));
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    private String buildMessage(String jiraTicketUrl) {
        return "Hi there,\nThe jira ticket with updates of your request is provided below.\nJira ticket url: " + jiraTicketUrl + "\nThank you,\nThe Parodos Team";
    }
}

