/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.ocponboarding.task;

import com.redhat.parodos.infrastructure.Notifier;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppLinkNotificationWorkFlowTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppLinkNotificationWorkFlowTask.class);
    private static final String TEMPLATE_DEFAULT_ENCODING = "UTF-8";
    private static final String TEMPLATE_BASE_PACKAGE_PATH = "templates";
    private static final String TEMPLATE_NAME = "appLinkNotification.ftlh";
    private static final String JIRA_TICKET_URL_WORKFLOW_TASK_PARAMETER_NAME = "ISSUE_LINK";
    private static final String OCP_APP_LINK_WORKFLOW_TASK_PARAMETER_NAME = "APP_LINK";
    private static final String NOTIFICATION_SUBJECT = "App link notification";
    private final Notifier notifier;

    public AppLinkNotificationWorkFlowTask(Notifier notifier) {
        this.notifier = notifier;
    }

    public WorkReport execute(WorkContext workContext) {
        String message;
        log.info("Start appLinkNotificationWorkFlowTask...");
        HashMap<String, Object> messageData = new HashMap<String, Object>();
        try {
            String jiraTicketUrl = this.getRequiredParameterValue(JIRA_TICKET_URL_WORKFLOW_TASK_PARAMETER_NAME);
            messageData.put("jiraTicketUrl", jiraTicketUrl);
            String appLink = this.getRequiredParameterValue(OCP_APP_LINK_WORKFLOW_TASK_PARAMETER_NAME);
            messageData.put("appLink", appLink);
            message = this.getMessage(messageData);
        }
        catch (MissingParameterException | TemplateException | IOException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext);
        }
        this.notifier.send(NOTIFICATION_SUBJECT, message);
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    private String getMessage(Map<String, Object> templateData) throws IOException, TemplateException {
        String message = "";
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_30);
        cfg.setClassLoaderForTemplateLoading(((Object)((Object)this)).getClass().getClassLoader(), TEMPLATE_BASE_PACKAGE_PATH);
        cfg.setDefaultEncoding(TEMPLATE_DEFAULT_ENCODING);
        Template template = cfg.getTemplate(TEMPLATE_NAME);
        try (StringWriter out = new StringWriter();){
            template.process(templateData, (Writer)out);
            message = out.getBuffer().toString();
            out.flush();
        }
        return message;
    }
}

