/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.ocponboarding.escalation;

import com.redhat.parodos.infrastructure.Notifier;
import com.redhat.parodos.notification.sdk.model.NotificationMessageCreateRequestDTO;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraTicketApprovalEscalationWorkFlowTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JiraTicketApprovalEscalationWorkFlowTask.class);
    private static final String ISSUE_LINK = "ISSUE_LINK";
    private static final String NOTIFICATION_SUBJECT = "Jira ticket approval escalation";
    private final String escalationUserId;
    private final Notifier notifier;

    public JiraTicketApprovalEscalationWorkFlowTask(Notifier notifier, String escalationUserId) {
        this.notifier = notifier;
        this.escalationUserId = escalationUserId;
    }

    public WorkReport execute(WorkContext workContext) {
        String jiraTicketUrl;
        log.info("Start jiraTicketApprovalEscalationWorkFlowTask...");
        try {
            jiraTicketUrl = this.getRequiredParameterValue(ISSUE_LINK);
        }
        catch (MissingParameterException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext);
        }
        NotificationMessageCreateRequestDTO notificationMessageCreateRequestDTO = new NotificationMessageCreateRequestDTO();
        notificationMessageCreateRequestDTO.addUsernamesItem(this.escalationUserId);
        notificationMessageCreateRequestDTO.setBody(this.buildMessage(jiraTicketUrl));
        notificationMessageCreateRequestDTO.setSubject(NOTIFICATION_SUBJECT);
        this.notifier.send(notificationMessageCreateRequestDTO);
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    private String buildMessage(String jiraTicketUrl) {
        return "Hi there,\nThe jira ticket below has been escalated due to pending review and approval.\nJira ticket url: " + jiraTicketUrl + "\nThank you,\nThe Parodos Team";
    }
}

