/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.move2kube.task;

import com.redhat.parodos.examples.move2kube.task.Move2KubeBase;
import com.redhat.parodos.examples.move2kube.utils.Move2KubeUtils;
import com.redhat.parodos.infrastructure.Notifier;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import dev.parodos.move2kube.ApiException;
import dev.parodos.move2kube.api.PlanApi;
import dev.parodos.move2kube.api.ProjectOutputsApi;
import dev.parodos.move2kube.client.model.GetPlan200Response;
import dev.parodos.move2kube.client.model.StartTransformation202Response;
import dev.parodos.move2kube.client.model.StartTransformationRequest;
import java.io.IOException;
import java.net.URISyntaxException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class Move2KubeTransform
extends Move2KubeBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Move2KubeTransform.class);
    private PlanApi planApi;
    private ProjectOutputsApi projectOutputsApi;
    private Notifier notifierBus;
    private String plan;
    private String server;
    @Value(value="${workflows.m2k.public_url}")
    private String publicUrl;

    public Move2KubeTransform(String serverUrl, Notifier notifier) {
        this.setClient(serverUrl);
        this.planApi = new PlanApi(this.client);
        this.projectOutputsApi = new ProjectOutputsApi(this.client);
        this.notifierBus = notifier;
        this.server = serverUrl;
    }

    public Move2KubeTransform(String serverUrl, Notifier notifier, PlanApi plan, ProjectOutputsApi projectOutputs) {
        new Move2KubeTransform(serverUrl, notifier);
        this.planApi = plan;
        this.projectOutputsApi = projectOutputs;
        this.notifierBus = notifier;
        this.server = serverUrl;
    }

    @Override
    public WorkReport execute(WorkContext workContext) {
        String workspaceId = (String)workContext.get(Move2KubeTransform.getWorkspaceContextKey());
        String projectId = (String)workContext.get(Move2KubeTransform.getProjectContextKey());
        String transformId = null;
        try {
            this.isPlanCreated(workspaceId, projectId);
        }
        catch (ApiException | RuntimeException e) {
            String errorMessage = "Plan for workspace '%s'' and project '%s' is not created".formatted(workspaceId, projectId);
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new IllegalArgumentException(errorMessage));
        }
        try {
            transformId = this.transform(workspaceId, projectId);
            workContext.put(Move2KubeTransform.getTransformContextKey(), (Object)transformId);
        }
        catch (IOException | IllegalArgumentException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        catch (ApiException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        String message = this.sendNotification(workspaceId, projectId, transformId);
        if (message == null) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new RuntimeException("Cannot notify user about the transformation status"));
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext, message);
    }

    private String sendNotification(String workspaceID, String projectID, String outputID) {
        String message;
        String serverURL = this.server;
        if (this.publicUrl != null && !this.publicUrl.isEmpty()) {
            serverURL = this.publicUrl;
        }
        try {
            String url = Move2KubeUtils.getPath(serverURL, workspaceID, projectID, outputID);
            message = String.format("You need to complete some information for your transformation in the following [url](%s)", url);
            this.notifierBus.send("Move2kube workflow approval needed", message);
        }
        catch (URISyntaxException e) {
            log.error("Cannot parse move2kube url {}", (Object)this.server);
            return null;
        }
        return message;
    }

    private String transform(String workspaceID, String projectID) throws IllegalArgumentException, ApiException, IOException {
        StartTransformation202Response response = this.projectOutputsApi.startTransformation(workspaceID, projectID, StartTransformationRequest.fromJson((String)this.plan));
        if (response == null) {
            throw new IllegalArgumentException("Cannot start transformation");
        }
        return response.getId();
    }

    private void isPlanCreated(String workspaceID, String projectID) throws ApiException {
        GetPlan200Response response = this.planApi.getPlan(workspaceID, projectID);
        if (response == null) {
            throw new RuntimeException("Plan cannot be retrieved");
        }
        this.plan = response.toJson();
    }
}

