/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.move2kube.checker;

import com.google.common.base.Strings;
import com.redhat.parodos.examples.move2kube.utils.Move2KubeUtils;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.task.checker.BaseWorkFlowCheckerTask;
import com.redhat.parodos.workflow.task.enums.WorkFlowTaskOutput;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import dev.parodos.move2kube.ApiClient;
import dev.parodos.move2kube.ApiException;
import dev.parodos.move2kube.api.ProjectsApi;
import dev.parodos.move2kube.client.model.Project;
import dev.parodos.move2kube.client.model.ProjectOutputsValue;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.steppschuh.markdowngenerator.text.TextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class TransformChecker
extends BaseWorkFlowCheckerTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransformChecker.class);
    private ApiClient client = new ApiClient();
    private static String transformContextKey = "move2KubeTransformID";
    private static String workspaceContextKey = "move2KubeWorkspaceID";
    protected static String projectContextKey = "move2KubeProjectID";
    private final String server;
    @Value(value="${workflows.m2k.public_url}")
    private String publicUrl;

    public TransformChecker(String server) {
        this.client.setBasePath(server);
        this.server = server;
    }

    public WorkReport checkWorkFlowStatus(WorkContext workContext) {
        String workspaceID = (String)workContext.get(workspaceContextKey);
        String projectID = (String)workContext.get(projectContextKey);
        String transformID = (String)workContext.get(transformContextKey);
        if (Strings.isNullOrEmpty((String)transformID)) {
            return new DefaultWorkReport(WorkStatus.PENDING, workContext, (Throwable)new IllegalArgumentException("There is no transform ID"));
        }
        ProjectsApi project = new ProjectsApi(this.client);
        try {
            Project res = project.getProject(workspaceID, projectID);
            ProjectOutputsValue output = (ProjectOutputsValue)Objects.requireNonNull(res.getOutputs()).get(transformID);
            if (output == null) {
                String errorMsg = "Cannot get the project transformation output from the list";
                this.taskLogger.logErrorWithSlf4j(errorMsg, new String[0]);
                return new DefaultWorkReport(WorkStatus.REJECTED, workContext, (Throwable)new IllegalArgumentException(errorMsg));
            }
            if (!Objects.equals(output.getStatus(), "done")) {
                return new DefaultWorkReport(WorkStatus.FAILED, workContext, this.getMessage(workspaceID, projectID, transformID));
            }
        }
        catch (ApiException e) {
            return new DefaultWorkReport(WorkStatus.REJECTED, workContext, (Throwable)new IllegalArgumentException("Cannot get current project for the workflow, error:" + e.getMessage()));
        }
        catch (Exception e) {
            return new DefaultWorkReport(WorkStatus.REJECTED, workContext, (Throwable)new IllegalArgumentException("Transform checker cannot be validated:" + e.getMessage()));
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext, (String)null);
    }

    public List<WorkParameter> getWorkFlowTaskParameters() {
        return Collections.emptyList();
    }

    public List<WorkFlowTaskOutput> getWorkFlowTaskOutputs() {
        return Collections.emptyList();
    }

    private String getMessage(String workspaceID, String projectID, String transformId) {
        Object path;
        String serverURL = this.server;
        if (this.publicUrl != null && !this.publicUrl.isEmpty()) {
            serverURL = this.publicUrl;
        }
        try {
            path = Move2KubeUtils.getPath(serverURL, workspaceID, projectID, transformId);
        }
        catch (URISyntaxException e) {
            path = "Cannot parse move2kube url " + this.server;
        }
        return ((TextBuilder)((TextBuilder)((TextBuilder)((TextBuilder)((TextBuilder)((TextBuilder)new TextBuilder().heading("Alert", 1)).newParagraph()).text((Object)"You need to complete some information for your transformation")).newLine()).text((Object)"Please check this")).link("link", (String)path)).end().toString();
    }

    @Generated
    public static String getProjectContextKey() {
        return projectContextKey;
    }
}

