/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.doclet;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.util.DocTrees;
import com.sun.source.util.SimpleDocTreeVisitor;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.util.ElementScanner9;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;

public class Markdown
implements Doclet {
    private DocTrees treeUtils;
    private static final boolean OK = true;

    @Override
    public void init(Locale locale, Reporter reporter) {
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        return Set.of();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean run(DocletEnvironment environment) {
        this.treeUtils = environment.getDocTrees();
        ShowTags st = new ShowTags(System.out);
        st.show(environment.getSpecifiedElements());
        return true;
    }

    class ShowTags
    extends ElementScanner9<Void, Integer> {
        final PrintStream out;

        ShowTags(PrintStream out) {
            this.out = out;
        }

        void show(Set<? extends Element> elements) {
            this.scan(elements, Integer.valueOf(0));
        }

        @Override
        public Void scan(Element e, Integer depth) {
            DocCommentTree dcTree = Markdown.this.treeUtils.getDocCommentTree(e);
            if (dcTree != null) {
                String indent = "  ".repeat(depth);
                this.out.println(indent + "| " + e.getKind() + " " + e + " annotations has configuration " + e.getAnnotationMirrors().toArray().toString());
                if (e.getAnnotationMirrors().stream().anyMatch(a -> a.toString().equals("@org.springframework.context.annotation.Configuration"))) {
                    try {
                        Files.write(Paths.get(e.getSimpleName() + ".md", new String[0]), dcTree.getFullBody().toString().getBytes(), new OpenOption[0]);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                TreeMap<String, List<String>> tags = new TreeMap<String, List<String>>();
                new TagScanner(tags).visitDocComment(dcTree, null);
                tags.forEach((t, l) -> {
                    this.out.println(indent + "  @" + t);
                    l.forEach(c -> this.out.println(indent + "    " + c));
                });
            }
            if (e.getKind().toString().equals("RECORD")) {
                return null;
            }
            return (Void)super.scan(e, Integer.valueOf(depth + 1));
        }
    }

    class TagScanner
    extends SimpleDocTreeVisitor<Void, Void> {
        private final Map<String, List<String>> tags;

        TagScanner(Map<String, List<String>> tags) {
            this.tags = tags;
        }

        @Override
        public Void visitDocComment(DocCommentTree tree, Void p) {
            return (Void)this.visit(tree.getBlockTags(), null);
        }

        @Override
        public Void visitUnknownBlockTag(UnknownBlockTagTree tree, Void p) {
            String name = tree.getTagName();
            String content = tree.getContent().toString();
            this.tags.computeIfAbsent(name, n -> new ArrayList()).add(content);
            return null;
        }
    }
}

