/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.prebuilt.migrationtoolkit;

import com.redhat.parodos.examples.prebuilt.migrationtoolkit.MTAAnalysisReport;
import com.redhat.parodos.workflow.context.WorkContextDelegate;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.option.WorkFlowOption;
import com.redhat.parodos.workflow.option.WorkFlowOptions;
import com.redhat.parodos.workflow.task.assessment.BaseAssessmentTask;
import com.redhat.parodos.workflow.task.infrastructure.Notifier;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.function.Predicate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ProcessAnalysisTask
extends BaseAssessmentTask {
    private final WorkFlowOption passOption;
    private final WorkFlowOption defaultOption;
    private final Predicate<MTAAnalysisReport.AnalysisIncidents> incidentsPredicate;
    private final Notifier notificationSender;

    protected ProcessAnalysisTask(WorkFlowOption passOption, WorkFlowOption defaultOption, Predicate<MTAAnalysisReport.AnalysisIncidents> passCriteria, Notifier notifier) {
        super(List.of(passOption, defaultOption));
        this.passOption = passOption;
        this.defaultOption = defaultOption;
        this.incidentsPredicate = passCriteria;
        this.notificationSender = notifier;
    }

    public WorkReport execute(WorkContext workContext) {
        String reportURL;
        try {
            reportURL = this.getRequiredParameterValue("reportURL") + "/";
        }
        catch (MissingParameterException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext);
        }
        URI uri = URI.create(reportURL);
        try {
            String issueSummaries = uri.getScheme().startsWith("file") ? Files.readString(Paths.get(uri)) : this.download(uri.resolve("reports/data/issue_summaries.js"));
            MTAAnalysisReport.AnalysisIncidents incidents = MTAAnalysisReport.extractIncidents(issueSummaries);
            if (this.incidentsPredicate.test(incidents)) {
                this.notificationSender.send(this.passOption.getDisplayName(), "The MTA report summary passes the specified criteria in the workflow. \\ %s \\ ##Incidents summary %s".formatted(this.passOption.getDescription(), incidents));
                WorkContextDelegate.write((WorkContext)workContext, (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, (WorkContextDelegate.Resource)WorkContextDelegate.Resource.WORKFLOW_OPTIONS, (Object)new WorkFlowOptions.Builder().addNewOption(this.passOption).build());
            } else {
                WorkContextDelegate.write((WorkContext)workContext, (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, (WorkContextDelegate.Resource)WorkContextDelegate.Resource.WORKFLOW_OPTIONS, (Object)new WorkFlowOptions.Builder().addNewOption(this.defaultOption).build());
            }
            return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
        }
        catch (Exception e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
    }

    private String download(URI uri) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext nonValidatingSSLContext = SSLContext.getInstance("SSL");
        nonValidatingSSLContext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }}, SecureRandom.getInstanceStrong());
        HttpClient c = HttpClient.newBuilder().sslContext(nonValidatingSSLContext).followRedirects(HttpClient.Redirect.ALWAYS).build();
        try {
            HttpResponse<String> get = c.send(HttpRequest.newBuilder().uri(uri).build(), HttpResponse.BodyHandlers.ofString());
            if (get.statusCode() == 200) {
                return get.body();
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

