/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.prebuilt.migrationtoolkit;

import com.redhat.parodos.tasks.migrationtoolkit.CreateApplicationTask;
import com.redhat.parodos.tasks.migrationtoolkit.GetAnalysisTask;
import com.redhat.parodos.tasks.migrationtoolkit.GetApplicationTask;
import com.redhat.parodos.tasks.migrationtoolkit.SubmitAnalysisTask;
import com.redhat.parodos.workflow.annotation.Checker;
import com.redhat.parodos.workflow.annotation.Infrastructure;
import com.redhat.parodos.workflow.annotation.Parameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.infrastructure.Notifier;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.workflow.SequentialFlow;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.net.URI;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"dev"})
public class MigrationAnalysisWorkflow {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationAnalysisWorkflow.class);
    @Value(value="${workflows.mta.url}")
    private String mtaUrl;

    @Bean
    public CreateApplicationTask createApplicationTask() {
        return new CreateApplicationTask(URI.create(this.mtaUrl), "");
    }

    @Bean
    public GetApplicationTask getApplicationTask() {
        return new GetApplicationTask(URI.create(this.mtaUrl), "");
    }

    @Bean
    public SubmitAnalysisTask submitAnalysisTask(WorkFlow fetchReportURL) {
        SubmitAnalysisTask t = new SubmitAnalysisTask(URI.create(this.mtaUrl), "");
        t.setWorkFlowCheckers(List.of(fetchReportURL));
        return t;
    }

    @Bean
    public GetAnalysisTask getAnalysisTask(Notifier notifier) {
        return new GetAnalysisTask(URI.create(this.mtaUrl), "", notifier);
    }

    @Bean(name={"AnalyzeApplication"})
    @Infrastructure(parameters={@Parameter(key="repositoryURL", description="The repository with the code to analyze", type=WorkParameterType.URL, optional=false), @Parameter(key="applicationName", description="The name of the application to analyze", type=WorkParameterType.TEXT, optional=false)})
    public WorkFlow AnalyzeApplication(CreateApplicationTask createApplicationTask, GetApplicationTask getAppTask, SubmitAnalysisTask submitAnalysisTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("AnalyzeApplication").execute((Work)createApplicationTask).then((Work)getAppTask).then((Work)submitAnalysisTask).build();
    }

    @Bean(value={"fetchReportURL"})
    @Checker(cronExpression="*/5 * * * * ?")
    public WorkFlow fetchReportURL(GetAnalysisTask getAnalysisTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("fetchReportURL").execute((Work)getAnalysisTask).build();
    }
}

