/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.ocponboarding.checker;

import com.redhat.parodos.examples.ocponboarding.task.dto.jira.GetJiraTicketResponseDto;
import com.redhat.parodos.examples.ocponboarding.task.dto.jira.GetJiraTicketResponseValue;
import com.redhat.parodos.utils.RestUtils;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.checker.BaseWorkFlowCheckerTask;
import com.redhat.parodos.workflow.task.enums.WorkFlowTaskOutput;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;

public class JiraTicketApprovalWorkFlowCheckerTask
extends BaseWorkFlowCheckerTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JiraTicketApprovalWorkFlowCheckerTask.class);
    private static final String ISSUE_KEY = "ISSUE_KEY";
    private static final String CLUSTER_TOKEN = "CLUSTER_TOKEN";
    private static final String CLUSTER_TOKEN_CUSTOM_FIELD_ID = "customfield_10064";
    private static final String DONE = "DONE";
    private static final String DECLINED = "DECLINED";
    private final String jiraServiceBaseUrl;
    private final String jiraUsername;
    private final String jiraPassword;

    public JiraTicketApprovalWorkFlowCheckerTask(WorkFlow jiraTicketApprovalEscalationWorkFlow, long sla, String jiraServiceBaseUrl, String jiraUsername, String jiraPassword) {
        super(jiraTicketApprovalEscalationWorkFlow, sla);
        this.jiraServiceBaseUrl = jiraServiceBaseUrl;
        this.jiraUsername = jiraUsername;
        this.jiraPassword = jiraPassword;
    }

    public WorkReport checkWorkFlowStatus(WorkContext workContext) {
        log.info("Start jiraTicketApprovalWorkFlowCheckerTask...");
        try {
            String urlString = this.jiraServiceBaseUrl + "/rest/servicedeskapi/request/";
            String issueKey = this.getRequiredParameterValue(ISSUE_KEY);
            log.info("Calling: urlString: {} username: {}", (Object)urlString, (Object)this.jiraUsername);
            ResponseEntity result = RestUtils.restExchange((String)(urlString + issueKey), (String)this.jiraUsername, (String)this.jiraPassword, GetJiraTicketResponseDto.class);
            GetJiraTicketResponseDto responseDto = (GetJiraTicketResponseDto)result.getBody();
            if (!result.getStatusCode().is2xxSuccessful() || responseDto == null) {
                log.error("Call to the API was not successful. Response: {}", (Object)result.getStatusCode());
            } else {
                log.info("Rest call completed: {}", (Object)responseDto.getIssueKey());
                switch (responseDto.getCurrentStatus().getStatus().toUpperCase()) {
                    case "DONE": {
                        log.info("request {} is approved", (Object)responseDto.getIssueKey());
                        String clusterToken = responseDto.getRequestFieldValues().stream().filter(requestFieldValue -> requestFieldValue.getFieldId().equals(CLUSTER_TOKEN_CUSTOM_FIELD_ID)).findFirst().map(GetJiraTicketResponseValue::getValue).orElseThrow(() -> new MissingParameterException("cluster token is not provided by approver!")).toString();
                        this.addParameter(CLUSTER_TOKEN, clusterToken);
                        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
                    }
                    case "DECLINED": {
                        log.info("request {} is rejected", (Object)responseDto.getIssueKey());
                        return new DefaultWorkReport(WorkStatus.REJECTED, workContext);
                    }
                }
                log.info("request {} is waiting for approval", (Object)responseDto.getIssueKey());
            }
        }
        catch (RestClientException e) {
            log.error("There was an issue with the REST call: {}", (Object)e.getMessage());
        }
        catch (MissingParameterException e) {
            log.error("There was an error getting parameter(s): {}", (Object)e.getMessage());
        }
        return new DefaultWorkReport(WorkStatus.FAILED, workContext);
    }

    public List<WorkFlowTaskOutput> getWorkFlowTaskOutputs() {
        return List.of(WorkFlowTaskOutput.HTTP2XX, WorkFlowTaskOutput.OTHER);
    }
}

