/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.move2kube.task;

import com.redhat.parodos.examples.move2kube.task.Move2KubeBase;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import dev.parodos.move2kube.ApiClient;
import dev.parodos.move2kube.ApiException;
import dev.parodos.move2kube.api.PlanApi;
import dev.parodos.move2kube.api.ProjectInputsApi;
import dev.parodos.move2kube.client.model.GetPlan200Response;
import java.io.File;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Move2KubePlan
extends Move2KubeBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Move2KubePlan.class);
    private PlanApi planApi;
    private long sleepTime = 1000L;
    private ProjectInputsApi projectInputsApi;

    public Move2KubePlan(String server) {
        this.setClient(server);
        this.planApi = new PlanApi(this.client);
        ApiClient clientFormData = this.client;
        clientFormData.addDefaultHeader("Content-Type", "multipart/form-data");
        this.projectInputsApi = new ProjectInputsApi(clientFormData);
    }

    public Move2KubePlan(String server, PlanApi plan, ProjectInputsApi projectInputs) {
        new Move2KubePlan(server);
        this.setClient(server);
        this.planApi = plan;
        this.projectInputsApi = projectInputs;
    }

    @Override
    public WorkReport execute(WorkContext workContext) {
        String workspaceID = (String)workContext.get(Move2KubePlan.getWorkspaceContextKey());
        String projectID = (String)workContext.get(Move2KubePlan.getProjectContextKey());
        this.addSourceCode(workspaceID, projectID, (String)workContext.get("gitArchivePath"));
        try {
            this.planApi.startPlanning(workspaceID, projectID);
            for (int i = 1; i <= 10; ++i) {
                GetPlan200Response plan = this.planApi.getPlan(workspaceID, projectID);
                if (plan == null) {
                    try {
                        Thread.sleep((long)i * this.sleepTime);
                    }
                    catch (Exception e) {}
                    continue;
                }
                log.error("Plan is here in the {} attempt", (Object)i);
                break;
            }
        }
        catch (ApiException e) {
            log.error("Cannot execute plan, error: {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext);
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    private void addSourceCode(String workspaceID, String projectID, String ZIPPath) {
        File file = new File(ZIPPath);
        try {
            this.projectInputsApi.createProjectInput(workspaceID, projectID, "sources", "Id", "source code", file);
        }
        catch (Exception e) {
            log.error("cannot append source code! {}", (Object)e.getMessage());
        }
    }

    @Generated
    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }
}

