/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.move2kube;

import com.redhat.parodos.examples.move2kube.checker.TransformChecker;
import com.redhat.parodos.examples.move2kube.task.GitArchiveTask;
import com.redhat.parodos.examples.move2kube.task.GitBranchTask;
import com.redhat.parodos.examples.move2kube.task.GitCommitTask;
import com.redhat.parodos.examples.move2kube.task.GitPushTask;
import com.redhat.parodos.examples.move2kube.task.Move2KubePlan;
import com.redhat.parodos.examples.move2kube.task.Move2KubeRetrieve;
import com.redhat.parodos.examples.move2kube.task.Move2KubeTask;
import com.redhat.parodos.examples.move2kube.task.Move2KubeTransform;
import com.redhat.parodos.tasks.git.GitCloneTask;
import com.redhat.parodos.workflow.annotation.Checker;
import com.redhat.parodos.workflow.annotation.Infrastructure;
import com.redhat.parodos.workflow.task.infrastructure.Notifier;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.workflow.ParallelFlow;
import com.redhat.parodos.workflows.workflow.SequentialFlow;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.List;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class move2kubeWorkFlowConfiguration {
    @Value(value="${workflows.m2k.url}")
    private String m2kURL;

    @Bean
    GitCloneTask gitCloneTask() {
        return new GitCloneTask();
    }

    @Bean
    GitArchiveTask gitArchiveTask() {
        return new GitArchiveTask();
    }

    @Bean
    GitCommitTask gitCommitTask() {
        return new GitCommitTask();
    }

    @Bean
    GitPushTask gitPushTask() {
        return new GitPushTask();
    }

    @Bean
    GitBranchTask gitBranchTask() {
        return new GitBranchTask();
    }

    @Bean
    Move2KubeTask move2KubeTask() {
        return new Move2KubeTask(this.m2kURL);
    }

    @Bean
    Move2KubeRetrieve move2KubeRetrieve() {
        return new Move2KubeRetrieve(this.m2kURL);
    }

    @Bean
    TransformChecker transformChecker() {
        return new TransformChecker(this.m2kURL);
    }

    @Bean(name={"transformWorkFlowChecker"})
    @Checker(cronExpression="*/5 * * * * ?")
    WorkFlow transformWorkFlowChecker(@Qualifier(value="transformChecker") TransformChecker transformChecker) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("transformWorkFlowChecker").execute((Work)transformChecker).build();
    }

    @Bean
    Move2KubeTransform move2KubeTransform(@Qualifier(value="transformWorkFlowChecker") WorkFlow transformWorkFlowChecker, Notifier notifier) {
        Move2KubeTransform move2KubeTransform = new Move2KubeTransform(this.m2kURL, notifier);
        move2KubeTransform.setWorkFlowCheckers(List.of(transformWorkFlowChecker));
        return move2KubeTransform;
    }

    @Bean
    Move2KubePlan move2KubePlan() {
        return new Move2KubePlan(this.m2kURL);
    }

    @Bean(name={"move2KubeProject"})
    @Infrastructure
    WorkFlow move2KubeProject(@Qualifier(value="move2KubeTask") Move2KubeTask move2KubeTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("move2KubeProject").execute((Work)move2KubeTask).build();
    }

    @Bean(name={"getSources"})
    @Infrastructure
    WorkFlow getSources(@Qualifier(value="gitCloneTask") GitCloneTask gitCloneTask, @Qualifier(value="gitBranchTask") GitBranchTask gitBranchTask, @Qualifier(value="gitArchiveTask") GitArchiveTask gitArchiveTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("getSources").execute((Work)gitCloneTask).then((Work)gitBranchTask).then((Work)gitArchiveTask).build();
    }

    @Bean(name={"preparationWorkflow"})
    @Infrastructure
    WorkFlow preparationWorkflow(@Qualifier(value="getSources") WorkFlow getSources, @Qualifier(value="move2KubeProject") WorkFlow move2KubeProject) {
        return ParallelFlow.Builder.aNewParallelFlow().named("preparationWorkflow").execute(new Work[]{move2KubeProject, getSources}).with(Executors.newFixedThreadPool(2)).build();
    }

    @Bean(name={"move2KubeWorkFlow_INFRASTRUCTURE_WORKFLOW"})
    @Infrastructure
    WorkFlow move2kubeWorkflow(@Qualifier(value="preparationWorkflow") WorkFlow preparationWorkflow, @Qualifier(value="move2KubePlan") Move2KubePlan move2KubePlan, @Qualifier(value="move2KubeTransform") Move2KubeTransform move2KubeTransform, @Qualifier(value="move2KubeRetrieve") Move2KubeRetrieve move2KubeRetrieve, @Qualifier(value="gitCommitTask") GitCommitTask gitCommitTask, @Qualifier(value="gitPushTask") GitPushTask gitPushTask) {
        return SequentialFlow.Builder.aNewSequentialFlow().named("move2KubeWorkFlow_INFRASTRUCTURE_WORKFLOW").execute((Work)preparationWorkflow).then((Work)move2KubePlan).then((Work)move2KubeTransform).then((Work)move2KubeRetrieve).then((Work)gitCommitTask).then((Work)gitPushTask).build();
    }
}

