/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.ocponboarding.escalation;

import com.redhat.parodos.examples.ocponboarding.task.dto.email.MessageRequestDTO;
import com.redhat.parodos.utils.RestUtils;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.enums.WorkFlowTaskOutput;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;

public class JiraTicketApprovalEscalationWorkFlowTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JiraTicketApprovalEscalationWorkFlowTask.class);
    private static final String ISSUE_LINK = "ISSUE_LINK";
    private final String mailServiceUrl;
    private final String mailServiceSiteName;

    public JiraTicketApprovalEscalationWorkFlowTask(String mailServiceUrl, String mailServiceSiteName) {
        this.mailServiceUrl = mailServiceUrl;
        this.mailServiceSiteName = mailServiceSiteName;
    }

    public WorkReport execute(WorkContext workContext) {
        String jiraTicketUrl;
        log.info("Start jiraTicketApprovalEscalationWorkFlowTask...");
        String requesterName = "Test Test";
        String requesterEmail = "ttest@test.com";
        try {
            jiraTicketUrl = this.getRequiredParameterValue(ISSUE_LINK);
            log.info("Jira ticket url is: {}", (Object)jiraTicketUrl);
        }
        catch (MissingParameterException e) {
            log.error("JiraTicketApprovalEscalationWorkFlowTask failed! Message: {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext);
        }
        MessageRequestDTO messageRequestDTO = MessageRequestDTO.builder().name(requesterName).email(requesterEmail).siteName(this.mailServiceSiteName).message(this.getMessage(jiraTicketUrl)).build();
        ResponseEntity responseEntity = null;
        try {
            HttpEntity requestEntity = new HttpEntity((Object)messageRequestDTO);
            LocalDateTime startDateTime = LocalDateTime.now();
            responseEntity = RestUtils.executePost((String)this.mailServiceUrl, (HttpEntity)requestEntity);
            log.info("Request duration: {} ms", (Object)ChronoUnit.MILLIS.between(startDateTime, LocalDateTime.now()));
        }
        catch (Exception e) {
            log.error("Error occurred when submitting message: {}", (Object)e.getMessage());
        }
        if (!Objects.isNull(responseEntity) && responseEntity.getStatusCode().is2xxSuccessful() && !Objects.isNull(responseEntity.getBody()) && ((String)responseEntity.getBody()).contains("Mail Sent")) {
            log.info("JiraTicketApprovalEscalationWorkFlowTask completed!");
            return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
        }
        log.info("JiraTicketApprovalEscalationWorkFlowTask failed!");
        return new DefaultWorkReport(WorkStatus.FAILED, workContext);
    }

    public List<WorkFlowTaskOutput> getWorkFlowTaskOutputs() {
        return List.of(WorkFlowTaskOutput.EXCEPTION, WorkFlowTaskOutput.OTHER);
    }

    private String getMessage(String jiraTicketUrl) {
        return "Hi there,\nThe jira ticket below has been escalated due to pending review and approval.\nJira ticket url: " + jiraTicketUrl + "\nThank you,\nThe Parodos Team";
    }
}

