/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.move2kube.task;

import com.google.common.base.Strings;
import com.redhat.parodos.examples.move2kube.task.Move2KubeBase;
import com.redhat.parodos.workflow.utils.WorkContextUtils;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import dev.parodos.move2kube.ApiClient;
import dev.parodos.move2kube.ApiException;
import dev.parodos.move2kube.api.ProjectInputsApi;
import dev.parodos.move2kube.api.ProjectsApi;
import dev.parodos.move2kube.api.WorkspacesApi;
import dev.parodos.move2kube.client.model.CreateProject201Response;
import dev.parodos.move2kube.client.model.Project;
import dev.parodos.move2kube.client.model.ProjectInputsValue;
import dev.parodos.move2kube.client.model.Workspace;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Move2KubeTask
extends Move2KubeBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Move2KubeTask.class);
    private WorkspacesApi workspacesApi;
    private ProjectsApi projectsApi;
    private ProjectInputsApi projectInputsApi;

    public Move2KubeTask(String server) {
        this.setClient(server);
        this.workspacesApi = new WorkspacesApi(this.client);
        this.projectsApi = new ProjectsApi(this.client);
        ApiClient clientFormData = this.client;
        clientFormData.addDefaultHeader("Content-Type", "multipart/form-data");
        this.projectInputsApi = new ProjectInputsApi(clientFormData);
    }

    Move2KubeTask(String server, WorkspacesApi wrk, ProjectsApi projects, ProjectInputsApi projectInputs) {
        new Move2KubeTask(server);
        this.workspacesApi = wrk;
        this.projectsApi = projects;
        this.projectInputsApi = projectInputs;
    }

    @Override
    public WorkReport execute(WorkContext workContext) {
        log.debug("Init Move2Kube Project initialization!");
        String workspaceID = null;
        Map workspaceInputs = null;
        try {
            Optional<Workspace> workspace = this.setWorkspace();
            if (workspace.isEmpty()) {
                return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new RuntimeException("No move2kube workspace found"));
            }
            workspaceID = workspace.get().getId();
            workspaceInputs = workspace.get().getInputs();
            workContext.put("move2KubeWorkspaceID", (Object)workspaceID);
            String projectId = this.setProject(workspaceID, workspaceInputs, WorkContextUtils.getMainExecutionId((WorkContext)workContext));
            if (Strings.isNullOrEmpty((String)projectId)) {
                return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new RuntimeException("Cannot create project on move2kube server"));
            }
            workContext.put("move2KubeProjectID", (Object)projectId);
        }
        catch (ApiException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new RuntimeException("Cannot setup the project on move2kube: %s".formatted(e.getMessage())));
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    private Optional<Workspace> setWorkspace() throws ApiException {
        return this.workspacesApi.getWorkspaces().stream().findFirst();
    }

    private String setProject(String workspaceId, Map<String, ProjectInputsValue> inputs, UUID workflowId) throws ApiException {
        Project project = new Project();
        project.setName("WorkFlowID: " + workflowId.toString());
        project.description("Project for workflow execution id: " + workflowId.toString());
        CreateProject201Response res = this.projectsApi.createProject(workspaceId, project);
        project.setId(res.getId());
        if (inputs == null) {
            return project.getId();
        }
        for (Map.Entry<String, ProjectInputsValue> v : inputs.entrySet()) {
            this.projectInputsApi.createProjectInput(workspaceId, project.getId(), "reference", v.getValue().getId(), v.getValue().getDescription(), null);
        }
        return project.getId();
    }
}

