/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.examples.move2kube.task;

import com.redhat.parodos.examples.move2kube.task.Move2KubeBase;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import dev.parodos.move2kube.api.ProjectOutputsApi;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import lombok.Generated;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Move2KubeRetrieve
extends Move2KubeBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Move2KubeRetrieve.class);
    private String plan;
    private ProjectOutputsApi output;

    public Move2KubeRetrieve(String server) {
        this.setClient(server);
        this.output = new ProjectOutputsApi(this.client);
    }

    public Move2KubeRetrieve(String server, ProjectOutputsApi outputsApi) {
        new Move2KubeRetrieve(server);
        this.output = outputsApi;
    }

    @Override
    public WorkReport execute(WorkContext workContext) {
        String workspaceID = (String)workContext.get(Move2KubeRetrieve.getWorkspaceContextKey());
        String projectID = (String)workContext.get(Move2KubeRetrieve.getProjectContextKey());
        String transformID = (String)workContext.get(Move2KubeRetrieve.getTransformContextKey());
        String sourcePath = workContext.get("gitDestination").toString();
        Path tempDir = null;
        try {
            File file = this.output.getProjectOutput(workspaceID, projectID, transformID);
            if (file == null) {
                return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new RuntimeException("Couldn't get file from transformation"));
            }
            tempDir = Files.createTempDirectory(String.format("move2kube-transform-%s", transformID), new FileAttribute[0]);
            Move2KubeRetrieve.extractZipFile(file, tempDir);
        }
        catch (Exception e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        try {
            Path finalPath = Files.newDirectoryStream(Paths.get(tempDir.toString() + "/output/", new String[0])).iterator().next();
            log.info("FinalPath is --->{} and GitPath is {}", (Object)finalPath, (Object)sourcePath);
            FileUtils.copyDirectory((File)finalPath.resolve(Paths.get("deploy", new String[0])).toFile(), (File)Paths.get(sourcePath, new String[0]).resolve("deploy").toFile());
            FileUtils.copyDirectory((File)finalPath.resolve(Paths.get("scripts", new String[0])).toFile(), (File)Paths.get(sourcePath, new String[0]).resolve("scripts").toFile());
        }
        catch (Exception e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    public static void extractZipFile(File zipFile, Path extractPath) throws IOException {
        try (ZipFile zip = new ZipFile(zipFile);){
            for (ZipArchiveEntry entry : Collections.list(zip.getEntries())) {
                File entryFile = new File(extractPath.toString() + "/" + entry.getName());
                if (entry.isDirectory()) {
                    entryFile.mkdirs();
                    continue;
                }
                File parentDir = entryFile.getParentFile();
                if (parentDir != null && !parentDir.exists()) {
                    parentDir.mkdirs();
                }
                try (FileOutputStream fos = new FileOutputStream(entryFile);){
                    zip.getInputStream(entry).transferTo(fos);
                }
            }
        }
    }
}

