/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zjsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.zjsonpatch.Constants;
import io.fabric8.zjsonpatch.Diff;
import io.fabric8.zjsonpatch.NodeType;
import io.fabric8.zjsonpatch.Operation;
import io.fabric8.zjsonpatch.internal.collections4.ListUtils;
import io.fabric8.zjsonpatch.internal.guava.Lists;
import io.fabric8.zjsonpatch.internal.guava.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class JsonDiff {
    public static final EncodePathFunction ENCODE_PATH_FUNCTION = new EncodePathFunction();

    private JsonDiff() {
    }

    public static JsonNode asJson(JsonNode source2, JsonNode target) {
        ArrayList<Diff> diffs = new ArrayList<Diff>();
        LinkedList<Object> path = new LinkedList<Object>();
        JsonDiff.generateDiffs(diffs, path, source2, target);
        JsonDiff.compactDiffs(diffs);
        return JsonDiff.getJsonNodes(diffs);
    }

    private static void compactDiffs(List<Diff> diffs) {
        block0: for (int i = 0; i < diffs.size(); ++i) {
            Diff diff1 = diffs.get(i);
            if (!Operation.REMOVE.equals((Object)diff1.getOperation()) && !Operation.ADD.equals((Object)diff1.getOperation())) continue;
            for (int j = i + 1; j < diffs.size(); ++j) {
                Diff diff2 = diffs.get(j);
                if (!diff1.getValue().equals(diff2.getValue())) continue;
                Diff moveDiff = null;
                if (Operation.REMOVE.equals((Object)diff1.getOperation()) && Operation.ADD.equals((Object)diff2.getOperation())) {
                    JsonDiff.computeRelativePath(diff2.getPath(), i + 1, j - 1, diffs);
                    moveDiff = new Diff(Operation.MOVE, diff1.getPath(), diff2.getValue(), diff2.getPath());
                } else if (Operation.ADD.equals((Object)diff1.getOperation()) && Operation.REMOVE.equals((Object)diff2.getOperation())) {
                    JsonDiff.computeRelativePath(diff2.getPath(), i, j - 1, diffs);
                    moveDiff = new Diff(Operation.MOVE, diff2.getPath(), diff1.getValue(), diff1.getPath());
                }
                if (moveDiff == null) continue;
                diffs.remove(j);
                diffs.set(i, moveDiff);
                continue block0;
            }
        }
    }

    private static void computeRelativePath(List<Object> path, int startIdx, int endIdx, List<Diff> diffs) {
        ArrayList<Integer> counters = new ArrayList<Integer>();
        JsonDiff.resetCounters(counters, path.size());
        for (int i = startIdx; i <= endIdx; ++i) {
            Diff diff = diffs.get(i);
            if (!Operation.ADD.equals((Object)diff.getOperation()) && !Operation.REMOVE.equals((Object)diff.getOperation())) continue;
            JsonDiff.updatePath(path, diff, counters);
        }
        JsonDiff.updatePathWithCounters(counters, path);
    }

    private static void resetCounters(List<Integer> counters, int size) {
        for (int i = 0; i < size; ++i) {
            counters.add(0);
        }
    }

    private static void updatePathWithCounters(List<Integer> counters, List<Object> path) {
        for (int i = 0; i < counters.size(); ++i) {
            int value = counters.get(i);
            if (value == 0) continue;
            Integer currValue = Integer.parseInt(path.get(i).toString());
            path.set(i, String.valueOf(currValue + value));
        }
    }

    private static void updatePath(List<Object> path, Diff pseudo, List<Integer> counters) {
        if (pseudo.getPath().size() <= path.size()) {
            int idx = -1;
            int i = 0;
            while (i < pseudo.getPath().size() - 1 && pseudo.getPath().get(i).equals(path.get(i))) {
                idx = i++;
            }
            if (idx == pseudo.getPath().size() - 2 && pseudo.getPath().get(pseudo.getPath().size() - 1) instanceof Integer) {
                JsonDiff.updateCounters(pseudo, pseudo.getPath().size() - 1, counters);
            }
        }
    }

    private static void updateCounters(Diff pseudo, int idx, List<Integer> counters) {
        if (Operation.ADD.equals((Object)pseudo.getOperation())) {
            counters.set(idx, counters.get(idx) - 1);
        } else if (Operation.REMOVE.equals((Object)pseudo.getOperation())) {
            counters.set(idx, counters.get(idx) + 1);
        }
    }

    private static ArrayNode getJsonNodes(List<Diff> diffs) {
        JsonNodeFactory FACTORY = JsonNodeFactory.instance;
        ArrayNode patch = FACTORY.arrayNode();
        for (Diff diff : diffs) {
            ObjectNode jsonNode = JsonDiff.getJsonNode(FACTORY, diff);
            patch.add(jsonNode);
        }
        return patch;
    }

    private static ObjectNode getJsonNode(JsonNodeFactory FACTORY, Diff diff) {
        ObjectNode jsonNode = FACTORY.objectNode();
        jsonNode.put(Constants.OP, diff.getOperation().rfcName());
        jsonNode.put(Constants.PATH, JsonDiff.getArrayNodeRepresentation(diff.getPath()));
        if (Operation.MOVE.equals((Object)diff.getOperation())) {
            jsonNode.put(Constants.FROM, JsonDiff.getArrayNodeRepresentation(diff.getPath()));
            jsonNode.put(Constants.PATH, JsonDiff.getArrayNodeRepresentation(diff.getToPath()));
        }
        if (!Operation.REMOVE.equals((Object)diff.getOperation()) && !Operation.MOVE.equals((Object)diff.getOperation())) {
            jsonNode.put(Constants.VALUE, diff.getValue());
        }
        return jsonNode;
    }

    private static String getArrayNodeRepresentation(List<Object> path) {
        StringBuilder sb = new StringBuilder();
        for (Object o : path) {
            sb.append('/').append(ENCODE_PATH_FUNCTION.apply(o));
        }
        if (sb.length() == 0) {
            sb.append('/');
        }
        return sb.toString();
    }

    private static void generateDiffs(List<Diff> diffs, List<Object> path, JsonNode source2, JsonNode target) {
        if (!source2.equals(target)) {
            NodeType sourceType = NodeType.getNodeType(source2);
            NodeType targetType = NodeType.getNodeType(target);
            if (sourceType == NodeType.ARRAY && targetType == NodeType.ARRAY) {
                JsonDiff.compareArray(diffs, path, source2, target);
            } else if (sourceType == NodeType.OBJECT && targetType == NodeType.OBJECT) {
                JsonDiff.compareObjects(diffs, path, source2, target);
            } else {
                diffs.add(Diff.generateDiff(Operation.REPLACE, path, target));
            }
        }
    }

    private static void compareArray(List<Diff> diffs, List<Object> path, JsonNode source2, JsonNode target) {
        List<JsonNode> lcs = JsonDiff.getLCS(source2, target);
        int srcIdx = 0;
        int targetIdx = 0;
        int lcsIdx = 0;
        int srcSize = source2.size();
        int targetSize = target.size();
        int lcsSize = lcs.size();
        int pos = 0;
        while (lcsIdx < lcsSize) {
            List<Object> currPath;
            JsonNode lcsNode = lcs.get(lcsIdx);
            JsonNode srcNode = source2.get(srcIdx);
            JsonNode targetNode = target.get(targetIdx);
            if (lcsNode.equals(srcNode) && lcsNode.equals(targetNode)) {
                ++srcIdx;
                ++targetIdx;
                ++lcsIdx;
                ++pos;
                continue;
            }
            if (lcsNode.equals(srcNode)) {
                currPath = JsonDiff.getPath(path, pos);
                diffs.add(Diff.generateDiff(Operation.ADD, currPath, targetNode));
                ++pos;
                ++targetIdx;
                continue;
            }
            if (lcsNode.equals(targetNode)) {
                currPath = JsonDiff.getPath(path, pos);
                diffs.add(Diff.generateDiff(Operation.REMOVE, currPath, srcNode));
                ++srcIdx;
                continue;
            }
            currPath = JsonDiff.getPath(path, pos);
            JsonDiff.generateDiffs(diffs, currPath, srcNode, targetNode);
            ++srcIdx;
            ++targetIdx;
            ++pos;
        }
        while (srcIdx < srcSize && targetIdx < targetSize) {
            JsonNode srcNode = source2.get(srcIdx);
            JsonNode targetNode = target.get(targetIdx);
            List<Object> currPath = JsonDiff.getPath(path, pos);
            JsonDiff.generateDiffs(diffs, currPath, srcNode, targetNode);
            ++srcIdx;
            ++targetIdx;
            ++pos;
        }
        pos = JsonDiff.addRemaining(diffs, path, target, pos, targetIdx, targetSize);
        JsonDiff.removeRemaining(diffs, path, pos, srcIdx, srcSize, source2);
    }

    private static Integer removeRemaining(List<Diff> diffs, List<Object> path, int pos, int srcIdx, int srcSize, JsonNode source2) {
        while (srcIdx < srcSize) {
            List<Object> currPath = JsonDiff.getPath(path, pos);
            diffs.add(Diff.generateDiff(Operation.REMOVE, currPath, source2.get(srcIdx)));
            ++srcIdx;
        }
        return pos;
    }

    private static Integer addRemaining(List<Diff> diffs, List<Object> path, JsonNode target, int pos, int targetIdx, int targetSize) {
        while (targetIdx < targetSize) {
            JsonNode jsonNode = target.get(targetIdx);
            List<Object> currPath = JsonDiff.getPath(path, pos);
            diffs.add(Diff.generateDiff(Operation.ADD, currPath, jsonNode.deepCopy()));
            ++pos;
            ++targetIdx;
        }
        return pos;
    }

    private static void compareObjects(List<Diff> diffs, List<Object> path, JsonNode source2, JsonNode target) {
        Iterator<String> keysFromSrc = source2.fieldNames();
        while (keysFromSrc.hasNext()) {
            List<Object> currPath;
            String key = keysFromSrc.next();
            if (!target.has(key)) {
                currPath = JsonDiff.getPath(path, key);
                diffs.add(Diff.generateDiff(Operation.REMOVE, currPath, source2.get(key)));
                continue;
            }
            currPath = JsonDiff.getPath(path, key);
            JsonDiff.generateDiffs(diffs, currPath, source2.get(key), target.get(key));
        }
        Iterator<String> keysFromTarget = target.fieldNames();
        while (keysFromTarget.hasNext()) {
            String key = keysFromTarget.next();
            if (source2.has(key)) continue;
            List<Object> currPath = JsonDiff.getPath(path, key);
            diffs.add(Diff.generateDiff(Operation.ADD, currPath, target.get(key)));
        }
    }

    private static List<Object> getPath(List<Object> path, Object key) {
        ArrayList<Object> toReturn = new ArrayList<Object>();
        toReturn.addAll(path);
        toReturn.add(key);
        return toReturn;
    }

    private static List<JsonNode> getLCS(JsonNode first, JsonNode second) {
        Preconditions.checkArgument(first.isArray(), "LCS can only work on JSON arrays");
        Preconditions.checkArgument(second.isArray(), "LCS can only work on JSON arrays");
        return ListUtils.longestCommonSubsequence(Lists.newArrayList(first), Lists.newArrayList(second));
    }

    private static final class EncodePathFunction {
        private EncodePathFunction() {
        }

        public String apply(Object object) {
            String path = object.toString();
            return path.replaceAll("~", "~0").replaceAll("/", "~1");
        }
    }
}

