/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.internal;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectAccessReview;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.OpenIDConnectionUtils;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.LocalResourceAccessReview;
import io.fabric8.openshift.api.model.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.ResourceAccessReview;
import io.fabric8.openshift.api.model.SelfSubjectRulesReview;
import io.fabric8.openshift.api.model.SubjectAccessReview;
import io.fabric8.openshift.api.model.SubjectRulesReview;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftOAuthInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenShiftOAuthInterceptor.class);
    private static final String AUTHORIZATION = "Authorization";
    private static final String LOCATION = "Location";
    private static final String AUTHORIZATION_SERVER_PATH = ".well-known/oauth-authorization-server";
    private static final String AUTHORIZE_QUERY = "?response_type=token&client_id=openshift-challenging-client";
    private static final String BEFORE_TOKEN = "access_token=";
    private static final String AFTER_TOKEN = "&expires";
    private static final Set<String> RETRIABLE_RESOURCES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(HasMetadata.getPlural(LocalSubjectAccessReview.class), HasMetadata.getPlural(LocalResourceAccessReview.class), HasMetadata.getPlural(ResourceAccessReview.class), HasMetadata.getPlural(SelfSubjectRulesReview.class), HasMetadata.getPlural(SubjectRulesReview.class), HasMetadata.getPlural(SubjectAccessReview.class), HasMetadata.getPlural(SelfSubjectAccessReview.class))));
    private final HttpClient client;
    private final Config config;

    public OpenShiftOAuthInterceptor(HttpClient client, Config config) {
        this.client = client;
        this.config = config;
    }

    @Override
    public void before(BasicBuilder builder, HttpRequest httpRequest, Interceptor.RequestTags tags) {
        this.setAuthHeader(builder, this.config.getOauthToken());
    }

    @Override
    public CompletableFuture<Boolean> afterFailure(HttpRequest.Builder builder, HttpResponse<?> response, Interceptor.RequestTags tags) {
        if (this.shouldProceed(response.request(), response)) {
            return CompletableFuture.completedFuture(false);
        }
        if (Utils.isNotNullOrEmpty(this.config.getUsername()) && Utils.isNotNullOrEmpty(this.config.getPassword())) {
            return this.authorize().thenApply(t -> {
                if (t != null) {
                    this.config.setOauthToken((String)t);
                    try {
                        OpenIDConnectionUtils.persistKubeConfigWithUpdatedAuthInfo(this.config, a -> a.setToken((String)t));
                    }
                    catch (IOException e) {
                        LOGGER.warn("failure while persisting new token into KUBECONFIG", (Throwable)e);
                    }
                    return this.setAuthHeader(builder, (String)t);
                }
                return this.refreshFromConfig(builder);
            });
        }
        return CompletableFuture.completedFuture(this.refreshFromConfig(builder));
    }

    private boolean refreshFromConfig(HttpRequest.Builder builder) {
        Config newestConfig = this.config.refresh();
        String oauthToken = newestConfig.getOauthToken();
        if (oauthToken != null) {
            this.config.setOauthToken(oauthToken);
        }
        return this.setAuthHeader(builder, oauthToken);
    }

    private boolean setAuthHeader(BasicBuilder builder, String token) {
        if (token != null) {
            builder.setHeader(AUTHORIZATION, String.format("Bearer %s", token));
            return true;
        }
        return false;
    }

    private CompletableFuture<String> authorize() {
        URL url;
        HttpClient.DerivedClientBuilder builder = this.client.newBuilder();
        builder.addOrReplaceInterceptor("TOKEN", null);
        HttpClient clone = builder.build();
        try {
            url = new URL(URLUtils.join(this.config.getMasterUrl(), AUTHORIZATION_SERVER_PATH));
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        CompletableFuture<HttpResponse<String>> responseFuture = clone.sendAsync(clone.newHttpRequestBuilder().url(url).build(), String.class);
        return ((CompletableFuture)responseFuture.thenCompose(response -> {
            if (!response.isSuccessful() || response.body() == null) {
                throw new KubernetesClientException("Unexpected response (" + response.code() + " " + response.message() + ")");
            }
            String body = (String)response.body();
            try {
                JsonNode jsonResponse = Serialization.jsonMapper().readTree(body);
                String authorizationServer = jsonResponse.get("authorization_endpoint").asText();
                URL authorizeQuery = new URL(authorizationServer + AUTHORIZE_QUERY);
                String credential = HttpClientUtils.basicCredentials(this.config.getUsername(), this.config.getPassword());
                return clone.sendAsync(this.client.newHttpRequestBuilder().url(authorizeQuery).setHeader(AUTHORIZATION, credential).build(), String.class);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        })).thenApply(response -> {
            String token;
            HttpResponse<?> responseOrPrevious = response.previousResponse().isPresent() ? response.previousResponse().get() : response;
            List<String> location = responseOrPrevious.headers(LOCATION);
            String string = token = !location.isEmpty() ? location.get(0) : null;
            if (token == null || token.isEmpty()) {
                throw new KubernetesClientException("Unexpected response (" + responseOrPrevious.code() + " " + responseOrPrevious.message() + "), to the authorization request. Missing header:[" + LOCATION + "].  More than likely the username / password are not correct.");
            }
            token = token.substring(token.indexOf(BEFORE_TOKEN) + BEFORE_TOKEN.length());
            token = token.substring(0, token.indexOf(AFTER_TOKEN));
            return token;
        });
    }

    private boolean shouldProceed(HttpRequest request, HttpResponse<?> response) {
        String url = request.uri().toString();
        String method = request.method();
        if (method.equals("POST")) {
            if (RETRIABLE_RESOURCES.stream().anyMatch(url::endsWith)) {
                return false;
            }
        }
        return response.code() != 401;
    }
}

