/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.installer.v1.ImageContentSource;
import io.fabric8.openshift.api.model.installer.v1.ImageContentSourceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageContentSourceFluentImpl<A extends ImageContentSourceFluent<A>>
extends BaseFluent<A>
implements ImageContentSourceFluent<A> {
    private List<String> mirrors = new ArrayList<String>();
    private String source;
    private Map<String, Object> additionalProperties;

    public ImageContentSourceFluentImpl() {
    }

    public ImageContentSourceFluentImpl(ImageContentSource instance) {
        this.withMirrors(instance.getMirrors());
        this.withSource(instance.getSource());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToMirrors(Integer index, String item) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<String>();
        }
        this.mirrors.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMirrors(Integer index, String item) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<String>();
        }
        this.mirrors.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMirrors(String ... items) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<String>();
        }
        for (String item : items) {
            this.mirrors.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMirrors(Collection<String> items) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<String>();
        }
        for (String item : items) {
            this.mirrors.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMirrors(String ... items) {
        for (String item : items) {
            if (this.mirrors == null) continue;
            this.mirrors.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMirrors(Collection<String> items) {
        for (String item : items) {
            if (this.mirrors == null) continue;
            this.mirrors.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMirrors() {
        return this.mirrors;
    }

    @Override
    public String getMirror(Integer index) {
        return this.mirrors.get(index);
    }

    @Override
    public String getFirstMirror() {
        return this.mirrors.get(0);
    }

    @Override
    public String getLastMirror() {
        return this.mirrors.get(this.mirrors.size() - 1);
    }

    @Override
    public String getMatchingMirror(Predicate<String> predicate) {
        for (String item : this.mirrors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMirror(Predicate<String> predicate) {
        for (String item : this.mirrors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMirrors(List<String> mirrors) {
        if (mirrors != null) {
            this.mirrors = new ArrayList<String>();
            for (String item : mirrors) {
                this.addToMirrors(item);
            }
        } else {
            this.mirrors = null;
        }
        return (A)this;
    }

    @Override
    public A withMirrors(String ... mirrors) {
        if (this.mirrors != null) {
            this.mirrors.clear();
        }
        if (mirrors != null) {
            for (String item : mirrors) {
                this.addToMirrors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMirrors() {
        return this.mirrors != null && !this.mirrors.isEmpty();
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public A withSource(String source2) {
        this.source = source2;
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageContentSourceFluentImpl that = (ImageContentSourceFluentImpl)o;
        if (this.mirrors != null ? !this.mirrors.equals(that.mirrors) : that.mirrors != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mirrors, this.source, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mirrors != null && !this.mirrors.isEmpty()) {
            sb.append("mirrors:");
            sb.append(this.mirrors + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

