/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.informers.cache.ItemStore;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;

public class ReducedStateItemStore<V extends HasMetadata>
implements ItemStore<V> {
    private static final String METADATA = "metadata";
    private final ConcurrentHashMap<String, Object[]> store = new ConcurrentHashMap();
    private final List<String[]> fields = new ArrayList<String[]>();
    private final Class<V> typeClass;
    private final KeyState keyState;
    public static final KeyState NAME_KEY_STATE;
    public static final KeyState UID_KEY_STATE;

    public ReducedStateItemStore(KeyState keyState, Class<V> typeClass, String ... valueFields) {
        this.keyState = keyState;
        this.fields.add(new String[]{METADATA, "resourceVersion"});
        if (valueFields != null) {
            for (int i = 0; i < valueFields.length; ++i) {
                this.fields.add(valueFields[i].split("\\."));
            }
        }
        this.typeClass = typeClass;
    }

    Object[] store(V value) {
        if (value == null) {
            return null;
        }
        Map raw = Serialization.jsonMapper().convertValue(value, Map.class);
        return this.fields.stream().map(f -> GenericKubernetesResource.get(raw, f)).toArray();
    }

    V restore(String key, Object[] values2) {
        if (values2 == null) {
            return null;
        }
        HashMap<String, Object> raw = new HashMap<String, Object>();
        ReducedStateItemStore.applyFields(values2, raw, this.fields);
        Object[] keyParts = this.keyState.keyFieldFunction.apply(key);
        ReducedStateItemStore.applyFields(keyParts, raw, this.keyState.keyFields);
        return (V)((HasMetadata)Serialization.jsonMapper().convertValue(raw, this.typeClass));
    }

    private static void applyFields(Object[] values2, Map<String, Object> raw, List<String[]> fields) {
        for (int i = 0; i < fields.size(); ++i) {
            Object value = values2[i];
            if (value == null) continue;
            String[] path = fields.get(i);
            Map parent = raw;
            for (int j = 0; j < path.length - 1; ++j) {
                parent = (Map)parent.computeIfAbsent((String)path[j], k -> new LinkedHashMap());
            }
            parent.put(path[path.length - 1], value);
        }
    }

    @Override
    public V put(String key, V obj) {
        return this.restore(key, this.store.put(key, this.store(obj)));
    }

    @Override
    public V remove(String key) {
        return this.restore(key, this.store.remove(key));
    }

    @Override
    public Stream<String> keySet() {
        return this.store.keySet().stream();
    }

    @Override
    public Stream<V> values() {
        return this.store.entrySet().stream().map(e -> this.restore((String)e.getKey(), (Object[])e.getValue()));
    }

    @Override
    public V get(String key) {
        return this.restore(key, this.store.get(key));
    }

    public String getResourceVersion(String key) {
        return (String)this.store.getOrDefault(key, new Object[1])[0];
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public String getKey(V obj) {
        return this.keyState.keyFunction.apply((HasMetadata)obj);
    }

    @Override
    public boolean isFullState() {
        return false;
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class KeyState {
        final Function<HasMetadata, String> keyFunction;
        final Function<String, String[]> keyFieldFunction;
        final List<String[]> keyFields;

        public KeyState(Function<HasMetadata, String> keyFunction, Function<String, String[]> keyFieldFunction, String[] ... keyFields) {
            this.keyFunction = keyFunction;
            this.keyFieldFunction = keyFieldFunction;
            this.keyFields = Arrays.asList(keyFields);
        }
    }
}

